<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Kanews
 */
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
get_header();
global $post;
?>
	<?php do_action('kanews_header_ad'); ?>
  <main id="main" class="site-main">
    <div class="container">
      <div class="row">
				<div class="site-main-wrapper">
					<div class="site-main-inner d-flex flex-wrap">
						
						<?php 
							while ( have_posts() ) : the_post(); ?>
              <?php
                $pid = get_the_ID();
                $add_style = $add_style2 = '';
                $pic_data = get_user_meta( $post->post_author, 'cover_bg', true );
                if( empty($pic_data['url']) ) {
                  $pic_url = '';
                  $add_style = 'style="display: none"';
                } else {
                  $pic_url = $pic_data['url'];
                  $add_style2 = 'style="margin-top:-75px"';
                }
                ?>
                <div class="col-12">
                    <div class="kanews-profile-wrapper kanews-section">
                      <div class="kanews-profile-avatar" <?php echo $add_style2; ?>><?php echo kanews_user_avatar(get_the_author_meta('ID', $post->post_author),'90'); ?></div>
                      <div class="kanews-profile-content">
                        <div class="kanews-profile-name"><?php echo esc_html(get_the_author_meta('display_name', $post->post_author)); ?> <?php echo kanews_user_subscribe_badge($post->post_author); ?></div>
        
                        <div class="kanews-profile-links d-flex flex-wrap">
                          <a class="kanews-profile-link"  href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><?php esc_html_e( 'Diğer Yazıları', 'kanews' ); ?></a>
                          <?php if( kanews_get_option('follow-authors', false) && get_current_user_id() != $post->post_author ) :
                            $user_cats 	  = get_user_option( 'kanews_subscribe_authors', get_current_user_id() ) ? get_user_option( 'kanews_subscribe_authors', get_current_user_id() ) : array('');
                            $follow_class = in_array($post->post_author, $user_cats) ? 'category-subscribed' : '';
                            $follow_text  = ($follow_class == 'category-subscribed') ? esc_html__( 'Takip Ediliyor', 'kanews' ) : esc_html__( 'Takip Et', 'kanews' );
                            // print_r($user_cats);
                            ?>
                            <button data-author="true" data-user-id="<?php echo $post->post_author; ?>" class="kanews-category-subscribe-button hf1s <?php echo $follow_class; ?>"><?php echo $follow_text; ?> <div id="kanews-loader"></div></button>
                          <?php endif; ?>
                          <?php echo user_badge($post->post_author); ?>
                          <?php echo kanews_get_user_social_links($post->post_author, false, 'kanews-profile-link'); ?>
                        </div>
                      </div>
                    </div>
                  </div>
                <div class="d-flex flex-wrap">
                  
                  <div class="col-12 col-lg-9 kanews-sticky kgs2 mb-1">
                    <article id="post-<?php echo $pid; ?>" <?php post_class('kanews-article kanews-section-box kanews-article-1'); ?>>
                    
                      <?php kanews_entry_header(); ?>
                      <?php kanews_post_featured($pid); ?>
                      <?php kanews_entry_assets(); ?>
                      <div class="kanews-prev-post-link" hidden><?php previous_post_link('%link', '', FALSE); ?></div>
                      <div class="kanews-article-content entry-content">
                        <?php 
                          // Entry Below
                          do_action('kanews_entry_below', $pid);
                          // Content
                          echo '<div class="entry-content-wrapper" property="articleBody">';
                            echo '<div class="entry-content-inner">';
                              the_content();
                              // Links
                              kanews_link_pages();
                            echo '</div>';
                          echo '</div>';
                          // Entry Above
                          do_action('kanews_entry_above', $pid);
                        ?>
                      </div>
                    </article>
                    <?php do_action('kanews_entry_comment_above'); ?>
                    <?php if ( comments_open() || get_comments_number() ) :
                      comments_template();
                    endif; ?>
                  </div>
                  <div class="col-12 col-lg-3 sidebar-right kanews-sticky">
                    <div class="row" role="complementary">
          
                      <?php 
                      $kanews_query = new WP_Query(
                        array( 
                          'author__in'    => array(get_post_field ('post_author', $pid)),
                          'post_type'    => 'columist',
                          'showposts'    => 10,
                          'post__not_in' => array($pid)
                        )
                      );
                      ?>
  
                      <?php if ($kanews_query->have_posts()) : ?>
                      <div class="col-12">
                        <div class="kanews-section">
                          <?php echo kanews_widget_title(sprintf(esc_html__( '%s Yazıları', 'kanews' ), get_the_author_meta('display_name', $post->post_author))); ?>
                          
                            <div class="kanews-scroll" style="max-height: 410px">
                              <?php while($kanews_query->have_posts()): $kanews_query->the_post(); global $post; ?>
                         
                                  <div class="kanews-post-item kanews-post-grid-item kanews-post-small-item">
                                    <a href="<?php the_permalink(); ?>" class="kanews-post-href"></a>
                                    <?php kanews_post_thumbnail('thumbnail', 'kanews-post-thumb'); ?>
                                    <div class="kanews-post-content">
                                      <?php the_title( sprintf( '<h3 class="kanews-post-headline truncate truncate-2"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
                                      <?php echo kanews_post_date(); ?>
                                    </div>
                                  </div>
                              
                              <?php endwhile;  wp_reset_postdata(); ?>
                            </div>
                        </div>
                      </div>
                      <?php endif;  ?>

                      <?php 
                      $kanews_query = new WP_Query(
                        array( 
                          'author__not_in' => array(get_post_field ('post_author', $pid)),
                          'post_type'    => 'columist',
                          'showposts'    => 10,
                          'post__not_in' => array($pid)
                        )
                      );
                      ?>
  
                      <?php if ($kanews_query->have_posts()) : ?>
                      <div class="col-12">
                        <div class="kanews-section">
                          <?php echo kanews_widget_title( esc_html__( 'Diğer Yazarlar', 'kanews' ) ); ?>
                          
                            <div class="kanews-scroll" style="max-height: 410px">
                              <?php while($kanews_query->have_posts()): $kanews_query->the_post(); global $post; ?>
                         
                                  <div class="kanews-post-item kanews-post-grid-item kanews-post-small-item">
                                    <a href="<?php the_permalink(); ?>" class="kanews-post-href"></a>
                                    <div class="kanews-post-thumb">
                                    <?php echo kanews_user_avatar( get_the_author_meta( 'ID' ), 150); ?>
                                    </div>
                                    <div class="kanews-post-content">
                                    <div class="kanews-post-columist-author">
                                      <?php the_author(); ?>
                                      </div>
                                      <?php the_title( sprintf( '<h3 class="kanews-post-headline truncate truncate-2"><a href="%s" rel="bookmark">"', esc_url( get_permalink() ) ), '"</a></h3>' ); ?>
                                      
                                    </div>
                                  </div>
                              
                              <?php endwhile;  wp_reset_postdata(); ?>
                            </div>
                        </div>
                      </div>
                      <?php endif;  ?>

                      <?php dynamic_sidebar( sanitize_title( 'columnist-sidebar' ) ); ?>
                      
                    </div>
                  </div>
                </div>
							<?php endwhile;
						?>
						
					</div>
				</div>
			</div>
		</div>
	</main>

<?php
get_footer();
