<?php
/**
 * The template for displaying all single comp
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Kanews
 */
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
$qua = [
  '0' => [
    'question' => '3x3=?',
    'answer' => '9'
  ],
  '1' => [
    'question' => '1x3=?',
    'answer' => '3'
  ],
  '2' => [
    'question' => '2+2=?',
    'answer' => '4'
  ],
  '3' => [
    'question' => '1+8=?',
    'answer' => '9'
  ],
  '4' => [
    'question' => '5x0=?',
    'answer' => '0'
  ],
  '5' => [
    'question' => '2+2=?',
    'answer' => '4'
  ],
];
$qua_rand = array_rand($qua);
get_header();
while ( have_posts() ) : the_post();
kanews_page_header($post->ID); 
endwhile;

?>
	<?php do_action('kanews_header_ad'); ?>
  <main id="main" class="site-main">
    <div class="container">
      <div class="row">

        <?php while ( have_posts() ) : the_post(); 
          $hidden = false;
          if( kanews_get_option('comp-logged', true) && ! is_user_logged_in()) {
            $hidden = true;
            $hidden_text = kanews_translate('comp-insights-text', esc_html__( 'Firmanın bilgilerini görmek için lütfen giriş yapın.', 'kanews' ));
          } elseif( ! kanews_insights_control($post->post_author) && kanews_get_option('comp-insights')) {
            $hidden = true;
            $hidden_text = kanews_translate('comp-insights-text', esc_html__( 'Firmanın aboneliği olmadığı ilgili bilgi gizlenmiştir.', 'kanews' ));
          }
          $comp = [
            'name' => get_post_meta($post->ID, "comp_name", true ) ? get_post_meta($post->ID, "comp_name", true ) : get_the_title(),
            'auth' => get_post_meta($post->ID, "comp_auth", true ) ? get_post_meta($post->ID, "comp_auth", true ) : esc_html__( 'Belirtilmemiş', 'kanews' ),
            'city' => get_post_meta($post->ID, "comp_city", true ) ? get_post_meta($post->ID, "comp_city", true ) : esc_html__( 'Belirtilmemiş', 'kanews' ),
            'address' => get_post_meta($post->ID, "comp_adress", true ) ? get_post_meta($post->ID, "comp_adress", true ) : esc_html__( 'Belirtilmemiş', 'kanews' ),
            'phone' => get_post_meta($post->ID, "comp_tel", true ) ? get_post_meta($post->ID, "comp_tel", true ) : esc_html__( 'Belirtilmemiş', 'kanews' ),
            'fax' => get_post_meta($post->ID, "comp_fax", true ) ? get_post_meta($post->ID, "comp_fax", true ) : esc_html__( 'Belirtilmemiş', 'kanews' ),
            'site' => get_post_meta($post->ID, "comp_site", true ) ? get_post_meta($post->ID, "comp_site", true ) : esc_html__( 'Belirtilmemiş', 'kanews' ),
            'map' => get_post_meta($post->ID, "comp_map", true ),
            'mail' => get_post_meta($post->ID, "comp_mail", true ) ? get_post_meta($post->ID, "comp_mail", true ) : get_the_author_meta('user_email', $post->post_author)
          ];
          ?>
          <div class="col-12 col-lg-4 kanews-sticky">
            <div class="row">
              <div class="col-12">
                <div class="kanews-section widget widget_pages">
                  <div class="kanews-section-heading justify-content-center">
                    <h2 class="kanews-section-headline"><span><?php printf( esc_html__('%s Hakkında', 'kanews'), $comp['name'] ? $comp['name'] : get_the_title()); ?></span></h2>
                  </div>
                  <div class="col-12 text-center">
                    <?php the_post_thumbnail('full', array('class' => 'kanews-comp-logo', 'style' => 'max-width: 200px')); ?> 
                    <?php if(!$hidden): ?><p class="mt-1 mb-0"><?php echo esc_html($comp['address']); ?></p><?php else: ?><p class="mt-1 mb-0 blur-text" aria-label="<?php echo $hidden_text; ?>" role="tooltip" data-microtip-position="top" class="blur-text"><?php esc_html_e( 'Firma adresi', 'kanews' ); ?></p><?php endif; ?>
                    
                  </div>
                  <ul>
                    <li class="page-item"><a href="#"><i class="icon-user"></i> <?php echo esc_html($comp['auth']); ?></a></li>
                    <li class="page-item"><a href="#"><i class="icon-location"></i> <?php echo esc_html($comp['city']); ?></a></li>
                    <li class="page-item"><?php if(!$hidden): ?><a href="tel:<?php echo esc_attr($comp['phone']); ?>"><i class="icon-call"></i> <?php echo esc_html($comp['phone']); ?></a><?php else: ?><a href="#"><i class="icon-call"></i><span aria-label="<?php echo $hidden_text; ?>" role="tooltip" data-microtip-position="top" class="blur-text"><?php esc_html_e( 'Firma Telefonu', 'kanews' ); ?></span></a><?php endif; ?></li>
                    <li class="page-item"><?php if(!$hidden): ?><a href="fax:<?php echo esc_attr($comp['fax']); ?>"><i class="icon-call"></i> <?php echo esc_html($comp['fax']); ?></a><?php else: ?><a href="#"><i class="icon-call"></i> <span aria-label="<?php echo $hidden_text; ?>" role="tooltip" data-microtip-position="top" class="blur-text"><?php esc_html_e( 'Firma Fax Numarası', 'kanews' ); ?></span></a><?php endif; ?></li>
                    <?php 
                    $domain = preg_replace("(^https?://)", "", $comp['site'] );
                    if (substr($domain, 0, 4) == 'www.') {
                      $domain = substr($domain, 4);
                    } ?>
                    <li class="page-item">
                      
                      <?php if(!$hidden): ?>
                        <a rel="external nofollow noopener" href="<?php echo esc_url($comp['site']) ?>"><i class="icon-logout"></i>  <?php echo esc_html($domain); ?></a>
                      <?php else: ?>
                        <a href="#"><i class="icon-logout"></i> <span aria-label="<?php echo $hidden_text; ?>" role="tooltip" data-microtip-position="top" class="blur-text"><?php esc_html_e( 'Firma Web Sitesi', 'kanews' ); ?></span></a>
                      <?php endif; ?>
                    </li>
                    <li class="page-item current_page_item text-center"><a data-toggle="comp-contact" href="#"><?php esc_html_e( 'İletişime Geç', 'kanews' ); ?></a></li>
                    <li class="page-item current_page_item text-center"><a class="bg-dark border-dark" href="<?php echo get_post_type_archive_link('firma'); ?>"><?php esc_html_e( 'Diğer Firmalara Gözat', 'kanews' ); ?></a></li>
                    
                  </ul>
                </div>
              </div>
              
                <?php 
                $average = false;
                $comments = get_approved_comments( $post->ID );

                if ( $comments ) {
                  
                  $i = 0;
                  $total = $one = $two = $three = $four = $five = 0;
                  foreach( $comments as $comment ){
                    $rate = get_comment_meta( $comment->comment_ID, 'kanews-post-rating', true );
                    if( isset( $rate ) && '' !== $rate ) {
                      $i++;
                      switch($rate) {
                        case '1':
                          $one++; 
                          break;
                        case '2':
                          $two++; 
                          break;
                        case '3':
                          $three++; 
                          break;
                        case '4':
                          $four++; 
                          break;
                        case '5':
                          $five++; 
                          break;
                      }
                      $total += $rate;
                    }
                  }

                  if ( 0 === $i ) {
                    $average = false;
                  } else {
                    $average = round( $total / $i, 1 );
                  }
                }

                if ( false != $average): ?>
                <div class="col-12">
                  <div class="kanews-section kanews-section-box">
                    <div class="kanews-section-heading kanews-section-flat-heading"><h3 class="kanews-section-headline"><span><?php esc_html_e( 'Firma Puanı', 'kanews' ); ?></span></h3></div>
                    <?php $stars   = '';

                    for ( $i2 = 1; $i2 <= $average + 1; $i2++ ) {
                      
                      $width = intval( $i2 - $average > 0 ? 20 - ( ( $i2 - $average ) * 20 ) : 20 );

                      if ( 0 === $width ) {
                        continue;
                      }

                      $stars .= '<span style="overflow:hidden; width:' . $width . 'px" class="kanews-rating-stars-active icon-star"></span>';

                      if ( $i2 - $average > 0 ) {
                        $stars .= '<span style="overflow:hidden; position:relative; left:-' . $width .'px;" class="icon-star-o"></span>';
                      }
                    }
                    ?>

                    
                    <div class="row no-gutters align-items-center">
                      <div class="col-auto text-center">
                        <span class="kanews-rating-num"><?php echo $average;?></span>
                        <div class="kanews-rating-stars">
                          <?php echo $stars; ?>
                        </div>
                        <div class="kanews-rating-users">
                          <i class="icon-user"></i><?php printf(esc_html__( '%s kişi oy kullanmış', 'kanews' ), $i); ?>
                        </div>
                      </div>
                      <div class="histo col">
                        <div class="five histo-rate row align-items-center">
                          <span class="histo-star col-auto">5</span>
                          <span class="bar-block col">
                            <span id="bar-five" class="kanews-rating-bar" style="width: <?php echo ceil(($five *100)/$i); ?>%">
                              <span style="display: inline;"><?php echo $five; ?></span>&nbsp;
                            </span> 
                          </span>
                        </div>
                        
                        <div class="four histo-rate row align-items-center">
                          <span class="histo-star col-auto">4</span>
                          <span class="bar-block col">
                            <span id="bar-four" class="kanews-rating-bar" style="width: <?php echo ceil(($four *100)/$i); ?>%">
                              <span style="display: inline;"><?php echo $four; ?></span>&nbsp;
                            </span> 
                          </span>
                        </div> 
                        
                        <div class="three histo-rate row align-items-center">
                          <span class="histo-star col-auto">3</span>
                          <span class="bar-block col">
                            <span id="bar-three" class="kanews-rating-bar" style="width: <?php echo ceil(($three *100)/$i); ?>%">
                              <span style="display: inline;"><?php echo $three; ?></span>&nbsp;
                            </span> 
                          </span>
                        </div>
                        
                        <div class="two histo-rate row align-items-center">
                          <span class="histo-star col-auto">2</span>
                          <span class="bar-block col">
                            <span id="bar-two" class="kanews-rating-bar" style="width: <?php echo ceil(($two *100)/$i); ?>%">
                              <span style="display: inline;"><?php echo $two; ?></span>&nbsp;
                            </span> 
                          </span>
                        </div>
                        
                        <div class="one histo-rate row align-items-center">
                          <span class="histo-star col-auto">1</span>
                          <span class="bar-block col">
                            <span id="bar-one" class="kanews-rating-bar" style="width: <?php echo ceil(($one *100)/$i); ?>%">
                              <span style="display: inline;"><?php echo $one; ?></span>&nbsp;
                            </span> 
                          </span>
                        </div>
                      </div>
                    </div>
                  </div>
                  </div>
                <?php endif; ?>
              
              <?php if(!empty($comp['map']) && (!$hidden)): ?>
                <div class="col-12">
                  <iframe style="max-width: 100%" class="kanews-lazy" data-src="<?php echo $comp['map']; ?>" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
                </div>
              <?php endif; ?>
            </div>
          </div>
          <div class="col-12 col-lg-8">
            <article class="kanews-article kanews-section kanews-section-box kanews-article-1">  
              <div class="kanews-section-heading" style="margin: -20px -20px 0;">
                <h3 class="kanews-section-headline"><span><?php esc_html_e( 'Firma Açıklaması', 'kanews' ); ?></span></h3>
              </div>
              <div class="kanews-article-content entry-content">
                <?php the_content(); ?>
              </div>
              <?php kanews_post_share($post->ID);?>
            </article>

            <?php get_template_part( 'template-parts/content/components/related', 'firma');?>
            
            <?php do_action('kanews_entry_comment_above'); ?>
            <?php if ( comments_open() || get_comments_number() ) :
              comments_template();
            endif; ?>
          </div>
        <?php endwhile;	?>
	
			</div>
		</div>
	</main>
  
  <div id="comp-contact" class="kanews-modal">
    <div data-toggle="comp-contact" class="kanews-modal-close"></div>
    <div class="kanews-modal-content">
      <div class="kanews-modal-title"><?php esc_html_e( 'İletişim', 'kanews' ); ?></div>
      <div data-toggle="comp-contact" class="kanews-modal-close-btn"><i class="icon-close"></i></div>
      <div class="kanews-modal-content-inner">
        <?php if(!$hidden): ?>
          <form id="kanews-contact-form" method="post" style="margin-top: 1em" action="<?php the_permalink(); ?>">
            <div class="row">
              <div class="col-12 col-lg-6">
                <div class="kanews-form">
                  <input id="name" name="name"  required />
                  <span class="highlight"></span><span class="bar"></span>
                  <label for="name"><?php esc_html_e( 'Adınız', 'kanews' ); ?> *</label>
                </div>
              </div>
              <div class="col-12 col-lg-6">
                <div class="kanews-form">
                  <input id="surname" name="surname"  type="text" required />
                  <span class="highlight"></span><span class="bar"></span>
                  <label for="surname"><?php esc_html_e( 'Soyadınız', 'kanews' ); ?> *</label>
                </div>
              </div>
              <div class="col-12">
                <div class="kanews-form">
                  <input id="subject" name="subject" type="text" required />
                  <span class="highlight"></span><span class="bar"></span>
                  <label for="subject"><?php esc_html_e( 'Konu', 'kanews' ); ?> *</label>
                </div>
              </div>
              <div class="col-12 col-lg-6">
                <div class="kanews-form">
                  <input id="pid" name="pid" type="pid" value="<?php echo $post->ID; ?>" hidden />
                  <input id="to" name="to" type="to" value="<?php echo $comp['mail']; ?>" hidden />
                  <input id="email" name="email" type="email"  required />
                  <span class="highlight"></span><span class="bar"></span>
                  <label for="email"><?php esc_html_e( 'E-Posta', 'kanews' ); ?> *</label>
                </div>
              </div>
              <div class="col-12 col-lg-6">
                <div class="kanews-form">
                  <input id="phone" name="phone" type="phone"  />
                  <span class="highlight"></span><span class="bar"></span>
                  <label for="phone"><?php esc_html_e( 'Telefon Numaranız', 'kanews' ); ?></label>
                </div>
              </div>
              <div class="col-12">
              <div class="kanews-form">
                  <input id="qua1" name="qua1" type="qua1" value="<?php echo $qua_rand; ?>" hidden />
                  <input id="qua" name="qua" type="qua"  required />
                  <span class="highlight"></span><span class="bar"></span>
                  <label for="qua"><?php esc_html_e( 'Güvelik Sorusu', 'kanews' ); ?> (<?php echo $qua[$qua_rand]['question']; ?>) *</label>
                </div>
              </div>
              <div class="col-12">
                <div class="kanews-form">
                  <textarea id="comment" name="comment" cols="45" rows="4" aria-required="true" required=""></textarea>
                  <span class="highlight"></span><span class="bar"></span>
                  <label for="comment"><?php esc_html_e( 'Mesajınız', 'kanews' ); ?> *</label>
                </div>
              </div>
              <?php echo kanews_get_recaptcha('registration_form'); ?>
              <div class="col-12">
                <button  class="kanews-btn kanews-btn-block" type="submit"><?php esc_html_e( 'Gönder', 'kanews' ); ?><div id="kanews-loader"></div></button>
                <?php wp_nonce_field( 'contact_action', 'contact_field' ); ?>
              </div>
            </div>
          </form>
        <?php else: ?>
          <?php echo $hidden_text; ?>
        <?php endif; ?>
      </div>
    </div>
  </div>

<?php
get_footer();
