<?php 
/**
* Header #2
*
* @since 1.0.0
**/
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
$skin = kanews_get_option('header-skin') ? 'header-skin-'.kanews_get_option('header-skin') : 'header-skin-dark';
$nav_skin = kanews_get_option('navbar-skin') ? 'navbar-skin-'.kanews_get_option('navbar-skin') : 'navbar-skin-light';
?>
<div class="site-head site-head-1">
  <?php kanews_header_top_modules(); ?>
  <header id="header" class="site-header">
    <div class="site-header-wrapper <?php echo $skin; ?>">
      <?php if(kanews_get_option('subheader-position') == 'top'): ?>
        <?php get_template_part('template-parts/header/subheader'); ?>
      <?php endif; ?>

      <div class="site-header-top">
        <div class="container">
          <div class="row site-row justify-content-between align-items-center">

            <div class="col-auto">
              <div class="site-header-top-left d-flex align-items-center">
                <button aria-label="<?php esc_html_e( 'Menü', 'kanews' ); ?>" class="site-mobil-menu-btn hidden-desktop" data-toggle="<?php echo kan_is_mobile() ? 'site-mobile-menu' : 'site-menu-block'; ?>"><i class="icon-menu icon-3x"></i></button>
                <?php kanews_header_big_menu_btn(); ?>
                <?php kanews_logo(); ?>
              </div>
            </div>

            <?php if(kanews_get_option('header-center') != 'disable'): ?>
              <div class="col-auto hidden-mobile">
                <div class="site-header-top-center">
                  <?php kanews_header_center_module(); ?>
                </div>
              </div>
            <?php endif; ?>

            <div class="col-auto col-lg">
              <div class="site-header-top-right">
                <?php if(kanews_get_option('kanews-insights') == true && kanews_get_option('kanews-insights-button') == true && kanews_insights_control() == false): ?>
                  <a href="<?php echo kanews_insights_page_url(); ?>" class="header-btn header-kanews-insights-btn hidden-mobile"><?php echo kanews_translate('kanews-insights-button-text', esc_html('Abone Ol', 'kanews')); ?></a>
                <?php endif; ?>
                <?php $header_buttons = kanews_get_option('header-buttons');
                if ($header_buttons && is_array($header_buttons)) {
                  foreach ( $header_buttons as $button ) {
                    $bg_color = !empty($button['color']) ? 'style="background-color: '.$button['color'].'"' : '';
                    $link = !empty($button['url']) ? esc_url($button['url']) : '#';
                    if(!empty($button['title']))
                    echo '<a href="'.$link.'" class="header-btn hidden-mobile" '.$bg_color.'>'.$button['title'].'</a>';
                  }
                } ?>
                <?php if(kanews_get_option('search-button') ): ?>
                  <?php kanews_header_search_form('style2'); ?>
                <?php endif; ?>
                <?php kanews_header_action_btn(); ?>
                <?php kanews_header_user_btn(); ?>
                <?php echo Kanews\Members\Notifications::get_user_notifications('desktop'); ?>
              </div>
            </div>

          </div>
        </div>
      </div>
    </div>

    <?php kanews_header_big_menu(); ?>
  </header>

  <nav id="navbar" class="site-navbar hidden-mobile <?php echo $nav_skin; ?>">
    <div class="site-navbar-wrapper <?php if(kanews_get_option('sticky-navbar')) echo 'site-navbar-wrapper-fixed'; ?>">
      <div class="container">
        <div class="navbar-row">
          <?php if(kanews_get_option('home-button') != false): ?>
            <div class="col-auto no-gutter">
              <ul class="site-navbar-nav">
                <li class="current-menu-item home-btn"><a aria-label="<?php esc_html_e( 'Ana sayfa', 'kanews' ); ?>" href="<?php echo home_url( '/'); ?>"><i class="icon-home"></i></a></li>
              </ul>
            </div>
          <?php endif; ?>
          <?php kanews_header_nav_menu(); ?>
          <?php echo kanews_dark_mode_button(); ?>
        </div>
      </div>
    </div>
  </nav>

  <?php if(kanews_get_option('subheader-position') == 'bottom'): ?>
    <?php get_template_part('template-parts/header/subheader'); ?>
  <?php endif; ?>

  <?php if(kanews_get_option('subnavbar-left-bn') == true): ?>
    <div class="extra-sub bn-bar hidden-mobile">
      <div class="site-subheader">
        <div class="container">
          <div class="row site-row align-items-center">
            <div class="col-12">
              <div class="site-subheader-left">
                <?php 
                if( kanews_get_option('subnavbar-left-bn-custom', false) )  {
                  $list = kanews_get_option('subnavbar-left-bn-customx', array());
                  if( isset($list[0]) ) {
                    echo  '<ul class="d-flex flex-wrap extra-sub-action">';
                    echo '<li class="home-url"><a href="'.home_url( '/' ).'">'.__('Neler Oluyor', 'kanews').'</a></li>';
                      foreach( $list as $key => $value ) {  
                      
                        if( $value['title'] != ''  &&  $value['url'] != '')
                        echo '<li><a href="'.esc_url($value['url']).'">'.$value['title'].'</a></li>';
                      
                      }
                    echo '</ul>';
                  }
                }  else { 
                  $cats     = (!empty(kanews_get_option('subnavbar-left-bn-cats'))) ? kanews_get_option('subnavbar-left-bn-cats') : 'all';
                  $excluded = (!empty(kanews_get_option('subnavbar-left-bn-post-not-in'))) ? kanews_get_option('subnavbar-left-bn-post-not-in') : '';
                  $count    = (!empty(kanews_get_option('subnavbar-left-bn-count'))) ? kanews_get_option('subnavbar-left-bn-count') : '5';
                  $sortby    = kanews_get_option('subnavbar-left-bn-sortby') == 'recent' ? 'DESC' : 'modified';
                  $title    = kanews_translate('breaking-new-text', esc_html__( 'Son Gelişmeler', 'kanews' ));
                  $query = new WP_Query(
                    array( 
                      'cat'          => $cats,
                      'showposts'    => $count,
                      'orderby'      => $sortby,
                      'post__not_in' => $excluded
                    )
                  );
                  ?>
                  <?php kanews_breaking_news_ticker($title, $query, true, true, $sortby ); 
                }
                ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  <?php endif; ?>
</div>