<?php 
/**
* Header #2
*
* @since 1.0.0
**/
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
?>
<div class="site-head site-head-3 header-btn-small">
<?php kanews_header_top_modules(); ?>
  <header id="header" class="site-header">
    <div class="site-header-wrapper">
      <?php if(kanews_get_option('subheader-position') == 'top'): ?>
        <?php get_template_part('template-parts/header/subheader'); ?>
      <?php endif; ?>

      <div class="site-header-top header-skin-light <?php if(kanews_get_option('sticky-navbar')) echo 'site-navbar-wrapper-fixed'; ?>">
        <div class="container-fluid">
          <div class="row site-row justify-content-between align-items-center">

            <div class="col-auto">
              <div class="site-header-top-left d-flex align-items-center">
                <button aria-label="<?php esc_html_e( 'Menü', 'kanews' ); ?>" class="site-mobil-menu-btn hidden-desktop" data-toggle="site-mobile-menu"><i class="icon-menu icon-3x"></i></button>
                <?php kanews_header_big_menu_btn(); ?>
                <?php kanews_logo(); ?>
              </div>
            </div>


            <div class="col hidden-mobile">
              <div class="site-header-top-center">
                <nav id="navbar" class="site-navbar hidden-mobile">
                  <div class="navbar-row">
                    <?php kanews_header_nav_menu(); ?>
                    
                  </div>
                </nav>
              </div>
            </div>

            <div class="col-auto">
              <div class="site-header-top-right">
              
                <?php if(kanews_get_option('kanews-insights') == true && kanews_get_option('kanews-insights-button') == true && kanews_insights_control() == false): ?>
                  <a href="<?php echo kanews_insights_page_url(); ?>" class="header-btn header-kanews-insights-btn hidden-mobile"><?php echo kanews_translate('kanews-insights-button-text', esc_html('Abone Ol', 'kanews')); ?></a>
                <?php endif; ?>
                <?php $header_buttons = kanews_get_option('header-buttons');
                if ($header_buttons && is_array($header_buttons)) {
                  foreach ( $header_buttons as $button ) {
                    $bg_color = !empty($button['color']) ? 'style="background-color: '.$button['color'].'"' : '';
                    $link = !empty($button['url']) ? esc_url($button['url']) : '#';
                    if(!empty($button['title']))
                    echo '<a href="'.$link.'" class="header-btn hidden-mobile" '.$bg_color.'>'.$button['title'].'</a>';
                  }
                } ?>
                <div class="hidden-mobile"><?php echo kanews_dark_mode_button(); ?></div>
                <?php if(kanews_get_option('search-button') == true): ?>
                  <?php kanews_header_search_form('style2'); ?>
                <?php endif; ?>
                <?php kanews_header_action_btn(); ?>
                <?php kanews_header_user_btn(); ?>
                <?php echo Kanews\Members\Notifications::get_user_notifications('desktop'); ?>
              </div>
            </div>

          </div>
        </div>
      </div>
      <?php if(kanews_get_option('subheader-position') == 'bottom'): ?>
    <?php get_template_part('template-parts/header/subheader'); ?>
  <?php endif; ?>
    </div>
    
    <?php kanews_header_big_menu(); ?>
  </header>





  <?php if(kanews_get_option('subnavbar-left-bn') == true): ?>
    <div class="extra-sub bn-bar hidden-mobile">
      <div class="site-subheader">
        <div class="container">
          <div class="row site-row align-items-center">
            <div class="col-12">
              <div class="site-subheader-left">
              <?php 
                if( kanews_get_option('subnavbar-left-bn-custom', false) )  {
                  $list = kanews_get_option('subnavbar-left-bn-customx', array());
                  if( isset($list[0]) ) {
                    echo  '<ul class="d-flex flex-wrap extra-sub-action">';
                    echo '<li class="home-url"><a href="'.home_url( '/' ).'">'.__('Neler Oluyor', 'kanews').'</a></li>';
                      foreach( $list as $key => $value ) {  
                      
                        if( $value['title'] != ''  &&  $value['url'] != '')
                        echo '<li><a href="'.esc_url($value['url']).'">'.$value['title'].'</a></li>';
                      
                      }
                    echo '</ul>';
                  }
                }  else { 
                  $cats     = (!empty(kanews_get_option('subnavbar-left-bn-cats'))) ? kanews_get_option('subnavbar-left-bn-cats') : 'all';
                  $excluded = (!empty(kanews_get_option('subnavbar-left-bn-post-not-in'))) ? kanews_get_option('subnavbar-left-bn-post-not-in') : '';
                  $count    = (!empty(kanews_get_option('subnavbar-left-bn-count'))) ? kanews_get_option('subnavbar-left-bn-count') : '5';
                  $sortby    = kanews_get_option('subnavbar-left-bn-sortby') == 'recent' ? 'DESC' : 'modified';
                  $title    = kanews_translate('breaking-new-text', esc_html__( 'Son Gelişmeler', 'kanews' ));
                  $query = new WP_Query(
                    array( 
                      'cat'          => $cats,
                      'showposts'    => $count,
                      'orderby'      => $sortby,
                      'post__not_in' => $excluded
                    )
                  );
                  ?>
                  <?php kanews_breaking_news_ticker($title, $query, true, true, $sortby ); 
                }
                ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  <?php endif; ?>
</div>