<?php
/**
 * Grid Overlay
 */
// Setup defaults
$array_defaults = array( 
    'cat_color' => '',
    'item_class' => '',
    'thumbnail' => 'kanews-post-big',
); 
    
$args = wp_parse_args($args, $array_defaults );
?>

<div class="kanews-post-overlay <?php echo $args['item_class']; ?>" <?php if($args['cat_color']) {echo 'style="--gradient-start-color: #'.$args['cat_color'].'"';} ?>>
    <a href="<?php the_permalink(); ?>" class="kanews-post-href" aria-label="<?php the_title(); ?>"></a>		
    <?php kanews_post_thumbnail($args['thumbnail'], 'kanews-post-thumb'); ?>
    <?php do_action('kanews_post_hook'); ?>
    <div class="kanews-post-content">
        <?php echo kanews_primary_category($post->ID); ?>
        <?php echo kanews_post_date('post', 'span'); ?>
        <?php the_title( sprintf( '<h3 class="kanews-post-headline truncate-3 truncate"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
    </div>
</div>