<?php
/**
 * Compass Pro Demo Plugin Custom Modules & Styles Class
 */

class td_compass_pro_demo_cm_styles {

	var $td_demo_cmstyles_path = '';
	var $td_demo_cmstyles_url = '';

    function __construct( $plugin_path, $plugin_url ) {

		$this->td_demo_cmstyles_path = $plugin_path;
		$this->td_demo_cmstyles_url = $plugin_url;

        // Hook used to add or modify items via API, called early for registering styles
        add_action( 'td_global_after', function() {
            self::register_styles();
            self::register_styles_2();
            self::register_styles_3();
            self::register_styles_4();
            self::register_styles_5();
        }, 9 );

        // Hook used to add or modify items via API
        add_action( 'td_global_after', function() {

            /**
             * Modules
             */
            td_api_module::add( 'tds_compass_module01',
                array(
                    'file'                         => $this->td_demo_cmstyles_path . '/includes/modules/tds_compass_module01.php',
                    'text'                         => 'Compass Module 01',
                    'img'                          => '',
                    'used_on_blocks'               => array(),
                    'excerpt_title'                => 25,
                    'excerpt_content'              => 25,
                    'enabled_excerpt_in_panel'     => false,
                    'enabled_on_more_articles_box' => false,
                    'enabled_on_loops'             => false,
                    'uses_columns'                 => false,
                    // if the module uses columns on the page template + loop
                    'category_label'               => false,
                    'class'                        => 'td_module_wrap td-animation-stack',
                    'group'                        => ''
                    // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
                )
            );

            td_api_module::add( 'tds_compass_module02',
                array(
                    'file'                         => $this->td_demo_cmstyles_path . '/includes/modules/tds_compass_module02.php',
                    'text'                         => 'Compass Module 02',
                    'img'                          => '',
                    'used_on_blocks'               => array(),
                    'excerpt_title'                => 25,
                    'excerpt_content'              => 25,
                    'enabled_excerpt_in_panel'     => false,
                    'enabled_on_more_articles_box' => false,
                    'enabled_on_loops'             => false,
                    'uses_columns'                 => false,
                    // if the module uses columns on the page template + loop
                    'category_label'               => false,
                    'class'                        => 'td_module_wrap td-animation-stack',
                    'group'                        => ''
                    // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
                )
            );

            td_api_module::add( 'tds_compass_module03',
                array(
                    'file'                         => $this->td_demo_cmstyles_path . '/includes/modules/tds_compass_module03.php',
                    'text'                         => 'Compass Module 03',
                    'img'                          => '',
                    'used_on_blocks'               => array(),
                    'excerpt_title'                => 25,
                    'excerpt_content'              => 25,
                    'enabled_excerpt_in_panel'     => false,
                    'enabled_on_more_articles_box' => false,
                    'enabled_on_loops'             => false,
                    'uses_columns'                 => false,
                    // if the module uses columns on the page template + loop
                    'category_label'               => false,
                    'class'                        => 'td_module_wrap td-animation-stack',
                    'group'                        => ''
                    // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
                )
            );

            td_api_module::add( 'tds_compass_module04',
                array(
                    'file'                         => $this->td_demo_cmstyles_path . '/includes/modules/tds_compass_module04.php',
                    'text'                         => 'Compass Module 04',
                    'img'                          => '',
                    'used_on_blocks'               => array(),
                    'excerpt_title'                => 25,
                    'excerpt_content'              => 25,
                    'enabled_excerpt_in_panel'     => false,
                    'enabled_on_more_articles_box' => false,
                    'enabled_on_loops'             => false,
                    'uses_columns'                 => false,
                    // if the module uses columns on the page template + loop
                    'category_label'               => false,
                    'class'                        => 'td_module_wrap td-animation-stack',
                    'group'                        => ''
                    // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
                )
            );

            td_api_module::add( 'tds_compass_module05',
                array(
                    'file'                         => $this->td_demo_cmstyles_path . '/includes/modules/tds_compass_module05.php',
                    'text'                         => 'Compass Module 05',
                    'img'                          => '',
                    'used_on_blocks'               => array(),
                    'excerpt_title'                => 25,
                    'excerpt_content'              => 25,
                    'enabled_excerpt_in_panel'     => false,
                    'enabled_on_more_articles_box' => false,
                    'enabled_on_loops'             => false,
                    'uses_columns'                 => false,
                    // if the module uses columns on the page template + loop
                    'category_label'               => false,
                    'class'                        => 'td_module_wrap td-animation-stack',
                    'group'                        => ''
                    // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
                )
            );

        });

	}

    /**
     * Modules styles
     */
    public function register_styles() {
        td_api_style::add( 'tds_compass_module_style01', array(
                'group' => 'tds_module_loop_style',
                'title' => 'Compass Module 01',
                'file' => $this->td_demo_cmstyles_path . '/includes/styles/tds_module_loop_style/tds_compass_module_style01.php',
                'params' => array_merge(
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'General',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Layout',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),


                        array(
                            "param_name"  => "modules_on_row",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                '1'  => '100%',
                                '2'  => '50%',
                                '3'  => '33.33333333%',
                                '4'  => '25%',
                                '5'  => '20%',
                                '6'  => '16.66666667%',
                                '7'  => '14.28571428%',
                                '8'  => '12.5%',
                                '9'  => '11.11111111%',
                                '10' => '10%',
                            ),
                            "heading"     => 'Modules per row',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-small",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_per_row.png",
                        ),
                        array(
                            "param_name"  => "modules_gap",
                            "type"        => "textfield-responsive",
                            "value"       => '48',
                            "heading"     => 'Modules gap',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "40",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_gap.png",
                        ),
                        array(
                            "param_name"  => "m_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Modules padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_padding.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Border',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "modules_border_size",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_border_width.png",
                        ),
                        array(
                            "param_name"  => "modules_border_style",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Solid'  => '',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Border style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_style.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Border color',
                            "param_name"  => "modules_border_color",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Image',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "image_height",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "50",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_height.png",
                        ),
                        array(
                            "param_name"  => "image_width",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (0-100 percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_width.png",
                        ),
                        array(
                            "param_name"  => "image_floated",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Normal'      => 'no_float',
                                'Float left'  => 'float_left',
                                'Float right' => 'float_right',
                                'Hidden'      => 'hidden',
                            ),
                            "heading"     => 'Image position',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_position.png",
                        ),
                        array(
                            "param_name"  => "image_size",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Medium - Default - 696x0px'  => '',
                                '-- [No crop] --' => '__',
                                'XSmall - 150x0px' => 'td_150x0',
                                'Small - 300x0px' => 'td_300x0',
                                'Large - 1068x0px' => 'td_1068x0',
                                'Full - 1920x0px'  => 'td_1920x0',
                                '-- [Other sizes] --' => '__',
                                '218x150px' => 'td_218x150',
                                '324x400px'  => 'td_324x400',
                                '485x360' => 'td_485x360'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_image_size.png",
                        ),
//                        array(
//                            "param_name"  => "image_radius",
//                            "type"        => "textfield-responsive",
//                            "value"       => '',
//                            "heading"     => 'Image radius',
//                            "description" => "",
//                            "holder"      => "div",
//                            "class"       => "tdc-textfield-small",
//                            "placeholder" => "0",
//                            "group"       => "Module",
//                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_radius.png",
//                        ),
//                        array(
//                            "param_name"  => "hide_image",
//                            "type"        => "checkbox",
//                            "value"       => '',
//                            "heading"     => "Hide image",
//                            "description" => "",
//                            "holder"      => "div",
//                            "class"       => "",
//                            "group"       => 'Module',
//                            "info_img" => "https://cloud.tagdiv.com/help/layout_hide_image.png",
//                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Title',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name" => "mc1_title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H3' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H4' => 'h4',
                                'Paragraph' => 'p'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/module_title_seo.png",
                            "group" => "Module"
                        ),

                        array(
                            "param_name"  => "mc1_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                            "info_img" => "https://cloud.tagdiv.com/help/title_length.png",
                            "group" => "Module"
                        ),
                    ),
                    td_config_helper::mix_blend('Module'),
                    td_config_helper::image_filters(),
                    td_config::get_map_exclusive_label_array(),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Compass',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Article title',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_art_title', true, 'Article title', "Module", '', '', '', '' ),
                    array(

                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Article title color',
                            "param_name"  => "article_title_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Article title hover color',
                            "param_name"  => "article_title_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "art_tit_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0 0 6px 0",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Release date',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Text color',
                            "param_name"  => "release_date_color",
                            "value"       => '#fff',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "release_date_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Release date margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                    ),
                        td_config_helper::get_map_block_font_array( 'f_release_date', true, 'Release date font', "Module", '', '', '', '' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Ratings',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_rating_text', true, 'Rating font', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_rating_label', false, 'Rating label', "Module", '', '', '', '' ),
                    array(

                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Rating text color',
                            "param_name"  => "rating_text_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Rating label color',
                            "param_name"  => "rating_label_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Border color',
                            "param_name"  => "border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "border_height",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Border height',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '15px',
                            "group" => "Module"
                        ),
                        array(
                            "param_name"  => "ratings_label_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Ratings label margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Categories/Tags',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "categories",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Categories/Tags',
                            "description" => "Comma separated slugs",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-extrabig",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "cat_limit",
                            "type"        => "textfield",
                            "value"       => '3',
                            "heading"     => 'Categories/Tags limit',
                            "description" => "Limit the categories/tags displayed",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_cats_tags_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Categories/Tags Margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0 5px 0 0",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_cats_tags_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Categories/Tags Padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "1px 3px",
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Categories/Tags Color',
                            "param_name"  => "td_cat_tag_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Categories/Tags Color Hover',
                            "param_name"  => "td_cat_tag_color_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Categories/Tags Background',
                            "param_name"  => "td_cat_tag_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Categories/Tags Background Hover',
                            "param_name"  => "td_cat_tag_bg_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_cat_tag_compass_info', false, 'Categories/Tags', "Module", '', '', '', '' ),
                    array(

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Track List',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_list_title', false, 'List title font', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_list_items', false, 'List items font', "Module", '', '', '', '' ),
                    array(
                        array(
                            "param_name"  => "list_title_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'List title margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "27px 0px 17px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'List title color',
                            "param_name"  => "list_title_color",
                            "value"       => '#fff',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'List items color',
                            "param_name"  => "list_items_color",
                            "value"       => '#fff',
                            "description" => '',
                            "group"       => "Module",
                        ),

                    )
                ),
            )
        );
    }

	public function register_styles_2() {
        td_api_style::add( 'tds_compass_module_style02', array(
                'group' => 'tds_module_loop_style',
                'title' => 'Compass Module 02',
                'file' => $this->td_demo_cmstyles_path . '/includes/styles/tds_module_loop_style/tds_compass_module_style02.php',
                'params' => array_merge(
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'General',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Layout',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),


                        array(
                            "param_name"  => "modules_on_row",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                '1'  => '100%',
                                '2'  => '50%',
                                '3'  => '33.33333333%',
                                '4'  => '25%',
                                '5'  => '20%',
                                '6'  => '16.66666667%',
                                '7'  => '14.28571428%',
                                '8'  => '12.5%',
                                '9'  => '11.11111111%',
                                '10' => '10%',
                            ),
                            "heading"     => 'Modules per row',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-small",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_per_row.png",
                        ),
                        array(
                            "param_name"  => "modules_gap",
                            "type"        => "textfield-responsive",
                            "value"       => '48',
                            "heading"     => 'Modules gap',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "40",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_gap.png",
                        ),
                        array(
                            "param_name"  => "m_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Modules padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_padding.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Border',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "modules_border_size",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_border_width.png",
                        ),
                        array(
                            "param_name"  => "modules_border_style",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Solid'  => '',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Border style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_style.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Border color',
                            "param_name"  => "modules_border_color",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Title',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name" => "mc1_title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H3' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H4' => 'h4',
                                'Paragraph' => 'p'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/module_title_seo.png",
                            "group" => "Module"
                        ),
                        array(
                            "param_name"  => "mc1_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                            "info_img" => "https://cloud.tagdiv.com/help/title_length.png",
                            "group" => "Module"
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Image',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "image_height",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "50",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_height.png",
                        ),
                        array(
                            "param_name"  => "image_width",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (0-100 percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_width.png",
                        ),
                        array(
                            "param_name"  => "image_size",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Medium - Default - 696x0px'  => '',
                                '-- [No crop] --' => '__',
                                'XSmall - 150x0px' => 'td_150x0',
                                'Small - 300x0px' => 'td_300x0',
                                'Large - 1068x0px' => 'td_1068x0',
                                'Full - 1920x0px'  => 'td_1920x0',
                                '-- [Other sizes] --' => '__',
                                '218x150px' => 'td_218x150',
                                '324x400px'  => 'td_324x400',
                                '485x360' => 'td_485x360'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_image_size.png",
                        ),
                        array(
                            "param_name"  => "image_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_radius.png",
                        ),

                    ),
                    td_config_helper::mix_blend('Module'),
                    td_config_helper::image_filters(),
                    td_config::get_map_exclusive_label_array(),
                    array(

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Compass',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Fonts',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),

                    ),
                    td_config_helper::get_map_block_font_array( 'f_art_title_compass', true, 'Article Title', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_average_score_label_compass', false, 'Average Score Label', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_review_score_label_compass', false, 'Review Score Label', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_average_score_compass', false, 'Average Score', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_review_score_compass', false, 'Review Score', "Module", '', '', '', '' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Colors',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Title Color',
                            "param_name"  => "td_compass_title_color",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Average Score Label',
                            "param_name"  => "td_compass_average_score_label_color",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Review Score Label',
                            "param_name"  => "td_compass_review_score_label_color",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Average Score',
                            "param_name"  => "td_compass_average_score_color",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Review Score',
                            "param_name"  => "td_compass_review_score_color",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Average Score Background',
                            "param_name"  => "td_compass_average_score_background_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Average Score Background Hover',
                            "param_name"  => "td_compass_average_score_background_color_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Review Score Background',
                            "param_name"  => "td_compass_review_score_background_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Review Score Background Hover',
                            "param_name"  => "td_compass_review_score_background_color_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Image Border Color',
                            "param_name"  => "td_compass_image_border_color",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Margins and Paddings',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "td_compass_average_score_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Average Score Margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_compass_title_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Title Margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_compass_review_score_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Review Score Margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_compass_average_score_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '10px',
                            "heading"     => 'Average Score Padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_compass_review_score_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '10px',
                            "heading"     => 'Review Score Padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_compass_average_score_border_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Average Score Border Radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_compass_review_score_border_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Review Score Border Radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_compass_image_container_border",
                            "type"        => "textfield-responsive",
                            "value"       => '1px',
                            "heading"     => 'Image Container Border',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_compass_image_container_border_style",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Solid'  => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Image Border style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_compass_image_container_border_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '50%',
                            "heading"     => 'Image Border Radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),

                    )
                )
            )
        );
    }

	public function register_styles_3() {
        td_api_style::add( 'tds_compass_module_style03', array(
                'group' => 'tds_module_loop_style',
                'title' => 'Compass Module 03',
                'file' => $this->td_demo_cmstyles_path . '/includes/styles/tds_module_loop_style/tds_compass_module_style03.php',
                'params' => array_merge(
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'General',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Layout',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),


                        array(
                            "param_name"  => "modules_on_row",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                '1'  => '100%',
                                '2'  => '50%',
                                '3'  => '33.33333333%',
                                '4'  => '25%',
                                '5'  => '20%',
                                '6'  => '16.66666667%',
                                '7'  => '14.28571428%',
                                '8'  => '12.5%',
                                '9'  => '11.11111111%',
                                '10' => '10%',
                            ),
                            "heading"     => 'Modules per row',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-small",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_per_row.png",
                        ),
                        array(
                            "param_name"  => "modules_gap",
                            "type"        => "textfield-responsive",
                            "value"       => '48',
                            "heading"     => 'Modules gap',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "40",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_gap.png",
                        ),
                        array(
                            "param_name"  => "m_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Modules padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_padding.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Border',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "modules_border_size",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_border_width.png",
                        ),
                        array(
                            "param_name"  => "modules_border_style",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Solid'  => '',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Border style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_style.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Border color',
                            "param_name"  => "modules_border_color",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Title',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name" => "mc1_title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H3' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H4' => 'h4',
                                'Paragraph' => 'p'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/module_title_seo.png",
                            "group" => "Module"
                        ),
                        array(
                            "param_name"  => "mc1_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                            "info_img" => "https://cloud.tagdiv.com/help/title_length.png",
                            "group" => "Module"
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Image',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "image_height",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "50",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_height.png",
                        ),
                        array(
                            "param_name"  => "image_width",
                            "type"        => "textfield-responsive",
                            "value"       => '50',
                            "heading"     => 'Image width (0-100 percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_width.png",
                        ),
                        array(
                            "param_name"  => "image_size",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Medium - Default - 696x0px'  => '',
                                '-- [No crop] --' => '__',
                                'XSmall - 150x0px' => 'td_150x0',
                                'Small - 300x0px' => 'td_300x0',
                                'Large - 1068x0px' => 'td_1068x0',
                                'Full - 1920x0px'  => 'td_1920x0',
                                '-- [Other sizes] --' => '__',
                                '218x150px' => 'td_218x150',
                                '324x400px'  => 'td_324x400',
                                '485x360' => 'td_485x360'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_image_size.png",
                        ),
                        array(
                            "param_name"  => "image_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_radius.png",
                        ),

                    ),
                    td_config_helper::mix_blend('Module'),
                    td_config_helper::image_filters(),
                    td_config::get_map_exclusive_label_array(),
                    array(

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Compass',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Categories/Tags',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "categories",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Categories/Tags',
                            "description" => "Comma separated slugs",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-extrabig",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "cat_limit",
                            "type"        => "textfield",
                            "value"       => '3',
                            "heading"     => 'Categories/Tags limit',
                            "description" => "Limit the categories/tags displayed",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Paddings and Margins',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "td_compass_title_3_margins",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Title Margins',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_compass_meta_info_container_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta Info Margins',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_compass_label_3_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '0 0 0 5px',
                            "heading"     => 'Label Name Margins',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_compass_release_date_3_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '0 0 0 5px',
                            "heading"     => 'Release Date Name Margins',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_compass_average_score_3_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '0 0 0 5px',
                            "heading"     => 'Average Score Name Margins',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_compass_review_score_3_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '0 0 0 5px',
                            "heading"     => 'Review Score Name Margins',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_compass_release_3_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Release Date Margins',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_compass_review_3_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Review Score Margins',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_compass_average_score_padding_3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Average Score Padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_compass_review_score_padding_3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Average Score Padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_cats_tags_margin_3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Categories/Tags Margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0 5px 0 0",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_cats_tags_padding_3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Categories/Tags Padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "1px 3px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_cats_tags_margin_3module",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Categories/Tags Margin Module',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "1px 3px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Fonts',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_art_title_compass_3', true, 'Article Title', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_label_compass_3', false, 'Label', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_label_compass_name_3', false, 'Label Name', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_release_date_compass_3', false, 'Release Date', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_release_date_info_compass_3', false, 'Release Date Info', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_average_score_compass_3', false, 'Average Score', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_average_score_compass_info_3', false, 'Average Score Info', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_review_score_compass_3', false, 'Review Score', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_review_score_compass_info_3', false, 'Review Score Info', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_cat_tag_compass_info_3', false, 'Categories/Tags', "Module", '', '', '', '' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Name Colors',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Label',
                            "param_name"  => "td_compass_label_name_color_3",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Release Date',
                            "param_name"  => "td_compass_release_date_name_color_3",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Average Score',
                            "param_name"  => "td_compass_average_score_color_3",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Review Score',
                            "param_name"  => "td_compass_review_score_color_3",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Information Color',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Label',
                            "param_name"  => "td_compass_label_color_info_3",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Release Date',
                            "param_name"  => "td_compass_release_date_color_info_3",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Average Score',
                            "param_name"  => "td_compass_average_score_color_info_3",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Review Score',
                            "param_name"  => "td_compass_review_score_color_info_3",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Average Score Background',
                            "param_name"  => "td_compass_average_score_background_3",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Review Score Background',
                            "param_name"  => "td_compass_review_score_background_3",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'More Colors',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Title Color',
                            "param_name"  => "td_compass_title_color_3",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Title Hover Color',
                            "param_name"  => "td_compass_title_color_3_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Categories/Tags Color',
                            "param_name"  => "td_cat_tag_3color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Categories/Tags Color Hover',
                            "param_name"  => "td_cat_tag_color_3hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Categories/Tags Background',
                            "param_name"  => "td_cat_tag_3bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Categories/Tags Background Hover',
                            "param_name"  => "td_cat_tag_bg_3hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                    )
                )
            )
        );
    }

	public function register_styles_4() {
        td_api_style::add( 'tds_compass_module_style04', array(
                'group' => 'tds_module_loop_style',
                'title' => 'Compass Module 04',
                'file' => $this->td_demo_cmstyles_path . '/includes/styles/tds_module_loop_style/tds_compass_module_style04.php',
                'params' => array_merge(
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'General',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Layout',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),


                        array(
                            "param_name"  => "modules_on_row",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                '1'  => '100%',
                                '2'  => '50%',
                                '3'  => '33.33333333%',
                                '4'  => '25%',
                                '5'  => '20%',
                                '6'  => '16.66666667%',
                                '7'  => '14.28571428%',
                                '8'  => '12.5%',
                                '9'  => '11.11111111%',
                                '10' => '10%',
                            ),
                            "heading"     => 'Modules per row',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-small",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_per_row.png",
                        ),
                        array(
                            "param_name"  => "modules_gap",
                            "type"        => "textfield-responsive",
                            "value"       => '48',
                            "heading"     => 'Modules gap',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "40",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_gap.png",
                        ),
                        array(
                            "param_name"  => "m_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Modules padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_padding.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Border',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "modules_border_size",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_border_width.png",
                        ),
                        array(
                            "param_name"  => "modules_border_style",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Solid'  => '',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Border style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_style.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Border color',
                            "param_name"  => "modules_border_color",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Title',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name" => "mc1_title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H3' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H4' => 'h4',
                                'Paragraph' => 'p'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/module_title_seo.png",
                            "group" => "Module"
                        ),
                        array(
                            "param_name"  => "mc1_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                            "info_img" => "https://cloud.tagdiv.com/help/title_length.png",
                            "group" => "Module"
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Image',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "image_height",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "50",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_height.png",
                        ),
                        array(
                            "param_name"  => "image_width",
                            "type"        => "textfield-responsive",
                            "value"       => '50',
                            "heading"     => 'Image width (0-100 percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_width.png",
                        ),
                        array(
                            "param_name"  => "image_size",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Medium - Default - 696x0px'  => '',
                                '-- [No crop] --' => '__',
                                'XSmall - 150x0px' => 'td_150x0',
                                'Small - 300x0px' => 'td_300x0',
                                'Large - 1068x0px' => 'td_1068x0',
                                'Full - 1920x0px'  => 'td_1920x0',
                                '-- [Other sizes] --' => '__',
                                '218x150px' => 'td_218x150',
                                '324x400px'  => 'td_324x400',
                                '485x360' => 'td_485x360'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_image_size.png",
                        ),
                        array(
                            "param_name"  => "image_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_radius.png",
                        ),

                    ),
                    td_config_helper::mix_blend('Module'),
                    td_config_helper::image_filters(),
                    td_config::get_map_exclusive_label_array(),
                    array(

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Compass',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Margins and Paddings',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "td_compass_buy_padding_4",
                            "type"        => "textfield-responsive",
                            "value"       => '10px',
                            "heading"     => 'Buy Album Padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_compass_buy_album_margin_4",
                            "type"        => "textfield-responsive",
                            "value"       => '10px',
                            "heading"     => 'Buy Album Margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_compass_title_4",
                            "type"        => "textfield-responsive",
                            "value"       => '10px',
                            "heading"     => 'Title Margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Fonts',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_compass_buy_album_4', true, 'Buy Album', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_compass_art_title_4', false, 'Title', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_compass_release_date_4', false, 'Release Date', "Module", '', '', '', '' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Colors',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Buy Album Color',
                            "param_name"  => "td_compass_buy_album_co",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Buy Album Hover Color',
                            "param_name"  => "td_compass_buy_album_co_ho",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Title Color',
                            "param_name"  => "td_compass_title_co",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Title Hover Color',
                            "param_name"  => "td_compass_title_co_ho",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Release Date Color',
                            "param_name"  => "td_compass_release_date_co",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                        ),
                    ),
                    td_config_helper::get_map_block_shadow_array('compass_img4_shadow', 'Image Shadow', 0, 0, 0, "Module", '', 0, true, '', '', '' )
                )
            )
        );
    }

	public function register_styles_5() {
        td_api_style::add( 'tds_compass_module_style05', array(
                'group' => 'tds_module_loop_style',
                'title' => 'Compass Module 05',
                'file' => $this->td_demo_cmstyles_path . '/includes/styles/tds_module_loop_style/tds_compass_module_style05.php',
                'params' => array_merge(
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'General',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Layout',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),


                        array(
                            "param_name"  => "modules_on_row",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                '1'  => '100%',
                                '2'  => '50%',
                                '3'  => '33.33333333%',
                                '4'  => '25%',
                                '5'  => '20%',
                                '6'  => '16.66666667%',
                                '7'  => '14.28571428%',
                                '8'  => '12.5%',
                                '9'  => '11.11111111%',
                                '10' => '10%',
                            ),
                            "heading"     => 'Modules per row',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-small",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_per_row.png",
                        ),
                        array(
                            "param_name"  => "modules_gap",
                            "type"        => "textfield-responsive",
                            "value"       => '48',
                            "heading"     => 'Modules gap',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "40",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_gap.png",
                        ),
                        array(
                            "param_name"  => "m_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Modules padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_padding.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Border',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "modules_border_size",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_border_width.png",
                        ),
                        array(
                            "param_name"  => "modules_border_style",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Solid'  => '',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Border style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_style.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Border color',
                            "param_name"  => "modules_border_color",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Title',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name" => "mc1_title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H3' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H4' => 'h4',
                                'Paragraph' => 'p'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/module_title_seo.png",
                            "group" => "Module"
                        ),
                        array(
                            "param_name"  => "mc1_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                            "info_img" => "https://cloud.tagdiv.com/help/title_length.png",
                            "group" => "Module"
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Image',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "image_height",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "50",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_height.png",
                        ),
                        array(
                            "param_name"  => "image_width",
                            "type"        => "textfield-responsive",
                            "value"       => '50',
                            "heading"     => 'Image width (0-100 percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_width.png",
                        ),
                        array(
                            "param_name"  => "image_size",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Medium - Default - 696x0px'  => '',
                                '-- [No crop] --' => '__',
                                'XSmall - 150x0px' => 'td_150x0',
                                'Small - 300x0px' => 'td_300x0',
                                'Large - 1068x0px' => 'td_1068x0',
                                'Full - 1920x0px'  => 'td_1920x0',
                                '-- [Other sizes] --' => '__',
                                '218x150px' => 'td_218x150',
                                '324x400px'  => 'td_324x400',
                                '485x360' => 'td_485x360'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_image_size.png",
                        ),
                        array(
                            "param_name"  => "image_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_radius.png",
                        ),

                    ),
                    td_config_helper::mix_blend('Module'),
                    td_config_helper::image_filters(),
                    td_config::get_map_exclusive_label_array(),
                    array(

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Compass',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Fonts',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_art_title_5compass', true, 'Article Title', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_release_5date_compass', false, 'Release Date', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_release_5date_info_compass', false, 'Release Date Info', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_label_5compass', false, 'Label', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_label_5compass_name', false, 'Label Name', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_review_5score_compass', false, 'Review Score', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_review_5score_compass_info', false, 'Review Score Info', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_buy_5album_compass', false, 'Buy Album', "Module", '', '', '', '' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Margins and Paddings',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "td_compass_title5_margins",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Title Margins',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_compass_release5_margins",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Release Date Margins',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_compass_label5_margins",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Label Margins',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_compass_review5_margins",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Review Score Margins',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_compass_buyalbum5_margins",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Buy Album Margins',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Colors',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Title Color',
                            "param_name"  => "td_compass_title5_co",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Title Color Hover',
                            "param_name"  => "td_compass_title5_coho",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Buy Album Color',
                            "param_name"  => "td_compass_buyalbum5_co",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Buy Album Color Hover',
                            "param_name"  => "td_compass_buyalbum5_coho",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Release Date Color',
                            "param_name"  => "td_compass_releasedate5_co",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Release Date Name Color',
                            "param_name"  => "td_compass_releasedatename5_co",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Label Color',
                            "param_name"  => "td_compass_label5_co",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Label Name Color',
                            "param_name"  => "td_compass_labelname5_co",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Review Score Color',
                            "param_name"  => "td_compass_reviewscore5_co",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Review Score Name Color',
                            "param_name"  => "td_compass_reviewscorename5_co",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                        ),
                    )
                )
            )
        );
    }

}

