<?php if ( !defined( 'ABSPATH' ) ) exit(); // Exit if accessed directly

/**
 * Class Moore_Elementor_Contact_Info
 */
if ( !class_exists( 'Moore_Elementor_Contact_Info', false ) ) {

	class Moore_Elementor_Contact_Info extends \Elementor\Widget_Base {

		/**
		 * Get widget name
		 */
		public function get_name() {
			return 'moore_elementor_contact_info';
		}

		/**
		 * Get widget title
		 */
		public function get_title() {
			return esc_html__( 'Contact Info', 'moore' );
		}

		/**
		 * Get widget icon
		 */
		public function get_icon() {
			return ' eicon-map-pin';
		}

		/**
		 * Get widget categories
		 */
		public function get_categories() {
			return [ 'moore' ];
		}

		/**
		 * Get script depends
		 */
		public function get_script_depends() {
			return [];
		}

		/**
		 * Register controls
		 */
		protected function register_controls() {

			/**
			 * Content Tab
			 */
			$this->start_controls_section(
				'section_content',
				[
					'label' => esc_html__( 'Content', 'moore' ),
					
				]
			);

				$this->add_control(
					'icon',
					[
						'label' 	=> esc_html__( 'Class Icon', 'moore' ),
						'type' 		=> \Elementor\Controls_Manager::TEXT,
						'default' 	=> 'ovaicon-facebook-logo',
					]
				);

				$this->add_control(
					'label',
					[
						'label' 	=> esc_html__( 'Label', 'moore' ),
						'type' 		=> \Elementor\Controls_Manager::TEXT,
						'default' 	=> esc_html__('Label', 'moore'),
					]
				);

				// New repeater
				$repeater = new \Elementor\Repeater();

					$repeater->add_control(
						'type',
						[
							'label' 	=> esc_html__( 'Type', 'moore' ),
							'type' 		=> \Elementor\Controls_Manager::SELECT,
							'default' 	=> 'email',
							'options' 	=> [
								'email' => esc_html__( 'Email', 'moore' ),
								'phone' => esc_html__( 'Phone', 'moore' ),
								'link' 	=> esc_html__( 'Link', 'moore' ),
								'text' 	=> esc_html__( 'Text', 'moore' ),
							]
						]
					);

					$repeater->add_control(
						'email_label',
						[
							'label'   		=> esc_html__( 'Email Label', 'moore' ),
							'type'    		=> \Elementor\Controls_Manager::TEXT,
							'description' 	=> esc_html__( 'email@company.com', 'moore' ),
							'condition' 	=> [
								'type' => 'email',
							]
						]
					);

					$repeater->add_control(
						'email_address',
						[
							'label'   		=> esc_html__( 'Email Adress', 'moore' ),
							'type'    		=> \Elementor\Controls_Manager::TEXT,
							'description' 	=> esc_html__( 'email@company.com', 'moore' ),
							'condition' 	=> [
								'type' => 'email',
							]
						]
					);

					$repeater->add_control(
						'phone_label',
						[
							'label'   		=> esc_html__( 'Phone Label', 'moore' ),
							'type'    		=> \Elementor\Controls_Manager::TEXT,
							'description' 	=> esc_html__( '+012 (345) 678', 'moore' ),
							'condition' 	=> [
								'type' => 'phone',
							]
						]
					);

					$repeater->add_control(
						'phone_address',
						[
							'label'   		=> esc_html__( 'Phone Adress', 'moore' ),
							'type'    		=> \Elementor\Controls_Manager::TEXT,
							'description' 	=> esc_html__( '+012345678', 'moore' ),
							'condition' 	=> [
								'type' => 'phone',
							]
						]
					);

					$repeater->add_control(
						'link_label',
						[
							'label'   		=> esc_html__( 'Link Label', 'moore' ),
							'type'    		=> \Elementor\Controls_Manager::TEXT,
							'description' 	=> esc_html__( 'https://your-domain.com', 'moore' ),
							'condition' 	=> [
								'type' => 'link',
							]

						]
					);

					$repeater->add_control(
						'link_address',
						[
							'label'   		=> esc_html__( 'Link Adress', 'moore' ),
							'type'    		=> \Elementor\Controls_Manager::URL,
							'description' 	=> esc_html__( 'https://your-domain.com', 'moore' ),
							'condition' 	=> [
								'type' => 'link',
							],
							'show_external' => false,
							'default' 		=> [
								'url' 			=> '#',
								'is_external' 	=> false,
								'nofollow' 		=> false,
							],
						]
					);

					$repeater->add_control(
						'text',
						[
							'label'   		=> esc_html__( 'Text', 'moore' ),
							'type'    		=> \Elementor\Controls_Manager::TEXT,
							'description' 	=> esc_html__( 'Your text', 'moore' ),
							'condition' 	=> [
								'type' => 'text',
							]
						]
					);

					$this->add_control(
						'items_info',
						[
							'label' 	=> esc_html__( 'Items Info', 'moore' ),
							'type' 		=> \Elementor\Controls_Manager::REPEATER,
							'fields' 	=> $repeater->get_controls(),
							'default' 	=> [
								[
									'type' 			=> 'email',
									'email_label' 	=> esc_html__( 'email@company.com', 'moore' ),
									'email_address' => esc_html__( 'email@company.com', 'moore' ),
								],
							],
							'title_field' => '{{{ type }}}',
						]
					);

				$this->add_responsive_control(
					'align',
					[
						'label' 	=> esc_html__( 'Alignment', 'moore' ),
						'type' 		=> \Elementor\Controls_Manager::CHOOSE,
						'options' 	=> [
							'left' 	=> [
								'title' => esc_html__( 'Left', 'moore' ),
								'icon' 	=> 'eicon-text-align-left',
							],
							'center' => [
								'title' => esc_html__( 'Center', 'moore' ),
								'icon' 	=> 'eicon-text-align-center',
							],
							'right' => [
								'title' => esc_html__( 'Right', 'moore' ),
								'icon' 	=> 'eicon-text-align-right',
							],
							
						],
						'default' 	=> 'left',
						'selectors' => [
							'{{WRAPPER}} .ova-contact-info' => 'justify-content: {{VALUE}};',
						],
					]
				);

			$this->end_controls_section(); // End Content Tab

			/**
			 * Icon Style Tab
			 */
			$this->start_controls_section(
				'section_icon_style',
				[
					'label' => esc_html__( 'Icon', 'moore' ),
					'tab' 	=> \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

				$this->add_control(
					'icon_fontsize',
					[
						'label' 		=> esc_html__( 'Font Size', 'moore' ),
						'type' 			=> \Elementor\Controls_Manager::SLIDER,
						'size_units' 	=> [ 'px' ],
						'range' 		=> [
							'px' => [
								'min' 	=> 1,
								'max' 	=> 300,
								'step' 	=> 1,
							]
						],
						'selectors' 	=> [
							'{{WRAPPER}} .ova-contact-info .icon' => 'font-size: {{SIZE}}{{UNIT}};',
						],
					]
				);

				$this->add_control(
					'icon_color',
					[
						'label' 	=> esc_html__( 'Color', 'moore' ),
						'type' 		=> \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-contact-info .icon' => 'color : {{VALUE}};',
						],
					]
				);

				$this->add_responsive_control(
					'icon_margin',
					[
						'label' 		=> esc_html__( 'Margin', 'moore' ),
						'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
						'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
						'selectors' 	=> [
							'{{WRAPPER}} .ova-contact-info .icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]
				);

			$this->end_controls_section(); // End Icon Style Tab

			/**
			 * Label Style Tab
			 */
			$this->start_controls_section(
				'section_label_style',
				[
					'label' => esc_html__( 'Label', 'moore' ),
					'tab' 	=> \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

				$this->add_control(
					'label_color',
					[
						'label' 	=> esc_html__( 'Color', 'moore' ),
						'type' 		=> \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-contact-info .contact .label' => 'color : {{VALUE}};',
						],
					]
				);

				$this->add_group_control(
					\Elementor\Group_Control_Typography::get_type(),
					[
						'name' 		=> 'label_typography',
						'selector' 	=> '{{WRAPPER}} .ova-contact-info .contact .label',
					]
				);

				$this->add_responsive_control(
					'label_margin',
					[
						'label' 		=> esc_html__( 'Margin', 'moore' ),
						'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
						'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
						'selectors' 	=> [
							'{{WRAPPER}} .ova-contact-info .contact .label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]
				);

			$this->end_controls_section(); // End Label Style Tab


			/**
			 * Info Style Tab
			 */
			$this->start_controls_section(
				'section_info_style',
				[
					'label' => esc_html__( 'Info', 'moore' ),
					'tab' 	=> \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

				$this->add_control(
					'info_color',
					[
						'label' 	=> esc_html__( 'Color', 'moore' ),
						'type' 		=> \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-contact-info .contact .info .item' => 'color : {{VALUE}};',
							'{{WRAPPER}} .ova-contact-info .contact .info .item a' => 'color : {{VALUE}};',
						],
					]
				);

				$this->add_control(
					'info_color_hover',
					[
						'label' 	=> esc_html__( 'Link Color hover', 'moore' ),
						'type' 		=> \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-contact-info .contact .info .item a:hover' => 'color : {{VALUE}};',
						],
					]
				);

				$this->add_control(
					'info_line_color_hover',
					[
						'label' 	=> esc_html__( 'Line Color', 'moore' ),
						'type' 		=> \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-contact-info .contact .info .item a:before' => 'background-color : {{VALUE}};',
						],
					]
				);

				$this->add_group_control(
					\Elementor\Group_Control_Typography::get_type(),
					[
						'name' 		=> 'info_typography',
						'selector' 	=> '{{WRAPPER}} .ova-contact-info .contact .info .item a',
					]
				);

				$this->add_responsive_control(
					'info_margin',
					[
						'label' 		=> esc_html__( 'Margin', 'moore' ),
						'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
						'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
						'selectors' 	=> [
							'{{WRAPPER}} .ova-contact-info .contact .info .item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]
				);

			$this->end_controls_section(); // End Label Style Tab
		}

		/**
		 * Render HTML
		 */
		protected function render() {
			// Get settings
			$settings = $this->get_settings_for_display();

			// Get icon
			$icon = isset( $settings['icon'] ) ? $settings['icon'] : '';

			// Get label
			$label = isset( $settings['label'] ) ? $settings['label'] : '';

			// Get items info
			$items_info = isset( $settings['items_info'] ) ? $settings['items_info'] : '';
			
			?>
			<div class="ova-contact-info">
				<?php if ( $icon ): ?>
					<div class="icon">
						<i class="<?php echo esc_attr( $icon ); ?>"></i>
					</div>	
				<?php endif; ?>
				<div class="contact">
					<?php if ( $label ): ?>
						<div class="label">
							<?php echo esc_html( $label ); ?>
						</div>
					<?php endif; ?>
					<ul class="info">
						<?php if ( !empty( $items_info ) && is_array( $items_info ) ):
							foreach ( $items_info as $item ):
								$type = isset( $item['type'] ) ? $item['type'] : '';
							?>
								<li class="item">
								<?php switch ( $type ) {
									case 'email':
										// Get email address
										$email_address = isset( $item['email_address'] ) ? $item['email_address'] : '';

										// Get email label
										$email_label = isset( $item['email_label'] ) ? $item['email_label'] : '';

										if ( $email_address && $email_label ): ?>
											<a href="mailto:<?php echo esc_attr( $email_address ) ?> ">
												<?php echo esc_html( $email_label ); ?>
											</a>
										<?php endif;
										break;
									case 'phone':
										// Get phone number
										$phone_number = isset( $item['phone_address'] ) ? $item['phone_address'] : '';

										// Get phone label
										$phone_label = isset( $item['phone_label'] ) ? $item['phone_label'] : '';

										if ( $phone_number && $phone_label ): ?>
											<a href="tel:<?php echo esc_attr( $phone_number ) ?> ">
												<?php echo esc_html( $phone_label ); ?>
											</a>
										<?php endif;
										break;
									case 'link':
										// Get link URL
										$link_url = isset( $item['link_address']['url'] ) ? $item['link_address']['url'] : '';

										// Get title
										$title = isset( $item['link_label'] ) ? $item['link_label'] : '';

										// Target
										$targer = isset( $item['link_address']['is_external'] ) && $item['link_address']['is_external'] ? '_blank' : '_self';

										// Nofollow
										$nofollow = isset( $item['link_address']['nofollow'] ) && $item['link_address']['nofollow'] ? 'nofollow' : '';

										if ( $link_url ): ?>
											<a href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $targer ); ?>" rel="<?php echo esc_attr( $nofollow ); ?>">
												<?php echo esc_html( $title ); ?>
											</a>
										<?php else:
											echo esc_html( $title );
										endif;
										break;
									case 'text':
										$text = isset( $item['text'] ) ? $item['text'] : '';
										echo esc_html( $text );
										break;
									default:
										break;
								} ?>
								</li>
							<?php endforeach;
						endif; ?>
					</ul>
				</div>
			</div>
			<?php
		}
	}

	// init widget
	$widgets_manager->register( new Moore_Elementor_Contact_Info() );
}