<?php
/**
 * The Header: Logo and main menu
 *
 * @package SMARTSEO
 * @since SMARTSEO 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js<?php
	// Class scheme_xxx need in the <html> as context for the <body>!
	echo ' scheme_' . esc_attr( smartseo_get_theme_option( 'color_scheme' ) );
?>">

<head>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}
	do_action( 'smartseo_action_before_body' );
	?>

	<div class="<?php echo esc_attr( apply_filters( 'smartseo_filter_body_wrap_class', 'body_wrap' ) ); ?>" <?php do_action('smartseo_action_body_wrap_attributes'); ?>>

		<?php do_action( 'smartseo_action_before_page_wrap' ); ?>

		<div class="<?php echo esc_attr( apply_filters( 'smartseo_filter_page_wrap_class', 'page_wrap' ) ); ?>" <?php do_action('smartseo_action_page_wrap_attributes'); ?>>

			<?php do_action( 'smartseo_action_page_wrap_start' ); ?>

			<?php
			$smartseo_full_post_loading = ( smartseo_is_singular( 'post' ) || smartseo_is_singular( 'attachment' ) ) && smartseo_get_value_gp( 'action' ) == 'full_post_loading';
			$smartseo_prev_post_loading = ( smartseo_is_singular( 'post' ) || smartseo_is_singular( 'attachment' ) ) && smartseo_get_value_gp( 'action' ) == 'prev_post_loading';

			// Don't display the header elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ! $smartseo_full_post_loading && ! $smartseo_prev_post_loading ) {

				// Short links to fast access to the content, sidebar and footer from the keyboard
				?>
				<a class="smartseo_skip_link skip_to_content_link" href="#content_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'smartseo_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to content", 'smartseo' ); ?></a>
				<?php if ( smartseo_sidebar_present() ) { ?>
				<a class="smartseo_skip_link skip_to_sidebar_link" href="#sidebar_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'smartseo_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to sidebar", 'smartseo' ); ?></a>
				<?php } ?>
				<a class="smartseo_skip_link skip_to_footer_link" href="#footer_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'smartseo_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to footer", 'smartseo' ); ?></a>

				<?php
				do_action( 'smartseo_action_before_header' );

				// Header
				$smartseo_header_type = smartseo_get_theme_option( 'header_type' );
				if ( 'custom' == $smartseo_header_type && ! smartseo_is_layouts_available() ) {
					$smartseo_header_type = 'default';
				}
				get_template_part( apply_filters( 'smartseo_filter_get_template_part', "templates/header-" . sanitize_file_name( $smartseo_header_type ) ) );

				// Side menu
				if ( in_array( smartseo_get_theme_option( 'menu_side', 'none' ), array( 'left', 'right' ) ) ) {
					get_template_part( apply_filters( 'smartseo_filter_get_template_part', 'templates/header-navi-side' ) );
				}

				// Mobile menu
				if ( apply_filters( 'smartseo_filter_use_navi_mobile', true ) ) {
					get_template_part( apply_filters( 'smartseo_filter_get_template_part', 'templates/header-navi-mobile' ) );
				}

				do_action( 'smartseo_action_after_header' );

			}
			?>

			<?php do_action( 'smartseo_action_before_page_content_wrap' ); ?>

			<div class="page_content_wrap<?php
				if ( smartseo_is_off( smartseo_get_theme_option( 'remove_margins' ) ) ) {
					if ( empty( $smartseo_header_type ) ) {
						$smartseo_header_type = smartseo_get_theme_option( 'header_type' );
					}
					if ( 'custom' == $smartseo_header_type && smartseo_is_layouts_available() ) {
						$smartseo_header_id = smartseo_get_custom_header_id();
						if ( $smartseo_header_id > 0 ) {
							$smartseo_header_meta = smartseo_get_custom_layout_meta( $smartseo_header_id );
							if ( ! empty( $smartseo_header_meta['margin'] ) ) {
								?> page_content_wrap_custom_header_margin<?php
							}
						}
					}
					$smartseo_footer_type = smartseo_get_theme_option( 'footer_type' );
					if ( 'custom' == $smartseo_footer_type && smartseo_is_layouts_available() ) {
						$smartseo_footer_id = smartseo_get_custom_footer_id();
						if ( $smartseo_footer_id ) {
							$smartseo_footer_meta = smartseo_get_custom_layout_meta( $smartseo_footer_id );
							if ( ! empty( $smartseo_footer_meta['margin'] ) ) {
								?> page_content_wrap_custom_footer_margin<?php
							}
						}
					}
				}
				do_action( 'smartseo_action_page_content_wrap_class', $smartseo_prev_post_loading );
				?>"<?php
				if ( apply_filters( 'smartseo_filter_is_prev_post_loading', $smartseo_prev_post_loading ) ) {
					?> data-single-style="<?php echo esc_attr( smartseo_get_theme_option( 'single_style' ) ); ?>"<?php
				}
				do_action( 'smartseo_action_page_content_wrap_data', $smartseo_prev_post_loading );
			?>>
				<?php
				do_action( 'smartseo_action_page_content_wrap', $smartseo_full_post_loading || $smartseo_prev_post_loading );

				// Single posts banner
				if ( apply_filters( 'smartseo_filter_single_post_header', smartseo_is_singular( 'post' ) || smartseo_is_singular( 'attachment' ) ) ) {
					if ( $smartseo_prev_post_loading ) {
						if ( smartseo_get_theme_option( 'posts_navigation_scroll_which_block', 'article' ) != 'article' ) {
							do_action( 'smartseo_action_between_posts' );
						}
					}
					// Single post thumbnail and title
					$smartseo_path = apply_filters( 'smartseo_filter_get_template_part', 'templates/single-styles/' . smartseo_get_theme_option( 'single_style' ) );
					if ( smartseo_get_file_dir( $smartseo_path . '.php' ) != '' ) {
						get_template_part( $smartseo_path );
					}
				}

				// Widgets area above page
				$smartseo_body_style   = smartseo_get_theme_option( 'body_style' );
				$smartseo_widgets_name = smartseo_get_theme_option( 'widgets_above_page', 'hide' );
				$smartseo_show_widgets = ! smartseo_is_off( $smartseo_widgets_name ) && is_active_sidebar( $smartseo_widgets_name );
				if ( $smartseo_show_widgets ) {
					if ( 'fullscreen' != $smartseo_body_style ) {
						?>
						<div class="content_wrap">
							<?php
					}
					smartseo_create_widgets_area( 'widgets_above_page' );
					if ( 'fullscreen' != $smartseo_body_style ) {
						?>
						</div>
						<?php
					}
				}

				// Content area
				do_action( 'smartseo_action_before_content_wrap' );
				?>
				<div class="content_wrap<?php echo 'fullscreen' == $smartseo_body_style ? '_fullscreen' : ''; ?>">

					<?php do_action( 'smartseo_action_content_wrap_start' ); ?>

					<div class="content">
						<?php
						do_action( 'smartseo_action_page_content_start' );

						// Skip link anchor to fast access to the content from keyboard
						?>
						<a id="content_skip_link_anchor" class="smartseo_skip_link_anchor" href="#"></a>
						<?php
						// Single posts banner between prev/next posts
						if ( ( smartseo_is_singular( 'post' ) || smartseo_is_singular( 'attachment' ) )
							&& $smartseo_prev_post_loading 
							&& smartseo_get_theme_option( 'posts_navigation_scroll_which_block', 'article' ) == 'article'
						) {
							do_action( 'smartseo_action_between_posts' );
						}

						// Widgets area above content
						smartseo_create_widgets_area( 'widgets_above_content' );

						do_action( 'smartseo_action_page_content_start_text' );
