<?php
/**
 * The custom template to display the content
 *
 * Used for index/archive/search.
 *
 * @package SMARTSEO
 * @since SMARTSEO 1.0.50
 */

$smartseo_template_args = get_query_var( 'smartseo_template_args' );
if ( is_array( $smartseo_template_args ) ) {
	$smartseo_columns    = empty( $smartseo_template_args['columns'] ) ? 2 : max( 1, $smartseo_template_args['columns'] );
	$smartseo_blog_style = array( $smartseo_template_args['type'], $smartseo_columns );
} else {
	$smartseo_template_args = array();
	$smartseo_blog_style = explode( '_', smartseo_get_theme_option( 'blog_style' ) );
	$smartseo_columns    = empty( $smartseo_blog_style[1] ) ? 2 : max( 1, $smartseo_blog_style[1] );
}
$smartseo_blog_id       = smartseo_get_custom_blog_id( join( '_', $smartseo_blog_style ) );
$smartseo_blog_style[0] = str_replace( 'blog-custom-', '', $smartseo_blog_style[0] );
$smartseo_expanded      = ! smartseo_sidebar_present() && smartseo_get_theme_option( 'expand_content' ) == 'expand';
$smartseo_components    = ! empty( $smartseo_template_args['meta_parts'] )
							? ( is_array( $smartseo_template_args['meta_parts'] )
								? join( ',', $smartseo_template_args['meta_parts'] )
								: $smartseo_template_args['meta_parts']
								)
							: smartseo_array_get_keys_by_value( smartseo_get_theme_option( 'meta_parts' ) );
$smartseo_post_format   = get_post_format();
$smartseo_post_format   = empty( $smartseo_post_format ) ? 'standard' : str_replace( 'post-format-', '', $smartseo_post_format );

$smartseo_blog_meta     = smartseo_get_custom_layout_meta( $smartseo_blog_id );
$smartseo_custom_style  = ! empty( $smartseo_blog_meta['scripts_required'] ) ? $smartseo_blog_meta['scripts_required'] : 'none';

if ( ! empty( $smartseo_template_args['slider'] ) || $smartseo_columns > 1 || ! smartseo_is_off( $smartseo_custom_style ) ) {
	?><div class="
		<?php
		if ( ! empty( $smartseo_template_args['slider'] ) ) {
			echo 'slider-slide swiper-slide';
		} else {
			echo esc_attr( ( smartseo_is_off( $smartseo_custom_style ) ? 'column' : sprintf( '%1$s_item %1$s_item', $smartseo_custom_style ) ) . "-1_{$smartseo_columns}" );
		}
		?>
	">
	<?php
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
			'post_item post_item_container post_format_' . esc_attr( $smartseo_post_format )
					. ' post_layout_custom post_layout_custom_' . esc_attr( $smartseo_columns )
					. ' post_layout_' . esc_attr( $smartseo_blog_style[0] )
					. ' post_layout_' . esc_attr( $smartseo_blog_style[0] ) . '_' . esc_attr( $smartseo_columns )
					. ( ! smartseo_is_off( $smartseo_custom_style )
						? ' post_layout_' . esc_attr( $smartseo_custom_style )
							. ' post_layout_' . esc_attr( $smartseo_custom_style ) . '_' . esc_attr( $smartseo_columns )
						: ''
						)
		);
	smartseo_add_blog_animation( $smartseo_template_args );
	?>
>
	<?php
	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}
	// Custom layout
	do_action( 'smartseo_action_show_layout', $smartseo_blog_id, get_the_ID() );
	?>
</article><?php
if ( ! empty( $smartseo_template_args['slider'] ) || $smartseo_columns > 1 || ! smartseo_is_off( $smartseo_custom_style ) ) {
	?></div><?php
	// Need opening PHP-tag above just after </div>, because <div> is a inline-block element (used as column)!
}
