<?php
/**
 * The template to display the site logo in the footer
 *
 * @package SMARTSEO
 * @since SMARTSEO 1.0.10
 */

// Logo
if ( smartseo_is_on( smartseo_get_theme_option( 'logo_in_footer' ) ) ) {
	$smartseo_logo_image = smartseo_get_logo_image( 'footer' );
	$smartseo_logo_text  = get_bloginfo( 'name' );
	if ( ! empty( $smartseo_logo_image['logo'] ) || ! empty( $smartseo_logo_text ) ) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if ( ! empty( $smartseo_logo_image['logo'] ) ) {
					$smartseo_attr = smartseo_getimagesize( $smartseo_logo_image['logo'] );
					echo '<a href="' . esc_url( home_url( '/' ) ) . '">'
							. '<img src="' . esc_url( $smartseo_logo_image['logo'] ) . '"'
								. ( ! empty( $smartseo_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $smartseo_logo_image['logo_retina'] ) . ' 2x"' : '' )
								. ' class="logo_footer_image"'
								. ' alt="' . esc_attr__( 'Site logo', 'smartseo' ) . '"'
								. ( ! empty( $smartseo_attr[3] ) ? ' ' . wp_kses_data( $smartseo_attr[3] ) : '' )
							. '>'
						. '</a>';
				} elseif ( ! empty( $smartseo_logo_text ) ) {
					echo '<h1 class="logo_footer_text">'
							. '<a href="' . esc_url( home_url( '/' ) ) . '">'
								. esc_html( $smartseo_logo_text )
							. '</a>'
						. '</h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
