<?php

namespace PenciAIContentGenerator\AjaxRequests;

class GeneratePlaceholders {

	private $ajax;

	/**
	 * PreloadCaches constructor.
	 */
	public function __construct( $a ) {
		$this->ajax = $a;
		add_action( "wp_ajax_generate_placeholders", [ $this, 'ajax' ] );
	}

	public function ajax() {
		\penciai_checkNonce();

		if ( ! empty( get_bloginfo() ) ) {

			if ( ! empty( get_theme_mod( 'penci_ai_api_key' ) ) ) {
				$ai = new \OpenAIAPI( get_theme_mod( 'penci_ai_api_key' ) );
				$default_model = get_theme_mod( 'penci_ai_model', 'gpt-3.5-turbo-instruct' );
				$ai->setModel( $default_model );

				$lang    = get_locale();
				$in_lang = '';
				if ( ! empty( $lang ) && $lang != 'en_US' ) {
					if ( $lang == 'as' ) {
						$lang = 'Assamese';
					}
					$in_lang = ' in the "' . $lang . '" language.';
				}

				$prompt = 'Write some related topic of "' . get_bloginfo() . '"' . $in_lang;

				$data = array(
					'prompt'            => $prompt,
					'temperature'       => 0.3,
					'max_tokens'        => 2000, //short: 128 , medium: 128, long: 1000 (for topic detailes)
					'frequency_penalty' => 0,
					'presence_penalty'  => 0,
				);

				if ( $default_model == 'gpt-3.5-turbo-instruct' ) {
					$data['prompt'] = $prompt;
				} else {
					$data['model'] = $default_model;
					$data['messages'] = array(
						array(
							'role'    => 'user',
							'content' => $prompt,
						),
					);
				}

				$response = $ai->complete( $data );


				$str = "";
				if ( isset( $response ) && ! empty( $response ) && penciai_is_json( $response ) ) {

					$json = json_decode( $response );
					if ( $default_model == 'gpt-3.5-turbo-instruct' ) {
						$str = penciai_remove_first_br( $json->choices[0]->text );
					} else {
						$str = penciai_remove_first_br( $json->choices[0]->message->content );
					}

					$str = penciai_remove_first_br( $str );
					$str = explode( "\n", $str );
					$str = implode( ',', $str );
					$str = rtrim( $str, ',' );

					update_option( 'penciai-placeholders', $str );
				}

				wp_send_json_success( $str );

			} else {
				wp_send_json_error( 'API key is empty, please enter the API key on the settings panel first.' );
			}
		}

		wp_die();

	}
}
