<?php
/**
 * @author : PenciDesign
 */

namespace SoledadFW\Customizer;

/**
 * Class Theme Soledad Customizer
 */
class PenciBillard_Option extends CustomizerOptionAbstract {

	public $panelID = 'penci_player_rankings_panel';

	public function set_option() {
		$this->set_panel();
		$this->set_section();
	}

	public function set_panel() {
		$this->customizer->add_panel( [
			'id'       => $this->panelID,
			'title'    => esc_html__( 'Penci Player Rankings', 'penci-player-rankings' ),
			'priority' => $this->id,
		] );
	}

	public function set_section() {
		$this->add_lazy_section( 'penci_player_rankings_general_section', esc_html__( 'General Settings', 'penci-player-rankings' ), $this->panelID );
		$this->add_lazy_section( 'penci_player_rankings_style_section', esc_html__( 'Color & Styles', 'penci-player-rankings' ), $this->panelID );
		$this->add_lazy_section( 'penci_player_rankings_text_section', esc_html__( 'Quick Text Translations', 'penci-player-rankings' ), $this->panelID );
	}
}