<?php
$group_color = 'Typo & Color';

vc_map( array(
	'base'          => 'animated_headline',
	'icon'          => PENCI_SOLEDAD_URL . '/images/vc-icon.png',
	'category'      => penci_get_theme_name( 'Soledad' ),
	'html_template' => PENCI_SOLEDAD_DIR . '/inc/js_composer/shortcodes/animated_headline/frontend.php',
	'weight'        => 700,
	'name'          => penci_get_theme_name( 'Penci' ) . ' ' . esc_html__( 'Animated Headline', 'soledad' ),
	'description'   => __( 'Create awesome heading title effects', 'soledad' ),
	'controls'      => 'full',
	'params'        => array_merge( array(
		array(
			'type'       => 'dropdown',
			'heading'    => __( 'Style', 'soledad' ),
			'param_name' => 'text_style',
			'value'      => array(
				'None'        => 'none',
				'Highlighted' => 'highlighted',
				'Rotating'    => 'rotating',
			),
			'std'        => 'rotating',
		),
		array(
			'type'       => 'dropdown',
			'heading'    => __( 'Shape', 'soledad' ),
			'param_name' => 'text_shape',
			'value'      => array(
				'Circle'           => 'circle',
				'Curly'            => 'curly',
				'Underline'        => 'underline',
				'Double'           => 'double',
				'Double Underline' => 'double-underline',
				'Underline Zigzag' => 'underline-zigzag',
				'Diagonal'         => 'diagonal',
				'Strikethrough'    => 'strikethrough',
				'X'                => 'x',
			),
			'std'        => 'circle',
			'dependency' => array( 'element' => 'text_style', 'value' => array( 'highlighted' ) ),
		),
		array(
			'type'       => 'dropdown',
			'heading'    => __( 'Rotating', 'soledad' ),
			'param_name' => 'text_rotating',
			'value'      => array(
				'Typing'      => 'typing',
				'Clip'        => 'clip',
				'Flip'        => 'flip',
				'Swirl'       => 'swirl',
				'Blinds'      => 'blinds',
				'Bounce'      => 'bounce',
				'Swing'       => 'swing',
				'Rubber Band' => 'rubber-band',
				'Drop In'     => 'drop-in',
				'Wave'        => 'wave',
				'Slide Left'  => 'slide-left',
				'Slide Right' => 'slide-right',
				'Slide Up'    => 'slide-up',
				'Slide Down'  => 'slide-down',
			),
			'std'        => 'typing',
			'dependency' => array( 'element' => 'text_style', 'value' => array( 'rotating' ) ),
		),
		array(
			'type'       => 'textfield',
			'heading'    => __( 'Letter Speed', 'soledad' ),
			'param_name' => 'text_letter_speed',
			'value'      => '100',
		),
		array(
			'type'       => 'textfield',
			'heading'    => __( 'Delay on Change', 'soledad' ),
			'param_name' => 'text_delay_change',
			'value'      => '2000',
		),
		array(
			'type'       => 'textfield',
			'heading'    => __( 'Clip Duration', 'soledad' ),
			'param_name' => 'text_clip_duration',
			'value'      => '2000',
		),
		array(
			'type'       => 'textfield',
			'heading'    => __( 'Delay on Delete', 'soledad' ),
			'param_name' => 'text_delay_delete',
			'value'      => '500',
		),
		array(
			'type'       => 'textfield',
			'heading'    => __( 'Before Text', 'soledad' ),
			'param_name' => 'text_before',
		),
		array(
			'type'       => 'textfield',
			'heading'    => __( 'Animated Text', 'soledad' ),
			'param_name' => 'text_animated',
			'dependency' => array( 'element' => 'text_style', 'value' => array( 'highlighted' ) ),
		),
		array(
			'type'       => 'textarea',
			'heading'    => __( 'Animated Text', 'soledad' ),
			'param_name' => 'text_animated_list',
			'dependency' => array( 'element' => 'text_style', 'value' => array( 'rotating' ) ),
		),
		array(
			'type'       => 'textfield',
			'heading'    => __( 'After Text', 'soledad' ),
			'param_name' => 'text_after',
		),
		array(
			'type'       => 'vc_link',
			'heading'    => __( 'Link', 'soledad' ),
			'param_name' => 'text_link',
		),
		array(
			'type'       => 'dropdown',
			'heading'    => __( 'HTML Tag', 'soledad' ),
			'param_name' => 'text_html_tag',
			'value'      => array(
				'H1'   => 'h1',
				'H2'   => 'h2',
				'H3'   => 'h3',
				'H4'   => 'h4',
				'H5'   => 'h5',
				'H6'   => 'h6',
				'div'  => 'div',
				'span' => 'span',
				'p'    => 'p',
			),
		),
		array(
			'type'       => 'dropdown',
			'heading'    => __( 'Alignment', 'soledad' ),
			'param_name' => 'text_alignment',
			'value'      => array(
				'Left'   => 'left',
				'Center' => 'center',
				'Right'  => 'right',
			),
		),
	), array(
		array(
			'type'             => 'textfield',
			'param_name'       => 'penci_separator_001',
			'heading'          => __( 'Normal Text', 'soledad' ),
			'group'            => $group_color,
			'edit_field_class' => 'penci-param-heading-wrapper no-top-margin vc_column vc_col-sm-12',
		),
		array(
			'type'       => 'font_container',
			'heading'    => __( 'Normal Text Typography', 'soledad' ),
			'param_name' => 'text_normal_typography',
			'value'      => '',
			'group'      => $group_color,
			'settings'   => array(
				'fields' => array(
					'text_align',
					'font_size',
					'line_height',
					'color',
					'tag_description'         => esc_html__( 'Select element tag.', 'js_composer' ),
					'text_align_description'  => esc_html__( 'Select text alignment.', 'js_composer' ),
					'font_size_description'   => esc_html__( 'Enter font size.', 'js_composer' ),
					'line_height_description' => esc_html__( 'Enter line height.', 'js_composer' ),
					'color_description'       => esc_html__( 'Select color for your element.', 'js_composer' ),
				),
			),
		),
		array(
			'type'       => 'colorpicker',
			'heading'    => __( 'Normal Text Color', 'soledad' ),
			'param_name' => 'text_normal_color',
			'group'      => $group_color,
		),
		array(
			'type'       => 'colorpicker',
			'heading'    => __( 'Normal Text Hover Color', 'soledad' ),
			'param_name' => 'text_normal_acolor',
			'group'      => $group_color,
		),
		array(
			'type'             => 'textfield',
			'param_name'       => 'penci_separator_002',
			'heading'          => __( 'Animate Text', 'soledad' ),
			'group'            => $group_color,
			'edit_field_class' => 'penci-param-heading-wrapper no-top-margin vc_column vc_col-sm-12',
		),
		array(
			'type'       => 'font_container',
			'heading'    => __( 'Animate Text Typography', 'soledad' ),
			'param_name' => 'text_ani_typography',
			'value'      => '',
			'group'      => $group_color,
			'settings'   => array(
				'fields' => array(
					'text_align',
					'font_size',
					'line_height',
					'color',
					'tag_description'         => esc_html__( 'Select element tag.', 'js_composer' ),
					'text_align_description'  => esc_html__( 'Select text alignment.', 'js_composer' ),
					'font_size_description'   => esc_html__( 'Enter font size.', 'js_composer' ),
					'line_height_description' => esc_html__( 'Enter line height.', 'js_composer' ),
					'color_description'       => esc_html__( 'Select color for your element.', 'js_composer' ),
				),
			),
		),
		array(
			'type'       => 'colorpicker',
			'heading'    => __( 'Animate Text Color', 'soledad' ),
			'param_name' => 'text_ani_color',
			'group'      => $group_color,
		),
		array(
			'type'       => 'colorpicker',
			'heading'    => __( 'Animate Text Hover Color', 'soledad' ),
			'param_name' => 'text_ani_acolor',
			'group'      => $group_color,
		),
		array(
			'type'             => 'textfield',
			'param_name'       => 'penci_separator_003',
			'heading'          => __( 'Highlight Text', 'soledad' ),
			'group'            => $group_color,
			'edit_field_class' => 'penci-param-heading-wrapper no-top-margin vc_column vc_col-sm-12',
		),
		array(
			'type'       => 'textfield',
			'heading'    => __( 'Highlight Width', 'soledad' ),
			'param_name' => 'highlight_width',
			'value'      => '8',
			'group'      => $group_color,
		),
		array(
			'type'       => 'textfield',
			'heading'    => __( 'Animation Duration', 'soledad' ),
			'param_name' => 'highlight_animation_duration',
			'group'      => $group_color,
		),
		array(
			'type'             => 'textfield',
			'param_name'       => 'penci_separator_02',
			'heading'          => __( 'Cursor Style', 'soledad' ),
			'group'            => $group_color,
			'edit_field_class' => 'penci-param-heading-wrapper no-top-margin vc_column vc_col-sm-12',
		),
		array(
			'type'       => 'colorpicker',
			'heading'    => __( 'Cursor Color', 'soledad' ),
			'param_name' => 'cursor_color',
			'group'      => $group_color,
		),
		array(
			'type'       => 'colorpicker',
			'heading'    => __( 'Delete Block Font Color', 'soledad' ),
			'param_name' => 'typing_delete_color',
			'group'      => $group_color,
		),
		array(
			'type'       => 'colorpicker',
			'heading'    => __( 'Delete Block Background', 'soledad' ),
			'param_name' => 'typing_background',
			'group'      => $group_color,
		),
		array(
			'type'             => 'textfield',
			'param_name'       => 'penci_separator_01',
			'heading'          => __( 'Clip Effects', 'soledad' ),
			'group'            => $group_color,
			'edit_field_class' => 'penci-param-heading-wrapper no-top-margin vc_column vc_col-sm-12',
		),
		array(
			'type'       => 'textfield',
			'heading'    => __( 'Clip Width', 'soledad' ),
			'param_name' => 'clip_width',
			'group'      => $group_color,
		),
		array(
			'type'       => 'colorpicker',
			'heading'    => __( 'Clip Color', 'soledad' ),
			'param_name' => 'clip_background',
			'group'      => $group_color,
		),
	), Penci_Vc_Params_Helper::extra_params()),
) );
