<?php
namespace controlElementor;

class Icons_Library{
    
    public function __construct() {	
		$this->init();
	}

    private function init(){
        add_filter('elementor/icons_manager/additional_tabs', [$this, 'add_additional_tab' ]);        
    }

    public function add_additional_tab($additional_tabs){

        if( class_exists( 'Vc_Manager' ) ){
            $additional_tabs['control-elementor-icon-openiconic'] = [
                'name'          => 'openiconic',
                'label'         => esc_html__( 'Openiconic Icons', 'control-elementor' ),
                'labelIcon'     => 'vc-oi vc-oi-aperture-alt',
                'prefix'        => 'vc-oi-',
                'displayPrefix' => 'vc-oi',
                'url'           => '',
                'enqueue'       => [vc_asset_url( 'css/lib/vc-open-iconic/vc_openiconic.min.css' )],
                'icons'         => control_elementor_iconpicker_icons_array(control_elementor_iconpicker_type_openiconic(), 'vc-oi'),
                'ver'           => '1.0.0',
            ];
    
            $additional_tabs['control-elementor-icon-typicons'] = [
                'name'          => 'typicons',
                'label'         => esc_html__( 'Typicons', 'control-elementor' ),
                'labelIcon'     => 'typcn typcn-adjust-brightness',
                'prefix'        => 'typcn-',
                'displayPrefix' => 'typcn',
                'url'           => '',
                'enqueue'       => [ vc_asset_url( 'css/lib/typicons/src/font/typicons.min.css' ) ],
                'icons'         => control_elementor_iconpicker_icons_array(control_elementor_iconpicker_type_typicons(), 'typcn'),
                'ver'           => '2.0.0',
            ];
    
            $additional_tabs['control-elementor-icon-entypo'] = [
                'name'          => 'entypo',
                'label'         => esc_html__( 'Entypo Icons', 'control-elementor' ),
                'labelIcon'     => 'entypo-icon entypo-icon-book-open',
                'prefix'        => 'entypo-icon-',
                'displayPrefix' => 'entypo-icon',
                'url'           => '',
                'enqueue'       => [ vc_asset_url( 'css/lib/vc-entypo/vc_entypo.min.css' ) ],
                'icons' => control_elementor_iconpicker_icons_array(control_elementor_iconpicker_type_entypo(), 'entypo-icon'),
                'ver'           => '4.0.0',
            ];
    
            $additional_tabs['control-elementor-icon-linecons'] = [
                'name'          => 'linecons',
                'label'         => esc_html__( 'Linecons', 'control-elementor' ),
                'labelIcon'     => 'vc_li vc_li-heart',
                'prefix'        => 'vc_li-',
                'displayPrefix' => 'vc_li',
                'url'           => '',
                'enqueue'       => [ vc_asset_url( 'css/lib/vc-linecons/vc_linecons_icons.min.css' ) ],
                'icons' => control_elementor_iconpicker_icons_array(control_elementor_iconpicker_type_linecons(), 'vc_li'),
                'ver'           => '4.0.0',
            ];
    
            $additional_tabs['control-elementor-icon-material'] = [
                'name'          => 'material',
                'label'         => esc_html__( 'Material Icons', 'control-elementor' ),
                'labelIcon'     => 'vc-material vc-material-all_inclusive',
                'prefix'        => 'vc-material-',
                'displayPrefix' => 'vc-material',
                'url'           => '',
                'enqueue'       => [ vc_asset_url( 'css/lib/vc-material/vc_material.min.css' ) ],
                'icons' => control_elementor_iconpicker_icons_array(control_elementor_iconpicker_type_material(), 'vc-material'),
                'ver'           => '4.0.0',
            ];
    
        }

        return $additional_tabs;
    }
}