<?php
namespace controlElementor;

use Elementor\Modules\Favorites\Types\Widgets;

class Loader{
    

    public function __construct() {	
		$this->init();
	}

    private function init(){
        new Setup;
        add_action( 'wp_enqueue_scripts', [ $this, 'assets' ] );

        
        add_action( 'elementor/elements/categories_registered', [ $this, 'register_category'] );
        add_action( 'elementor/widgets/register', [ $this, 'register_widgets'] );

        new Icons_Library();
        
    }

    public function assets(){
        wp_enqueue_style( 'control-elementor', CONTROL_ELEMENTOR_ASSETS.'/css/control-elementor.css', false, '1.0.0' );
    }

    /**
	 * Category Registered
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function register_category($elements_manager) {
        
		$elements_manager->add_category( 
		   	'control-elementor',                 // the name of the category
		   	[
		   		'title' => apply_filters( 'control-elementor/category', 'Themeperch' ),
		   		'icon' => 'fa fa-header', //default icon
		   	],
		   	4 // position
		);
	}

    /**
     * Register oEmbed Widget.
     *
     * Include widget file and register widget class.
     *
     * @since 1.0.0
     * @param \Elementor\Widgets_Manager $widgets_manager Elementor widgets manager.
     * @return void
     */
    function register_widgets( $widgets_manager ) {    
        $widgets_manager->register( new \controlElementor\Widgets\Title() );
        $widgets_manager->register( new \controlElementor\Widgets\Quote() );
        $widgets_manager->register( new \controlElementor\Widgets\Feature() );
        $widgets_manager->register( new \controlElementor\Widgets\Featured_Box() );
        $widgets_manager->register( new \controlElementor\Widgets\Service() );
        $widgets_manager->register( new \controlElementor\Widgets\About_Company() );
        $widgets_manager->register( new \controlElementor\Widgets\Single_Testimonial() );
        $widgets_manager->register( new \controlElementor\Widgets\Risk_Reward_Profile() );
        $widgets_manager->register( new \controlElementor\Widgets\Call_to_Action() );
        $widgets_manager->register( new \controlElementor\Widgets\Career() );
        $widgets_manager->register( new \controlElementor\Widgets\Company_Summary() );
        $widgets_manager->register( new \controlElementor\Widgets\Download_Box() );
        $widgets_manager->register( new \controlElementor\Widgets\Figures_Block() );
        $widgets_manager->register( new \controlElementor\Widgets\Contact_Info() );
        $widgets_manager->register( new \controlElementor\Widgets\Footer_Meta() );
        $widgets_manager->register( new \controlElementor\Widgets\Copyright_Bar() );
        $widgets_manager->register( new \controlElementor\Widgets\Background_Slider() );
        $widgets_manager->register( new \controlElementor\Widgets\Counter() );
        $widgets_manager->register( new \controlElementor\Widgets\Google_Map() );
        $widgets_manager->register( new \controlElementor\Widgets\OpenStreet_Map() );
        $widgets_manager->register( new \controlElementor\Widgets\List_Item() );
        $widgets_manager->register( new \controlElementor\Widgets\Our_Clients() );
        $widgets_manager->register( new \controlElementor\Widgets\Preloader() );
        $widgets_manager->register( new \controlElementor\Widgets\Skillbar() );
        $widgets_manager->register( new \controlElementor\Widgets\Timeline() );
        $widgets_manager->register( new \controlElementor\Widgets\Working_Hours() );
        $widgets_manager->register( new \controlElementor\Widgets\Header_Content() );
        $widgets_manager->register( new \controlElementor\Widgets\Header_Info() );
        $widgets_manager->register( new \controlElementor\Widgets\Nav_Menu() );
        $widgets_manager->register( new \controlElementor\Widgets\Mailchimp_Form() );
        $widgets_manager->register( new \controlElementor\Widgets\Single_Job_Info() );
        $widgets_manager->register( new \controlElementor\Widgets\Single_Team_Info() );
        $widgets_manager->register( new \controlElementor\Widgets\Portfolio_Template() );
        $widgets_manager->register( new \controlElementor\Widgets\Post_Template() );
        $widgets_manager->register( new \controlElementor\Widgets\Accordion() );
        $widgets_manager->register( new \controlElementor\Widgets\Tabs() );
        $widgets_manager->register( new \controlElementor\Widgets\Pricing() );
        $widgets_manager->register( new \controlElementor\Widgets\Testimonials() );


        $widgets_manager->register( new \controlElementor\Widgets\Team_Template() );
    }

    
}
