<?php

namespace controlElementor;

use Elementor\Core\Schemes\Manager as Schemes_Manager;

class Setup {

    public function __construct() {
        $this->init();
    }

    private function init() {
        add_filter('control_elementor/settings_pages', [$this, 'settings_pages']);
        add_filter('control_elementor/meta_boxes', [$this, 'meta_boxes']);

        add_action('after_switch_theme', [$this, 'theme_color_scheme']);
    }

    public function theme_color_scheme() {
        $theme_color_scheme = array(
            "1" => "#000",
            "2" => "#222222",
            "3" => "#333333",
            "4" => "#444444"
        );
        $schemes_manager = new Schemes_Manager();

        $scheme_obj = $schemes_manager->get_scheme('color');
        if ($scheme_obj) {
            $scheme_obj->save_scheme($theme_color_scheme);
            update_option('elementor_scheme_color', $theme_color_scheme, true);
        }
    }

    public function assets() {
        wp_enqueue_style('control-elementor', CONTROL_ELEMENTOR_ASSETS . '/css/control-elementor.css', false, '1.0.0');
    }

    public function settings_pages($settings_pages) {
        $settings_pages[] = array(
            'id' => 'control-elementor',
            'menu_title' => 'Control Elementor',
            'page_title' => 'Control Elementor',
            'option_name' => 'control_elementor',
            'icon_url' => 'dashicons-book',
            'parent' => 'admin.php?page=elementor',
            'submenu_title' => 'Settings',
            'tab_style' => '',
            'columns' => 1,
        );
        return $settings_pages;
    }

    public function meta_boxes($meta_boxes) {

        $meta_boxes[] = array(
            'id' => 'control-elementor-color-settings',
            'title' => 'Color',
            'settings_pages' => 'control-elementor',
            'context' => 'normal',
            'style' => 'seamless',
            'fields' => array(
                [
                    'id' => 'primary_color',
                    'name' => 'Primary color',
                    'type' => 'text',
                ]
            )
        );

        return $meta_boxes;
    }
}
