<?php
namespace controlElementor\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;
use Elementor\Widget_Base;

/**
 * Elementor feature widget.
 *
 * Elementor widget that displays an eye-catching headlines.
 *
 * @since 1.0.0
 */
class Call_to_Action extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve heading widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'call_to_action';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Feature widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Call to Action', 'control-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Feature widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-call-to-action';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the heading widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since 2.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'control-elementor' ];
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'title', 'subtitle', 'button' ];
	}

	/**
	 * Register heading widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 3.1.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Call to Action', 'control-elementor' ),
			]
		);

		$this->add_control(
			'background_color',
			[
				'label' => esc_html__( 'Background type', 'control-elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'primary-bg' => esc_attr__('Primary color', 'control-elementor'),
					'secondary-bg' => esc_attr__('Secondary color', 'control-elementor'),
					'secondary-light-bg' => esc_attr__('Secondary light color', 'control-elementor'),
					'dark-bg' => esc_attr__('Dark color', 'control-elementor'),
					'grey-bg' => esc_attr__('Grey color', 'control-elementor'),
					'tra-bg' => esc_attr__('Transparent color', 'control-elementor'),
					'white-bg' => esc_attr__('White color', 'control-elementor'),
				],
				'default' => 'secondary-bg',
			]
		);

		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'control-elementor' ),
				'type' => Controls_Manager::TEXT,
				'description' => esc_html__( 'Use {} to highlight text', 'control-elementor' ),
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => esc_html__( 'Enter your title', 'control-elementor' ),
				'default' => esc_html__( 'Our clients are looking for YOU!', 'control-elementor' ),
				'label_block' => true
			]
		);

		$this->add_control(
			'subtitle',
			[
				'label' => esc_html__( 'Subtitle', 'control-elementor' ),
				'type' => Controls_Manager::TEXTAREA,
				'description' => esc_html__( 'Use {} to highlight text', 'control-elementor' ),
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => esc_html__( 'Enter your title', 'control-elementor' ),
				'label_block' => true
			]
		);

		$this->add_control(
			'link',
			[
				'label' => esc_html__( 'Button Link', 'control-elementor' ),
				'type' => Controls_Manager::URL,
				'default' => [
					'url' => '#',
				],
			]
		);

		$this->add_control(
			'link_text',
			[
				'label' => esc_html__( 'Button text', 'control-elementor' ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter link text', 'control-elementor' ),
				'default' => esc_html__( 'Apply Now', 'control-elementor' ),
			]
		);

		$this->add_control(
			'view',
			[
				'label' => esc_html__( 'View', 'control-elementor' ),
				'type' => Controls_Manager::HIDDEN,
				'default' => 'traditional',
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render heading widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$args = array(
			'bg_type' => $settings['background_color'],
			'title' => $settings['title'],
			'subtitle' => $settings['subtitle'],
			'button_text' => $settings['link_text'],
			'button_url' => $settings['link']['url'],
		);

		if(locate_template('template-parts/elements/call-to-action.php')){
			get_template_part('template-parts/elements/call-to-action', '', $args);
		}
	}

	/**
	 * Render heading widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 2.9.0
	 * @access protected
	 */
	protected function content_template() {}
}
