<?php
namespace controlElementor\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Controls_Manager\REPEATER;

/**
 * Elementor Mailchimp_Form widget.
 *
 * Elementor widget that displays an eye-catching headlines.
 *
 * @since 1.0.0
 */
class Mailchimp_Form extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve heading widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'mailchimp_form';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Feature widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Mailchimp Form', 'control-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Feature widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-mailchimp';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the heading widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since 2.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'control-elementor' ];
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'title', 'link', 'button' ];
	}

	/**
	 * Register heading widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 3.1.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Mailchimp Form', 'control-elementor' ),
			]
		);

		$this->add_control(
			'style',
			[
				'label' => esc_html__( 'Style', 'control-elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'vertical' => esc_attr__('Vrtical', 'control-elementor'),
					'horizontal' => esc_attr__('Horizontal', 'control-elementor'),
				],
				'default' => 'vertical',
			]
		);

		$this->add_control(
			'language',
			[
				'label' => esc_html__( 'Language', 'control-elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'en' => esc_attr__('en', 'control-elementor'),
					'it' => esc_attr__('it', 'control-elementor'),
					'de' => esc_attr__('de', 'control-elementor'),
					'pl' => esc_attr__('pl', 'control-elementor'),
					'es' => esc_attr__('es', 'control-elementor'),
					'fr' => esc_attr__('fr', 'control-elementor'),
				],
				'default' => 'en',
			]
		);

		$this->add_control(
			'post_url',
			[
				'label' => esc_html__( 'Mailchimp post url', 'control-elementor' ),
				'type' => Controls_Manager::TEXT,
				'description' => esc_html__( 'Required', 'control-elementor' ),
				'placeholder' => esc_html__( 'Enter post url', 'control-elementor' ),
				'default' => '//themeperch.us9.list-manage.com/subscribe/post?u=d33802e92fdc29def2e7af643&id=0085e5e2b5',
				'label_block' => true
			]
		);

		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'control-elementor' ),
				'type' => Controls_Manager::TEXT,
				'description' => esc_html__( 'Leave blank to avoid title area', 'control-elementor' ),
				'placeholder' => esc_html__( 'Enter your title', 'control-elementor' ),
				'default' => esc_html__( 'Try Premium Account', 'control-elementor' ),
				'label_block' => true
			]
		);

		$this->add_control(
			'link_text',
			[
				'label' => esc_html__( 'Button text', 'control-elementor' ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter field name', 'control-elementor' ),
				'default' => esc_html__( 'Get started', 'control-elementor' ),
				'label_block' => true
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'form-settings',
			[
				'label' => esc_html__( 'Form Fields', 'control-elementor' ),
			]
		);

		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'type',
			[
				'label' => esc_html__( 'Field type', 'control-elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'input' => esc_attr__('Input', 'control-elementor'),
					'email' => esc_attr__('Email', 'control-elementor'),
					'select' => esc_attr__('Select', 'control-elementor'),
					'radio' => esc_attr__('Radio', 'control-elementor'),
					'checkbox' => esc_attr__('Checkbox', 'control-elementor'),
					'date' => esc_attr__('Date', 'control-elementor'),
				],
			]
		);
		$repeater->add_control(
			'name',
			[
				'label' => esc_html__( 'Field Name', 'control-elementor' ),
				'type' => Controls_Manager::TEXT,
				'description' => esc_html__( 'Required', 'control-elementor' ),
				'placeholder' => esc_html__( 'Enter field name', 'control-elementor' ),
				'label_block' => true
			]
		);
		$repeater->add_control(
			'placeholder',
			[
				'label' => esc_html__( 'Placeholder', 'control-elementor' ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter field name', 'control-elementor' ),
				'label_block' => true
			]
		);
		$repeater->add_control(
			'format',
			[
				'label' => esc_html__( 'Format', 'control-elementor' ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter field format', 'control-elementor' ),
				'label_block' => true,
				'condition' => [
					'type' => 'date'
				]
			]
		);
		$repeater->add_control(
			'options',
			[
				'label' => esc_html__( 'Option fields', 'control-elementor' ),
				'type' => Controls_Manager::TEXTAREA,
				'description' => esc_html__( 'Multiple value are comma (|) separated. Example: male,Male|female,Female', 'control-elementor' ),
				'placeholder' => esc_html__( 'Enter field options', 'control-elementor' ),
				'label_block' => true,
				'condition' => [
					'type' => [ 'select', 'radio', 'checkbox' ]
				]
			]
		);
		$this->add_control(
			'fields',
			[
				'label' => esc_attr__('Fields', 'control-elementor'),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'type' => 'input',
						'name' => 'FULLNAME',
						'placeholder' => 'Your name',
					],
					[
						'type' => 'email',
						'name' => 'EMAIL',
						'placeholder' => 'Your Email',
					],
					[
						'type' => 'input',
						'name' => 'MMERGE3',
						'placeholder' => 'Phone number',
					]
				]  
			]
		);	

		$this->add_control(
			'view',
			[
				'label' => esc_html__( 'View', 'control-elementor' ),
				'type' => Controls_Manager::HIDDEN,
				'default' => 'traditional',
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render heading widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$slides = [];
		if(!empty($settings['slider_images'])){
			foreach($settings['slider_images'] as $slider_image){
				if(!isset($slider_image['image'])) continue;
				if(!isset($slider_image['image']['url']) || empty($slider_image['image']['url'])) continue;

				$slides[] = [
					'image' => $slider_image['image']['url']
				];
			}
		}

		$args = array(
			'style' => $settings['style'],
			'language' => $settings['language'],
			'post_url'  => $settings['post_url'],
			'title'  => $settings['title'],
			'fields'  => $settings['fields'],
			'button_text' => $settings['link_text']
		);

		if(locate_template('template-parts/elements/mc-form.php')){
			get_template_part('template-parts/elements/mc', 'form', $args);
		}
	}

	/**
	 * Render heading widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 2.9.0
	 * @access protected
	 */
	protected function content_template() {}
}
