<?php
namespace controlElementor\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Controls_Manager\REPEATER;

/**
 * Elementor Our_Clients widget.
 *
 * Elementor widget that displays an eye-catching headlines.
 *
 * @since 1.0.0
 */
class Our_Clients extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve heading widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'our_clients';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Feature widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Our Clients', 'control-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Feature widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-pojome';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the heading widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since 2.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'control-elementor' ];
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'title', 'content', 'image' ];
	}

	/**
	 * Register heading widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 3.1.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Heading', 'control-elementor' ),
			]
		);

		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'control-elementor' ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter your title', 'control-elementor' ),
				'default' => esc_html__( 'Our clients know', 'control-elementor' ),
				'label_block' => true
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label' => esc_html__( 'Subtitle', 'control-elementor' ),
				'type' => Controls_Manager::TEXTAREA,
				'description' => esc_html__( 'Use {} to highlight text', 'control-elementor' ),
				'placeholder' => esc_html__( 'Enter your subtitle', 'control-elementor' ),
				'default' => esc_html__( '{Investment Expert} is one of the largest and most experienced global private equity investors', 'control-elementor' ),
				'label_block' => true
			]
		);
		$this->add_control(
			'content',
			[
				'label' => esc_html__( 'Description', 'control-elementor' ),
				'type' => Controls_Manager::WYSIWYG,
				'placeholder' => esc_html__( 'Enter your description', 'control-elementor' ),
				'default' => '<p>We seek to invest in well-positioned companies with operational and strategic improvement potential and partner with management teams to create value by driving revenue and earnings growth.</p>',
				'label_block' => true
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'clients-settings',
			[
				'label' => esc_html__( 'Clients', 'control-elementor' ),
			]
		);

		$repeater = new \Elementor\Repeater();
	
		$repeater->add_control(
			'title',
			[
				'label' => esc_html__( 'Client title', 'control-elementor' ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter your title', 'control-elementor' ),
				'label_block' => true
			]
		);
		$repeater->add_control(
			'image',
			[
				'label' => esc_html__( 'Client Logo', 'control-elementor' ),
				'type' => Controls_Manager::MEDIA,
			]
		);
		$repeater->add_control(
			'title2',
			[
				'label' => esc_html__( 'Clients title #2', 'control-elementor' ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter your title', 'control-elementor' ),
				'label_block' => true
			]
		);
		$repeater->add_control(
			'image2',
			[
				'label' => esc_html__( 'Client logo #2', 'control-elementor' ),
				'type' => Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'clients',
			[
				'label' => esc_attr__('Clients', 'control-elementor'),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					array(
						'image' => [
							'url' => Utils::get_placeholder_image_src()
						],
						'title' => 'Client 1',
						'image2' => [
							'url' => Utils::get_placeholder_image_src()
						],				
						'title2' => 'Client 2'					                    
					),
					array(
						'image' => [
							'url' => Utils::get_placeholder_image_src()
						],
						'title' => 'Client 3',
						'image2' => [
							'url' => Utils::get_placeholder_image_src()
						],
						'title2' => 'Client 4'			                    
					),
					array(
						'image' => [
							'url' => Utils::get_placeholder_image_src()
						],
						'title' => 'Client 5',
						'image2' => [
							'url' => Utils::get_placeholder_image_src()
						],
						'title2' => 'Client 6'					                    
					)
				]  
			]
		);	

		$this->add_control(
			'view',
			[
				'label' => esc_html__( 'View', 'control-elementor' ),
				'type' => Controls_Manager::HIDDEN,
				'default' => 'traditional',
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render heading widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$clients = $settings['clients'];
		if(!empty($clients)){
			foreach($clients as $key => $client){
				if(isset($client['image']['url'])){
					$clients[$key]['image'] = $client['image']['url'];
				}
				if(isset($client['image2']['url'])){
					$clients[$key]['image2'] = $client['image2']['url'];
				}
			}
		}

		$args = array(
			'title'=> $settings['title'],
			'subtitle'=> $settings['subtitle'],
			'clients'=> $clients,
			'content' => $settings['content']
		);

		if(locate_template('template-parts/elements/our-clients.php')){
			get_template_part('template-parts/elements/our', 'clients', $args);
		}
	}

	/**
	 * Render heading widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 2.9.0
	 * @access protected
	 */
	protected function content_template() {}
}
