<?php
namespace controlElementor\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Css_Filter;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Controls_Manager\REPEATER;
use controlElementor\Widgets\Traits\Text_Trait;
use controlElementor\Widgets\Traits\Button_Trait;

/**
 * Elementor image box widget.
 *
 * Elementor widget that displays an image, a headline and a text.
 *
 * @since 1.0.0
 */
class Pricing extends Widget_Base {
	
	use Text_Trait;
	use Button_Trait;

	/**
	 * Get widget name.
	 *
	 * Retrieve image box widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'pricing-plan';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve image box widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Pricing Plan', 'control-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve image box widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-price-table';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'name', 'list', 'button', 'footer' ];
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the button widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since 2.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'control-elementor' ];
	}


	/**
	 * Register image box widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 3.1.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Pricing Plan', 'control-elementor' ),
			]
		);

		$this->add_control(
			'featured',
			[
				'label' => esc_html__( 'Featured', 'control-elementor' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'control-elementor' ),
				'label_off' => esc_html__( 'No', 'control-elementor' ),
				'return_value' => 'yes',
				'default' => 'yes',				
			]
		);

		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'control-elementor' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Standard Plan', 'control-elementor' ),
				'placeholder' => esc_html__( 'Enter your title', 'control-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'unit',
			[
				'label' => esc_html__( 'Price unit', 'control-elementor' ),
				'type' => Controls_Manager::TEXT,				
				'default' => esc_html__( '$', 'control-elementor' ),
				'placeholder' => esc_html__( '$', 'control-elementor' ),
			]
		);

		$this->add_control(
			'price',
			[
				'label' => esc_html__( 'Price', 'control-elementor' ),
				'description' => esc_html__( 'use {} for highlight text', 'control-elementor' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '{48}/mo', 'control-elementor' ),
				'placeholder' => esc_html__( 'e.g. {48}/mo', 'control-elementor' ),
			]
		);

		$this->add_control(
			'link_title',
			[
				'label' => esc_html__( 'Button link text', 'control-elementor' ),
				'description' => esc_html__( 'Leave blank to avoid button', 'control-elementor' ),
				'type' => Controls_Manager::TEXT,				
				'default' => esc_html__( 'Get started now', 'control-elementor' ),
				'placeholder' => esc_html__( 'Enter button text', 'control-elementor' ),
			]
		);

		$this->add_control(
			'link',
			[
				'label' => esc_html__( 'Button link', 'control-elementor' ),
				'type' => Controls_Manager::TEXT,				
				'default' => esc_html__( '#', 'control-elementor' ),
				'placeholder' => esc_html__( 'Enter button link', 'control-elementor' ),
			]
		);

		$this->add_control(
			'content',
			[
				'label' => esc_html__( 'Description', 'control-elementor' ),
				'type' => Controls_Manager::WYSIWYG,
				'default' => '<div style="text-align: center"><p>10 ready home page</p><p>5 different header style</p><p>Unlimited data transfer</p><p>30 days moneyback guarantee</p><p>Enhanced security</p></div>'
			]
		);

		$this->add_control(
			'view',
			[
				'label' => esc_html__( 'View', 'control-elementor' ),
				'type' => Controls_Manager::HIDDEN,
				'default' => 'traditional',
			]
		);		

		$this->end_controls_section();
	}

	/**
	 * Render image box widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		if(locate_template('template-parts/elements/pricing-table.php')){
			get_template_part('template-parts/elements/pricing', 'table', $settings);
		}
	}

	protected function content_template() {
	}
	
}
