<?php
namespace controlElementor\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Controls_Manager\REPEATER;

/**
 * Elementor Timeline widget.
 *
 * Elementor widget that displays an eye-catching headlines.
 *
 * @since 1.0.0
 */
class Timeline extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve heading widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'timeline';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Feature widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Timeline', 'control-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Feature widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-time-line';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the heading widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since 2.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'control-elementor' ];
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'title', 'content' ];
	}

	/**
	 * Register heading widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 3.1.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Timeline', 'control-elementor' ),
			]
		);

		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'year',
			[
				'label' => esc_html__( 'Year', 'control-elementor' ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter year', 'control-elementor' ),
				'label_block' => true
			]
		);
		$repeater->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'control-elementor' ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter title', 'control-elementor' ),
				'label_block' => true
			]
		);
		$repeater->add_control(
			'description',
			[
				'label' => esc_html__( 'Description', 'control-elementor' ),
				'type' => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter description', 'control-elementor' ),
				'label_block' => true
			]
		);
		
		$this->add_control(
			'timeline',
			[
				'label' => esc_attr__('Timeline', 'control-elementor'),
				'type' => Controls_Manager::REPEATER,
				'description' => esc_attr__( 'Enter values for graph - value, title and color.', 'control-elementor' ),
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'year' => esc_attr__('1941', 'control-elementor'),						                    
						'title' => esc_attr__('Established', 'control-elementor'),
						'description' => esc_attr__('It became the State Association of Investment Companies in 1941. In 1940,Company members included 68 mutual funds and 43 closed-end funds,and assets for the fund industry totaled $2.1 billion.', 'control-elementor'),					                    
					],
					[
						'year' => esc_attr__('1999', 'control-elementor'),						                    
						'title' => esc_attr__('Became The Investment Expert', 'control-elementor'),
						'description' => esc_attr__('SAIC changed its name to the Investment Expert in 1999,the year that underwriters and advisers of mutual funds became eligible for membership.IE objectives are essential organizing priciples for the many and varied activites in which the comapny participates.', 'control-elementor'),					                    
					],
					[
						'year' => esc_attr__('2005', 'control-elementor'),						                    
						'title' => esc_attr__('IE Relocated To Washington,DC', 'control-elementor'),
						'description' => esc_attr__('It became the State Association of Investment Companies in 1941. In 1940,Company members included 68 mutual funds and 43 closed-end funds,and assets for the fund industry totaled $2.1 billion.', 'control-elementor'),					                    
					],
					[
						'year' => esc_attr__('2016', 'control-elementor'),						                    
						'title' => esc_attr__('Today in 2016', 'control-elementor'),
						'description' => esc_attr__('Today,in 2016,IE celebrates the 75th anniversary of its founding and of the key legislation that gave rise to the modern fund industry.IE serves as a spokesman for funds and their share holders before policymakers,opinion leaders and the global media.', 'control-elementor'),				                    
					]
				]  
			]
		);	

		$this->add_control(
			'view',
			[
				'label' => esc_html__( 'View', 'control-elementor' ),
				'type' => Controls_Manager::HIDDEN,
				'default' => 'traditional',
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render heading widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$args = array(
			'history' => $settings['timeline'],
		);

		if(locate_template('template-parts/elements/timeline.php')){
			get_template_part('template-parts/elements/timeline', '', $args);
		}
	}

	/**
	 * Render heading widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 2.9.0
	 * @access protected
	 */
	protected function content_template() {}
}
