<?php
namespace controlElementor\Widgets\Traits;

use Elementor\Controls_Manager;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Icons_Manager;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

trait Text_Trait {
	
	protected function register_title_content_controls( $args = [] ) {
		$default_args = [
			'prefix' => '',
			'default_tag' => 'h2',
			'default_size_class' => '',
			'text_control_label' => esc_html__( 'Text', 'control-elementor' ),
		];

		$args = wp_parse_args( $args, $default_args );

		$this->add_control(
			$args['prefix'].'size',
			[
				'label' => esc_html__( 'HTML Tag', 'control-elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
					'div' => 'div',
					'span' => 'span',
					'p' => 'p',
				],
				'default' => 'h2',
			]
		);

		$this->add_control(
			$args['prefix'].'size_class',
			[
				'label' => esc_html__( 'Size class', 'control-elementor' ),
				'type' => Controls_Manager::SELECT,
				'default' => '',
				'options' => control_elementor_font_size_class_options(),
			]
		);

		$this->add_control(
			$args['prefix'].'text_color',
			[
				'label' => esc_html__( 'Color', 'control-elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => control_elementor_text_color_class_options(),
				'default' => '',
			]
		);

		$this->add_control(
			$args['prefix'].'letter_spacing',
			[
				'label' => esc_html__( 'Letter spacing', 'control-elementor' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 5,
				'step' => 1,
				'default' => 0
			]
		);

		$this->add_control(
			$args['prefix'].'font_weight',
			[
				'label' => esc_html__( 'Font weight', 'control-elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => control_elementor_font_weight_class_options(),
				'default' => '',
			]
		);

		$this->add_control(
			$args['prefix'].'add_underline',
			[
				'label' => esc_html__( 'Add underline', 'control-elementor' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'control-elementor' ),
				'label_off' => esc_html__( 'No', 'control-elementor' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			$args['prefix'].'underline_style',
			[
				'label' => esc_html__( 'Underline style', 'control-elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'underline-primary' => esc_attr__('Thin', 'control-elementor'),
					'underline_small' => esc_attr__('Bold', 'control-elementor'),
				],
				'default' => 'underline-primary',
				'condition' => array(
					$args['prefix'].'add_underline' => 'yes',
				),
			]
		);

		
		$this->add_control(
			$args['prefix'].'css_class',
			[
				'label' => esc_html__( 'CSS class', 'control-elementor' ),
				'type' => Controls_Manager::TEXT,
				'default' => ''
			]
		);
	}

	/**
	 * Render title widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @param \Elementor\Widget_Base|null $instance
	 *
	 * @since  3.4.0
	 * @access protected
	 */
	protected function render_title( Widget_Base $instance = null, $args = [] ) {
		$default_args = [
			'prefix' => '',
			'text'   => esc_html__( 'Add text here', 'control-elementor' ),
		];
		$args = wp_parse_args($args, $default_args);

		if(empty($args['text'])) return;

		if ( empty( $instance ) ) {
			$instance = $this;
		}

		$settings = $instance->get_settings_for_display();

		$instance->add_render_attribute( $args['prefix'] . 'text', 'class', 'control-heading-title' );

		
		if ( ! empty( $settings[$args['prefix'] .'size_class'] ) ) {
			$instance->add_render_attribute( $args['prefix'] . 'text', 'class', $settings[$args['prefix'].'size_class'] );
		}

		if ( ! empty( $settings[$args['prefix'] .'text_color'] ) ) {
			$instance->add_render_attribute( $args['prefix'] . 'text', 'class', 'text-'.$settings[$args['prefix'].'text_color'] );
		}

		if ( ! empty( $settings[$args['prefix'] .'letter_spacing'] ) ) {
			$instance->add_render_attribute( $args['prefix'] . 'text', 'class', 'ls-'.$settings[$args['prefix'].'letter_spacing'] );
		}

		if ( ! empty( $settings[$args['prefix'] .'font_weight'] ) ) {
			$instance->add_render_attribute( $args['prefix'] . 'text', 'class', $settings[$args['prefix'].'font_weight'] );
		}

		if ( ! empty( $settings[$args['prefix'] .'bs_classes'] ) ) {
			$instance->add_render_attribute( $args['prefix'] . 'text', 'class', join(" ", $settings[$args['prefix'].'bs_classes']) );
		}
		
		if ( ! empty( $settings[$args['prefix'] .'css_class'] ) ) {
			$instance->add_render_attribute( $args['prefix'] . 'text', 'class', $settings[$args['prefix'].'css_class'] );
		}

		$html = sprintf('<%1$s %2$s>%3$s</%1$s>', $settings[$args['prefix'] . 'size'], $instance->get_render_attribute_string($args['prefix'] . 'text'), $args['text']);

		return $html;
	}
}
