<?php
namespace controlElementor\Widgets\Traits;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

trait WP_Query_Trait {
	
	protected function register_query_arguments_controls( $args = [] ) {
		$default_args = [
			'prefix' => '',
			'post_type' => '',
			'taxonomy' => 'category'
		];

		$args = wp_parse_args( $args, $default_args );

		$categories = control_elementor_get_terms($args['taxonomy']);

		if(!empty($categories)){
			$this->add_control(
				$args['prefix'].'tax_term',
				[
					'label' => esc_html__( 'Category', 'control-elementor' ),
					'type' => Controls_Manager::SELECT2,
					'multiple' => true,
					'label_block' => true,
					'description' => 'Select categories to display',
					'options' => control_elementor_get_terms($args['taxonomy']),
				]
			);
		}

		$this->add_control(
			$args['prefix'].'operator',
			[
				'label' => esc_html__( 'Taxonomy term operator', 'control-elementor' ),
				'type' => Controls_Manager::SELECT,
				'description' => 'IN - posts that have any of selected categories terms<br/>NOT IN - posts that is does not have any of selected terms<br/>AND - posts that have all selected terms',
				'options' => [
					'IN' => 'IN',
					'NOT IN' => 'NOT IN',
					'AND' => 'AND'
				],
				'default' => 'IN',
			]
		);

		$this->add_control(
			$args['prefix'].'posts_per_page',
			[
				'label' => esc_html__( 'Posts per page', 'control-elementor' ),
				'type' => Controls_Manager::NUMBER,	
				'description' => esc_html__( 'Specify number of posts that you want to show. Enter -1 to get all posts', 'control-elementor' ),
				'min' => -1,
				'max' => 100,
				'step' => 1,			
				'default' => -1
			]
		);

		$this->add_control(
			$args['prefix'].'id',
			[
				'label' => esc_html__( 'Post ID\'s', 'control-elementor' ),
				'type' => Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter comma separated ID\'s of the posts that you want to show', 'control-elementor' ),
				'default' => '',
				'label_block' => true
			]
		);

		$this->add_control(
			$args['prefix'].'order',
			[
				'label' => esc_html__( 'Order', 'control-elementor' ),
				'type' => Controls_Manager::SELECT,
				'description' => esc_html__( 'Posts Order', 'control-elementor' ),
				'options' => [
					'desc' => __( 'Descending', 'control-elementor' ),
					'asc' => __( 'Ascending', 'control-elementor' )
				],
				'default' => 'desc',
			]
		);

		$this->add_control(
			$args['prefix'].'orderby',
			[
				'label' => esc_html__( 'Order by', 'control-elementor' ),
				'type' => Controls_Manager::SELECT,
				'description' => esc_html__( 'Order posts by', 'control-elementor' ),
				'options' => [
					'none' => __( 'None', 'control-elementor' ),
					'id' => __( 'Post ID', 'control-elementor' ),
					'author' => __( 'Post author', 'control-elementor' ),
					'title' => __( 'Post title', 'control-elementor' ),
					'name' => __( 'Post slug', 'control-elementor' ),
					'date' => __( 'Date', 'control-elementor' ), 
					'modified' => __( 'Last modified date', 'control-elementor' ),
					'parent' => __( 'Post parent', 'control-elementor' ),
					'rand' => __( 'Random', 'control-elementor' ), 
					'comment_count' => __( 'Comments number', 'control-elementor' ),
					'menu_order' => __( 'Menu order', 'control-elementor' ), 'meta_value' => __( 'Meta key values', 'control-elementor' ),
				],
				'default' => 'date',
			]
		);

		$this->add_control(
			$args['prefix'].'ignore_sticky',
			[
				'label' => esc_html__( 'Ignore sticky?', 'control-elementor' ),
				'type' => Controls_Manager::SWITCHER,
				'description' => esc_html__( 'Checked Yes to ignore posts that is sticked', 'control-elementor' ),
				'label_on' => esc_html__( 'Yes', 'control-elementor' ),
				'label_off' => esc_html__( 'No', 'control-elementor' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
	}

	/**
	 * Render title widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @param \Elementor\Widget_Base|null $instance
	 *
	 * @since  3.4.0
	 * @access protected
	 */
	protected function render_title( Widget_Base $instance = null, $args = [] ) {
		$default_args = [
			'prefix' => '',
			'text'   => esc_html__( 'Add text here', 'control-elementor' ),
		];
		$args = wp_parse_args($args, $default_args);

		if(empty($args['text'])) return;

		if ( empty( $instance ) ) {
			$instance = $this;
		}

		$settings = $instance->get_settings_for_display();

		$instance->add_render_attribute( $args['prefix'] . 'text', 'class', 'control-heading-title' );

		
		if ( ! empty( $settings[$args['prefix'] .'size_class'] ) ) {
			$instance->add_render_attribute( $args['prefix'] . 'text', 'class', $settings[$args['prefix'].'size_class'] );
		}

		if ( ! empty( $settings[$args['prefix'] .'text_color'] ) ) {
			$instance->add_render_attribute( $args['prefix'] . 'text', 'class', 'text-'.$settings[$args['prefix'].'text_color'] );
		}

		if ( ! empty( $settings[$args['prefix'] .'letter_spacing'] ) ) {
			$instance->add_render_attribute( $args['prefix'] . 'text', 'class', 'ls-'.$settings[$args['prefix'].'letter_spacing'] );
		}

		if ( ! empty( $settings[$args['prefix'] .'font_weight'] ) ) {
			$instance->add_render_attribute( $args['prefix'] . 'text', 'class', $settings[$args['prefix'].'font_weight'] );
		}

		if ( ! empty( $settings[$args['prefix'] .'bs_classes'] ) ) {
			$instance->add_render_attribute( $args['prefix'] . 'text', 'class', join(" ", $settings[$args['prefix'].'bs_classes']) );
		}
		
		if ( ! empty( $settings[$args['prefix'] .'css_class'] ) ) {
			$instance->add_render_attribute( $args['prefix'] . 'text', 'class', $settings[$args['prefix'].'css_class'] );
		}

		$html = sprintf('<%1$s %2$s>%3$s</%1$s>', $settings[$args['prefix'] . 'size'], $instance->get_render_attribute_string($args['prefix'] . 'text'), $args['text']);

		return $html;
	}
}
