<?php
/*
Plugin Name: Control Elementor
Plugin URI: https://themeperch.net/control-elementor
Description: Control Elementor widgets
Author: Themeperch
Author URI: https://themeperch.net
Version: 1.1.4
Text Domain: control-elementor
Domain Path: /languages
*/


define( 'CONTROL_ELEMENTOR_URL', plugin_dir_url( __FILE__ ) );
define( 'CONTROL_ELEMENTOR_DIR', dirname( __FILE__ ) ); 
define( 'CONTROL_ELEMENTOR_ASSETS', CONTROL_ELEMENTOR_URL.'/assets' ); 
define( 'CONTROL_ELEMENTOR_TEMPLATEPATH', trailingslashit(CONTROL_ELEMENTOR_DIR.'/templates') ); 




/**
 *
 * Load the plugin after Elementor (and other plugins) are loaded.
 *
 * @since 1.0.0
 */
function control_elementor_load_elements() {
    // Load localization file
    load_plugin_textdomain( 'control-elementor' );
    


    // Notice if the Elementor is not active
    if ( ! did_action( 'elementor/loaded' ) ) {
        return;
    }
    
    include __DIR__ .'/vendor/autoload.php';

    
    // Check version required
    $elementor_version_required = '3.6.7';
    if ( ! version_compare( ELEMENTOR_VERSION, $elementor_version_required, '>=' ) ) {
        return;
    }

    new controlElementor\Loader();
    
}
add_action( 'init', 'control_elementor_load_elements' );   //notiung but checking and notice

/*
* elementor script load
*/
add_action( 'elementor/editor/before_enqueue_scripts', function() {
    wp_enqueue_style( 'control-elementor-editor', CONTROL_ELEMENTOR_ASSETS . '/css/editor.css',  false,  '1.0.0',   false );
    wp_enqueue_script( 'control-elementor-editor', CONTROL_ELEMENTOR_ASSETS . '/js/editor.js',  ['jquery'],  '1.0.0',   false );
});