<?php
include __DIR__ .'/helper.php';
include __DIR__ .'/icons-library.php';
include __DIR__ .'/section.php';

function control_elementor_font_size_class_options(){
    $options = [
        '' => esc_html__( 'Default', 'elementor' ),
        'display-1' => esc_html__( 'Display 1', 'elementor' ),
        'display-2' => esc_html__( 'Display 2', 'elementor' ),
        'display-3' => esc_html__( 'Display 3', 'elementor' ),
        'display-4' => esc_html__( 'Display 4', 'elementor' ),
        'display-5' => esc_html__( 'Display 5', 'elementor' ),
        'display-6' => esc_html__( 'Display 6', 'elementor' ),
        'fs-1' => esc_html__( 'Heading 1', 'elementor' ),
        'fs-2' => esc_html__( 'Heading 2', 'elementor' ),
        'fs-3' => esc_html__( 'Heading 3', 'elementor' ),
        'fs-4' => esc_html__( 'Heading 4', 'elementor' ),
        'fs-5' => esc_html__( 'Heading 5', 'elementor' ),
        'fs-6' => esc_html__( 'Heading 6', 'elementor' ),
        'lead' => esc_html__( 'Lead', 'elementor' ),
        'small' => esc_html__( 'Small', 'elementor' ),
    ];

    return apply_filters( 'control_elementor_font_size_class_options', $options );
}

function control_elementor_font_weight_class_options(){
    $options = [
        '' => esc_html__( 'Default', 'elementor' ),
        'fw-bold' => esc_html__( 'Bold', 'elementor' ),
        'fw-bolder' => esc_html__( 'Bolder', 'elementor' ),
        'fw-semibold' => esc_html__( 'Semibold', 'elementor' ),
        'fw-normal' => esc_html__( 'Normal', 'elementor' ),
        'fw-light' => esc_html__( 'Light', 'elementor' ),
        'fw-lighter' => esc_html__( 'Lighter', 'elementor' )
    ];

    return apply_filters( 'control_elementor_font_weight_class_options', $options );
}

function control_elementor_text_color_class_options(){
    $options = [
        '' => esc_html__( 'Default', 'elementor' ),
        'primary' => esc_html__( 'primary', 'elementor' ),
        'secondary' => esc_html__( 'secondary', 'elementor' ),
        'success' => esc_html__( 'success', 'elementor' ),
        'danger' => esc_html__( 'danger', 'elementor' ),
        'warning' => esc_html__( 'warning', 'elementor' ),
        'info' => esc_html__( 'info', 'elementor' ),
        'light' => esc_html__( 'light', 'elementor' ),
        'dark' => esc_html__( 'dark', 'elementor' ),
        'body' => esc_html__( 'body', 'elementor' ),
        'muted' => esc_html__( 'muted', 'elementor' ),
        'white' => esc_html__( 'white', 'elementor' )
       
    ];

    return apply_filters( 'control_elementor_text_color_class_options', $options );
}

function control_elementor_button_style_class_options(){

   $options = [
        'link' => esc_html__( 'Link', 'elementor' ),
        'primary' => esc_html__( 'Primary', 'elementor' ),
        //'outline-primary' => esc_html__( 'Primary Outline', 'elementor' ),
        'secondary' => esc_html__( 'Secondary', 'elementor' ),
        //'outline-secondary' => esc_html__( 'Secondary outline', 'elementor' ),
        'info' => esc_html__( 'Info', 'elementor' ),
        'success' => esc_html__( 'Success', 'elementor' ),
        'warning' => esc_html__( 'Warning', 'elementor' ),
        'danger' => esc_html__( 'Danger', 'elementor' ),
   ];
   return apply_filters( 'control_elementor_button_style_class_options', $options );
}

function control_elementor_extra_class_options(){
    $options = [
        'underline_small' => 'Underline Bold',
        'underline-primary' => 'Underline Thin',
    ];
    return apply_filters( 'control_elementor_extra_class_options', $options );
}

function control_elementor_bs_classes_options(){
    $options = [];
    $options = array_merge($options, control_elementor_extra_class_options());

    $options = apply_filters( 'control_elementor_font_weight_class_options', $options );

    return array_filter(array_unique($options));
}