<?php
namespace ControlElementor;  //main namespace

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Base_Control;
use Elementor\Base_Data_Control;
use Elementor\Utils;

add_action( 'elementor/element/before_section_start', function( $element, $section_id, $args ) {
	global $pe_configs;
	//$config = $pe_configs[0];

	if ( 'section' === $element->get_name() && 'section_background' === $section_id ) :

		$gaps = $element->get_controls('gap');
		$gaps['options']['gap-5'] = 'Gap 5';
		$gaps['options']['gap-20'] = 'Gap 20';
		$element->update_control('gap', $gaps);

		$element->start_controls_section(
			'custom_section_layout',
			[
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'label' => __( 'Options', 'control-elementor' ),
			]
		);

		$element->add_control(
			'padding_class',
			[
				'label' => __( 'Section class name', 'control-elementor' ),
				'type' => Controls_Manager::SELECT,
				'default' => '',
				'options' => [
					'' => __( 'Default', 'control-elementor' ),
					'section-padding-normal' => __( 'Section padding normal', 'control-elementor' ),
					'section-padding-large' => __( 'Section padding large', 'control-elementor' ),
					'section-padding-small' => __( 'Section padding small', 'control-elementor' ),
					'section-no-padding' => __( 'Section no padding', 'control-elementor' ),
					'section-top-padding' => __( 'Section top padding only', 'control-elementor' ),
					'section-bottom-padding' => __( 'Section Bottom padding only', 'control-elementor' ),
				],
				'hide_in_inner' => true,
			]
		);

		$element->add_control(
			'bg_class',
			[
				'label' => __( 'Section Background', 'control-elementor' ),
				'type' => Controls_Manager::SELECT,
				'default' => '',
				'options' => [
					'' => __( 'Select Background color', 'control-elementor' ),
					'default-bg' => __( 'Default Background color', 'control-elementor' ),
					'primary-bg' => __( 'Primary Background color', 'control-elementor' ),
					'secondary-bg-dark' => __( 'Secondary Background color', 'control-elementor' ),
					'secondary-light-bg' => __( 'Secondary Light Background color', 'control-elementor' ),
					'secondary-dark-bg' => __( 'Secondary Dark Background color', 'control-elementor' ),
					'bg_gray' => __( 'Gray Background color', 'control-elementor' ),
				],
				'hide_in_inner' => true,
			]
		);

		$element->end_controls_section();

	endif;	

}, 10, 3 );



add_action( 'elementor/frontend/section/before_render', function ( \Elementor\Element_Base $element ) {	

	$element->add_render_attribute( '_wrapper', [
		'class' => $element->get_settings( 'padding_class' )
	]);

	$bg_class = $element->get_settings( 'bg_class' );
	if( $bg_class == 'primary-bg' ) $bg_class = 'bg-primary';
	if( $bg_class == 'bg_gray' ) $bg_class = 'bg-light';
	if( $bg_class == 'secondary-bg-dark' ) $bg_class = 'bg-secondary';
	if( $bg_class == 'secondary-dark-bg' ) $bg_class = 'bg-dark';
	if( $bg_class == 'secondary-light-bg' ) $bg_class = 'bg-secondary-light';
	if( $bg_class == 'default-bg' ) $bg_class = 'bg-body';

	$element->add_render_attribute( '_wrapper', [
		'class' => $bg_class
	]);

	if(in_array($element->get_settings( 'bg_class' ), [ 'primary-bg', 'secondary-bg-dark', 'secondary-light-bg', 'secondary-dark-bg' ] )){
		$element->add_render_attribute( '_wrapper', [
			'class' => 'has-darkbg-class'
		]);
	}
});