<?php
/**
 * Class for managing plugin data
 */
class Tp_Data {

	/**
	 * Constructor
	 */
	function __construct() {}

	/**
	 * Shortcode groups
	 */
	public static function groups() {
		return apply_filters( 'perch/data/groups', array(
				'all'     => __( 'All', 'perch' ),
				'schema' => __( 'Schema', 'perch' ),
				'content' => __( 'Content', 'perch' ),
				'box'     => __( 'Box', 'perch' ),
				'media'   => __( 'Media', 'perch' ),
				'gallery' => __( 'Gallery', 'perch' ),
				'data'    => __( 'Data', 'perch' ),
				'other'   => __( 'Other', 'perch' )
			) );
	}

	/**
	 * Border styles
	 */
	public static function borders() {
		return apply_filters( 'perch/data/borders', array(
				'none'   => __( 'None', 'perch' ),
				'solid'  => __( 'Solid', 'perch' ),
				'dotted' => __( 'Dotted', 'perch' ),
				'dashed' => __( 'Dashed', 'perch' ),
				'double' => __( 'Double', 'perch' ),
				'groove' => __( 'Groove', 'perch' ),
				'ridge'  => __( 'Ridge', 'perch' )
			) );
	}

	/**
	 * Font-Awesome icons
	 */
	public static function icons() {
		return apply_filters( 'perch/data/icons', 
			array(
				'Generic-icons' => array( 'genericon genericon-404', 'genericon genericon-activity', 'genericon genericon-anchor', 'genericon genericon-aside', 'genericon genericon-attachment', 'genericon genericon-audio', 'genericon genericon-bold', 'genericon genericon-book', 'genericon genericon-bug', 'genericon genericon-cart', 'genericon genericon-category', 'genericon genericon-chat', 'genericon genericon-checkmark', 'genericon genericon-close', 'genericon genericon-close-alt', 'genericon genericon-cloud', 'genericon genericon-cloud-download', 'genericon genericon-cloud-upload', 'genericon genericon-code', 'genericon genericon-codepen', 'genericon genericon-cog', 'genericon genericon-collapse', 'genericon genericon-comment', 'genericon genericon-day', 'genericon genericon-digg', 'genericon genericon-document', 'genericon genericon-dot', 'genericon genericon-downarrow', 'genericon genericon-download', 'genericon genericon-draggable', 'genericon genericon-dribbble', 'genericon genericon-dropbox', 'genericon genericon-dropdown', 'genericon genericon-dropdown-left', 'genericon genericon-edit', 'genericon genericon-ellipsis', 'genericon genericon-expand', 'genericon genericon-external', 'genericon genericon-facebook', 'genericon genericon-facebook-alt', 'genericon genericon-fastforward', 'genericon genericon-feed', 'genericon genericon-flag', 'genericon genericon-flickr', 'genericon genericon-foursquare', 'genericon genericon-fullscreen', 'genericon genericon-gallery', 'genericon genericon-github', 'genericon genericon-googleplus', 'genericon genericon-googleplus-alt', 'genericon genericon-handset', 'genericon genericon-heart', 'genericon genericon-help', 'genericon genericon-hide', 'genericon genericon-hierarchy', 'genericon genericon-home', 'genericon genericon-image', 'genericon genericon-info', 'genericon genericon-instagram', 'genericon genericon-italic', 'genericon genericon-key', 'genericon genericon-leftarrow', 'genericon genericon-link', 'genericon genericon-linkedin', 'genericon genericon-linkedin-alt', 'genericon genericon-location', 'genericon genericon-lock', 'genericon genericon-mail', 'genericon genericon-maximize', 'genericon genericon-menu', 'genericon genericon-microphone', 'genericon genericon-minimize', 'genericon genericon-minus', 'genericon genericon-month', 'genericon genericon-move', 'genericon genericon-next', 'genericon genericon-notice', 'genericon genericon-paintbrush', 'genericon genericon-path', 'genericon genericon-pause', 'genericon genericon-phone', 'genericon genericon-picture', 'genericon genericon-pinned', 'genericon genericon-pinterest', 'genericon genericon-pinterest-alt', 'genericon genericon-play', 'genericon genericon-plugin', 'genericon genericon-plus', 'genericon genericon-pocket', 'genericon genericon-polldaddy', 'genericon genericon-portfolio', 'genericon genericon-previous', 'genericon genericon-print', 'genericon genericon-quote', 'genericon genericon-rating-empty', 'genericon genericon-rating-full', 'genericon genericon-rating-half', 'genericon genericon-reddit', 'genericon genericon-refresh', 'genericon genericon-reply', 'genericon genericon-reply-alt', 'genericon genericon-reply-single', 'genericon genericon-rewind', 'genericon genericon-rightarrow', 'genericon genericon-search', 'genericon genericon-send-to-phone', 'genericon genericon-send-to-tablet', 'genericon genericon-share', 'genericon genericon-show', 'genericon genericon-shuffle', 'genericon genericon-sitemap', 'genericon genericon-skip-ahead', 'genericon genericon-skip-back', 'genericon genericon-skype', 'genericon genericon-spam', 'genericon genericon-spotify', 'genericon genericon-standard', 'genericon genericon-star', 'genericon genericon-status', 'genericon genericon-stop', 'genericon genericon-stumbleupon', 'genericon genericon-subscribe', 'genericon genericon-subscribed', 'genericon genericon-summary', 'genericon genericon-tablet', 'genericon genericon-tag', 'genericon genericon-time', 'genericon genericon-top', 'genericon genericon-trash', 'genericon genericon-tumblr', 'genericon genericon-twitch', 'genericon genericon-twitter', 'genericon genericon-unapprove', 'genericon genericon-unsubscribe', 'genericon genericon-unzoom', 'genericon genericon-uparrow', 'genericon genericon-user', 'genericon genericon-video', 'genericon genericon-videocamera', 'genericon genericon-vimeo', 'genericon genericon-warning', 'genericon genericon-website', 'genericon genericon-week', 'genericon genericon-wordpress', 'genericon genericon-xpost', 'genericon genericon-youtube', 'genericon genericon-zoom',  ),
				
				'Iconic-icons' => array( 'ion-ionic', 'ion-arrow-up-a', 'ion-arrow-right-a', 'ion-arrow-down-a', 'ion-arrow-left-a', 'ion-arrow-up-b', 'ion-arrow-right-b', 'ion-arrow-down-b', 'ion-arrow-left-b', 'ion-arrow-up-c', 'ion-arrow-right-c', 'ion-arrow-down-c', 'ion-arrow-left-c', 'ion-arrow-return-right', 'ion-arrow-return-left', 'ion-arrow-swap', 'ion-arrow-shrink', 'ion-arrow-expand', 'ion-arrow-move', 'ion-arrow-resize', 'ion-chevron-up', 'ion-chevron-right', 'ion-chevron-down', 'ion-chevron-left', 'ion-navicon-round', 'ion-navicon', 'ion-drag', 'ion-log-in', 'ion-log-out', 'ion-checkmark-round', 'ion-checkmark', 'ion-checkmark-circled', 'ion-close-round', 'ion-close', 'ion-close-circled', 'ion-plus-round', 'ion-plus', 'ion-plus-circled', 'ion-minus-round', 'ion-minus', 'ion-minus-circled', 'ion-information', 'ion-information-circled', 'ion-help', 'ion-help-circled', 'ion-backspace-outline', 'ion-backspace', 'ion-help-buoy', 'ion-asterisk', 'ion-alert', 'ion-alert-circled', 'ion-refresh', 'ion-loop', 'ion-shuffle', 'ion-home', 'ion-search', 'ion-flag', 'ion-star', 'ion-heart', 'ion-heart-broken', 'ion-gear-a', 'ion-gear-b', 'ion-toggle-filled', 'ion-toggle', 'ion-settings', 'ion-wrench', 'ion-hammer', 'ion-edit', 'ion-trash-a', 'ion-trash-b', 'ion-document', 'ion-document-text', 'ion-clipboard', 'ion-scissors', 'ion-funnel', 'ion-bookmark', 'ion-email', 'ion-email-unread', 'ion-folder', 'ion-filing', 'ion-archive', 'ion-reply', 'ion-reply-all', 'ion-forward', 'ion-share', 'ion-paper-airplane', 'ion-link', 'ion-paperclip', 'ion-compose', 'ion-briefcase', 'ion-medkit', 'ion-at', 'ion-pound', 'ion-quote', 'ion-cloud', 'ion-upload', 'ion-more', 'ion-grid', 'ion-calendar', 'ion-clock', 'ion-compass', 'ion-pinpoint', 'ion-pin', 'ion-navigate', 'ion-location', 'ion-map', 'ion-lock-combination', 'ion-locked', 'ion-unlocked', 'ion-key', 'ion-arrow-graph-up-right', 'ion-arrow-graph-down-right', 'ion-arrow-graph-up-left', 'ion-arrow-graph-down-left', 'ion-stats-bars', 'ion-connection-bars', 'ion-pie-graph', 'ion-chatbubble', 'ion-chatbubble-working', 'ion-chatbubbles', 'ion-chatbox', 'ion-chatbox-working', 'ion-chatboxes', 'ion-person', 'ion-person-add', 'ion-person-stalker', 'ion-woman', 'ion-man', 'ion-female', 'ion-male', 'ion-transgender', 'ion-fork', 'ion-knife', 'ion-spoon', 'ion-soup-can-outline', 'ion-soup-can', 'ion-beer', 'ion-wineglass', 'ion-coffee', 'ion-icecream', 'ion-pizza', 'ion-power', 'ion-mouse', 'ion-battery-full', 'ion-battery-half', 'ion-battery-low', 'ion-battery-empty', 'ion-battery-charging', 'ion-wifi', 'ion-bluetooth', 'ion-calculator', 'ion-camera', 'ion-eye', 'ion-eye-disabled', 'ion-flash', 'ion-flash-off', 'ion-qr-scanner', 'ion-image', 'ion-images', 'ion-wand', 'ion-contrast', 'ion-aperture', 'ion-crop', 'ion-easel', 'ion-paintbrush', 'ion-paintbucket', 'ion-monitor', 'ion-laptop', 'ion-ipad', 'ion-iphone', 'ion-ipod', 'ion-printer', 'ion-usb', 'ion-outlet', 'ion-bug', 'ion-code', 'ion-code-working', 'ion-code-download', 'ion-fork-repo', 'ion-network', 'ion-pull-request', 'ion-merge', 'ion-xbox', 'ion-playstation', 'ion-steam', 'ion-closed-captioning', 'ion-videocamera', 'ion-film-marker', 'ion-disc', 'ion-headphone', 'ion-music-note', 'ion-radio-waves', 'ion-speakerphone', 'ion-mic-a', 'ion-mic-b', 'ion-mic-c', 'ion-volume-high', 'ion-volume-medium', 'ion-volume-low', 'ion-volume-mute', 'ion-levels', 'ion-play', 'ion-pause', 'ion-stop', 'ion-record', 'ion-skip-forward', 'ion-skip-backward', 'ion-eject', 'ion-bag', 'ion-card', 'ion-cash', 'ion-pricetag', 'ion-pricetags', 'ion-thumbsup', 'ion-thumbsdown', 'ion-happy-outline', 'ion-happy', 'ion-sad-outline', 'ion-sad', 'ion-bowtie', 'ion-tshirt-outline', 'ion-tshirt', 'ion-trophy', 'ion-podium', 'ion-ribbon-a', 'ion-ribbon-b', 'ion-university', 'ion-magnet', 'ion-beaker', 'ion-erlenmeyer-flask', 'ion-egg', 'ion-earth', 'ion-planet', 'ion-lightbulb', 'ion-cube', 'ion-leaf', 'ion-waterdrop', 'ion-flame', 'ion-fireball', 'ion-bonfire', 'ion-umbrella', 'ion-nuclear', 'ion-no-smoking', 'ion-thermometer', 'ion-speedometer', 'ion-model-s', 'ion-plane', 'ion-jet', 'ion-load-a', 'ion-load-b', 'ion-load-c', 'ion-load-d', 'ion-ios-ionic-outline', 'ion-ios-arrow-back', 'ion-ios-arrow-forward', 'ion-ios-arrow-up', 'ion-ios-arrow-right', 'ion-ios-arrow-down', 'ion-ios-arrow-left', 'ion-ios-arrow-thin-up', 'ion-ios-arrow-thin-right', 'ion-ios-arrow-thin-down', 'ion-ios-arrow-thin-left', 'ion-ios-circle-filled', 'ion-ios-circle-outline', 'ion-ios-checkmark-empty', 'ion-ios-checkmark-outline', 'ion-ios-checkmark', 'ion-ios-plus-empty', 'ion-ios-plus-outline', 'ion-ios-plus', 'ion-ios-close-empty', 'ion-ios-close-outline', 'ion-ios-close', 'ion-ios-minus-empty', 'ion-ios-minus-outline', 'ion-ios-minus', 'ion-ios-information-empty', 'ion-ios-information-outline', 'ion-ios-information', 'ion-ios-help-empty', 'ion-ios-help-outline', 'ion-ios-help', 'ion-ios-search', 'ion-ios-search-strong', 'ion-ios-star', 'ion-ios-star-half', 'ion-ios-star-outline', 'ion-ios-heart', 'ion-ios-heart-outline', 'ion-ios-more', 'ion-ios-more-outline', 'ion-ios-home', 'ion-ios-home-outline', 'ion-ios-cloud', 'ion-ios-cloud-outline', 'ion-ios-cloud-upload', 'ion-ios-cloud-upload-outline', 'ion-ios-cloud-download', 'ion-ios-cloud-download-outline', 'ion-ios-upload', 'ion-ios-upload-outline', 'ion-ios-download', 'ion-ios-download-outline', 'ion-ios-refresh', 'ion-ios-refresh-outline', 'ion-ios-refresh-empty', 'ion-ios-reload', 'ion-ios-loop-strong', 'ion-ios-loop', 'ion-ios-bookmarks', 'ion-ios-bookmarks-outline', 'ion-ios-book', 'ion-ios-book-outline', 'ion-ios-flag', 'ion-ios-flag-outline', 'ion-ios-glasses', 'ion-ios-glasses-outline', 'ion-ios-browsers', 'ion-ios-browsers-outline', 'ion-ios-at', 'ion-ios-at-outline', 'ion-ios-pricetag', 'ion-ios-pricetag-outline', 'ion-ios-pricetags', 'ion-ios-pricetags-outline', 'ion-ios-cart', 'ion-ios-cart-outline', 'ion-ios-chatboxes', 'ion-ios-chatboxes-outline', 'ion-ios-chatbubble', 'ion-ios-chatbubble-outline', 'ion-ios-cog', 'ion-ios-cog-outline', 'ion-ios-gear', 'ion-ios-gear-outline', 'ion-ios-settings', 'ion-ios-settings-strong', 'ion-ios-toggle', 'ion-ios-toggle-outline', 'ion-ios-analytics', 'ion-ios-analytics-outline', 'ion-ios-pie', 'ion-ios-pie-outline', 'ion-ios-pulse', 'ion-ios-pulse-strong', 'ion-ios-filing', 'ion-ios-filing-outline', 'ion-ios-box', 'ion-ios-box-outline', 'ion-ios-compose', 'ion-ios-compose-outline', 'ion-ios-trash', 'ion-ios-trash-outline', 'ion-ios-copy', 'ion-ios-copy-outline', 'ion-ios-email', 'ion-ios-email-outline', 'ion-ios-undo', 'ion-ios-undo-outline', 'ion-ios-redo', 'ion-ios-redo-outline', 'ion-ios-paperplane', 'ion-ios-paperplane-outline', 'ion-ios-folder', 'ion-ios-folder-outline', 'ion-ios-paper', 'ion-ios-paper-outline', 'ion-ios-list', 'ion-ios-list-outline', 'ion-ios-world', 'ion-ios-world-outline', 'ion-ios-alarm', 'ion-ios-alarm-outline', 'ion-ios-speedometer', 'ion-ios-speedometer-outline', 'ion-ios-stopwatch', 'ion-ios-stopwatch-outline', 'ion-ios-timer', 'ion-ios-timer-outline', 'ion-ios-clock', 'ion-ios-clock-outline', 'ion-ios-time', 'ion-ios-time-outline', 'ion-ios-calendar', 'ion-ios-calendar-outline', 'ion-ios-photos', 'ion-ios-photos-outline', 'ion-ios-albums', 'ion-ios-albums-outline', 'ion-ios-camera', 'ion-ios-camera-outline', 'ion-ios-reverse-camera', 'ion-ios-reverse-camera-outline', 'ion-ios-eye', 'ion-ios-eye-outline', 'ion-ios-bolt', 'ion-ios-bolt-outline', 'ion-ios-color-wand', 'ion-ios-color-wand-outline', 'ion-ios-color-filter', 'ion-ios-color-filter-outline', 'ion-ios-grid-view', 'ion-ios-grid-view-outline', 'ion-ios-crop-strong', 'ion-ios-crop', 'ion-ios-barcode', 'ion-ios-barcode-outline', 'ion-ios-briefcase', 'ion-ios-briefcase-outline', 'ion-ios-medkit', 'ion-ios-medkit-outline', 'ion-ios-medical', 'ion-ios-medical-outline', 'ion-ios-infinite', 'ion-ios-infinite-outline', 'ion-ios-calculator', 'ion-ios-calculator-outline', 'ion-ios-keypad', 'ion-ios-keypad-outline', 'ion-ios-telephone', 'ion-ios-telephone-outline', 'ion-ios-drag', 'ion-ios-location', 'ion-ios-location-outline', 'ion-ios-navigate', 'ion-ios-navigate-outline', 'ion-ios-locked', 'ion-ios-locked-outline', 'ion-ios-unlocked', 'ion-ios-unlocked-outline', 'ion-ios-monitor', 'ion-ios-monitor-outline', 'ion-ios-printer', 'ion-ios-printer-outline', 'ion-ios-game-controller-a', 'ion-ios-game-controller-a-outline', 'ion-ios-game-controller-b', 'ion-ios-game-controller-b-outline', 'ion-ios-americanfootball', 'ion-ios-americanfootball-outline', 'ion-ios-baseball', 'ion-ios-baseball-outline', 'ion-ios-basketball', 'ion-ios-basketball-outline', 'ion-ios-tennisball', 'ion-ios-tennisball-outline', 'ion-ios-football', 'ion-ios-football-outline', 'ion-ios-body', 'ion-ios-body-outline', 'ion-ios-person', 'ion-ios-person-outline', 'ion-ios-personadd', 'ion-ios-personadd-outline', 'ion-ios-people', 'ion-ios-people-outline', 'ion-ios-musical-notes', 'ion-ios-musical-note', 'ion-ios-bell', 'ion-ios-bell-outline', 'ion-ios-mic', 'ion-ios-mic-outline', 'ion-ios-mic-off', 'ion-ios-volume-high', 'ion-ios-volume-low', 'ion-ios-play', 'ion-ios-play-outline', 'ion-ios-pause', 'ion-ios-pause-outline', 'ion-ios-recording', 'ion-ios-recording-outline', 'ion-ios-fastforward', 'ion-ios-fastforward-outline', 'ion-ios-rewind', 'ion-ios-rewind-outline', 'ion-ios-skipbackward', 'ion-ios-skipbackward-outline', 'ion-ios-skipforward', 'ion-ios-skipforward-outline', 'ion-ios-shuffle-strong', 'ion-ios-shuffle', 'ion-ios-videocam', 'ion-ios-videocam-outline', 'ion-ios-film', 'ion-ios-film-outline', 'ion-ios-flask', 'ion-ios-flask-outline', 'ion-ios-lightbulb', 'ion-ios-lightbulb-outline', 'ion-ios-wineglass', 'ion-ios-wineglass-outline', 'ion-ios-pint', 'ion-ios-pint-outline', 'ion-ios-nutrition', 'ion-ios-nutrition-outline', 'ion-ios-flower', 'ion-ios-flower-outline', 'ion-ios-rose', 'ion-ios-rose-outline', 'ion-ios-paw', 'ion-ios-paw-outline', 'ion-ios-flame', 'ion-ios-flame-outline', 'ion-ios-sunny', 'ion-ios-sunny-outline', 'ion-ios-partlysunny', 'ion-ios-partlysunny-outline', 'ion-ios-cloudy', 'ion-ios-cloudy-outline', 'ion-ios-rainy', 'ion-ios-rainy-outline', 'ion-ios-thunderstorm', 'ion-ios-thunderstorm-outline', 'ion-ios-snowy', 'ion-ios-moon', 'ion-ios-moon-outline', 'ion-ios-cloudy-night', 'ion-ios-cloudy-night-outline', 'ion-android-arrow-up', 'ion-android-arrow-forward', 'ion-android-arrow-down', 'ion-android-arrow-back', 'ion-android-arrow-dropup', 'ion-android-arrow-dropup-circle', 'ion-android-arrow-dropright', 'ion-android-arrow-dropright-circle', 'ion-android-arrow-dropdown', 'ion-android-arrow-dropdown-circle', 'ion-android-arrow-dropleft', 'ion-android-arrow-dropleft-circle', 'ion-android-add', 'ion-android-add-circle', 'ion-android-remove', 'ion-android-remove-circle', 'ion-android-close', 'ion-android-cancel', 'ion-android-radio-button-off', 'ion-android-radio-button-on', 'ion-android-checkmark-circle', 'ion-android-checkbox-outline-blank', 'ion-android-checkbox-outline', 'ion-android-checkbox-blank', 'ion-android-checkbox', 'ion-android-done', 'ion-android-done-all', 'ion-android-menu', 'ion-android-more-horizontal', 'ion-android-more-vertical', 'ion-android-refresh', 'ion-android-sync', 'ion-android-wifi', 'ion-android-call', 'ion-android-apps', 'ion-android-settings', 'ion-android-options', 'ion-android-funnel', 'ion-android-search', 'ion-android-home', 'ion-android-cloud-outline', 'ion-android-cloud', 'ion-android-download', 'ion-android-upload', 'ion-android-cloud-done', 'ion-android-cloud-circle', 'ion-android-favorite-outline', 'ion-android-favorite', 'ion-android-star-outline', 'ion-android-star-half', 'ion-android-star', 'ion-android-calendar', 'ion-android-alarm-clock', 'ion-android-time', 'ion-android-stopwatch', 'ion-android-watch', 'ion-android-locate', 'ion-android-navigate', 'ion-android-pin', 'ion-android-compass', 'ion-android-map', 'ion-android-walk', 'ion-android-bicycle', 'ion-android-car', 'ion-android-bus', 'ion-android-subway', 'ion-android-train', 'ion-android-boat', 'ion-android-plane', 'ion-android-restaurant', 'ion-android-bar', 'ion-android-cart', 'ion-android-camera', 'ion-android-image', 'ion-android-film', 'ion-android-color-palette', 'ion-android-create', 'ion-android-mail', 'ion-android-drafts', 'ion-android-send', 'ion-android-archive', 'ion-android-delete', 'ion-android-attach', 'ion-android-share', 'ion-android-share-alt', 'ion-android-bookmark', 'ion-android-document', 'ion-android-clipboard', 'ion-android-list', 'ion-android-folder-open', 'ion-android-folder', 'ion-android-print', 'ion-android-open', 'ion-android-exit', 'ion-android-contract', 'ion-android-expand', 'ion-android-globe', 'ion-android-chat', 'ion-android-textsms', 'ion-android-hangout', 'ion-android-happy', 'ion-android-sad', 'ion-android-person', 'ion-android-people', 'ion-android-person-add', 'ion-android-contact', 'ion-android-contacts', 'ion-android-playstore', 'ion-android-lock', 'ion-android-unlock', 'ion-android-microphone', 'ion-android-microphone-off', 'ion-android-notifications-none', 'ion-android-notifications', 'ion-android-notifications-off', 'ion-android-volume-mute', 'ion-android-volume-down', 'ion-android-volume-up', 'ion-android-volume-off', 'ion-android-hand', 'ion-android-desktop', 'ion-android-laptop', 'ion-android-phone-portrait', 'ion-android-phone-landscape', 'ion-android-bulb', 'ion-android-sunny', 'ion-android-alert', 'ion-android-warning', 'ion-social-twitter', 'ion-social-twitter-outline', 'ion-social-facebook', 'ion-social-facebook-outline', 'ion-social-googleplus', 'ion-social-googleplus-outline', 'ion-social-google', 'ion-social-google-outline', 'ion-social-dribbble', 'ion-social-dribbble-outline', 'ion-social-octocat', 'ion-social-github', 'ion-social-github-outline', 'ion-social-instagram', 'ion-social-instagram-outline', 'ion-social-whatsapp', 'ion-social-whatsapp-outline', 'ion-social-snapchat', 'ion-social-snapchat-outline', 'ion-social-foursquare', 'ion-social-foursquare-outline', 'ion-social-pinterest', 'ion-social-pinterest-outline', 'ion-social-rss', 'ion-social-rss-outline', 'ion-social-tumblr', 'ion-social-tumblr-outline', 'ion-social-wordpress', 'ion-social-wordpress-outline', 'ion-social-reddit', 'ion-social-reddit-outline', 'ion-social-hackernews', 'ion-social-hackernews-outline', 'ion-social-designernews', 'ion-social-designernews-outline', 'ion-social-yahoo', 'ion-social-yahoo-outline', 'ion-social-buffer', 'ion-social-buffer-outline', 'ion-social-skype', 'ion-social-skype-outline', 'ion-social-linkedin', 'ion-social-linkedin-outline', 'ion-social-vimeo', 'ion-social-vimeo-outline', 'ion-social-twitch', 'ion-social-twitch-outline', 'ion-social-youtube', 'ion-social-youtube-outline', 'ion-social-dropbox', 'ion-social-dropbox-outline', 'ion-social-apple', 'ion-social-apple-outline', 'ion-social-android', 'ion-social-android-outline', 'ion-social-windows', 'ion-social-windows-outline', 'ion-social-html5', 'ion-social-html5-outline', 'ion-social-css3', 'ion-social-css3-outline', 'ion-social-javascript', 'ion-social-javascript-outline', 'ion-social-angular', 'ion-social-angular-outline', 'ion-social-nodejs', 'ion-social-sass', 'ion-social-python', 'ion-social-chrome', 'ion-social-chrome-outline', 'ion-social-codepen', 'ion-social-codepen-outline', 'ion-social-markdown', 'ion-social-tux', 'ion-social-freebsd-devil', 'ion-social-usd', 'ion-social-usd-outline', 'ion-social-bitcoin', 'ion-social-bitcoin-outline', 'ion-social-yen', 'ion-social-yen-outline', 'ion-social-euro', 'ion-social-euro-outline',  ),

				'linear-icons' => array( 'lnr lnr-home', 'lnr lnr-apartment', 'lnr lnr-pencil', 'lnr lnr-magic-wand', 'lnr lnr-drop', 'lnr lnr-lighter', 'lnr lnr-poop', 'lnr lnr-sun', 'lnr lnr-moon', 'lnr lnr-cloud', 'lnr lnr-cloud-upload', 'lnr lnr-cloud-download', 'lnr lnr-cloud-sync', 'lnr lnr-cloud-check', 'lnr lnr-database', 'lnr lnr-lock', 'lnr lnr-cog', 'lnr lnr-trash', 'lnr lnr-dice', 'lnr lnr-heart', 'lnr lnr-star', 'lnr lnr-star-half', 'lnr lnr-star-empty', 'lnr lnr-flag', 'lnr lnr-envelope', 'lnr lnr-paperclip', 'lnr lnr-inbox', 'lnr lnr-eye', 'lnr lnr-printer', 'lnr lnr-file-empty', 'lnr lnr-file-add', 'lnr lnr-enter', 'lnr lnr-exit', 'lnr lnr-graduation-hat', 'lnr lnr-license', 'lnr lnr-music-note', 'lnr lnr-film-play', 'lnr lnr-camera-video', 'lnr lnr-camera', 'lnr lnr-picture', 'lnr lnr-book', 'lnr lnr-bookmark', 'lnr lnr-user', 'lnr lnr-users', 'lnr lnr-shirt', 'lnr lnr-store', 'lnr lnr-cart', 'lnr lnr-tag', 'lnr lnr-phone-handset', 'lnr lnr-phone', 'lnr lnr-pushpin', 'lnr lnr-map-marker', 'lnr lnr-map', 'lnr lnr-location', 'lnr lnr-calendar-full', 'lnr lnr-keyboard', 'lnr lnr-spell-check', 'lnr lnr-screen', 'lnr lnr-smartphone', 'lnr lnr-tablet', 'lnr lnr-laptop', 'lnr lnr-laptop-phone', 'lnr lnr-power-switch', 'lnr lnr-bubble', 'lnr lnr-heart-pulse', 'lnr lnr-construction', 'lnr lnr-pie-chart', 'lnr lnr-chart-bars', 'lnr lnr-gift', 'lnr lnr-diamond', 'lnr lnr-linearicons', 'lnr lnr-dinner', 'lnr lnr-coffee-cup', 'lnr lnr-leaf', 'lnr lnr-paw', 'lnr lnr-rocket', 'lnr lnr-briefcase', 'lnr lnr-bus', 'lnr lnr-car', 'lnr lnr-train', 'lnr lnr-bicycle', 'lnr lnr-wheelchair', 'lnr lnr-select', 'lnr lnr-earth', 'lnr lnr-smile', 'lnr lnr-sad', 'lnr lnr-neutral', 'lnr lnr-mustache', 'lnr lnr-alarm', 'lnr lnr-bullhorn', 'lnr lnr-volume-high', 'lnr lnr-volume-medium', 'lnr lnr-volume-low', 'lnr lnr-volume', 'lnr lnr-mic', 'lnr lnr-hourglass', 'lnr lnr-undo', 'lnr lnr-redo', 'lnr lnr-sync', 'lnr lnr-history', 'lnr lnr-clock', 'lnr lnr-download', 'lnr lnr-upload', 'lnr lnr-enter-down', 'lnr lnr-exit-up', 'lnr lnr-bug', 'lnr lnr-code', 'lnr lnr-link', 'lnr lnr-unlink', 'lnr lnr-thumbs-up', 'lnr lnr-thumbs-down', 'lnr lnr-magnifier', 'lnr lnr-cross', 'lnr lnr-menu', 'lnr lnr-list', 'lnr lnr-chevron-up', 'lnr lnr-chevron-down', 'lnr lnr-chevron-left', 'lnr lnr-chevron-right', 'lnr lnr-arrow-up', 'lnr lnr-arrow-down', 'lnr lnr-arrow-left', 'lnr lnr-arrow-right', 'lnr lnr-move', 'lnr lnr-warning', 'lnr lnr-question-circle', 'lnr lnr-menu-circle', 'lnr lnr-checkmark-circle', 'lnr lnr-cross-circle', 'lnr lnr-plus-circle', 'lnr lnr-circle-minus', 'lnr lnr-arrow-up-circle', 'lnr lnr-arrow-down-circle', 'lnr lnr-arrow-left-circle', 'lnr lnr-arrow-right-circle', 'lnr lnr-chevron-up-circle', 'lnr lnr-chevron-down-circle', 'lnr lnr-chevron-left-circle', 'lnr lnr-chevron-right-circle', 'lnr lnr-crop', 'lnr lnr-frame-expand', 'lnr lnr-frame-contract', 'lnr lnr-layers', 'lnr lnr-funnel', 'lnr lnr-text-format', 'lnr lnr-text-format-remove', 'lnr lnr-text-size', 'lnr lnr-bold', 'lnr lnr-italic', 'lnr lnr-underline', 'lnr lnr-strikethrough', 'lnr lnr-highlight', 'lnr lnr-text-align-left', 'lnr lnr-text-align-center', 'lnr lnr-text-align-right', 'lnr lnr-text-align-justify', 'lnr lnr-line-spacing', 'lnr lnr-indent-increase', 'lnr lnr-indent-decrease', 'lnr lnr-pilcrow', 'lnr lnr-direction-ltr', 'lnr lnr-direction-rtl', 'lnr lnr-page-break', 'lnr lnr-sort-alpha-asc', 'lnr lnr-sort-amount-asc', 'lnr lnr-hand', 'lnr lnr-pointer-up', 'lnr lnr-pointer-right', 'lnr lnr-pointer-down', 'lnr lnr-pointer-left'  ),	

				'Font-Awesome-icons' => array( 'fa fa-glass', 'fa fa-music', 'fa fa-search', 'fa fa-envelope-o', 'fa fa-heart', 'fa fa-star', 'fa fa-star-o', 'fa fa-user', 'fa fa-film', 'fa fa-th-large', 'fa fa-th', 'fa fa-th-list', 'fa fa-check', 'fa fa-times', 'fa fa-search-plus', 'fa fa-search-minus', 'fa fa-power-off', 'fa fa-signal', 'fa fa-cog', 'fa fa-trash-o', 'fa fa-home', 'fa fa-file-o', 'fa fa-clock-o', 'fa fa-road', 'fa fa-download', 'fa fa-arrow-circle-o-down', 'fa fa-arrow-circle-o-up', 'fa fa-inbox', 'fa fa-play-circle-o', 'fa fa-repeat', 'fa fa-refresh', 'fa fa-list-alt', 'fa fa-lock', 'fa fa-flag', 'fa fa-headphones', 'fa fa-volume-off', 'fa fa-volume-down', 'fa fa-volume-up', 'fa fa-qrcode', 'fa fa-barcode', 'fa fa-tag', 'fa fa-tags', 'fa fa-book', 'fa fa-bookmark', 'fa fa-print', 'fa fa-camera', 'fa fa-font', 'fa fa-bold', 'fa fa-italic', 'fa fa-text-height', 'fa fa-text-width', 'fa fa-align-left', 'fa fa-align-center', 'fa fa-align-right', 'fa fa-align-justify', 'fa fa-list', 'fa fa-outdent', 'fa fa-indent', 'fa fa-video-camera', 'fa fa-picture-o', 'fa fa-pencil', 'fa fa-map-marker', 'fa fa-adjust', 'fa fa-tint', 'fa fa-pencil-square-o', 'fa fa-share-square-o', 'fa fa-check-square-o', 'fa fa-arrows', 'fa fa-step-backward', 'fa fa-fast-backward', 'fa fa-backward', 'fa fa-play', 'fa fa-pause', 'fa fa-stop', 'fa fa-forward', 'fa fa-fast-forward', 'fa fa-step-forward', 'fa fa-eject', 'fa fa-chevron-left', 'fa fa-chevron-right', 'fa fa-plus-circle', 'fa fa-minus-circle', 'fa fa-times-circle', 'fa fa-check-circle', 'fa fa-question-circle', 'fa fa-info-circle', 'fa fa-crosshairs', 'fa fa-times-circle-o', 'fa fa-check-circle-o', 'fa fa-ban', 'fa fa-arrow-left', 'fa fa-arrow-right', 'fa fa-arrow-up', 'fa fa-arrow-down', 'fa fa-share', 'fa fa-expand', 'fa fa-compress', 'fa fa-plus', 'fa fa-minus', 'fa fa-asterisk', 'fa fa-exclamation-circle', 'fa fa-gift', 'fa fa-leaf', 'fa fa-fire', 'fa fa-eye', 'fa fa-eye-slash', 'fa fa-exclamation-triangle', 'fa fa-plane', 'fa fa-calendar', 'fa fa-random', 'fa fa-comment', 'fa fa-magnet', 'fa fa-chevron-up', 'fa fa-chevron-down', 'fa fa-retweet', 'fa fa-shopping-cart', 'fa fa-folder', 'fa fa-folder-open', 'fa fa-arrows-v', 'fa fa-arrows-h', 'fa fa-bar-chart', 'fa fa-twitter-square', 'fa fa-facebook-square', 'fa fa-camera-retro', 'fa fa-key', 'fa fa-cogs', 'fa fa-comments', 'fa fa-thumbs-o-up', 'fa fa-thumbs-o-down', 'fa fa-star-half', 'fa fa-heart-o', 'fa fa-sign-out', 'fa fa-linkedin-square', 'fa fa-thumb-tack', 'fa fa-external-link', 'fa fa-sign-in', 'fa fa-trophy', 'fa fa-github-square', 'fa fa-upload', 'fa fa-lemon-o', 'fa fa-phone', 'fa fa-square-o', 'fa fa-bookmark-o', 'fa fa-phone-square', 'fa fa-twitter', 'fa fa-facebook', 'fa fa-github', 'fa fa-unlock', 'fa fa-credit-card', 'fa fa-rss', 'fa fa-hdd-o', 'fa fa-bullhorn', 'fa fa-bell', 'fa fa-certificate', 'fa fa-hand-o-right', 'fa fa-hand-o-left', 'fa fa-hand-o-up', 'fa fa-hand-o-down', 'fa fa-arrow-circle-left', 'fa fa-arrow-circle-right', 'fa fa-arrow-circle-up', 'fa fa-arrow-circle-down', 'fa fa-globe', 'fa fa-wrench', 'fa fa-tasks', 'fa fa-filter', 'fa fa-briefcase', 'fa fa-arrows-alt', 'fa fa-users', 'fa fa-link', 'fa fa-cloud', 'fa fa-flask', 'fa fa-scissors', 'fa fa-files-o', 'fa fa-paperclip', 'fa fa-floppy-o', 'fa fa-square', 'fa fa-bars', 'fa fa-list-ul', 'fa fa-list-ol', 'fa fa-strikethrough', 'fa fa-underline', 'fa fa-table', 'fa fa-magic', 'fa fa-truck', 'fa fa-pinterest', 'fa fa-pinterest-square', 'fa fa-google-plus-square', 'fa fa-google-plus', 'fa fa-money', 'fa fa-caret-down', 'fa fa-caret-up', 'fa fa-caret-left', 'fa fa-caret-right', 'fa fa-columns', 'fa fa-sort', 'fa fa-sort-desc', 'fa fa-sort-asc', 'fa fa-envelope', 'fa fa-linkedin', 'fa fa-undo', 'fa fa-gavel', 'fa fa-tachometer', 'fa fa-comment-o', 'fa fa-comments-o', 'fa fa-bolt', 'fa fa-sitemap', 'fa fa-umbrella', 'fa fa-clipboard', 'fa fa-lightbulb-o', 'fa fa-exchange', 'fa fa-cloud-download', 'fa fa-cloud-upload', 'fa fa-user-md', 'fa fa-stethoscope', 'fa fa-suitcase', 'fa fa-bell-o', 'fa fa-coffee', 'fa fa-cutlery', 'fa fa-file-text-o', 'fa fa-building-o', 'fa fa-hospital-o', 'fa fa-ambulance', 'fa fa-medkit', 'fa fa-fighter-jet', 'fa fa-beer', 'fa fa-h-square', 'fa fa-plus-square', 'fa fa-angle-double-left', 'fa fa-angle-double-right', 'fa fa-angle-double-up', 'fa fa-angle-double-down', 'fa fa-angle-left', 'fa fa-angle-right', 'fa fa-angle-up', 'fa fa-angle-down', 'fa fa-desktop', 'fa fa-laptop', 'fa fa-tablet', 'fa fa-mobile', 'fa fa-circle-o', 'fa fa-quote-left', 'fa fa-quote-right', 'fa fa-spinner', 'fa fa-circle', 'fa fa-reply', 'fa fa-github-alt', 'fa fa-folder-o', 'fa fa-folder-open-o', 'fa fa-smile-o', 'fa fa-frown-o', 'fa fa-meh-o', 'fa fa-gamepad', 'fa fa-keyboard-o', 'fa fa-flag-o', 'fa fa-flag-checkered', 'fa fa-terminal', 'fa fa-code', 'fa fa-reply-all', 'fa fa-star-half-o', 'fa fa-location-arrow', 'fa fa-crop', 'fa fa-code-fork', 'fa fa-chain-broken', 'fa fa-question', 'fa fa-info', 'fa fa-exclamation', 'fa fa-superscript', 'fa fa-subscript', 'fa fa-eraser', 'fa fa-puzzle-piece', 'fa fa-microphone', 'fa fa-microphone-slash', 'fa fa-shield', 'fa fa-calendar-o', 'fa fa-fire-extinguisher', 'fa fa-rocket', 'fa fa-maxcdn', 'fa fa-chevron-circle-left', 'fa fa-chevron-circle-right', 'fa fa-chevron-circle-up', 'fa fa-chevron-circle-down', 'fa fa-html5', 'fa fa-css3', 'fa fa-anchor', 'fa fa-unlock-alt', 'fa fa-bullseye', 'fa fa-ellipsis-h', 'fa fa-ellipsis-v', 'fa fa-rss-square', 'fa fa-play-circle', 'fa fa-ticket', 'fa fa-minus-square', 'fa fa-minus-square-o', 'fa fa-level-up', 'fa fa-level-down', 'fa fa-check-square', 'fa fa-pencil-square', 'fa fa-external-link-square', 'fa fa-share-square', 'fa fa-compass', 'fa fa-caret-square-o-down', 'fa fa-caret-square-o-up', 'fa fa-caret-square-o-right', 'fa fa-eur', 'fa fa-gbp', 'fa fa-usd', 'fa fa-inr', 'fa fa-jpy', 'fa fa-rub', 'fa fa-krw', 'fa fa-btc', 'fa fa-file', 'fa fa-file-text', 'fa fa-sort-alpha-asc', 'fa fa-sort-alpha-desc', 'fa fa-sort-amount-asc', 'fa fa-sort-amount-desc', 'fa fa-sort-numeric-asc', 'fa fa-sort-numeric-desc', 'fa fa-thumbs-up', 'fa fa-thumbs-down', 'fa fa-youtube-square', 'fa fa-youtube', 'fa fa-xing', 'fa fa-xing-square', 'fa fa-youtube-play', 'fa fa-dropbox', 'fa fa-stack-overflow', 'fa fa-instagram', 'fa fa-flickr', 'fa fa-adn', 'fa fa-bitbucket', 'fa fa-bitbucket-square', 'fa fa-tumblr', 'fa fa-tumblr-square', 'fa fa-long-arrow-down', 'fa fa-long-arrow-up', 'fa fa-long-arrow-left', 'fa fa-long-arrow-right', 'fa fa-apple', 'fa fa-windows', 'fa fa-android', 'fa fa-linux', 'fa fa-dribbble', 'fa fa-skype', 'fa fa-foursquare', 'fa fa-trello', 'fa fa-female', 'fa fa-male', 'fa fa-gratipay', 'fa fa-sun-o', 'fa fa-moon-o', 'fa fa-archive', 'fa fa-bug', 'fa fa-vk', 'fa fa-weibo', 'fa fa-renren', 'fa fa-pagelines', 'fa fa-stack-exchange', 'fa fa-arrow-circle-o-right', 'fa fa-arrow-circle-o-left', 'fa fa-caret-square-o-left', 'fa fa-dot-circle-o', 'fa fa-wheelchair', 'fa fa-vimeo-square', 'fa fa-try', 'fa fa-plus-square-o', 'fa fa-space-shuttle', 'fa fa-slack', 'fa fa-envelope-square', 'fa fa-wordpress', 'fa fa-openid', 'fa fa-university', 'fa fa-graduation-cap', 'fa fa-yahoo', 'fa fa-google', 'fa fa-reddit', 'fa fa-reddit-square', 'fa fa-stumbleupon-circle', 'fa fa-stumbleupon', 'fa fa-delicious', 'fa fa-digg', 'fa fa-pied-piper', 'fa fa-pied-piper-alt', 'fa fa-drupal', 'fa fa-joomla', 'fa fa-language', 'fa fa-fax', 'fa fa-building', 'fa fa-child', 'fa fa-paw', 'fa fa-spoon', 'fa fa-cube', 'fa fa-cubes', 'fa fa-behance', 'fa fa-behance-square', 'fa fa-steam', 'fa fa-steam-square', 'fa fa-recycle', 'fa fa-car', 'fa fa-taxi', 'fa fa-tree', 'fa fa-spotify', 'fa fa-deviantart', 'fa fa-soundcloud', 'fa fa-database', 'fa fa-file-pdf-o', 'fa fa-file-word-o', 'fa fa-file-excel-o', 'fa fa-file-powerpoint-o', 'fa fa-file-image-o', 'fa fa-file-archive-o', 'fa fa-file-audio-o', 'fa fa-file-video-o', 'fa fa-file-code-o', 'fa fa-vine', 'fa fa-codepen', 'fa fa-jsfiddle', 'fa fa-life-ring', 'fa fa-circle-o-notch', 'fa fa-rebel', 'fa fa-empire', 'fa fa-git-square', 'fa fa-git', 'fa fa-hacker-news', 'fa fa-tencent-weibo', 'fa fa-qq', 'fa fa-weixin', 'fa fa-paper-plane', 'fa fa-paper-plane-o', 'fa fa-history', 'fa fa-circle-thin', 'fa fa-header', 'fa fa-paragraph', 'fa fa-sliders', 'fa fa-share-alt', 'fa fa-share-alt-square', 'fa fa-bomb', 'fa fa-futbol-o', 'fa fa-tty', 'fa fa-binoculars', 'fa fa-plug', 'fa fa-slideshare', 'fa fa-twitch', 'fa fa-yelp', 'fa fa-newspaper-o', 'fa fa-wifi', 'fa fa-calculator', 'fa fa-paypal', 'fa fa-google-wallet', 'fa fa-cc-visa', 'fa fa-cc-mastercard', 'fa fa-cc-discover', 'fa fa-cc-amex', 'fa fa-cc-paypal', 'fa fa-cc-stripe', 'fa fa-bell-slash', 'fa fa-bell-slash-o', 'fa fa-trash', 'fa fa-copyright', 'fa fa-at', 'fa fa-eyedropper', 'fa fa-paint-brush', 'fa fa-birthday-cake', 'fa fa-area-chart', 'fa fa-pie-chart', 'fa fa-line-chart', 'fa fa-lastfm', 'fa fa-lastfm-square', 'fa fa-toggle-off', 'fa fa-toggle-on', 'fa fa-bicycle', 'fa fa-bus', 'fa fa-ioxhost', 'fa fa-angellist', 'fa fa-cc', 'fa fa-ils', 'fa fa-meanpath', 'fa fa-buysellads', 'fa fa-connectdevelop', 'fa fa-dashcube', 'fa fa-forumbee', 'fa fa-leanpub', 'fa fa-sellsy', 'fa fa-shirtsinbulk', 'fa fa-simplybuilt', 'fa fa-skyatlas', 'fa fa-cart-plus', 'fa fa-cart-arrow-down', 'fa fa-diamond', 'fa fa-ship', 'fa fa-user-secret', 'fa fa-motorcycle', 'fa fa-street-view', 'fa fa-heartbeat', 'fa fa-venus', 'fa fa-mars', 'fa fa-mercury', 'fa fa-transgender', 'fa fa-transgender-alt', 'fa fa-venus-double', 'fa fa-mars-double', 'fa fa-venus-mars', 'fa fa-mars-stroke', 'fa fa-mars-stroke-v', 'fa fa-mars-stroke-h', 'fa fa-neuter', 'fa fa-genderless', 'fa fa-facebook-official', 'fa fa-pinterest-p', 'fa fa-whatsapp', 'fa fa-server', 'fa fa-user-plus', 'fa fa-user-times', 'fa fa-bed', 'fa fa-viacoin', 'fa fa-train', 'fa fa-subway', 'fa fa-medium', 'fa fa-y-combinator', 'fa fa-optin-monster', 'fa fa-opencart', 'fa fa-expeditedssl', 'fa fa-battery-full', 'fa fa-battery-three-quarters', 'fa fa-battery-half', 'fa fa-battery-quarter', 'fa fa-battery-empty', 'fa fa-mouse-pointer', 'fa fa-i-cursor', 'fa fa-object-group', 'fa fa-object-ungroup', 'fa fa-sticky-note', 'fa fa-sticky-note-o', 'fa fa-cc-jcb', 'fa fa-cc-diners-club', 'fa fa-clone', 'fa fa-balance-scale', 'fa fa-hourglass-o', 'fa fa-hourglass-start', 'fa fa-hourglass-half', 'fa fa-hourglass-end', 'fa fa-hourglass', 'fa fa-hand-rock-o', 'fa fa-hand-paper-o', 'fa fa-hand-scissors-o', 'fa fa-hand-lizard-o', 'fa fa-hand-spock-o', 'fa fa-hand-pointer-o', 'fa fa-hand-peace-o', 'fa fa-trademark', 'fa fa-registered', 'fa fa-creative-commons', 'fa fa-gg', 'fa fa-gg-circle', 'fa fa-tripadvisor', 'fa fa-odnoklassniki', 'fa fa-odnoklassniki-square', 'fa fa-get-pocket', 'fa fa-wikipedia-w', 'fa fa-safari', 'fa fa-chrome', 'fa fa-firefox', 'fa fa-opera', 'fa fa-internet-explorer', 'fa fa-television', 'fa fa-contao', 'fa fa-500px', 'fa fa-amazon', 'fa fa-calendar-plus-o', 'fa fa-calendar-minus-o', 'fa fa-calendar-times-o', 'fa fa-calendar-check-o', 'fa fa-industry', 'fa fa-map-pin', 'fa fa-map-signs', 'fa fa-map-o', 'fa fa-map', 'fa fa-commenting', 'fa fa-commenting-o', 'fa fa-houzz', 'fa fa-vimeo', 'fa fa-black-tie', 'fa fa-fonticons', 'fa fa-500px', 'fa fa-amazon', 'fa fa-balance-scale', 'fa fa-battery-0', 'fa fa-battery-1', 'fa fa-battery-2', 'fa fa-battery-3', 'fa fa-battery-4', 'fa fa-battery-empty', 'fa fa-battery-full', 'fa fa-battery-half', 'fa fa-battery-quarter', 'fa fa-battery-three-quarters', 'fa fa-black-tie', 'fa fa-calendar-check-o', 'fa fa-calendar-minus-o', 'fa fa-calendar-plus-o', 'fa fa-calendar-times-o', 'fa fa-cc-diners-club', 'fa fa-cc-jcb', 'fa fa-chrome', 'fa fa-clone', 'fa fa-commenting', 'fa fa-commenting-o', 'fa fa-contao', 'fa fa-creative-commons', 'fa fa-expeditedssl', 'fa fa-firefox', 'fa fa-fonticons', 'fa fa-genderless', 'fa fa-get-pocket', 'fa fa-gg', 'fa fa-gg-circle', 'fa fa-hand-grab-o', 'fa fa-hand-lizard-o', 'fa fa-hand-paper-o', 'fa fa-hand-peace-o', 'fa fa-hand-pointer-o', 'fa fa-hand-rock-o', 'fa fa-hand-scissors-o', 'fa fa-hand-spock-o', 'fa fa-hand-stop-o', 'fa fa-hourglass', 'fa fa-hourglass-1', 'fa fa-hourglass-2', 'fa fa-hourglass-3', 'fa fa-hourglass-end', 'fa fa-hourglass-half', 'fa fa-hourglass-o', 'fa fa-hourglass-start', 'fa fa-houzz', 'fa fa-i-cursor', 'fa fa-industry', 'fa fa-internet-explorer', 'fa fa-map', 'fa fa-map-o', 'fa fa-map-pin', 'fa fa-map-signs', 'fa fa-mouse-pointer', 'fa fa-object-group', 'fa fa-object-ungroup', 'fa fa-odnoklassniki', 'fa fa-odnoklassniki-square', 'fa fa-opencart', 'fa fa-opera', 'fa fa-optin-monster', 'fa fa-registered', 'fa fa-safari', 'fa fa-sticky-note', 'fa fa-sticky-note-o', 'fa fa-television', 'fa fa-trademark', 'fa fa-tripadvisor', 'fa fa-tv', 'fa fa-vimeo', 'fa fa-wikipedia-w', 'fa fa-y-combinator', 'fa fa-yc', 'fa fa-adjust', 'fa fa-anchor', 'fa fa-archive', 'fa fa-area-chart', 'fa fa-arrows', 'fa fa-arrows-h', 'fa fa-arrows-v', 'fa fa-asterisk', 'fa fa-at', 'fa fa-automobile', 'fa fa-balance-scale', 'fa fa-ban', 'fa fa-bank', 'fa fa-bar-chart', 'fa fa-bar-chart-o', 'fa fa-barcode', 'fa fa-bars', 'fa fa-battery-0', 'fa fa-battery-1', 'fa fa-battery-2', 'fa fa-battery-3', 'fa fa-battery-4', 'fa fa-battery-empty', 'fa fa-battery-full', 'fa fa-battery-half', 'fa fa-battery-quarter', 'fa fa-battery-three-quarters', 'fa fa-bed', 'fa fa-beer', 'fa fa-bell', 'fa fa-bell-o', 'fa fa-bell-slash', 'fa fa-bell-slash-o', 'fa fa-bicycle', 'fa fa-binoculars', 'fa fa-birthday-cake', 'fa fa-bolt', 'fa fa-bomb', 'fa fa-book', 'fa fa-bookmark', 'fa fa-bookmark-o', 'fa fa-briefcase', 'fa fa-bug', 'fa fa-building', 'fa fa-building-o', 'fa fa-bullhorn', 'fa fa-bullseye', 'fa fa-bus', 'fa fa-cab', 'fa fa-calculator', 'fa fa-calendar', 'fa fa-calendar-check-o', 'fa fa-calendar-minus-o', 'fa fa-calendar-o', 'fa fa-calendar-plus-o', 'fa fa-calendar-times-o', 'fa fa-camera', 'fa fa-camera-retro', 'fa fa-car', 'fa fa-caret-square-o-down', 'fa fa-caret-square-o-left', 'fa fa-caret-square-o-right', 'fa fa-caret-square-o-up', 'fa fa-cart-arrow-down', 'fa fa-cart-plus', 'fa fa-cc', 'fa fa-certificate', 'fa fa-check', 'fa fa-check-circle', 'fa fa-check-circle-o', 'fa fa-check-square', 'fa fa-check-square-o', 'fa fa-child', 'fa fa-circle', 'fa fa-circle-o', 'fa fa-circle-o-notch', 'fa fa-circle-thin', 'fa fa-clock-o', 'fa fa-clone', 'fa fa-close', 'fa fa-cloud', 'fa fa-cloud-download', 'fa fa-cloud-upload', 'fa fa-code', 'fa fa-code-fork', 'fa fa-coffee', 'fa fa-cog', 'fa fa-cogs', 'fa fa-comment', 'fa fa-comment-o', 'fa fa-commenting', 'fa fa-commenting-o', 'fa fa-comments', 'fa fa-comments-o', 'fa fa-compass', 'fa fa-copyright', 'fa fa-creative-commons', 'fa fa-credit-card', 'fa fa-crop', 'fa fa-crosshairs', 'fa fa-cube', 'fa fa-cubes', 'fa fa-cutlery', 'fa fa-dashboard', 'fa fa-database', 'fa fa-desktop', 'fa fa-diamond', 'fa fa-dot-circle-o', 'fa fa-download', 'fa fa-edit', 'fa fa-ellipsis-h', 'fa fa-ellipsis-v', 'fa fa-envelope', 'fa fa-envelope-o', 'fa fa-envelope-square', 'fa fa-eraser', 'fa fa-exchange', 'fa fa-exclamation', 'fa fa-exclamation-circle', 'fa fa-exclamation-triangle', 'fa fa-external-link', 'fa fa-external-link-square', 'fa fa-eye', 'fa fa-eye-slash', 'fa fa-eyedropper', 'fa fa-fax', 'fa fa-feed', 'fa fa-female', 'fa fa-fighter-jet', 'fa fa-file-archive-o', 'fa fa-file-audio-o', 'fa fa-file-code-o', 'fa fa-file-excel-o', 'fa fa-file-image-o', 'fa fa-file-movie-o', 'fa fa-file-pdf-o', 'fa fa-file-photo-o', 'fa fa-file-picture-o', 'fa fa-file-powerpoint-o', 'fa fa-file-sound-o', 'fa fa-file-video-o', 'fa fa-file-word-o', 'fa fa-file-zip-o', 'fa fa-film', 'fa fa-filter', 'fa fa-fire', 'fa fa-fire-extinguisher', 'fa fa-flag', 'fa fa-flag-checkered', 'fa fa-flag-o', 'fa fa-flash', 'fa fa-flask', 'fa fa-folder', 'fa fa-folder-o', 'fa fa-folder-open', 'fa fa-folder-open-o', 'fa fa-frown-o', 'fa fa-futbol-o', 'fa fa-gamepad', 'fa fa-gavel', 'fa fa-gear', 'fa fa-gears', 'fa fa-gift', 'fa fa-glass', 'fa fa-globe', 'fa fa-graduation-cap', 'fa fa-group', 'fa fa-hand-grab-o', 'fa fa-hand-lizard-o', 'fa fa-hand-paper-o', 'fa fa-hand-peace-o', 'fa fa-hand-pointer-o', 'fa fa-hand-rock-o', 'fa fa-hand-scissors-o', 'fa fa-hand-spock-o', 'fa fa-hand-stop-o', 'fa fa-hdd-o', 'fa fa-headphones', 'fa fa-heart', 'fa fa-heart-o', 'fa fa-heartbeat', 'fa fa-history', 'fa fa-home', 'fa fa-hotel', 'fa fa-hourglass', 'fa fa-hourglass-1', 'fa fa-hourglass-2', 'fa fa-hourglass-3', 'fa fa-hourglass-end', 'fa fa-hourglass-half', 'fa fa-hourglass-o', 'fa fa-hourglass-start', 'fa fa-i-cursor', 'fa fa-image', 'fa fa-inbox', 'fa fa-industry', 'fa fa-info', 'fa fa-info-circle', 'fa fa-institution', 'fa fa-key', 'fa fa-keyboard-o', 'fa fa-language', 'fa fa-laptop', 'fa fa-leaf', 'fa fa-legal', 'fa fa-lemon-o', 'fa fa-level-down', 'fa fa-level-up', 'fa fa-life-bouy', 'fa fa-life-buoy', 'fa fa-life-ring', 'fa fa-life-saver', 'fa fa-lightbulb-o', 'fa fa-line-chart', 'fa fa-location-arrow', 'fa fa-lock', 'fa fa-magic', 'fa fa-magnet', 'fa fa-mail-forward', 'fa fa-mail-reply', 'fa fa-mail-reply-all', 'fa fa-male', 'fa fa-map', 'fa fa-map-marker', 'fa fa-map-o', 'fa fa-map-pin', 'fa fa-map-signs', 'fa fa-meh-o', 'fa fa-microphone', 'fa fa-microphone-slash', 'fa fa-minus', 'fa fa-minus-circle', 'fa fa-minus-square', 'fa fa-minus-square-o', 'fa fa-mobile', 'fa fa-mobile-phone', 'fa fa-money', 'fa fa-moon-o', 'fa fa-mortar-board', 'fa fa-motorcycle', 'fa fa-mouse-pointer', 'fa fa-music', 'fa fa-navicon', 'fa fa-newspaper-o', 'fa fa-object-group', 'fa fa-object-ungroup', 'fa fa-paint-brush', 'fa fa-paper-plane', 'fa fa-paper-plane-o', 'fa fa-paw', 'fa fa-pencil', 'fa fa-pencil-square', 'fa fa-pencil-square-o', 'fa fa-phone', 'fa fa-phone-square', 'fa fa-photo', 'fa fa-picture-o', 'fa fa-pie-chart', 'fa fa-plane', 'fa fa-plug', 'fa fa-plus', 'fa fa-plus-circle', 'fa fa-plus-square', 'fa fa-plus-square-o', 'fa fa-power-off', 'fa fa-print', 'fa fa-puzzle-piece', 'fa fa-qrcode', 'fa fa-question', 'fa fa-question-circle', 'fa fa-quote-left', 'fa fa-quote-right', 'fa fa-random', 'fa fa-recycle', 'fa fa-refresh', 'fa fa-registered', 'fa fa-remove', 'fa fa-reorder', 'fa fa-reply', 'fa fa-reply-all', 'fa fa-retweet', 'fa fa-road', 'fa fa-rocket', 'fa fa-rss', 'fa fa-rss-square', 'fa fa-search', 'fa fa-search-minus', 'fa fa-search-plus', 'fa fa-send', 'fa fa-send-o', 'fa fa-server', 'fa fa-share', 'fa fa-share-alt', 'fa fa-share-alt-square', 'fa fa-share-square', 'fa fa-share-square-o', 'fa fa-shield', 'fa fa-ship', 'fa fa-shopping-cart', 'fa fa-sign-in', 'fa fa-sign-out', 'fa fa-signal', 'fa fa-sitemap', 'fa fa-sliders', 'fa fa-smile-o', 'fa fa-soccer-ball-o', 'fa fa-sort', 'fa fa-sort-alpha-asc', 'fa fa-sort-alpha-desc', 'fa fa-sort-amount-asc', 'fa fa-sort-amount-desc', 'fa fa-sort-asc', 'fa fa-sort-desc', 'fa fa-sort-down', 'fa fa-sort-numeric-asc', 'fa fa-sort-numeric-desc', 'fa fa-sort-up', 'fa fa-space-shuttle', 'fa fa-spinner', 'fa fa-spoon', 'fa fa-square', 'fa fa-square-o', 'fa fa-star', 'fa fa-star-half', 'fa fa-star-half-empty', 'fa fa-star-half-full', 'fa fa-star-half-o', 'fa fa-star-o', 'fa fa-sticky-note', 'fa fa-sticky-note-o', 'fa fa-street-view', 'fa fa-suitcase', 'fa fa-sun-o', 'fa fa-support', 'fa fa-tablet', 'fa fa-tachometer', 'fa fa-tag', 'fa fa-tags', 'fa fa-tasks', 'fa fa-taxi', 'fa fa-television', 'fa fa-terminal', 'fa fa-thumb-tack', 'fa fa-thumbs-down', 'fa fa-thumbs-o-down', 'fa fa-thumbs-o-up', 'fa fa-thumbs-up', 'fa fa-ticket', 'fa fa-times', 'fa fa-times-circle', 'fa fa-times-circle-o', 'fa fa-tint', 'fa fa-toggle-down', 'fa fa-toggle-left', 'fa fa-toggle-off', 'fa fa-toggle-on', 'fa fa-toggle-right', 'fa fa-toggle-up', 'fa fa-trademark', 'fa fa-trash', 'fa fa-trash-o', 'fa fa-tree', 'fa fa-trophy', 'fa fa-truck', 'fa fa-tty', 'fa fa-tv', 'fa fa-umbrella', 'fa fa-university', 'fa fa-unlock', 'fa fa-unlock-alt', 'fa fa-unsorted', 'fa fa-upload', 'fa fa-user', 'fa fa-user-plus', 'fa fa-user-secret', 'fa fa-user-times', 'fa fa-users', 'fa fa-video-camera', 'fa fa-volume-down', 'fa fa-volume-off', 'fa fa-volume-up', 'fa fa-warning', 'fa fa-wheelchair', 'fa fa-wifi', 'fa fa-wrench', 'fa fa-hand-grab-o', 'fa fa-hand-lizard-o', 'fa fa-hand-o-down', 'fa fa-hand-o-left', 'fa fa-hand-o-right', 'fa fa-hand-o-up', 'fa fa-hand-paper-o', 'fa fa-hand-peace-o', 'fa fa-hand-pointer-o', 'fa fa-hand-rock-o', 'fa fa-hand-scissors-o', 'fa fa-hand-spock-o', 'fa fa-hand-stop-o', 'fa fa-thumbs-down', 'fa fa-thumbs-o-down', 'fa fa-thumbs-o-up', 'fa fa-thumbs-up', 'fa fa-ambulance', 'fa fa-automobile', 'fa fa-bicycle', 'fa fa-bus', 'fa fa-cab', 'fa fa-car', 'fa fa-fighter-jet', 'fa fa-motorcycle', 'fa fa-plane', 'fa fa-rocket', 'fa fa-ship', 'fa fa-space-shuttle', 'fa fa-subway', 'fa fa-taxi', 'fa fa-train', 'fa fa-truck', 'fa fa-wheelchair', 'fa fa-genderless', 'fa fa-intersex', 'fa fa-mars', 'fa fa-mars-double', 'fa fa-mars-stroke', 'fa fa-mars-stroke-h', 'fa fa-mars-stroke-v', 'fa fa-mercury', 'fa fa-neuter', 'fa fa-transgender', 'fa fa-transgender-alt', 'fa fa-venus', 'fa fa-venus-double', 'fa fa-venus-mars', 'fa fa-file', 'fa fa-file-archive-o', 'fa fa-file-audio-o', 'fa fa-file-code-o', 'fa fa-file-excel-o', 'fa fa-file-image-o', 'fa fa-file-movie-o', 'fa fa-file-o', 'fa fa-file-pdf-o', 'fa fa-file-photo-o', 'fa fa-file-picture-o', 'fa fa-file-powerpoint-o', 'fa fa-file-sound-o', 'fa fa-file-text', 'fa fa-file-text-o', 'fa fa-file-video-o', 'fa fa-file-word-o', 'fa fa-file-zip-o', 'fa fa-circle-o-notch', 'fa fa-cog', 'fa fa-gear', 'fa fa-refresh', 'fa fa-spinner', 'fa fa-check-square', 'fa fa-check-square-o', 'fa fa-circle', 'fa fa-circle-o', 'fa fa-dot-circle-o', 'fa fa-minus-square', 'fa fa-minus-square-o', 'fa fa-plus-square', 'fa fa-plus-square-o', 'fa fa-square', 'fa fa-square-o', 'fa fa-cc-amex', 'fa fa-cc-diners-club', 'fa fa-cc-discover', 'fa fa-cc-jcb', 'fa fa-cc-mastercard', 'fa fa-cc-paypal', 'fa fa-cc-stripe', 'fa fa-cc-visa', 'fa fa-credit-card', 'fa fa-google-wallet', 'fa fa-paypal', 'fa fa-area-chart', 'fa fa-bar-chart', 'fa fa-bar-chart-o', 'fa fa-line-chart', 'fa fa-pie-chart', 'fa fa-bitcoin', 'fa fa-btc', 'fa fa-cny', 'fa fa-dollar', 'fa fa-eur', 'fa fa-euro', 'fa fa-gbp', 'fa fa-gg', 'fa fa-gg-circle', 'fa fa-ils', 'fa fa-inr', 'fa fa-jpy', 'fa fa-krw', 'fa fa-money', 'fa fa-rmb', 'fa fa-rouble', 'fa fa-rub', 'fa fa-ruble', 'fa fa-rupee', 'fa fa-shekel', 'fa fa-sheqel', 'fa fa-try', 'fa fa-turkish-lira', 'fa fa-usd', 'fa fa-won', 'fa fa-yen', 'fa fa-align-center', 'fa fa-align-justify', 'fa fa-align-left', 'fa fa-align-right', 'fa fa-bold', 'fa fa-chain', 'fa fa-chain-broken', 'fa fa-clipboard', 'fa fa-columns', 'fa fa-copy', 'fa fa-cut', 'fa fa-dedent', 'fa fa-eraser', 'fa fa-file', 'fa fa-file-o', 'fa fa-file-text', 'fa fa-file-text-o', 'fa fa-files-o', 'fa fa-floppy-o', 'fa fa-font', 'fa fa-header', 'fa fa-indent', 'fa fa-italic', 'fa fa-link', 'fa fa-list', 'fa fa-list-alt', 'fa fa-list-ol', 'fa fa-list-ul', 'fa fa-outdent', 'fa fa-paperclip', 'fa fa-paragraph', 'fa fa-paste', 'fa fa-repeat', 'fa fa-rotate-left', 'fa fa-rotate-right', 'fa fa-save', 'fa fa-scissors', 'fa fa-strikethrough', 'fa fa-subscript', 'fa fa-superscript', 'fa fa-table', 'fa fa-text-height', 'fa fa-text-width', 'fa fa-th', 'fa fa-th-large', 'fa fa-th-list', 'fa fa-underline', 'fa fa-undo', 'fa fa-unlink', 'fa fa-angle-double-down', 'fa fa-angle-double-left', 'fa fa-angle-double-right', 'fa fa-angle-double-up', 'fa fa-angle-down', 'fa fa-angle-left', 'fa fa-angle-right', 'fa fa-angle-up', 'fa fa-arrow-circle-down', 'fa fa-arrow-circle-left', 'fa fa-arrow-circle-o-down', 'fa fa-arrow-circle-o-left', 'fa fa-arrow-circle-o-right', 'fa fa-arrow-circle-o-up', 'fa fa-arrow-circle-right', 'fa fa-arrow-circle-up', 'fa fa-arrow-down', 'fa fa-arrow-left', 'fa fa-arrow-right', 'fa fa-arrow-up', 'fa fa-arrows', 'fa fa-arrows-alt', 'fa fa-arrows-h', 'fa fa-arrows-v', 'fa fa-caret-down', 'fa fa-caret-left', 'fa fa-caret-right', 'fa fa-caret-square-o-down', 'fa fa-caret-square-o-left', 'fa fa-caret-square-o-right', 'fa fa-caret-square-o-up', 'fa fa-caret-up', 'fa fa-chevron-circle-down', 'fa fa-chevron-circle-left', 'fa fa-chevron-circle-right', 'fa fa-chevron-circle-up', 'fa fa-chevron-down', 'fa fa-chevron-left', 'fa fa-chevron-right', 'fa fa-chevron-up', 'fa fa-exchange', 'fa fa-hand-o-down', 'fa fa-hand-o-left', 'fa fa-hand-o-right', 'fa fa-hand-o-up', 'fa fa-long-arrow-down', 'fa fa-long-arrow-left', 'fa fa-long-arrow-right', 'fa fa-long-arrow-up', 'fa fa-toggle-down', 'fa fa-toggle-left', 'fa fa-toggle-right', 'fa fa-toggle-up', 'fa fa-arrows-alt', 'fa fa-backward', 'fa fa-compress', 'fa fa-eject', 'fa fa-expand', 'fa fa-fast-backward', 'fa fa-fast-forward', 'fa fa-forward', 'fa fa-pause', 'fa fa-play', 'fa fa-play-circle', 'fa fa-play-circle-o', 'fa fa-random', 'fa fa-step-backward', 'fa fa-step-forward', 'fa fa-stop', 'fa fa-youtube-play', 'fa fa-500px', 'fa fa-adn', 'fa fa-amazon', 'fa fa-android', 'fa fa-angellist', 'fa fa-apple', 'fa fa-behance', 'fa fa-behance-square', 'fa fa-bitbucket', 'fa fa-bitbucket-square', 'fa fa-bitcoin', 'fa fa-black-tie', 'fa fa-btc', 'fa fa-buysellads', 'fa fa-cc-amex', 'fa fa-cc-diners-club', 'fa fa-cc-discover', 'fa fa-cc-jcb', 'fa fa-cc-mastercard', 'fa fa-cc-paypal', 'fa fa-cc-stripe', 'fa fa-cc-visa', 'fa fa-chrome', 'fa fa-codepen', 'fa fa-connectdevelop', 'fa fa-contao', 'fa fa-css3', 'fa fa-dashcube', 'fa fa-delicious', 'fa fa-deviantart', 'fa fa-digg', 'fa fa-dribbble', 'fa fa-dropbox', 'fa fa-drupal', 'fa fa-empire', 'fa fa-expeditedssl', 'fa fa-facebook', 'fa fa-facebook-f', 'fa fa-facebook-official', 'fa fa-facebook-square', 'fa fa-firefox', 'fa fa-flickr', 'fa fa-fonticons', 'fa fa-forumbee', 'fa fa-foursquare', 'fa fa-ge', 'fa fa-get-pocket', 'fa fa-gg', 'fa fa-gg-circle', 'fa fa-git', 'fa fa-git-square', 'fa fa-github', 'fa fa-github-alt', 'fa fa-github-square', 'fa fa-gittip', 'fa fa-google', 'fa fa-google-plus', 'fa fa-google-plus-square', 'fa fa-google-wallet', 'fa fa-gratipay', 'fa fa-hacker-news', 'fa fa-houzz', 'fa fa-html5', 'fa fa-instagram', 'fa fa-internet-explorer', 'fa fa-ioxhost', 'fa fa-joomla', 'fa fa-jsfiddle', 'fa fa-lastfm', 'fa fa-lastfm-square', 'fa fa-leanpub', 'fa fa-linkedin', 'fa fa-linkedin-square', 'fa fa-linux', 'fa fa-maxcdn', 'fa fa-meanpath', 'fa fa-medium', 'fa fa-odnoklassniki', 'fa fa-odnoklassniki-square', 'fa fa-opencart', 'fa fa-openid', 'fa fa-opera', 'fa fa-optin-monster', 'fa fa-pagelines', 'fa fa-paypal', 'fa fa-pied-piper', 'fa fa-pied-piper-alt', 'fa fa-pinterest', 'fa fa-pinterest-p', 'fa fa-pinterest-square', 'fa fa-qq', 'fa fa-ra', 'fa fa-rebel', 'fa fa-reddit', 'fa fa-reddit-square', 'fa fa-renren', 'fa fa-safari', 'fa fa-sellsy', 'fa fa-share-alt', 'fa fa-share-alt-square', 'fa fa-shirtsinbulk', 'fa fa-simplybuilt', 'fa fa-skyatlas', 'fa fa-skype', 'fa fa-slack', 'fa fa-slideshare', 'fa fa-soundcloud', 'fa fa-spotify', 'fa fa-stack-exchange', 'fa fa-stack-overflow', 'fa fa-steam', 'fa fa-steam-square', 'fa fa-stumbleupon', 'fa fa-stumbleupon-circle', 'fa fa-tencent-weibo', 'fa fa-trello', 'fa fa-tripadvisor', 'fa fa-tumblr', 'fa fa-tumblr-square', 'fa fa-twitch', 'fa fa-twitter', 'fa fa-twitter-square', 'fa fa-viacoin', 'fa fa-vimeo', 'fa fa-vimeo-square', 'fa fa-vine', 'fa fa-vk', 'fa fa-wechat', 'fa fa-weibo', 'fa fa-weixin', 'fa fa-whatsapp', 'fa fa-wikipedia-w', 'fa fa-windows', 'fa fa-wordpress', 'fa fa-xing', 'fa fa-xing-square', 'fa fa-y-combinator', 'fa fa-y-combinator-square', 'fa fa-yahoo', 'fa fa-yc', 'fa fa-yc-square', 'fa fa-yelp', 'fa fa-youtube', 'fa fa-youtube-play', 'fa fa-youtube-square', 'fa fa-ambulance', 'fa fa-h-square', 'fa fa-heart', 'fa fa-heart-o', 'fa fa-heartbeat', 'fa fa-hospital-o', 'fa fa-medkit', 'fa fa-plus-square', 'fa fa-stethoscope', 'fa fa-user-md', 'fa fa-wheelchair' )
				));
	}

	/**
	 * Animate.css animations
	 */
	public static function animations() {
		return apply_filters( 'perch/data/animations', array( 'flash', 'bounce', 'shake', 'tada', 'swing', 'wobble', 'pulse', 'flip', 'flipInX', 'flipOutX', 'flipInY', 'flipOutY', 'fadeIn', 'fadeInUp', 'fadeInDown', 'fadeInLeft', 'fadeInRight', 'fadeInUpBig', 'fadeInDownBig', 'fadeInLeftBig', 'fadeInRightBig', 'fadeOut', 'fadeOutUp', 'fadeOutDown', 'fadeOutLeft', 'fadeOutRight', 'fadeOutUpBig', 'fadeOutDownBig', 'fadeOutLeftBig', 'fadeOutRightBig', 'slideInDown', 'slideInLeft', 'slideInRight', 'slideOutUp', 'slideOutLeft', 'slideOutRight', 'bounceIn', 'bounceInDown', 'bounceInUp', 'bounceInLeft', 'bounceInRight', 'bounceOut', 'bounceOutDown', 'bounceOutUp', 'bounceOutLeft', 'bounceOutRight', 'rotateIn', 'rotateInDownLeft', 'rotateInDownRight', 'rotateInUpLeft', 'rotateInUpRight', 'rotateOut', 'rotateOutDownLeft', 'rotateOutDownRight', 'rotateOutUpLeft', 'rotateOutUpRight', 'lightSpeedIn', 'lightSpeedOut', 'hinge', 'rollIn', 'rollOut' ) );
	}

	/**
	 * Examples section
	 */
	public static function examples() {
		return apply_filters( 'perch/data/examples', array(
				'basic' => array(
					'title' => __( 'Basic examples', 'perch' ),
					'items' => array(
						array(
							'name' => __( 'Accordions, spoilers, different styles, anchors', 'perch' ),
							'id'   => 'spoilers',
							'code' => plugin_dir_path( TP_PLUGIN_FILE ) . '/inc/examples/spoilers.example',
							'icon' => 'tasks'
						),
						array(
							'name' => __( 'Tabs, vertical tabs, tab anchors', 'perch' ),
							'id'   => 'tabs',
							'code' => plugin_dir_path( TP_PLUGIN_FILE ) . '/inc/examples/tabs.example',
							'icon' => 'folder'
						),
						array(
							'name' => __( 'Column layouts', 'perch' ),
							'id'   => 'columns',
							'code' => plugin_dir_path( TP_PLUGIN_FILE ) . '/inc/examples/columns.example',
							'icon' => 'th-large'
						),
						array(
							'name' => __( 'Media elements, YouTube, Vimeo, Screenr and self-hosted videos, audio player', 'perch' ),
							'id'   => 'media',
							'code' => plugin_dir_path( TP_PLUGIN_FILE ) . '/inc/examples/media.example',
							'icon' => 'play-circle'
						),
						array(
							'name' => __( 'Unlimited buttons', 'perch' ),
							'id'   => 'buttons',
							'code' => plugin_dir_path( TP_PLUGIN_FILE ) . '/inc/examples/buttons.example',
							'icon' => 'heart'
						),
						array(
							'name' => __( 'Animations', 'perch' ),
							'id'   => 'animations',
							'code' => plugin_dir_path( TP_PLUGIN_FILE ) . '/inc/examples/animations.example',
							'icon' => 'bolt'
						),
					)
				),
				'advanced' => array(
					'title' => __( 'Advanced examples', 'perch' ),
					'items' => array(
						array(
							'name' => __( 'Interacting with posts shortcode', 'perch' ),
							'id' => 'posts',
							'code' => plugin_dir_path( TP_PLUGIN_FILE ) . '/inc/examples/posts.example',
							'icon' => 'list'
						),
						array(
							'name' => __( 'Nested shortcodes, shortcodes inside of attributes', 'perch' ),
							'id' => 'nested',
							'code' => plugin_dir_path( TP_PLUGIN_FILE ) . '/inc/examples/nested.example',
							'icon' => 'indent'
						),
					)
				),
			) );
	}

	/**
	 * Shortcodes
	 */
	public static function shortcodes( $shortcode = false ) {
		$shortcodes = apply_filters( 'perch/data/shortcodes', array(
				'video_gallery' => array(),
				'image_info' => array(
					'name' => __( 'Image Info', 'perch' ),
					'type' => 'wrap',
					'group' => 'schema',
					'atts' => array(
						'image' => array(
							'type' => 'upload',
							'default' => '',
							'name' => __( 'Image', 'perch' ),
							'desc' => __( '', 'perch' )
						),						
					),
					'content' => 'Now the world don\'t move to the beat of just one drum what might be right for you may not be right for some to explore strange new worlds to seek out new life and new civilizations to boldly go',
					'desc' => __( 'Image description', 'perch' ),
					'icon' => 'image'
				),
				// about_me
				'about_me' => array(
					'name' => __( 'About me', 'perch' ),
					'type' => 'wrap',
					'group' => 'schema',
					'atts' => array(
						'style' => array(
							'type' => 'select',
							'values' => array(
								'round' => __( 'Round image style', 'perch' ),
								'square' => __( 'Square image style', 'perch' ),
							),
							'default' => 'style1',
							'name' => __( 'Style', 'perch' ),
							'desc' => __( 'Choose style for About me', 'perch' ) 
						),
						'image' => array(
							'type' => 'upload',
							'default' => '',
							'name' => __( 'Client Image', 'perch' ),
							'desc' => __( '', 'perch' )
						),
						'width' => array(
							'type' => 'slider',
							'min' => 50,
							'max' => 500,
							'step' => 1,
							'default' => 275,
							'name' => __( 'Image width(maximum)', 'perch' ),
							'desc' => __( '', 'perch' ),
						),				
						'height' => array(
							'type' => 'slider',
							'min' => 50,
							'max' => 600,
							'step' => 1,
							'default' => 275,
							'name' => __( 'Image height(maximum)', 'perch' ),
							'desc' => __( '', 'perch' ),
						),
						'border' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Image Border', 'perch' ),
							'desc' => __( '', 'perch' )
						),
						'align' => array(
							'type' => 'select',
							'values' => array(
								'left' => __( 'Left', 'perch' ),
								'center' => __( 'Center', 'perch' ),
								'right' => __( 'Right', 'perch' )
							),
							'default' => 'center',
							'name' => __( 'Align', 'perch' ),
							'desc' => __( 'Content alignment', 'perch' )
						),
						'sign' => array(
							'type' => 'upload',
							'default' => '',
							'name' => __( 'Signature Image url', 'perch' ),
							'desc' => __( '', 'perch' )
						),
					),					
					'content' => __( 'Lorem ipsum dolor sit amet, consect etur adipisic ing elit', 'perch' ),
					'desc' => __( 'Styled heading', 'perch' ),
					'icon' => 'user'
				),	
				// image link
				'image_link' => array(
					'name' => __( 'Image Link', 'perch' ),
					'type' => 'single',
					'group' => 'schema',
					'atts' => array(
						'style' => array(
							'type' => 'select',
							'values' => array(
								'style1' => __( 'Default', 'perch' ),
								'style2' => __( 'Style 2', 'perch' ),
							),
							'default' => 'default',
							'name' => __( 'Style', 'perch' ),
							'desc' => __( 'Choose style for this heading', 'perch' ) 
						),						
						'image' => array(
							'type' => 'upload',
							'default' => '',
							'name' => __( 'Image', 'perch' ),
							'desc' => __( '', 'perch' )
						),
						'width' => array(
							'type' => 'slider',
							'min' => 50,
							'max' => 500,
							'step' => 1,
							'default' => 340,
							'name' => __( 'Image width(maximum)', 'perch' ),
							'desc' => __( '', 'perch' ),
							'operator' => 'and',
							'condition' => 'style:is(style1)'
						),				
						'height' => array(
							'type' => 'slider',
							'min' => 50,
							'max' => 600,
							'step' => 1,
							'default' => 287,
							'name' => __( 'Image height(maximum)', 'perch' ),
							'desc' => __( '', 'perch' ),
							'operator' => 'and',
							'condition' => 'style:is(style2)'
						),
						'title' => array(
							'name' => __( 'Title', 'perch' ),
							'default' => 'Sample title'
						),				
						'link' => array(
							'name' => __( 'Link', 'perch' ),
							'default' => '#'
						),
						'target' => array(
							'type' => 'select',
							'values' => array(
								'self'  => __( 'Open link in same window/tab', 'perch' ),
								'blank' => __( 'Open link in new window/tab', 'perch' )
							),
							'default' => 'self',
							'name' => __( 'Link target', 'perch' ),
						),
						'overlay' => array(
							'type' => 'select',
							'values' => array(
								'dark'  => __( 'Dark overlay', 'perch' ),
								'light' => __( 'Light overlay', 'perch' )
							),
							'default' => 'dark',
							'name' => __( 'Overlay', 'perch' ),
						),
					),	
									
					'content' => '',
					'desc' => '',
					'icon' => 'image'
				),
				// heading
				'heading' => array(
					'name' => __( 'Heading', 'perch' ),
					'type' => 'wrap',
					'group' => 'content',
					'atts' => array(
						'style' => array(
							'type' => 'select',
							'values' => array(
								'default' => __( 'Default', 'perch' ),
								'2' => __( 'Style 2', 'perch' ),
							),
							'default' => 'default',
							'name' => __( 'Style', 'perch' ),
							'desc' => __( 'Choose style for this heading', 'perch' ) 
						),
						'title' => array(
							'default' => 'Heading title',
							'name' => __( 'Title', 'perch' ),
						),
						'size' => array(
							'type' => 'slider',
							'min' => 1,
							'max' => 7,
							'step' => 1,
							'default' => 3,
							'name' => __( 'Heading', 'perch' ),
							'desc' => __( 'Select heading (h1 to h7)', 'perch' )
						),
						'align' => array(
							'type' => 'select',
							'values' => array(
								'left' => __( 'Left', 'perch' ),
								'center' => __( 'Center', 'perch' ),
								'right' => __( 'Right', 'perch' )
							),
							'default' => 'center',
							'name' => __( 'Align', 'perch' ),
							'desc' => __( 'Heading text alignment', 'perch' )
						),
						'margin' => array(
							'type' => 'slider',
							'min' => 0,
							'max' => 200,
							'step' => 1,
							'default' => 25,
							'name' => __( 'Margin', 'perch' ),
							'desc' => __( 'Bottom margin (pixels)', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'content' => __( 'Lorem ipsum dolor sit amet, consect etur adipisic ing elit', 'perch' ),
					'desc' => __( 'Styled heading', 'perch' ),
					'icon' => 'h-square'
				),	
				// alerts
				'alert' => array(
					'name' => __( 'Alerts', 'perch' ),
					'type' => 'wrap',
					'group' => 'content',
					'atts' => array(
						'style' => array(
							'type' => 'select',
							'values' => array(
								'success' => __( 'Success', 'perch' ),
								'info' => __( 'Info', 'perch' ),
								'warning' => __( 'Warning', 'perch' ),
								'danger' => __( 'Danger', 'perch' ),
							),
							'default' => 'success',
							'name' => __( 'Style', 'perch' ),
							'desc' => __( 'Choose style for this alert', 'perch' ) 
						),
						'size' => array(
							'type' => 'slider',
							'min' => 1,
							'max' => 7,
							'step' => 1,
							'default' => 3,
							'name' => __( 'Heading', 'perch' ),
							'desc' => __( 'Select heading (h1 to h7)', 'perch' )
						),
						'align' => array(
							'type' => 'select',
							'values' => array(
								'left' => __( 'Left', 'perch' ),
								'center' => __( 'Center', 'perch' ),
								'right' => __( 'Right', 'perch' )
							),
							'default' => 'left',
							'name' => __( 'Align', 'perch' ),
							'desc' => __( 'Text alignment', 'perch' )
						),
						'color' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Text color', 'perch' ),
							'desc' => __( 'YES to change text color as Alert box color.', 'perch' )
						),
						'margin' => array(
							'type' => 'slider',
							'min' => 0,
							'max' => 200,
							'step' => 1,
							'default' => 20,
							'name' => __( 'Margin', 'perch' ),
							'desc' => __( 'Bottom margin (pixels)', 'perch' )
						),
						'title' => array(
							'default' => 'Heading title',
							'name' => __( 'Title', 'perch' ),
						)
					),
					'content' => __( 'It works fine! Good job, mate! This is green alert box, which everyone love to see! It works fine! Good job, mate!close3', 'perch' ),
					'desc' => __( 'Alert Description', 'perch' ),
					'icon' => 'exclamation-triangle'
				),
				// testimonial
				'testimonial' => array(
					'name' => __( 'Testimonial', 'perch' ),
					'type' => 'wrap',
					'group' => 'content',
					'atts' => array(
						'title' => array(
							'default' => 'Best alternative shop',
							'name' => __( 'Client title', 'perch' ),
						),
						'image' => array(
							'type' => 'upload',
							'default' => plugins_url( 'assets/images/client-photo.png', TP_PLUGIN_FILE ),
							'name' => __( 'Client Image', 'perch' ),
							'desc' => __( '', 'perch' )
						),
						'width' => array(
							'type' => 'slider',
							'min' => 50,
							'max' => 500,
							'step' => 1,
							'default' => 145,
							'name' => __( 'Image width(maximum)', 'perch' ),
							'desc' => __( '', 'perch' )
						),				
						'height' => array(
							'type' => 'slider',
							'min' => 50,
							'max' => 600,
							'step' => 1,
							'default' => 270,
							'name' => __( 'Image height(maximum)', 'perch' ),
							'desc' => __( '', 'perch' )
						),
						'name' => array(
							'default' => '- Henry Miller, Fashion Designer',
							'name' => __( 'Client name', 'perch' ),
						),
						
					),
					'content' => __( 'Free delivery in days to the place you Free delivery Free delivery in days to Free delivery in days to the place you', 'perch' ),
					'desc' => __( 'Testimonial Description', 'perch' ),
					'icon' => 'user-secret'
				),
				// testimonial slider
				'testimonials' => array(
					'name' => __( 'Testimonial slider', 'perch' ),
					'type' => 'wrap',
					'group' => 'content',
					'atts' => array(
						'border_bottom' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Border bottom', 'perch' ),
							'desc' => __( '', 'perch' )
						),	
						'autoplay' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Autoplay', 'perch' ),
							'desc' => __( '', 'perch' )
						),					
					),
					'content' => __( 'Single testimonial shortcode goes here', 'perch' ),
					'desc' => __( 'Single testimonial shortcode goes here', 'perch' ),
					'icon' => 'recycle'
				),
				// team
				'team' => array(
					'name' => __( 'Team', 'perch' ),
					'type' => 'wrap',
					'group' => 'content',
					'atts' => array(
						'style' => array(
							'type' => 'select',
							'values' => array(
								'vertical' => __( 'Vertical', 'perch' ),
								'horizontal' => __( 'Horizontal', 'perch' ),
							),
							'default' => 'vertical',
							'name' => __( 'Style', 'perch' ),
							'desc' => __( 'Choose style for this Team', 'perch' ) 
						),												
						'image' => array(
							'type' => 'upload',
							'default' => plugins_url( 'assets/images/team.png', TP_PLUGIN_FILE ),
							'name' => __( 'Team Image', 'perch' ),
							'desc' => __( '', 'perch' )
						),
						'width' => array(
							'type' => 'slider',
							'min' => 50,
							'max' => 500,
							'step' => 1,
							'default' => 255,
							'name' => __( 'Image width(maximum)', 'perch' ),
							'desc' => __( '', 'perch' )
						),				
						'height' => array(
							'type' => 'slider',
							'min' => 50,
							'max' => 500,
							'step' => 1,
							'default' => 202,
							'name' => __( 'Image height(maximum)', 'perch' ),
							'desc' => __( '', 'perch' )
						),
						'border' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Border', 'perch' ),
							'desc' => __( '', 'perch' )
						),
						'name' => array(
							'default' => 'STEVEN JOBS',
							'name' => __( 'Name', 'perch' ),
						),
						'title' => array(
							'default' => 'Designer',
							'name' => __( 'Title', 'perch' ),
						),
						'facebook' => array(
							'default' => '',
							'name' => __( 'Facebook Link', 'perch' ),
							'desc' => __( 'Leave blank to avoid this field', 'perch' )
						),
						'twitter' => array(
							'default' => '',
							'name' => __( 'Twitter Link', 'perch' ),
							'desc' => __( 'Leave blank to avoid this field', 'perch' )
						),
						'googleplus' => array(
							'default' => '',
							'name' => __( 'Google+ Link', 'perch' ),
							'desc' => __( 'Leave blank to avoid this field', 'perch' )
						),
						'pinterest' => array(
							'default' => '',
							'name' => __( 'Pinterest Link', 'perch' ),
							'desc' => __( 'Leave blank to avoid this field', 'perch' )
						),
						'linkedin' => array(
							'default' => '',
							'name' => __( 'Linkedin Link', 'perch' ),
							'desc' => __( 'Leave blank to avoid this field', 'perch' )
						),
						
					),
					'content' => __( '', 'perch' ),
					'desc' => __( 'Member Description', 'perch' ),
					'icon' => 'user-plus'
				),
				//social_links
				'social_links' => array(
					'name' => __( 'Social Links', 'perch' ),
					'type' => 'wrap',
					'group' => 'schema',
					'atts' => array(			
						'size' => array(
							'type' => 'slider',
							'min' => 10,
							'max' => 40,
							'step' => 1,
							'default' => 16,
							'name' => __( 'Icon Size', 'perch' ),
							'desc' => __( 'Height of the divider (in pixels)', 'perch' )
						),
						'align' => array(
							'type' => 'select',
							'values' => array(
								'left' => __( 'Left', 'perch' ),
								'center' => __( 'Center', 'perch' ),
								'right' => __( 'Right', 'perch' )
							),
							'default' => 'center',
							'name' => __( 'Align', 'perch' ),
							'desc' => __( 'Text alignment', 'perch' )
						),
						'icon1' => array(
							'type' => 'icon',
							'default' => '',
							'name' => __( 'Icon 1', 'perch' ),
							'desc' => __( 'You can upload custom icon for this list or pick a built-in icon', 'perch' )
						),
						'link1' => array(
							'default' => '',
							'name' => __( 'Link 1', 'perch' ),
							'desc' => __( 'Leave blank to avoid this field', 'perch' )
						),
						'icon2' => array(
							'type' => 'icon',
							'default' => '',
							'name' => __( 'Icon 2', 'perch' ),
							'desc' => __( 'You can upload custom icon for this list or pick a built-in icon', 'perch' )
						),
						'link2' => array(
							'default' => '',
							'name' => __( 'Link 2', 'perch' ),
							'desc' => __( 'Leave blank to avoid this field', 'perch' )
						),
						'icon3' => array(
							'type' => 'icon',
							'default' => '',
							'name' => __( 'Icon 3', 'perch' ),
							'desc' => __( 'You can upload custom icon for this list or pick a built-in icon', 'perch' )
						),
						'link3' => array(
							'default' => '',
							'name' => __( 'Link 3', 'perch' ),
							'desc' => __( 'Leave blank to avoid this field', 'perch' )
						),
						'icon4' => array(
							'type' => 'icon',
							'default' => '',
							'name' => __( 'Icon 4', 'perch' ),
							'desc' => __( 'You can upload custom icon for this list or pick a built-in icon', 'perch' )
						),
						'link4' => array(
							'default' => '',
							'name' => __( 'Link 4', 'perch' ),
							'desc' => __( 'Leave blank to avoid this field', 'perch' )
						),
						'icon5' => array(
							'type' => 'icon',
							'default' => '',
							'name' => __( 'Icon 5', 'perch' ),
							'desc' => __( 'You can upload custom icon for this list or pick a built-in icon', 'perch' )
						),
						'link5' => array(
							'default' => '',
							'name' => __( 'Link 5', 'perch' ),
							'desc' => __( 'Leave blank to avoid this field', 'perch' )
						),
						'icon6' => array(
							'type' => 'icon',
							'default' => '',
							'name' => __( 'Icon 6', 'perch' ),
							'desc' => __( 'You can upload custom icon for this list or pick a built-in icon', 'perch' )
						),
						'link6' => array(
							'default' => '',
							'name' => __( 'Link 6', 'perch' ),
							'desc' => __( 'Leave blank to avoid this field', 'perch' )
						),
						
					),
					'content' => __( 'Lorem ipsum dolor sit amet eiusmod tempor incididunt', 'perch' ),
					'desc' => __( '', 'perch' ),
					'icon' => 'users'
				),	
				// pricing_table
				'pricing_table' => array(
					'name' => __( 'Pricing table', 'perch' ),
					'type' => 'wrap',
					'group' => 'content',
					'atts' => array(
						'style' => array(
							'type' => 'select',
							'values' => array(
								'default' => __( 'Default', 'perch' ),
								'featured' => __( 'Featured', 'perch' ),
							),
							'default' => 'default',
							'name' => __( 'Style', 'perch' ),
							'desc' => __( 'Choose style for this package', 'perch' ) 
						),												
						'title' => array(
							'default' => 'Small package',
							'name' => __( 'Title', 'perch' ),
						),
						'currency' => array(
							'default' => '$',
							'name' => __( 'Currency', 'perch' ),
						),//
						'price' => array(
							'default' => '19',
							'name' => __( 'Price', 'perch' ),
						),
						'precision' => array(
							'default' => '00',
							'name' => __( 'Precision', 'perch' ),
						),
						'package_details' => array(
							'type' => 'textarea',
							'default' => '1 Shirt|1 Shirt',
							'name' => __( 'Package conditions', 'perch' ),
							'desc' => __( 'Each line will be <strong>|</strong> separated.', 'perch' ) 
						),
						'button_text' => array(
							'default' => 'Learn more',
							'name' => __( 'Button Text', 'perch' ),
						),						
						'button_url' => array(
							'default' => '#',
							'name' => __( 'Button url', 'perch' ),
							'desc' => __( 'Leave blank to avoid this field', 'perch' )
						),						
						
					),
					'content' => __( 'Duis turpis eros, tincidunt id tincidunt at, tempor a nisi.', 'perch' ),
					'desc' => __( 'Package Description', 'perch' ),
					'icon' => 'usd'
				),	
				// pricing tables
				'pricing_tables' => array(
					'name' => __( 'Pricing tables', 'perch' ),
					'type' => 'wrap',
					'group' => 'content',
					'atts' => array(	
						'style' => array(
							'type' => 'select',
							'values' => array(
								'default' => __( 'Default', 'perch' ),
								'2' => __( 'Style 2(No inner spacing)', 'perch' ),
							),
							'default' => 'default',
							'name' => __( 'Style', 'perch' ),
							'desc' => __( 'Choose style for packages', 'perch' ) 
						),	
						'column' => array(
							'type' => 'slider',
							'min' => 1,
							'max' => 4,
							'step' => 1,
							'default' => 3,
							'name' => __( 'Column', 'perch' ),
							'desc' => __( '', 'perch' )
						),				
					),
					'content' => __( 'Pricing table shortcode goes here', 'perch' ),
					'desc' => __( 'Single Pricing table shortcode goes here', 'perch' ),
					'icon' => 'columns'
				),
				// call_to_action
				'call_to_action' => array(
					'name' => __( 'Call to Action', 'perch' ),
					'type' => 'wrap',
					'group' => 'content',
					'atts' => array(
						'style' => array(
							'type' => 'select',
							'values' => array(
								'default' => __( 'Default', 'perch' ),
								'2' => __( 'Style 2', 'perch' ),
	
							),
							'default' => 'default',
							'name' => __( 'Style', 'perch' ),
							'desc' => __( 'Choose style for this call to action', 'perch' ) 
						),
						'background' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Background', 'perch' ),
							'desc' => __( '', 'perch' )
						),												
						'title' => array(
							'default' => 'Are you looking for job?',
							'name' => __( 'Title(Dark)', 'perch' ),
						),
						'title_color' => array(
							'default' => 'We are recruting!',
							'name' => __( 'Title(color)', 'perch' ),
						),
						'button_style1' => array(
							'type' => 'select',
							'values' => array(
								'color-bg' => __( 'Fill color', 'perch' ),
								'color-text alt' => __( 'Alt color', 'perch' ),								
							),
							'default' => 'color-bg',
							'name' => __( 'Button Style', 'perch' ),
							'desc' => __( 'Choose style for this button', 'perch' ) 
						),	
						'button_text1' => array(
							'default' => 'Learn more',
							'name' => __( 'Button Text', 'perch' ),
							'desc' => __( 'Leave blank to avoid button', 'perch' )
						),											
						'button_url1' => array(
							'default' => '#',
							'name' => __( 'Button url', 'perch' ),
							'desc' => __( 'Leave blank to avoid this field', 'perch' )
						),
						'button_style2' => array(
							'type' => 'select',
							'values' => array(
								'color-bg' => __( 'Fill color', 'perch' ),
								'alt' => __( 'Alt color', 'perch' ),								
							),
							'default' => 'alt',
							'name' => __( 'Button 2 style (Only for Style 2)', 'perch' ),
							'desc' => __( 'Choose style for button', 'perch' ) ,
							'operator' => 'and',
							'condition' => 'style:is(2)'
						),	
						'button_text2' => array(
							'default' => '',
							'name' => __( 'Button Text 2 (Only for Style 2)', 'perch' ),
							'desc' => __( 'Leave blank to avoid button', 'perch' ),
							'operator' => 'and',
							'condition' => 'style:is(2)'
						),						
						'button_url2' => array(
							'default' => '#',
							'name' => __( 'Button url (Only for Style 2)', 'perch' ),
							'operator' => 'and',
							'condition' => 'style:is(2)'
						),							
						
					),
					'content' => __( 'Free delivery in days to the place you included. 100% Free delivery Free delivery  Free delivery in days to the place you included. 100% Free delivery Free delivery  Free delivery in days to the place.', 'perch' ),
					'desc' => __( 'Package Description', 'perch' ),
					'icon' => 'phone'
				),		
				// tabs
				'tabs' => array(
					'name' => __( 'Tabs', 'perch' ),
					'type' => 'wrap',
					'group' => 'box',
					'atts' => array(
						'style' => array(
							'type' => 'select',
							'values' => array(
								'default' => __( 'Default', 'perch' )
							),
							'default' => 'default',
							'name' => __( 'Style', 'perch' ),
							'desc' => __( 'Choose style for this tabs', 'perch' ) 
						),
						'active' => array(
							'type' => 'number',
							'min' => 1,
							'max' => 100,
							'step' => 1,
							'default' => 1,
							'name' => __( 'Active tab', 'perch' ),
							'desc' => __( 'Select which tab is open by default', 'perch' )
						),
						'vertical' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Vertical', 'perch' ),
							'desc' => __( 'Show tabs vertically', 'perch' )
						),
						'center' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Center', 'perch' ),
							'desc' => __( 'Applied only for Horizontal tab', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'content' => __( "[%prefix_tab title=\"Title 1\"]Content 1[/%prefix_tab]\n[%prefix_tab title=\"Title 2\"]Content 2[/%prefix_tab]\n[%prefix_tab title=\"Title 3\"]Content 3[/%prefix_tab]", 'perch' ),
					'desc' => __( 'Tabs container', 'perch' ),
					'example' => 'tabs',
					'icon' => 'list-alt'
				),
				// tab
				'tab' => array(
					'name' => __( 'Tab', 'perch' ),
					'type' => 'wrap',
					'group' => 'box',
					'atts' => array(
						'title' => array(
							'default' => __( 'Tab name', 'perch' ),
							'name' => __( 'Title', 'perch' ),
							'desc' => __( 'Enter tab name', 'perch' )
						),
						'disabled' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Disabled', 'perch' ),
							'desc' => __( 'Is this tab disabled', 'perch' )
						),
						'anchor' => array(
							'default' => '',
							'name' => __( 'Anchor', 'perch' ),
							'desc' => __( 'You can use unique anchor for this tab to access it with hash in page url. For example: type here <b%value>Hello</b> and then use url like http://example.com/page-url#Hello. This tab will be activated and scrolled in', 'perch' )
						),
						'url' => array(
							'default' => '',
							'name' => __( 'URL', 'perch' ),
							'desc' => __( 'You can link this tab to any webpage. Enter here full URL to switch this tab into link', 'perch' )
						),
						'target' => array(
							'type' => 'select',
							'values' => array(
								'self'  => __( 'Open link in same window/tab', 'perch' ),
								'blank' => __( 'Open link in new window/tab', 'perch' )
							),
							'default' => 'blank',
							'name' => __( 'Link target', 'perch' ),
							'desc' => __( 'Choose how to open the custom tab link', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'content' => __( 'Tab content', 'perch' ),
					'desc' => __( 'Single tab', 'perch' ),
					'note' => __( 'Did you know that you need to wrap single tabs with [tabs] shortcode?', 'perch' ),
					'example' => 'tabs',
					'icon' => 'list-alt'
				),
				// spoiler
				'spoiler' => array(
					'name' => __( 'Spoiler', 'perch' ),
					'type' => 'wrap',
					'group' => 'box',
					'atts' => array(
						'title' => array(
							'default' => __( 'Spoiler title', 'perch' ),
							'name' => __( 'Title', 'perch' ), 'desc' => __( 'Text in spoiler title', 'perch' )
						),
						'open' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Open', 'perch' ),
							'desc' => __( 'Is spoiler content visible by default', 'perch' )
						),
						'style' => array(
							'type' => 'select',
							'values' => array(
								'default' => __( 'Default', 'perch' ),
								'fancy' => __( 'Fancy', 'perch' ),
								'simple' => __( 'Simple', 'perch' )
							),
							'default' => 'default',
							'name' => __( 'Style', 'perch' ),
							'desc' => __( 'Choose style for this spoiler', 'perch' ) 
						),
						'icon' => array(
							'type' => 'select',
							'values' => array(
								'plus'           => __( 'Plus', 'perch' ),
								'plus-circle'    => __( 'Plus circle', 'perch' ),
								'plus-square-1'  => __( 'Plus square 1', 'perch' ),
								'plus-square-2'  => __( 'Plus square 2', 'perch' ),
								'arrow'          => __( 'Arrow', 'perch' ),
								'arrow-circle-1' => __( 'Arrow circle 1', 'perch' ),
								'arrow-circle-2' => __( 'Arrow circle 2', 'perch' ),
								'chevron'        => __( 'Chevron', 'perch' ),
								'chevron-circle' => __( 'Chevron circle', 'perch' ),
								'caret'          => __( 'Caret', 'perch' ),
								'caret-square'   => __( 'Caret square', 'perch' ),
								'folder-1'       => __( 'Folder 1', 'perch' ),
								'folder-2'       => __( 'Folder 2', 'perch' )
							),
							'default' => 'plus',
							'name' => __( 'Icon', 'perch' ),
							'desc' => __( 'Icons for spoiler', 'perch' )
						),
						'anchor' => array(
							'default' => '',
							'name' => __( 'Anchor', 'perch' ),
							'desc' => __( 'You can use unique anchor for this spoiler to access it with hash in page url. For example: type here <b%value>Hello</b> and then use url like http://example.com/page-url#Hello. This spoiler will be open and scrolled in', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'content' => __( 'Hidden content', 'perch' ),
					'desc' => __( 'Spoiler with hidden content', 'perch' ),
					'note' => __( 'Did you know that you can wrap multiple spoilers with [accordion] shortcode to create accordion effect?', 'perch' ),
					'example' => 'spoilers',
					'icon' => 'list-ul'
				),
				// accordion
				'accordion' => array(
					'name' => __( 'Accordion', 'perch' ),
					'type' => 'wrap',
					'group' => 'box',
					'atts' => array(
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'content' => __( "[%prefix_spoiler]Content[/%prefix_spoiler]\n[%prefix_spoiler]Content[/%prefix_spoiler]\n[%prefix_spoiler]Content[/%prefix_spoiler]", 'perch' ),
					'desc' => __( 'Accordion with spoilers', 'perch' ),
					'note' => __( 'Did you know that you can wrap multiple spoilers with [accordion] shortcode to create accordion effect?', 'perch' ),
					'example' => 'spoilers',
					'icon' => 'list'
				),
				// divider
				'divider' => array(
					'name' => __( 'Divider', 'perch' ),
					'type' => 'single',
					'group' => 'content',
					'atts' => array(
						'top' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Show TOP link', 'perch' ),
							'desc' => __( 'Show link to top of the page or not', 'perch' )
						),
						'text' => array(
							'values' => array( ),
							'default' => __( 'Go to top', 'perch' ),
							'name' => __( 'Link text', 'perch' ), 'desc' => __( 'Text for the GO TOP link', 'perch' )
						),
						'style' => array(
							'type' => 'select',
							'values' => array(
								'default' => __( 'Default', 'perch' ),
								'dotted'  => __( 'Dotted', 'perch' ),
								'dashed'  => __( 'Dashed', 'perch' ),
								'double'  => __( 'Double', 'perch' )
							),
							'default' => 'default',
							'name' => __( 'Style', 'perch' ),
							'desc' => __( 'Choose style for this divider', 'perch' )
						),
						'divider_color' => array(
							'type' => 'color',
							'values' => array( ),
							'default' => '#999999',
							'name' => __( 'Divider color', 'perch' ),
							'desc' => __( 'Pick the color for divider', 'perch' )
						),
						'link_color' => array(
							'type' => 'color',
							'values' => array( ),
							'default' => '#999999',
							'name' => __( 'Link color', 'perch' ),
							'desc' => __( 'Pick the color for TOP link', 'perch' )
						),
						'size' => array(
							'type' => 'slider',
							'min' => 0,
							'max' => 40,
							'step' => 1,
							'default' => 3,
							'name' => __( 'Size', 'perch' ),
							'desc' => __( 'Height of the divider (in pixels)', 'perch' )
						),
						'margin' => array(
							'type' => 'slider',
							'min' => 0,
							'max' => 200,
							'step' => 5,
							'default' => 15,
							'name' => __( 'Margin', 'perch' ),
							'desc' => __( 'Adjust the top and bottom margins of this divider (in pixels)', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'desc' => __( 'Content divider with optional TOP link', 'perch' ),
					'icon' => 'ellipsis-h'
				),
				// spacer
				'spacer' => array(
					'name' => __( 'Spacer', 'perch' ),
					'type' => 'single',
					'group' => 'content other',
					'atts' => array(
						'size' => array(
							'type' => 'slider',
							'min' => 0,
							'max' => 800,
							'step' => 10,
							'default' => 20,
							'name' => __( 'Height', 'perch' ),
							'desc' => __( 'Height of the spacer in pixels', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'desc' => __( 'Empty space with adjustable height', 'perch' ),
					'icon' => 'arrows-v'
				),
				// highlight
				'highlight' => array(
					'name' => __( 'Highlight', 'perch' ),
					'type' => 'wrap',
					'group' => 'content',
					'atts' => array(
						'background' => array(
							'type' => 'color',
							'values' => array( ),
							'default' => '#DDFF99',
							'name' => __( 'Background', 'perch' ),
							'desc' => __( 'Highlighted text background color', 'perch' )
						),
						'color' => array(
							'type' => 'color',
							'values' => array( ),
							'default' => '#000000',
							'name' => __( 'Text color', 'perch' ), 'desc' => __( 'Highlighted text color', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'content' => __( 'Highlighted text', 'perch' ),
					'desc' => __( 'Highlighted text', 'perch' ),
					'icon' => 'pencil'
				),
				// instagram
				'instagram' => array(
					'name' => __( 'Instagram', 'perch' ),
					'type' => 'single',
					'group' => 'schema',
					'atts' => array(
						'layout_type' => array(
							'type' => 'select',
							'values' => array(
								'feed' => __( 'Feed', 'perch' ),
								'carousel' => __( 'Carousel', 'perch' ),
							),
							'default' => 'feed',
							'name' => __( 'Select Layout Type', 'perch' ),
							'desc' => __( '', 'perch' ) 
						),
						'car_display_item' => array(
							'type' => 'slider',
							'min' => 1,
							'max' => 20,
							'step' => 1,
							'default' => 6,
							'name' => __( 'Items Display', 'perch' ),
							'desc' => __( 'This variable allows you to set the maximum amount of items displayed at a time with the widest browser width', 'perch' ),
							'condition' => 'layout_type:is(carousel)'
						),
						'instagram_type' => array(
							'type' => 'select',
							'values' => array(
								'popular' => __( 'Popular', 'perch' ),
								'tagged' => __( 'Tagged', 'perch' ),
								'location' => __( 'Location', 'perch' ),
								'user' => __( 'User', 'perch' ),
							),
							'default' => 'user',
							'name' => __( 'Select Feed Type', 'perch' ),
							'desc' => __( '', 'perch' ) 
						),
						'tagged_id' => array(
							'default' => '',
							'name' => __( 'Tagged Name', 'perch' ),
							'desc' => __( 'Images with a specific tag. Use tagName to specify the tag. e.g. modern', 'perch' ),
							'condition' => 'instagram_type:is(tagged)'
						),
						'location_id' => array(
							'default' => '',
							'name' => __( 'Location ID', 'perch' ),
							'desc' => __( 'Images from a location. Use locationId to specify the location.e.g. 230548', 'perch' ),
							'condition' => 'instagram_type:is(location)'
						),
						'user_id' => array(
							'default' => '',
							'name' => __( 'User ID', 'perch' ),
							'desc' => __( 'Images with a user. Use userId to specify the user id.eg : 2223881582. Lookup Your Instagram User ID : <a href="http://jelled.com/instagram/lookup-user-id" target="_blank">Click here</a>', 'perch' ),
							'condition' => 'instagram_type:is(user)'
						),
						'instagram_num' => array(
							'type' => 'slider',
							'min' => 1,
							'max' => 100,
							'step' => 1,
							'default' => 9,
							'name' => __( 'Load per page feed limit', 'perch' ),
							'desc' => __( 'Set Limit for feed per page.', 'perch' ),
						),
						'sortby' => array(
							'type' => 'select',
							'values' => array(
								'none' => __( 'none', 'perch' ),
								'most-recent' => __( 'Most recent', 'perch' ),
								'least-recent' => __( 'Least recent', 'perch' ),
								'most-liked' => __( 'Most liked', 'perch' ),
								'least-liked' => __( 'Least liked', 'perch' ),
								'most-commented' => __( 'Most commented', 'perch' ),
								'least-commented' => __( 'Least commented', 'perch' ),
								'random' => __( 'Random', 'perch' ),
							),
							'default' => 'none',
							'name' => __( 'Sortby', 'perch' ),
							'desc' => __( 'Sort the images in a set order', 'perch' ) 
						),
						'car_pagination' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Show pagination', 'perch' ),
							'condition' => 'layout_type:is(carousel)'
						),
						'car_pagination_num' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Pagination number', 'perch' ),
							'operator' => 'and',
							'condition' => 'car_pagination:is(yes),layout_type:is(carousel)'
						),
						'car_navigation' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Hide navigation', 'perch' ),
							'desc' => __( 'Display "next" and "prev" buttons.', 'perch' ),
							'condition' => 'layout_type:is(carousel)'
						),
						'car_autoplay' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Autoplay', 'perch' ),
							'desc' => __( 'Set Carousel Autoplay.', 'perch' ),
							'condition' => 'layout_type:is(carousel)'
						),
						'car_autoplay_time' => array(
							'type' => 'slider',
							'min' => 1,
							'max' => 100,
							'step' => 1,
							'default' => 3,
							'name' => __( 'AutoPlay Time', 'perch' ),
							'desc' => __( 'Set Autoplay slider speed in <i>seconds</i>.', 'perch' ),
							'operator' => 'and',
							'condition' => 'layout_type:is(carousel),car_autoplay:is(yes)'
						),
						'grid_columns_count_for_desktop' => array(
							'type' => 'slider',
							'min' => 1,
							'max' => 4,
							'step' => 1,
							'default' => 3,
							'name' => __( 'Desktop Columns', 'perch' ),
							'desc' => __( 'Choose Desktop(PC Mode) Columns Count', 'perch' ),
							'operator' => 'and',
							'condition' => 'layout_type:is(feed)'
						),
						'grid_columns_count_for_tablet' => array(
							'type' => 'slider',
							'min' => 1,
							'max' => 4,
							'step' => 1,
							'default' => 4,
							'name' => __( 'Tablet Columns', 'perch' ),
							'desc' => __( 'Choose Tablet mode Columns Count', 'perch' ),
							'operator' => 'and',
							'condition' => 'layout_type:is(feed)'
						),
						'grid_columns_count_for_mobile' => array(
							'type' => 'slider',
							'min' => 1,
							'max' => 4,
							'step' => 1,
							'default' => 2,
							'name' => __( 'Mobile Columns', 'perch' ),
							'desc' => __( 'Choose Mobile mode Columns Count', 'perch' ),
							'operator' => 'and',
							'condition' => 'layout_type:is(feed)'
						),
						'resolution' => array(
							'type' => 'select',
							'values' => array(
								'thumbnail' => __( 'Thumbnail (150x150)', 'perch' ),
								'low_resolution' => __( 'Standard resolution (306x306)', 'perch' ),
								'standard_resolution' => __( 'High resolution (612x612)', 'perch' )								
							),
							'default' => 'low_resolution',
							'name' => __( 'Sortby', 'perch' ),
							'desc' => __( 'Sort the images in a set order', 'perch' ) 
						)
					),
					'content' => __( '', 'perch' ),
					'desc' => __( 'Instagram feed', 'perch' ),
					'icon' => 'instagram'
				),
				// label
				'label' => array(
					'name' => __( 'Label', 'perch' ),
					'type' => 'wrap',
					'group' => 'content',
					'atts' => array(
						'type' => array(
							'type' => 'select',
							'values' => array(
								'default' => __( 'Default', 'perch' ),
								'success' => __( 'Success', 'perch' ),
								'warning' => __( 'Warning', 'perch' ),
								'important' => __( 'Important', 'perch' ),
								'black' => __( 'Black', 'perch' ),
								'info' => __( 'Info', 'perch' )
							),
							'default' => 'default',
							'name' => __( 'Type', 'perch' ),
							'desc' => __( 'Style of the label', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'content' => __( 'Label', 'perch' ),
					'desc' => __( 'Styled label', 'perch' ),
					'icon' => 'tag'
				),
				// quote
				'quote' => array(
					'name' => __( 'Quote', 'perch' ),
					'type' => 'wrap',
					'group' => 'box',
					'atts' => array(
						'style' => array(
							'type' => 'select',
							'values' => array(
								'default' => __( 'Default', 'perch' ),
								'2' => __( 'Style 2', 'perch' )
							),
							'default' => 'default',
							'name' => __( 'Style', 'perch' ),
							'desc' => __( 'Choose style for this quote', 'perch' ) 
						),
						'cite' => array(
							'default' => '',
							'name' => __( 'Cite', 'perch' ),
							'desc' => __( 'Quote author name', 'perch' )
						),
						'url' => array(
							'values' => array( ),
							'default' => '',
							'name' => __( 'Cite url', 'perch' ),
							'desc' => __( 'Url of the quote author. Leave empty to disable link', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'content' => __( 'Quote', 'perch' ),
					'desc' => __( 'Blockquote alternative', 'perch' ),
					'icon' => 'quote-right'
				),
				// pullquote
				'pullquote' => array(
					'name' => __( 'Pullquote', 'perch' ),
					'type' => 'wrap',
					'group' => 'box',
					'atts' => array(
						'align' => array(
							'type' => 'select',
							'values' => array(
								'left' => __( 'Left', 'perch' ),
								'right' => __( 'Right', 'perch' )
							),
							'default' => 'left',
							'name' => __( 'Align', 'perch' ), 'desc' => __( 'Pullquote alignment (float)', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'content' => __( 'Pullquote', 'perch' ),
					'desc' => __( 'Pullquote', 'perch' ),
					'icon' => 'quote-left'
				),
				// dropcap
				'dropcap' => array(
					'name' => __( 'Dropcap', 'perch' ),
					'type' => 'wrap',
					'group' => 'content',
					'atts' => array(
						'style' => array(
							'type' => 'select',
							'values' => array(
								'default' => __( 'Default', 'perch' ),
								'flat' => __( 'Flat', 'perch' ),
								'light' => __( 'Light', 'perch' ),
								'simple' => __( 'Simple', 'perch' )
							),
							'default' => 'default',
							'name' => __( 'Style', 'perch' ), 'desc' => __( 'Dropcap style preset', 'perch' )
						),
						'size' => array(
							'type' => 'slider',
							'min' => 1,
							'max' => 5,
							'step' => 1,
							'default' => 3,
							'name' => __( 'Size', 'perch' ),
							'desc' => __( 'Choose dropcap size', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'content' => __( 'D', 'perch' ),
					'desc' => __( 'Dropcap', 'perch' ),
					'icon' => 'bold'
				),
				// frame
				'frame' => array(
					'name' => __( 'Frame', 'perch' ),
					'type' => 'wrap',
					'group' => 'content',
					'atts' => array(
						'align' => array(
							'type' => 'select',
							'values' => array(
								'left' => __( 'Left', 'perch' ),
								'center' => __( 'Center', 'perch' ),
								'right' => __( 'Right', 'perch' )
							),
							'default' => 'left',
							'name' => __( 'Align', 'perch' ),
							'desc' => __( 'Frame alignment', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'content' => '<img src="http://lorempixel.com/g/400/200/" />',
					'desc' => __( 'Styled image frame', 'perch' ),
					'icon' => 'picture-o'
				),
				// row
				'row' => array(
					'name' => __( 'Row', 'perch' ),
					'type' => 'wrap',
					'group' => 'box',
					'atts' => array(
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'content' => __( "[%prefix_column size=\"1/3\"]Content[/%prefix_column]\n[%prefix_column size=\"1/3\"]Content[/%prefix_column]\n[%prefix_column size=\"1/3\"]Content[/%prefix_column]", 'perch' ),
					'desc' => __( 'Row for flexible columns', 'perch' ),
					'icon' => 'columns'
				),
				// column
				'column' => array(
					'name' => __( 'Column', 'perch' ),
					'type' => 'wrap',
					'group' => 'box',
					'atts' => array(
						'size' => array(
							'type' => 'select',
							'values' => array(
								'1/1' => __( 'Full width', 'perch' ),
								'1/2' => __( 'One half', 'perch' ),
								'1/3' => __( 'One third', 'perch' ),
								'2/3' => __( 'Two third', 'perch' ),
								'1/4' => __( 'One fourth', 'perch' ),
								'3/4' => __( 'Three fourth', 'perch' ),
								'1/5' => __( 'One fifth', 'perch' ),
								'2/5' => __( 'Two fifth', 'perch' ),
								'3/5' => __( 'Three fifth', 'perch' ),
								'4/5' => __( 'Four fifth', 'perch' ),
								'1/6' => __( 'One sixth', 'perch' ),
								'5/6' => __( 'Five sixth', 'perch' )
							),
							'default' => '1/2',
							'name' => __( 'Size', 'perch' ),
							'desc' => __( 'Select column width. This width will be calculated depend page width', 'perch' )
						),
						'center' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Centered', 'perch' ),
							'desc' => __( 'Is this column centered on the page', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'content' => __( 'Column content', 'perch' ),
					'desc' => __( 'Flexible and responsive columns', 'perch' ),
					'note' => __( 'Did you know that you need to wrap columns with [row] shortcode?', 'perch' ),
					'example' => 'columns',
					'icon' => 'columns'
				),
				// list
				'list' => array(
					'name' => __( 'List', 'perch' ),
					'type' => 'wrap',
					'group' => 'content',
					'atts' => array(
						'icon' => array(
							'type' => 'icon',
							'default' => '',
							'name' => __( 'Icon', 'perch' ),
							'desc' => __( 'You can upload custom icon for this list or pick a built-in icon', 'perch' )
						),
						'icon_color' => array(
							'type' => 'color',
							'default' => '#333333',
							'name' => __( 'Icon color', 'perch' ),
							'desc' => __( 'This color will be applied to the selected icon. Does not works with uploaded icons', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'content' => __( "<ul>\n<li>List item</li>\n<li>List item</li>\n<li>List item</li>\n</ul>", 'perch' ),
					'desc' => __( 'Styled unordered list', 'perch' ),
					'icon' => 'list-ol'
				),
				// button
				'button' => array(
					'name' => __( 'Button', 'perch' ),
					'type' => 'wrap',
					'group' => 'content',
					'atts' => array(
						'url' => array(
							'values' => array( ),
							'default' => get_option( 'home' ),
							'name' => __( 'Link', 'perch' ),
							'desc' => __( 'Button link', 'perch' )
						),
						'target' => array(
							'type' => 'select',
							'values' => array(
								'self' => __( 'Same tab', 'perch' ),
								'blank' => __( 'New tab', 'perch' )
							),
							'default' => 'self',
							'name' => __( 'Target', 'perch' ),
							'desc' => __( 'Button link target', 'perch' )
						),
						'style' => array(
							'type' => 'select',
							'values' => array(
								'default' => __( 'Default', 'perch' ),
								'flat' => __( 'Flat', 'perch' ),
								'ghost' => __( 'Ghost', 'perch' ),
								'soft' => __( 'Soft', 'perch' ),
								'glass' => __( 'Glass', 'perch' ),
								'bubbles' => __( 'Bubbles', 'perch' ),
								'noise' => __( 'Noise', 'perch' ),
								'stroked' => __( 'Stroked', 'perch' ),
								'3d' => __( '3D', 'perch' )
							),
							'default' => 'default',
							'name' => __( 'Style', 'perch' ), 'desc' => __( 'Button background style preset', 'perch' )
						),
						'background' => array(
							'type' => 'color',
							'values' => array( ),
							'default' => '#2D89EF',
							'name' => __( 'Background', 'perch' ), 'desc' => __( 'Button background color', 'perch' )
						),
						'color' => array(
							'type' => 'color',
							'values' => array( ),
							'default' => '#FFFFFF',
							'name' => __( 'Text color', 'perch' ),
							'desc' => __( 'Button text color', 'perch' )
						),
						'size' => array(
							'type' => 'slider',
							'min' => 1,
							'max' => 20,
							'step' => 1,
							'default' => 3,
							'name' => __( 'Size', 'perch' ),
							'desc' => __( 'Button size', 'perch' )
						),
						'wide' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Fluid', 'perch' ), 'desc' => __( 'Fluid buttons has 100% width', 'perch' )
						),
						'center' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Centered', 'perch' ), 'desc' => __( 'Is button centered on the page', 'perch' )
						),
						'radius' => array(
							'type' => 'select',
							'values' => array(
								'auto' => __( 'Auto', 'perch' ),
								'round' => __( 'Round', 'perch' ),
								'0' => __( 'Square', 'perch' ),
								'5' => '5px',
								'10' => '10px',
								'20' => '20px'
							),
							'default' => 'auto',
							'name' => __( 'Radius', 'perch' ),
							'desc' => __( 'Radius of button corners. Auto-radius calculation based on button size', 'perch' )
						),
						'icon' => array(
							'type' => 'icon',
							'default' => '',
							'name' => __( 'Icon', 'perch' ),
							'desc' => __( 'You can upload custom icon for this button or pick a built-in icon', 'perch' )
						),
						'icon_color' => array(
							'type' => 'color',
							'default' => '#FFFFFF',
							'name' => __( 'Icon color', 'perch' ),
							'desc' => __( 'This color will be applied to the selected icon. Does not works with uploaded icons', 'perch' )
						),
						'text_shadow' => array(
							'type' => 'shadow',
							'default' => 'none',
							'name' => __( 'Text shadow', 'perch' ),
							'desc' => __( 'Button text shadow', 'perch' )
						),
						'desc' => array(
							'default' => '',
							'name' => __( 'Description', 'perch' ),
							'desc' => __( 'Small description under button text. This option is incompatible with icon.', 'perch' )
						),
						'onclick' => array(
							'default' => '',
							'name' => __( 'onClick', 'perch' ),
							'desc' => __( 'Advanced JavaScript code for onClick action', 'perch' )
						),
						'rel' => array(
							'default' => '',
							'name' => __( 'Rel attribute', 'perch' ),
							'desc' => __( 'Here you can add value for the rel attribute.<br>Example values: <b%value>nofollow</b>, <b%value>lightbox</b>', 'perch' )
						),
						'title' => array(
							'default' => '',
							'name' => __( 'Title attribute', 'perch' ),
							'desc' => __( 'Here you can add value for the title attribute', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'content' => __( 'Button text', 'perch' ),
					'desc' => __( 'Styled button', 'perch' ),
					'example' => 'buttons',
					'icon' => 'heart'
				),
				// service
				'service' => array(
					'name' => __( 'Service', 'perch' ),
					'type' => 'wrap',
					'group' => 'box',
					'atts' => array(
						'title' => array(
							'values' => array( ),
							'default' => __( 'Service title', 'perch' ),
							'name' => __( 'Title', 'perch' ),
							'desc' => __( 'Service name', 'perch' )
						),
						'icon' => array(
							'type' => 'icon',
							'default' => '',
							'name' => __( 'Icon', 'perch' ),
							'desc' => __( 'You can upload custom icon for this box', 'perch' )
						),
						'icon_color' => array(
							'type' => 'color',
							'default' => '#333333',
							'name' => __( 'Icon color', 'perch' ),
							'desc' => __( 'This color will be applied to the selected icon. Does not works with uploaded icons', 'perch' )
						),
						'size' => array(
							'type' => 'slider',
							'min' => 10,
							'max' => 128,
							'step' => 2,
							'default' => 32,
							'name' => __( 'Icon size', 'perch' ),
							'desc' => __( 'Size of the uploaded icon in pixels', 'perch' )
						),
						'align' => array(
							'type' => 'select',
							'values' => array(
								'left' => __( 'Left', 'perch' ),
								'center' => __( 'Center', 'perch' ),
								'right' => __( 'Right', 'perch' )
							),
							'default' => 'left',
							'name' => __( 'Align', 'perch' ),
							'desc' => __( 'Heading text alignment', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'content' => __( 'Service description', 'perch' ),
					'desc' => __( 'Service box with title', 'perch' ),
					'icon' => 'check-square-o'
				),
				// box
				'box' => array(
					'name' => __( 'Box', 'perch' ),
					'type' => 'wrap',
					'group' => 'box',
					'atts' => array(
						'title' => array(
							'values' => array( ),
							'default' => __( 'Box title', 'perch' ),
							'name' => __( 'Title', 'perch' ), 'desc' => __( 'Text for the box title', 'perch' )
						),
						'style' => array(
							'type' => 'select',
							'values' => array(
								'default' => __( 'Default', 'perch' ),
								'soft' => __( 'Soft', 'perch' ),
								'glass' => __( 'Glass', 'perch' ),
								'bubbles' => __( 'Bubbles', 'perch' ),
								'noise' => __( 'Noise', 'perch' )
							),
							'default' => 'default',
							'name' => __( 'Style', 'perch' ),
							'desc' => __( 'Box style preset', 'perch' )
						),
						'box_color' => array(
							'type' => 'color',
							'values' => array( ),
							'default' => '#333333',
							'name' => __( 'Color', 'perch' ),
							'desc' => __( 'Color for the box title and borders', 'perch' )
						),
						'title_color' => array(
							'type' => 'color',
							'values' => array( ),
							'default' => '#FFFFFF',
							'name' => __( 'Title text color', 'perch' ), 'desc' => __( 'Color for the box title text', 'perch' )
						),
						'radius' => array(
							'type' => 'slider',
							'min' => 0,
							'max' => 20,
							'step' => 1,
							'default' => 3,
							'name' => __( 'Radius', 'perch' ),
							'desc' => __( 'Box corners radius', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'content' => __( 'Box content', 'perch' ),
					'desc' => __( 'Colored box with caption', 'perch' ),
					'icon' => 'list-alt'
				),
				// note
				'note' => array(
					'name' => __( 'Note', 'perch' ),
					'type' => 'wrap',
					'group' => 'box',
					'atts' => array(
						'note_color' => array(
							'type' => 'color',
							'values' => array( ),
							'default' => '#FFFF66',
							'name' => __( 'Background', 'perch' ), 'desc' => __( 'Note background color', 'perch' )
						),
						'text_color' => array(
							'type' => 'color',
							'values' => array( ),
							'default' => '#333333',
							'name' => __( 'Text color', 'perch' ),
							'desc' => __( 'Note text color', 'perch' )
						),
						'radius' => array(
							'type' => 'slider',
							'min' => 0,
							'max' => 20,
							'step' => 1,
							'default' => 3,
							'name' => __( 'Radius', 'perch' ), 'desc' => __( 'Note corners radius', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'content' => __( 'Note text', 'perch' ),
					'desc' => __( 'Colored box', 'perch' ),
					'icon' => 'list-alt'
				),
				// expand
				'expand' => array(
					'name' => __( 'Expand', 'perch' ),
					'type' => 'wrap',
					'group' => 'box',
					'atts' => array(
						'more_text' => array(
							'default' => __( 'Show more', 'perch' ),
							'name' => __( 'More text', 'perch' ),
							'desc' => __( 'Enter the text for more link', 'perch' )
						),
						'less_text' => array(
							'default' => __( 'Show less', 'perch' ),
							'name' => __( 'Less text', 'perch' ),
							'desc' => __( 'Enter the text for less link', 'perch' )
						),
						'height' => array(
							'type' => 'slider',
							'min' => 0,
							'max' => 1000,
							'step' => 10,
							'default' => 100,
							'name' => __( 'Height', 'perch' ),
							'desc' => __( 'Height for collapsed state (in pixels)', 'perch' )
						),
						'hide_less' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Hide less link', 'perch' ),
							'desc' => __( 'This option allows you to hide less link, when the text block has been expanded', 'perch' )
						),
						'text_color' => array(
							'type' => 'color',
							'values' => array( ),
							'default' => '#333333',
							'name' => __( 'Text color', 'perch' ),
							'desc' => __( 'Pick the text color', 'perch' )
						),
						'link_color' => array(
							'type' => 'color',
							'values' => array( ),
							'default' => '#0088FF',
							'name' => __( 'Link color', 'perch' ),
							'desc' => __( 'Pick the link color', 'perch' )
						),
						'link_style' => array(
							'type' => 'select',
							'values' => array(
								'default'    => __( 'Default', 'perch' ),
								'underlined' => __( 'Underlined', 'perch' ),
								'dotted'     => __( 'Dotted', 'perch' ),
								'dashed'     => __( 'Dashed', 'perch' ),
								'button'     => __( 'Button', 'perch' ),
							),
							'default' => 'default',
							'name' => __( 'Link style', 'perch' ),
							'desc' => __( 'Select the style for more/less link', 'perch' )
						),
						'link_align' => array(
							'type' => 'select',
							'values' => array(
								'left' => __( 'Left', 'perch' ),
								'center' => __( 'Center', 'perch' ),
								'right' => __( 'Right', 'perch' ),
							),
							'default' => 'left',
							'name' => __( 'Link align', 'perch' ),
							'desc' => __( 'Select link alignment', 'perch' )
						),
						'more_icon' => array(
							'type' => 'icon',
							'default' => '',
							'name' => __( 'More icon', 'perch' ),
							'desc' => __( 'Add an icon to the more link', 'perch' )
						),
						'less_icon' => array(
							'type' => 'icon',
							'default' => '',
							'name' => __( 'Less icon', 'perch' ),
							'desc' => __( 'Add an icon to the less link', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'content' => __( 'This text block can be expanded', 'perch' ),
					'desc' => __( 'Expandable text block', 'perch' ),
					'icon' => 'sort-amount-asc'
				),
				// lightbox
				'lightbox' => array(
					'name' => __( 'Lightbox', 'perch' ),
					'type' => 'wrap',
					'group' => 'gallery',
					'atts' => array(
						'type' => array(
							'type' => 'select',
							'values' => array(
								'iframe' => __( 'Iframe', 'perch' ),
								'image' => __( 'Image', 'perch' ),
								'inline' => __( 'Inline (html content)', 'perch' )
							),
							'default' => 'iframe',
							'name' => __( 'Content type', 'perch' ),
							'desc' => __( 'Select type of the lightbox window content', 'perch' )
						),
						'src' => array(
							'default' => '',
							'name' => __( 'Content source', 'perch' ),
							'desc' => __( 'Insert here URL or CSS selector. Use URL for Iframe and Image content types. Use CSS selector for Inline content type.<br />Example values:<br /><b%value>http://www.youtube.com/watch?v=XXXXXXXXX</b> - YouTube video (iframe)<br /><b%value>http://example.com/wp-content/uploads/image.jpg</b> - uploaded image (image)<br /><b%value>http://example.com/</b> - any web page (iframe)<br /><b%value>#my-custom-popup</b> - any HTML content (inline)', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'content' => __( '[%prefix_button] Click Here to Watch the Video [/%prefix_button]', 'perch' ),
					'desc' => __( 'Lightbox window with custom content', 'perch' ),
					'icon' => 'external-link'
				),
				// lightbox content
				'lightbox_content' => array(
					'name' => __( 'Lightbox content', 'perch' ),
					'type' => 'wrap',
					'group' => 'gallery',
					'atts' => array(
						'id' => array(
							'default' => '',
							'name' => __( 'ID', 'perch' ),
							'desc' => sprintf( __( 'Enter here the ID from Content source field. %s Example value: %s', 'perch' ), '<br>', '<b%value>my-custom-popup</b>' )
						),
						'width' => array(
							'default' => '50%',
							'name' => __( 'Width', 'perch' ),
							'desc' => sprintf( __( 'Adjust the width for inline content (in pixels or percents). %s Example values: %s, %s, %s', 'perch' ), '<br>', '<b%value>300px</b>', '<b%value>600px</b>', '<b%value>90%</b>' )
						),
						'margin' => array(
							'type' => 'slider',
							'min' => 0,
							'max' => 600,
							'step' => 5,
							'default' => 40,
							'name' => __( 'Margin', 'perch' ),
							'desc' => __( 'Adjust the margin for inline content (in pixels)', 'perch' )
						),
						'padding' => array(
							'type' => 'slider',
							'min' => 0,
							'max' => 600,
							'step' => 5,
							'default' => 40,
							'name' => __( 'Padding', 'perch' ),
							'desc' => __( 'Adjust the padding for inline content (in pixels)', 'perch' )
						),
						'text_align' => array(
							'type' => 'select',
							'values' => array(
								'left'   => __( 'Left', 'perch' ),
								'center' => __( 'Center', 'perch' ),
								'right'  => __( 'Right', 'perch' )
							),
							'default' => 'center',
							'name' => __( 'Text alignment', 'perch' ),
							'desc' => __( 'Select the text alignment', 'perch' )
						),
						'background' => array(
							'type' => 'color',
							'default' => '#FFFFFF',
							'name' => __( 'Background color', 'perch' ),
							'desc' => __( 'Pick a background color', 'perch' )
						),
						'color' => array(
							'type' => 'color',
							'default' => '#333333',
							'name' => __( 'Text color', 'perch' ),
							'desc' => __( 'Pick a text color', 'perch' )
						),
						'color' => array(
							'type' => 'color',
							'default' => '#333333',
							'name' => __( 'Text color', 'perch' ),
							'desc' => __( 'Pick a text color', 'perch' )
						),
						'shadow' => array(
							'type' => 'shadow',
							'default' => '0px 0px 15px #333333',
							'name' => __( 'Shadow', 'perch' ),
							'desc' => __( 'Adjust the shadow for content box', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'content' => __( 'Inline content', 'perch' ),
					'desc' => __( 'Inline content for lightbox', 'perch' ),
					'icon' => 'external-link'
				),
				// tooltip
				'tooltip' => array(
					'name' => __( 'Tooltip', 'perch' ),
					'type' => 'wrap',
					'group' => 'other',
					'atts' => array(
						'style' => array(
							'type' => 'select',
							'values' => array(
								'light' => __( 'Basic: Light', 'perch' ),
								'dark' => __( 'Basic: Dark', 'perch' ),
								'yellow' => __( 'Basic: Yellow', 'perch' ),
								'green' => __( 'Basic: Green', 'perch' ),
								'red' => __( 'Basic: Red', 'perch' ),
								'blue' => __( 'Basic: Blue', 'perch' ),
								'youtube' => __( 'Youtube', 'perch' ),
								'tipsy' => __( 'Tipsy', 'perch' ),
								'bootstrap' => __( 'Bootstrap', 'perch' ),
								'jtools' => __( 'jTools', 'perch' ),
								'tipped' => __( 'Tipped', 'perch' ),
								'cluetip' => __( 'Cluetip', 'perch' ),
							),
							'default' => 'yellow',
							'name' => __( 'Style', 'perch' ),
							'desc' => __( 'Tooltip window style', 'perch' )
						),
						'position' => array(
							'type' => 'select',
							'values' => array(
								'north' => __( 'Top', 'perch' ),
								'south' => __( 'Bottom', 'perch' ),
								'west' => __( 'Left', 'perch' ),
								'east' => __( 'Right', 'perch' )
							),
							'default' => 'top',
							'name' => __( 'Position', 'perch' ),
							'desc' => __( 'Tooltip position', 'perch' )
						),
						'shadow' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Shadow', 'perch' ),
							'desc' => __( 'Add shadow to tooltip. This option is only works with basic styes, e.g. blue, green etc.', 'perch' )
						),
						'rounded' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Rounded corners', 'perch' ),
							'desc' => __( 'Use rounded for tooltip. This option is only works with basic styes, e.g. blue, green etc.', 'perch' )
						),
						'size' => array(
							'type' => 'select',
							'values' => array(
								'default' => __( 'Default', 'perch' ),
								'1' => 1,
								'2' => 2,
								'3' => 3,
								'4' => 4,
								'5' => 5,
								'6' => 6,
							),
							'default' => 'default',
							'name' => __( 'Font size', 'perch' ),
							'desc' => __( 'Tooltip font size', 'perch' )
						),
						'title' => array(
							'default' => '',
							'name' => __( 'Tooltip title', 'perch' ),
							'desc' => __( 'Enter title for tooltip window. Leave this field empty to hide the title', 'perch' )
						),
						'content' => array(
							'default' => __( 'Tooltip text', 'perch' ),
							'name' => __( 'Tooltip content', 'perch' ),
							'desc' => __( 'Enter tooltip content here', 'perch' )
						),
						'behavior' => array(
							'type' => 'select',
							'values' => array(
								'hover' => __( 'Show and hide on mouse hover', 'perch' ),
								'click' => __( 'Show and hide by mouse click', 'perch' ),
								'always' => __( 'Always visible', 'perch' )
							),
							'default' => 'hover',
							'name' => __( 'Behavior', 'perch' ),
							'desc' => __( 'Select tooltip behavior', 'perch' )
						),
						'close' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Close button', 'perch' ),
							'desc' => __( 'Show close button', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'content' => __( '[%prefix_button] Hover me to open tooltip [/%prefix_button]', 'perch' ),
					'desc' => __( 'Tooltip window with custom content', 'perch' ),
					'icon' => 'comment-o'
				),
				// private
				'private' => array(
					'name' => __( 'Private', 'perch' ),
					'type' => 'wrap',
					'group' => 'other',
					'atts' => array(
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'content' => __( 'Private note text', 'perch' ),
					'desc' => __( 'Private note for post authors', 'perch' ),
					'icon' => 'lock'
				),
				// youtube
				'youtube' => array(
					'name' => __( 'YouTube', 'perch' ),
					'type' => 'single',
					'group' => 'media',
					'atts' => array(
						'url' => array(
							'values' => array( ),
							'default' => '',
							'name' => __( 'Url', 'perch' ),
							'desc' => __( 'Url of YouTube page with video. Ex: http://youtube.com/watch?v=XXXXXX', 'perch' )
						),
						'width' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 600,
							'name' => __( 'Width', 'perch' ),
							'desc' => __( 'Player width', 'perch' )
						),
						'height' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 400,
							'name' => __( 'Height', 'perch' ),
							'desc' => __( 'Player height', 'perch' )
						),
						'responsive' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Responsive', 'perch' ),
							'desc' => __( 'Ignore width and height parameters and make player responsive', 'perch' )
						),
						'autoplay' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Autoplay', 'perch' ),
							'desc' => __( 'Play video automatically when page is loaded', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'desc' => __( 'YouTube video', 'perch' ),
					'example' => 'media',
					'icon' => 'youtube-play'
				),
				// youtube_advanced
				'youtube_advanced' => array(
					'name' => __( 'YouTube Advanced', 'perch' ),
					'type' => 'single',
					'group' => 'media',
					'atts' => array(
						'url' => array(
							'values' => array( ),
							'default' => '',
							'name' => __( 'Url', 'perch' ),
							'desc' => __( 'Url of YouTube page with video. Ex: http://youtube.com/watch?v=XXXXXX', 'perch' )
						),
						'playlist' => array(
							'default' => '',
							'name' => __( 'Playlist', 'perch' ),
							'desc' => __( 'Value is a comma-separated list of video IDs to play. If you specify a value, the first video that plays will be the VIDEO_ID specified in the URL path, and the videos specified in the playlist parameter will play thereafter', 'perch' )
						),
						'width' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 600,
							'name' => __( 'Width', 'perch' ),
							'desc' => __( 'Player width', 'perch' )
						),
						'height' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 400,
							'name' => __( 'Height', 'perch' ),
							'desc' => __( 'Player height', 'perch' )
						),
						'responsive' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Responsive', 'perch' ),
							'desc' => __( 'Ignore width and height parameters and make player responsive', 'perch' )
						),
						'controls' => array(
							'type' => 'select',
							'values' => array(
								'no' => __( '0 - Hide controls', 'perch' ),
								'yes' => __( '1 - Show controls', 'perch' ),
								'alt' => __( '2 - Show controls when playback is started', 'perch' )
							),
							'default' => 'yes',
							'name' => __( 'Controls', 'perch' ),
							'desc' => __( 'This parameter indicates whether the video player controls will display', 'perch' )
						),
						'autohide' => array(
							'type' => 'select',
							'values' => array(
								'no' => __( '0 - Do not hide controls', 'perch' ),
								'yes' => __( '1 - Hide all controls on mouse out', 'perch' ),
								'alt' => __( '2 - Hide progress bar on mouse out', 'perch' )
							),
							'default' => 'alt',
							'name' => __( 'Autohide', 'perch' ),
							'desc' => __( 'This parameter indicates whether the video controls will automatically hide after a video begins playing', 'perch' )
						),
						'showinfo' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Show title bar', 'perch' ),
							'desc' => __( 'If you set the parameter value to NO, then the player will not display information like the video title and uploader before the video starts playing.', 'perch' )
						),
						'autoplay' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Autoplay', 'perch' ),
							'desc' => __( 'Play video automatically when page is loaded', 'perch' )
						),
						'loop' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Loop', 'perch' ),
							'desc' => __( 'Setting of YES will cause the player to play the initial video again and again', 'perch' )
						),
						'rel' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Related videos', 'perch' ),
							'desc' => __( 'This parameter indicates whether the player should show related videos when playback of the initial video ends', 'perch' )
						),
						'fs' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Show full-screen button', 'perch' ),
							'desc' => __( 'Setting this parameter to NO prevents the fullscreen button from displaying', 'perch' )
						),
						'modestbranding' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => 'modestbranding',
							'desc' => __( 'This parameter lets you use a YouTube player that does not show a YouTube logo. Set the parameter value to YES to prevent the YouTube logo from displaying in the control bar. Note that a small YouTube text label will still display in the upper-right corner of a paused video when the user\'s mouse pointer hovers over the player', 'perch' )
						),
						'theme' => array(
							'type' => 'select',
							'values' => array(
								'dark' => __( 'Dark theme', 'perch' ),
								'light' => __( 'Light theme', 'perch' )
							),
							'default' => 'dark',
							'name' => __( 'Theme', 'perch' ),
							'desc' => __( 'This parameter indicates whether the embedded player will display player controls (like a play button or volume control) within a dark or light control bar', 'perch' )
						),
						'https' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Force HTTPS', 'perch' ),
							'desc' => __( 'Use HTTPS in player iframe', 'perch' )
						),
						'wmode' => array(
							'default' => '',
							'name'    => __( 'WMode', 'perch' ),
							'desc'    => sprintf( __( 'Here you can specify wmode value for the embed URL. %s Example values: %s, %s', 'perch' ), '<br>', '<b%value>transparent</b>', '<b%value>opaque</b>' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'desc' => __( 'YouTube video player with advanced settings', 'perch' ),
					'example' => 'media',
					'icon' => 'youtube-play'
				),
				// vimeo
				'vimeo' => array(
					'name' => __( 'Vimeo', 'perch' ),
					'type' => 'single',
					'group' => 'media',
					'atts' => array(
						'url' => array(
							'values' => array( ),
							'default' => '',
							'name' => __( 'Url', 'perch' ), 'desc' => __( 'Url of Vimeo page with video', 'perch' )
						),
						'width' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 600,
							'name' => __( 'Width', 'perch' ),
							'desc' => __( 'Player width', 'perch' )
						),
						'height' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 400,
							'name' => __( 'Height', 'perch' ),
							'desc' => __( 'Player height', 'perch' )
						),
						'responsive' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Responsive', 'perch' ),
							'desc' => __( 'Ignore width and height parameters and make player responsive', 'perch' )
						),
						'autoplay' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Autoplay', 'perch' ),
							'desc' => __( 'Play video automatically when page is loaded', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'desc' => __( 'Vimeo video', 'perch' ),
					'example' => 'media',
					'icon' => 'youtube-play'
				),
				// screenr
				'screenr' => array(
					'name' => __( 'Screenr', 'perch' ),
					'type' => 'single',
					'group' => 'media',
					'atts' => array(
						'url' => array(
							'default' => '',
							'name' => __( 'Url', 'perch' ),
							'desc' => __( 'Url of Screenr page with video', 'perch' )
						),
						'width' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 600,
							'name' => __( 'Width', 'perch' ),
							'desc' => __( 'Player width', 'perch' )
						),
						'height' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 400,
							'name' => __( 'Height', 'perch' ),
							'desc' => __( 'Player height', 'perch' )
						),
						'responsive' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Responsive', 'perch' ),
							'desc' => __( 'Ignore width and height parameters and make player responsive', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'desc' => __( 'Screenr video', 'perch' ),
					'icon' => 'youtube-play'
				),
				// dailymotion
				'dailymotion' => array(
					'name' => __( 'Dailymotion', 'perch' ),
					'type' => 'single',
					'group' => 'media',
					'atts' => array(
						'url' => array(
							'default' => '',
							'name' => __( 'Url', 'perch' ),
							'desc' => __( 'Url of Dailymotion page with video', 'perch' )
						),
						'width' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 600,
							'name' => __( 'Width', 'perch' ),
							'desc' => __( 'Player width', 'perch' )
						),
						'height' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 400,
							'name' => __( 'Height', 'perch' ),
							'desc' => __( 'Player height', 'perch' )
						),
						'responsive' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Responsive', 'perch' ),
							'desc' => __( 'Ignore width and height parameters and make player responsive', 'perch' )
						),
						'autoplay' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Autoplay', 'perch' ),
							'desc' => __( 'Start the playback of the video automatically after the player load. May not work on some mobile OS versions', 'perch' )
						),
						'background' => array(
							'type' => 'color',
							'default' => '#FFC300',
							'name' => __( 'Background color', 'perch' ),
							'desc' => __( 'HTML color of the background of controls elements', 'perch' )
						),
						'foreground' => array(
							'type' => 'color',
							'default' => '#F7FFFD',
							'name' => __( 'Foreground color', 'perch' ),
							'desc' => __( 'HTML color of the foreground of controls elements', 'perch' )
						),
						'highlight' => array(
							'type' => 'color',
							'default' => '#171D1B',
							'name' => __( 'Highlight color', 'perch' ),
							'desc' => __( 'HTML color of the controls elements\' highlights', 'perch' )
						),
						'logo' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Show logo', 'perch' ),
							'desc' => __( 'Allows to hide or show the Dailymotion logo', 'perch' )
						),
						'quality' => array(
							'type' => 'select',
							'values' => array(
								'240'  => '240',
								'380'  => '380',
								'480'  => '480',
								'720'  => '720',
								'1080' => '1080'
							),
							'default' => '380',
							'name' => __( 'Quality', 'perch' ),
							'desc' => __( 'Determines the quality that must be played by default if available', 'perch' )
						),
						'related' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Show related videos', 'perch' ),
							'desc' => __( 'Show related videos at the end of the video', 'perch' )
						),
						'info' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Show video info', 'perch' ),
							'desc' => __( 'Show videos info (title/author) on the start screen', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'desc' => __( 'Dailymotion video', 'perch' ),
					'icon' => 'youtube-play'
				),
				// audio
				'audio' => array(
					'name' => __( 'Audio', 'perch' ),
					'type' => 'single',
					'group' => 'media',
					'atts' => array(
						'url' => array(
							'type' => 'upload',
							'default' => '',
							'name' => __( 'File', 'perch' ),
							'desc' => __( 'Audio file url. Supported formats: mp3, ogg', 'perch' )
						),
						'width' => array(
							'values' => array(),
							'default' => '100%',
							'name' => __( 'Width', 'perch' ),
							'desc' => __( 'Player width. You can specify width in percents and player will be responsive. Example values: <b%value>200px</b>, <b%value>100&#37;</b>', 'perch' )
						),
						'autoplay' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Autoplay', 'perch' ),
							'desc' => __( 'Play file automatically when page is loaded', 'perch' )
						),
						'loop' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Loop', 'perch' ),
							'desc' => __( 'Repeat when playback is ended', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'desc' => __( 'Custom audio player', 'perch' ),
					'example' => 'media',
					'icon' => 'play-circle'
				),
				// video
				'video' => array(
					'name' => __( 'Video', 'perch' ),
					'type' => 'single',
					'group' => 'media',
					'atts' => array(
						'url' => array(
							'type' => 'upload',
							'default' => '',
							'name' => __( 'File', 'perch' ),
							'desc' => __( 'Url to mp4/flv video-file', 'perch' )
						),
						'poster' => array(
							'type' => 'upload',
							'default' => '',
							'name' => __( 'Poster', 'perch' ),
							'desc' => __( 'Url to poster image, that will be shown before playback', 'perch' )
						),
						'title' => array(
							'values' => array( ),
							'default' => '',
							'name' => __( 'Title', 'perch' ),
							'desc' => __( 'Player title', 'perch' )
						),
						'width' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 600,
							'name' => __( 'Width', 'perch' ),
							'desc' => __( 'Player width', 'perch' )
						),
						'height' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 300,
							'name' => __( 'Height', 'perch' ),
							'desc' => __( 'Player height', 'perch' )
						),
						'controls' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Controls', 'perch' ),
							'desc' => __( 'Show player controls (play/pause etc.) or not', 'perch' )
						),
						'autoplay' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Autoplay', 'perch' ),
							'desc' => __( 'Play file automatically when page is loaded', 'perch' )
						),
						'loop' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Loop', 'perch' ),
							'desc' => __( 'Repeat when playback is ended', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'desc' => __( 'Custom video player', 'perch' ),
					'example' => 'media',
					'icon' => 'play-circle'
				),
				// table
				'table' => array(
					'name' => __( 'Table', 'perch' ),
					'type' => 'mixed',
					'group' => 'content',
					'atts' => array(
						'style' => array(
							'type' => 'select',
							'values' => array(
								'default' => __( 'Default', 'perch' ),
								'2' => __( 'Style 2', 'perch' ),
							),
							'default' => 'default',
							'name' => __( 'Style', 'perch' ),
							'desc' => __( 'Choose style for this heading', 'perch' ) 
						),
						'url' => array(
							'type' => 'upload',
							'default' => '',
							'name' => __( 'CSV file', 'perch' ),
							'desc' => __( 'Upload CSV file if you want to create HTML-table from file', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'content' => __( "<table>\n<tr>\n\t<th>Table</th>\n\t<th>Table</th>\n</tr>\n<tr>\n\t<td>Table</td>\n\t<td>Table</td>\n</tr>\n</table>", 'perch' ),
					'desc' => __( 'Styled table from HTML or CSV file', 'perch' ),
					'icon' => 'table'
				),
				// permalink
				'permalink' => array(
					'name' => __( 'Permalink', 'perch' ),
					'type' => 'mixed',
					'group' => 'content other',
					'atts' => array(
						'id' => array(
							'values' => array( ), 'default' => 1,
							'name' => __( 'ID', 'perch' ),
							'desc' => __( 'Post or page ID', 'perch' )
						),
						'target' => array(
							'type' => 'select',
							'values' => array(
								'self' => __( 'Same tab', 'perch' ),
								'blank' => __( 'New tab', 'perch' )
							),
							'default' => 'self',
							'name' => __( 'Target', 'perch' ),
							'desc' => __( 'Link target. blank - link will be opened in new window/tab', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'content' => '',
					'desc' => __( 'Permalink to specified post/page', 'perch' ),
					'icon' => 'link'
				),
				// members
				'members' => array(
					'name' => __( 'Members', 'perch' ),
					'type' => 'wrap',
					'group' => 'other',
					'atts' => array(
						'message' => array(
							'default' => __( 'This content is for registered users only. Please %login%.', 'perch' ),
							'name' => __( 'Message', 'perch' ), 'desc' => __( 'Message for not logged users', 'perch' )
						),
						'color' => array(
							'type' => 'color',
							'default' => '#ffcc00',
							'name' => __( 'Box color', 'perch' ), 'desc' => __( 'This color will applied only to box for not logged users', 'perch' )
						),
						'login_text' => array(
							'default' => __( 'login', 'perch' ),
							'name' => __( 'Login link text', 'perch' ), 'desc' => __( 'Text for the login link', 'perch' )
						),
						'login_url' => array(
							'default' => wp_login_url(),
							'name' => __( 'Login link url', 'perch' ), 'desc' => __( 'Login link url', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'content' => __( 'Content for logged members', 'perch' ),
					'desc' => __( 'Content for logged in members only', 'perch' ),
					'icon' => 'lock'
				),
				// guests
				'guests' => array(
					'name' => __( 'Guests', 'perch' ),
					'type' => 'wrap',
					'group' => 'other',
					'atts' => array(
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'content' => __( 'Content for guests', 'perch' ),
					'desc' => __( 'Content for guests only', 'perch' ),
					'icon' => 'user'
				),
				// feed
				'feed' => array(
					'name' => __( 'RSS Feed', 'perch' ),
					'type' => 'single',
					'group' => 'content other',
					'atts' => array(
						'url' => array(
							'values' => array( ),
							'default' => '',
							'name' => __( 'Url', 'perch' ),
							'desc' => __( 'Url to RSS-feed', 'perch' )
						),
						'limit' => array(
							'type' => 'slider',
							'min' => 1,
							'max' => 20,
							'step' => 1,
							'default' => 3,
							'name' => __( 'Limit', 'perch' ), 'desc' => __( 'Number of items to show', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'desc' => __( 'Feed grabber', 'perch' ),
					'icon' => 'rss'
				),
				// menu
				'menu' => array(
					'name' => __( 'Menu', 'perch' ),
					'type' => 'single',
					'group' => 'other',
					'atts' => array(
						'name' => array(
							'values' => array( ),
							'default' => '',
							'name' => __( 'Menu name', 'perch' ), 'desc' => __( 'Custom menu name. Ex: Main menu', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'desc' => __( 'Custom menu by name', 'perch' ),
					'icon' => 'bars'
				),
				// subpages
				'subpages' => array(
					'name' => __( 'Sub pages', 'perch' ),
					'type' => 'single',
					'group' => 'other',
					'atts' => array(
						'depth' => array(
							'type' => 'select',
							'values' => array( 1, 2, 3, 4, 5 ), 'default' => 1,
							'name' => __( 'Depth', 'perch' ),
							'desc' => __( 'Max depth level of children pages', 'perch' )
						),
						'p' => array(
							'values' => array( ),
							'default' => '',
							'name' => __( 'Parent ID', 'perch' ),
							'desc' => __( 'ID of the parent page. Leave blank to use current page', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'desc' => __( 'List of sub pages', 'perch' ),
					'icon' => 'bars'
				),
				// siblings
				'siblings' => array(
					'name' => __( 'Siblings', 'perch' ),
					'type' => 'single',
					'group' => 'other',
					'atts' => array(
						'depth' => array(
							'type' => 'select',
							'values' => array( 1, 2, 3 ), 'default' => 1,
							'name' => __( 'Depth', 'perch' ),
							'desc' => __( 'Max depth level', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'desc' => __( 'List of cureent page siblings', 'perch' ),
					'icon' => 'bars'
				),
				// document
				'document' => array(
					'name' => __( 'Document', 'perch' ),
					'type' => 'single',
					'group' => 'media',
					'atts' => array(
						'url' => array(
							'type' => 'upload',
							'default' => '',
							'name' => __( 'Url', 'perch' ),
							'desc' => __( 'Url to uploaded document. Supported formats: doc, xls, pdf etc.', 'perch' )
						),
						'width' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 600,
							'name' => __( 'Width', 'perch' ),
							'desc' => __( 'Viewer width', 'perch' )
						),
						'height' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 600,
							'name' => __( 'Height', 'perch' ),
							'desc' => __( 'Viewer height', 'perch' )
						),
						'responsive' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Responsive', 'perch' ),
							'desc' => __( 'Ignore width and height parameters and make viewer responsive', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'desc' => __( 'Document viewer by Google', 'perch' ),
					'icon' => 'file-text'
				),
				// gmap
				'map' => array(
					'name' => __( 'MAP', 'perch' ),
					'type' => 'single',
					'group' => 'media',
					'atts' => array(
						
						'latitude' => array(
							'values' => '',
							'default' => '51.507207',
							'name' => __( 'Latitude', 'perch' ),
							'desc' => __( 'Get Latitude value from this <a href="http://universimmedia.pagesperso-orange.fr/geo/loc.htm" target="_blank">site</a>.', 'perch' )
						),
						'longitude' => array(
							'default' => '-0.127223',
							'name' => __( 'Longitude', 'perch' ),
							'desc' => __( 'Get Longitude value from this <a href="http://universimmedia.pagesperso-orange.fr/geo/loc.htm" target="_blank">site</a>.', 'perch' )
						),
						'height' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 10,
							'default' => 500,
							'name' => __( 'Height', 'perch' ),
							'desc' => __( 'Map height', 'perch' )
						),
						'zoom' => array(
							'type' => 'slider',
							'min' => 3,
							'max' => 40,
							'step' => 1,
							'default' => 12,
							'name' => __( 'Zoom', 'perch' ),
							'desc' => __( 'Map height', 'perch' )
						),
						'marker' => array(
							'type' => 'upload',
							'default' => plugins_url( 'assets/images/map-marker.png', TP_PLUGIN_FILE ),
							'name' => __( 'Map Marker', 'perch' ),
							'desc' => ''
						),
					),
					'desc' => __( 'Maps by Google', 'perch' ),
					'icon' => 'map-marker'
				),
				// gmap
				'gmap' => array(
					'name' => __( 'Gmap', 'perch' ),
					'type' => 'single',
					'group' => 'media',
					'atts' => array(
						'width' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 600,
							'name' => __( 'Width', 'perch' ),
							'desc' => __( 'Map width', 'perch' )
						),
						'height' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 400,
							'name' => __( 'Height', 'perch' ),
							'desc' => __( 'Map height', 'perch' )
						),
						'responsive' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Responsive', 'perch' ),
							'desc' => __( 'Ignore width and height parameters and make map responsive', 'perch' )
						),
						'address' => array(
							'values' => array( ),
							'default' => '',
							'name' => __( 'Marker', 'perch' ),
							'desc' => __( 'Address for the marker. You can type it in any language', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'desc' => __( 'Maps by Google', 'perch' ),
					'icon' => 'globe'
				),
				// slider
				'slider' => array(
					'name' => __( 'Slider', 'perch' ),
					'type' => 'single',
					'group' => 'gallery',
					'atts' => array(
						'source' => array(
							'type'    => 'image_source',
							'default' => 'none',
							'name'    => __( 'Source', 'perch' ),
							'desc'    => __( 'Choose images source. You can use images from Media library or retrieve it from posts (thumbnails) posted under specified blog category. You can also pick any custom taxonomy', 'perch' )
						),
						'limit' => array(
							'type' => 'slider',
							'min' => -1,
							'max' => 100,
							'step' => 1,
							'default' => 20,
							'name' => __( 'Limit', 'perch' ),
							'desc' => __( 'Maximum number of image source posts (for recent posts, category and custom taxonomy)', 'perch' )
						),
						'link' => array(
							'type' => 'select',
							'values' => array(
								'none'       => __( 'None', 'perch' ),
								'image'      => __( 'Full-size image', 'perch' ),
								'lightbox'   => __( 'Lightbox', 'perch' ),
								'custom'     => __( 'Slide link (added in media editor)', 'perch' ),
								'attachment' => __( 'Attachment page', 'perch' ),
								'post'       => __( 'Post permalink', 'perch' )
							),
							'default' => 'none',
							'name' => __( 'Links', 'perch' ),
							'desc' => __( 'Select which links will be used for images in this gallery', 'perch' )
						),
						'target' => array(
							'type' => 'select',
							'values' => array(
								'self' => __( 'Same window', 'perch' ),
								'blank' => __( 'New window', 'perch' )
							),
							'default' => 'self',
							'name' => __( 'Links target', 'perch' ),
							'desc' => __( 'Open links in', 'perch' )
						),
						'width' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 600,
							'name' => __( 'Width', 'perch' ), 'desc' => __( 'Slider width (in pixels)', 'perch' )
						),
						'height' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 300,
							'name' => __( 'Height', 'perch' ), 'desc' => __( 'Slider height (in pixels)', 'perch' )
						),
						'responsive' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Responsive', 'perch' ),
							'desc' => __( 'Ignore width and height parameters and make slider responsive', 'perch' )
						),
						'title' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Show titles', 'perch' ), 'desc' => __( 'Display slide titles', 'perch' )
						),
						'centered' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Center', 'perch' ), 'desc' => __( 'Is slider centered on the page', 'perch' )
						),
						'arrows' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Arrows', 'perch' ), 'desc' => __( 'Show left and right arrows', 'perch' )
						),
						'pages' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Pagination', 'perch' ),
							'desc' => __( 'Show pagination', 'perch' )
						),
						'mousewheel' => array(
							'type' => 'bool',
							'default' => 'yes', 'name' => __( 'Mouse wheel control', 'perch' ),
							'desc' => __( 'Allow to change slides with mouse wheel', 'perch' )
						),
						'autoplay' => array(
							'type' => 'number',
							'min' => 0,
							'max' => 100000,
							'step' => 100,
							'default' => 5000,
							'name' => __( 'Autoplay', 'perch' ),
							'desc' => __( 'Choose interval between slide animations. Set to 0 to disable autoplay', 'perch' )
						),
						'speed' => array(
							'type' => 'number',
							'min' => 0,
							'max' => 20000,
							'step' => 100,
							'default' => 600,
							'name' => __( 'Speed', 'perch' ), 'desc' => __( 'Specify animation speed', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'desc' => __( 'Customizable image slider', 'perch' ),
					'icon' => 'picture-o'
				),
				// carousel
				'carousel' => array(
					'name' => __( 'Carousel', 'perch' ),
					'type' => 'single',
					'group' => 'gallery',
					'atts' => array(
						'source' => array(
							'type'    => 'image_source',
							'default' => 'none',
							'name'    => __( 'Source', 'perch' ),
							'desc'    => __( 'Choose images source. You can use images from Media library or retrieve it from posts (thumbnails) posted under specified blog category. You can also pick any custom taxonomy', 'perch' )
						),
						'limit' => array(
							'type' => 'slider',
							'min' => -1,
							'max' => 100,
							'step' => 1,
							'default' => 20,
							'name' => __( 'Limit', 'perch' ),
							'desc' => __( 'Maximum number of image source posts (for recent posts, category and custom taxonomy)', 'perch' )
						),
						'link' => array(
							'type' => 'select',
							'values' => array(
								'none'       => __( 'None', 'perch' ),
								'image'      => __( 'Full-size image', 'perch' ),
								'lightbox'   => __( 'Lightbox', 'perch' ),
								'custom'     => __( 'Slide link (added in media editor)', 'perch' ),
								'attachment' => __( 'Attachment page', 'perch' ),
								'post'       => __( 'Post permalink', 'perch' )
							),
							'default' => 'none',
							'name' => __( 'Links', 'perch' ),
							'desc' => __( 'Select which links will be used for images in this gallery', 'perch' )
						),
						'target' => array(
							'type' => 'select',
							'values' => array(
								'self' => __( 'Same window', 'perch' ),
								'blank' => __( 'New window', 'perch' )
							),
							'default' => 'self',
							'name' => __( 'Links target', 'perch' ),
							'desc' => __( 'Open links in', 'perch' )
						),
						'width' => array(
							'type' => 'slider',
							'min' => 100,
							'max' => 1600,
							'step' => 20,
							'default' => 600,
							'name' => __( 'Width', 'perch' ),
							'desc' => __( 'Carousel width (in pixels)', 'perch' )
						),
						'height' => array(
							'type' => 'slider',
							'min' => 20,
							'max' => 1600,
							'step' => 20,
							'default' => 100,
							'name' => __( 'Height', 'perch' ),
							'desc' => __( 'Carousel height (in pixels)', 'perch' )
						),
						'responsive' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Responsive', 'perch' ),
							'desc' => __( 'Ignore width and height parameters and make carousel responsive', 'perch' )
						),
						'items' => array(
							'type' => 'number',
							'min' => 1,
							'max' => 20,
							'step' => 1,
							'default' => 3,
							'name' => __( 'Items to show', 'perch' ),
							'desc' => __( 'How much carousel items is visible', 'perch' )
						),
						'scroll' => array(
							'type' => 'number',
							'min' => 1,
							'max' => 20,
							'step' => 1, 'default' => 1,
							'name' => __( 'Scroll number', 'perch' ),
							'desc' => __( 'How much items are scrolled in one transition', 'perch' )
						),
						'title' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Show titles', 'perch' ), 'desc' => __( 'Display titles for each item', 'perch' )
						),
						'centered' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Center', 'perch' ), 'desc' => __( 'Is carousel centered on the page', 'perch' )
						),
						'arrows' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Arrows', 'perch' ), 'desc' => __( 'Show left and right arrows', 'perch' )
						),
						'pages' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Pagination', 'perch' ),
							'desc' => __( 'Show pagination', 'perch' )
						),
						'mousewheel' => array(
							'type' => 'bool',
							'default' => 'yes', 'name' => __( 'Mouse wheel control', 'perch' ),
							'desc' => __( 'Allow to rotate carousel with mouse wheel', 'perch' )
						),
						'autoplay' => array(
							'type' => 'number',
							'min' => 0,
							'max' => 100000,
							'step' => 100,
							'default' => 5000,
							'name' => __( 'Autoplay', 'perch' ),
							'desc' => __( 'Choose interval between auto animations. Set to 0 to disable autoplay', 'perch' )
						),
						'speed' => array(
							'type' => 'number',
							'min' => 0,
							'max' => 20000,
							'step' => 100,
							'default' => 600,
							'name' => __( 'Speed', 'perch' ), 'desc' => __( 'Specify animation speed', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'desc' => __( 'Customizable image carousel', 'perch' ),
					'icon' => 'picture-o'
				),
				// clients_carousel
				'clients_carousel' => array(
					'name' => __( 'Clients Carousel', 'perch' ),
					'type' => 'single',
					'group' => 'gallery',
					'atts' => array(
						'source' => array(
							'type'    => 'image_source',
							'default' => 'media',
							'name'    => __( 'Source', 'perch' ),
							'desc'    => __( 'Choose images source. You can use images from Media library or retrieve it from posts (thumbnails) posted under specified blog category. You can also pick any custom taxonomy', 'perch' )
						),
						'autoplay' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Autoplay', 'perch' ),
							'desc' => __( '', 'perch' )
						),
						'border_top' => array(
							'type' => 'bool',
							'default' => 'yes', 'name' => __( 'Border top', 'perch' ),
							'desc' => __( '', 'perch' )
						),
						'border_bottom' => array(
							'type' => 'bool',
							'default' => 'yes', 'name' => __( 'Border Bottom', 'perch' ),
							'desc' => __( '', 'perch' )
						),
						'item' => array(
							'type' => 'number',
							'min' => 1,
							'max' => 10,
							'step' => 1,
							'default' => 5,
							'name' => __( 'Carousel item show', 'perch' ),
							'desc' => __( '', 'perch' )
						),
					),
					'desc' => __( 'Customizable image carousel for client logo', 'perch' ),
					'icon' => 'picture-o'
				),
				// custom_gallery
				'custom_gallery' => array(
					'name' => __( 'Gallery', 'perch' ),
					'type' => 'single',
					'group' => 'gallery',
					'atts' => array(
						'source' => array(
							'type'    => 'image_source',
							'default' => 'none',
							'name'    => __( 'Source', 'perch' ),
							'desc'    => __( 'Choose images source. You can use images from Media library or retrieve it from posts (thumbnails) posted under specified blog category. You can also pick any custom taxonomy', 'perch' )
						),
						'limit' => array(
							'type' => 'slider',
							'min' => -1,
							'max' => 100,
							'step' => 1,
							'default' => 20,
							'name' => __( 'Limit', 'perch' ),
							'desc' => __( 'Maximum number of image source posts (for recent posts, category and custom taxonomy)', 'perch' )
						),
						'link' => array(
							'type' => 'select',
							'values' => array(
								'none'       => __( 'None', 'perch' ),
								'image'      => __( 'Full-size image', 'perch' ),
								'lightbox'   => __( 'Lightbox', 'perch' ),
								'custom'     => __( 'Slide link (added in media editor)', 'perch' ),
								'attachment' => __( 'Attachment page', 'perch' ),
								'post'       => __( 'Post permalink', 'perch' )
							),
							'default' => 'none',
							'name' => __( 'Links', 'perch' ),
							'desc' => __( 'Select which links will be used for images in this gallery', 'perch' )
						),
						'target' => array(
							'type' => 'select',
							'values' => array(
								'self' => __( 'Same window', 'perch' ),
								'blank' => __( 'New window', 'perch' )
							),
							'default' => 'self',
							'name' => __( 'Links target', 'perch' ),
							'desc' => __( 'Open links in', 'perch' )
						),
						'width' => array(
							'type' => 'slider',
							'min' => 10,
							'max' => 1600,
							'step' => 10,
							'default' => 90,
							'name' => __( 'Width', 'perch' ), 'desc' => __( 'Single item width (in pixels)', 'perch' )
						),
						'height' => array(
							'type' => 'slider',
							'min' => 10,
							'max' => 1600,
							'step' => 10,
							'default' => 90,
							'name' => __( 'Height', 'perch' ), 'desc' => __( 'Single item height (in pixels)', 'perch' )
						),
						'title' => array(
							'type' => 'select',
							'values' => array(
								'never' => __( 'Never', 'perch' ),
								'hover' => __( 'On mouse over', 'perch' ),
								'always' => __( 'Always', 'perch' )
							),
							'default' => 'hover',
							'name' => __( 'Show titles', 'perch' ),
							'desc' => __( 'Title display mode', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'desc' => __( 'Customizable image gallery', 'perch' ),
					'icon' => 'picture-o'
				),
				// posts
				'posts' => array(
					'name' => __( 'Posts', 'perch' ),
					'type' => 'single',
					'group' => 'other',
					'atts' => array(
						'template' => array(
							'default' => 'templates/default-loop.php', 'name' => __( 'Template', 'perch' ),
							'desc' => __( '<b>Do not change this field value if you do not understand description below.</b><br/>Relative path to the template file. Default templates is placed under the plugin directory (templates folder). You can copy it under your theme directory and modify as you want. You can use following default templates that already available in the plugin directory:<br/><b%value>templates/default-loop.php</b> - posts loop<br/><b%value>templates/masonary-loop.php</b> - posts loop with thumbnail and title<br/><b%value>templates/grid-loop.php</b> - Grid posts template<br/><b%value>templates/list-loop.php</b> - unordered list with posts titles', 'perch' )
						),						
						'id' => array(
							'default' => '',
							'name' => __( 'Post ID\'s', 'perch' ),
							'desc' => __( 'Enter comma separated ID\'s of the posts that you want to show', 'perch' )
						),
						'posts_per_page' => array(
							'type' => 'slider',
							'min' => -1,
							'max' => 100,
							'step' => 1,
							'default' => get_option( 'posts_per_page' ),
							'name' => __( 'Posts per page', 'perch' ),
							'desc' => __( 'Specify number of posts that you want to show. Enter -1 to get all posts', 'perch' ),
							'operator' => 'and',
							'condition' => ''
						),
						'large_box_posts' => array(
							'type' => 'slider',
							'min' => 0,
							'max' => 100,
							'step' => 1,
							'default' => 1,
							'name' => __( 'Large box posts', 'perch' ),
							'desc' => __( 'Specify number of Large box posts that you want to show. Enter -1 to get all posts', 'perch' ),
							'operator' => 'and',
							'condition' => 'template:is(templates/grid-loop.php)'
						),						
						'column' => array(
							'type' => 'slider',
							'min' => 2,
							'max' => 4,
							'step' => 1,
							'default' => 2,
							'name' => __( 'Small box Column', 'perch' ),
							'desc' => __( '', 'perch' ),
							'operator' => 'or',
							'condition' => 'template:is(templates/masonary-loop.php),template:is(templates/grid-loop.php)'
						),
						'post_type' => array(
							'type' => 'select',
							'multiple' => true,
							'values' => Tp_Tools::get_types(),
							'default' => 'post',
							'name' => __( 'Post types', 'perch' ),
							'desc' => __( 'Select post types. Hold Ctrl key to select multiple post types', 'perch' )
						),
						'taxonomy' => array(
							'type' => 'select',
							'values' => Tp_Tools::get_taxonomies(),
							'default' => 'category',
							'name' => __( 'Taxonomy', 'perch' ),
							'desc' => __( 'Select taxonomy to show posts from', 'perch' )
						),
						'tax_term' => array(
							'type' => 'select',
							'multiple' => true,
							'values' => Tp_Tools::get_terms( 'category' ),
							'default' => '',
							'name' => __( 'Terms', 'perch' ),
							'desc' => __( 'Select terms to show posts from', 'perch' )
						),
						'tax_operator' => array(
							'type' => 'select',
							'values' => array( 'IN', 'NOT IN', 'AND' ),
							'default' => 'IN', 'name' => __( 'Taxonomy term operator', 'perch' ),
							'desc' => __( 'IN - posts that have any of selected categories terms<br/>NOT IN - posts that is does not have any of selected terms<br/>AND - posts that have all selected terms', 'perch' )
						),
						// 'author' => array(
						// 	'type' => 'select',
						// 	'multiple' => true,
						// 	'values' => Tp_Tools::get_users(),
						// 	'default' => 'default',
						// 	'name' => __( 'Authors', 'perch' ),
						// 	'desc' => __( 'Choose the authors whose posts you want to show. Enter here comma-separated list of users (IDs). Example: 1,7,18', 'perch' )
						// ),
						'author' => array(
							'default' => '',
							'name' => __( 'Authors', 'perch' ),
							'desc' => __( 'Enter here comma-separated list of author\'s IDs. Example: 1,7,18', 'perch' )
						),
						'meta_key' => array(
							'default' => '',
							'name' => __( 'Meta key', 'perch' ),
							'desc' => __( 'Enter meta key name to show posts that have this key', 'perch' )
						),
						'offset' => array(
							'type' => 'number',
							'min' => 0,
							'max' => 10000,
							'step' => 1, 'default' => 0,
							'name' => __( 'Offset', 'perch' ),
							'desc' => __( 'Specify offset to start posts loop not from first post', 'perch' )
						),
						'order' => array(
							'type' => 'select',
							'values' => array(
								'desc' => __( 'Descending', 'perch' ),
								'asc' => __( 'Ascending', 'perch' )
							),
							'default' => 'DESC',
							'name' => __( 'Order', 'perch' ),
							'desc' => __( 'Posts order', 'perch' )
						),
						'orderby' => array(
							'type' => 'select',
							'values' => array(
								'none' => __( 'None', 'perch' ),
								'id' => __( 'Post ID', 'perch' ),
								'author' => __( 'Post author', 'perch' ),
								'title' => __( 'Post title', 'perch' ),
								'name' => __( 'Post slug', 'perch' ),
								'date' => __( 'Date', 'perch' ), 'modified' => __( 'Last modified date', 'perch' ),
								'parent' => __( 'Post parent', 'perch' ),
								'rand' => __( 'Random', 'perch' ), 'comment_count' => __( 'Comments number', 'perch' ),
								'menu_order' => __( 'Menu order', 'perch' ), 'meta_value' => __( 'Meta key values', 'perch' ),
							),
							'default' => 'date',
							'name' => __( 'Order by', 'perch' ),
							'desc' => __( 'Order posts by', 'perch' )
						),
						'post_parent' => array(
							'default' => '',
							'name' => __( 'Post parent', 'perch' ),
							'desc' => __( 'Show childrens of entered post (enter post ID)', 'perch' )
						),
						'post_status' => array(
							'type' => 'select',
							'values' => array(
								'publish' => __( 'Published', 'perch' ),
								'pending' => __( 'Pending', 'perch' ),
								'draft' => __( 'Draft', 'perch' ),
								'auto-draft' => __( 'Auto-draft', 'perch' ),
								'future' => __( 'Future post', 'perch' ),
								'private' => __( 'Private post', 'perch' ),
								'inherit' => __( 'Inherit', 'perch' ),
								'trash' => __( 'Trashed', 'perch' ),
								'any' => __( 'Any', 'perch' ),
							),
							'default' => 'publish',
							'name' => __( 'Post status', 'perch' ),
							'desc' => __( 'Show only posts with selected status', 'perch' )
						),
						'ignore_sticky_posts' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Ignore sticky', 'perch' ),
							'desc' => __( 'Select Yes to ignore posts that is sticked', 'perch' )
						),
						'pagination' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Pagination', 'perch' ),
							'desc' => __( '', 'perch' ),
							'operator' => 'and',
							'condition' => ''
						)
					),
					'desc' => __( 'Custom posts query with customizable template', 'perch' ),
					'icon' => 'th-list'
				),
				
				// dummy_text
				'dummy_text' => array(
					'name' => __( 'Dummy text', 'perch' ),
					'type' => 'single',
					'group' => 'content',
					'atts' => array(
						'what' => array(
							'type' => 'select',
							'values' => array(
								'paras' => __( 'Paragraphs', 'perch' ),
								'words' => __( 'Words', 'perch' ),
								'bytes' => __( 'Bytes', 'perch' ),
							),
							'default' => 'paras',
							'name' => __( 'What', 'perch' ),
							'desc' => __( 'What to generate', 'perch' )
						),
						'amount' => array(
							'type' => 'slider',
							'min' => 1,
							'max' => 100,
							'step' => 1,
							'default' => 1,
							'name' => __( 'Amount', 'perch' ),
							'desc' => __( 'How many items (paragraphs or words) to generate. Minimum words amount is 5', 'perch' )
						),
						'cache' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Cache', 'perch' ),
							'desc' => __( 'Generated text will be cached. Be careful with this option. If you disable it and insert many dummy_text shortcodes the page load time will be highly increased', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'desc' => __( 'Text placeholder', 'perch' ),
					'icon' => 'text-height'
				),
				// dummy_image
				'dummy_image' => array(
					'name' => __( 'Dummy image', 'perch' ),
					'type' => 'single',
					'group' => 'content',
					'atts' => array(
						'width' => array(
							'type' => 'slider',
							'min' => 10,
							'max' => 1600,
							'step' => 10,
							'default' => 500,
							'name' => __( 'Width', 'perch' ),
							'desc' => __( 'Image width', 'perch' )
						),
						'height' => array(
							'type' => 'slider',
							'min' => 10,
							'max' => 1600,
							'step' => 10,
							'default' => 300,
							'name' => __( 'Height', 'perch' ),
							'desc' => __( 'Image height', 'perch' )
						),
						'theme' => array(
							'type' => 'select',
							'values' => array(
								'any'       => __( 'Any', 'perch' ),
								'abstract'  => __( 'Abstract', 'perch' ),
								'animals'   => __( 'Animals', 'perch' ),
								'business'  => __( 'Business', 'perch' ),
								'cats'      => __( 'Cats', 'perch' ),
								'city'      => __( 'City', 'perch' ),
								'food'      => __( 'Food', 'perch' ),
								'nightlife' => __( 'Night life', 'perch' ),
								'fashion'   => __( 'Fashion', 'perch' ),
								'people'    => __( 'People', 'perch' ),
								'nature'    => __( 'Nature', 'perch' ),
								'sports'    => __( 'Sports', 'perch' ),
								'technics'  => __( 'Technics', 'perch' ),
								'transport' => __( 'Transport', 'perch' )
							),
							'default' => 'any',
							'name' => __( 'Theme', 'perch' ),
							'desc' => __( 'Select the theme for this image', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'desc' => __( 'Image placeholder with random image', 'perch' ),
					'icon' => 'picture-o'
				),
				// animate
				'animate' => array(
					'name' => __( 'Animation', 'perch' ),
					'type' => 'wrap',
					'group' => 'other',
					'atts' => array(
						'type' => array(
							'type' => 'select',
							'values' => array_combine( self::animations(), self::animations() ),
							'default' => 'bounceIn',
							'name' => __( 'Animation', 'perch' ),
							'desc' => __( 'Select animation type', 'perch' )
						),
						'duration' => array(
							'type' => 'slider',
							'min' => 0,
							'max' => 20,
							'step' => 0.5,
							'default' => 1,
							'name' => __( 'Duration', 'perch' ),
							'desc' => __( 'Animation duration (seconds)', 'perch' )
						),
						'delay' => array(
							'type' => 'slider',
							'min' => 0,
							'max' => 20,
							'step' => 0.5,
							'default' => 0,
							'name' => __( 'Delay', 'perch' ),
							'desc' => __( 'Animation delay (seconds)', 'perch' )
						),
						'inline' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Inline', 'perch' ),
							'desc' => __( 'This parameter determines what HTML tag will be used for animation wrapper. Turn this option to YES and animated element will be wrapped in SPAN instead of DIV. Useful for inline animations, like buttons', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'content' => __( 'Animated content', 'perch' ),
					'desc' => __( 'Wrapper for animation. Any nested element will be animated', 'perch' ),
					'example' => 'animations',
					'icon' => 'bolt'
				),
				// meta
				'meta' => array(
					'name' => __( 'Meta', 'perch' ),
					'type' => 'single',
					'group' => 'data',
					'atts' => array(
						'key' => array(
							'default' => '',
							'name' => __( 'Key', 'perch' ),
							'desc' => __( 'Meta key name', 'perch' )
						),
						'default' => array(
							'default' => '',
							'name' => __( 'Default', 'perch' ),
							'desc' => __( 'This text will be shown if data is not found', 'perch' )
						),
						'before' => array(
							'default' => '',
							'name' => __( 'Before', 'perch' ),
							'desc' => __( 'This content will be shown before the value', 'perch' )
						),
						'after' => array(
							'default' => '',
							'name' => __( 'After', 'perch' ),
							'desc' => __( 'This content will be shown after the value', 'perch' )
						),
						'post_id' => array(
							'default' => '',
							'name' => __( 'Post ID', 'perch' ),
							'desc' => __( 'You can specify custom post ID. Leave this field empty to use an ID of the current post. Current post ID may not work in Live Preview mode', 'perch' )
						),
						'filter' => array(
							'default' => '',
							'name' => __( 'Filter', 'perch' ),
							'desc' => __( 'You can apply custom filter to the retrieved value. Enter here function name. Your function must accept one argument and return modified value. Example function: ', 'perch' ) . "<br /><pre><code style='display:block;padding:5px'>function my_custom_filter( \$value ) {\n\treturn 'Value is: ' . \$value;\n}</code></pre>"
						)
					),
					'desc' => __( 'Post meta', 'perch' ),
					'icon' => 'info-circle'
				),
				// user
				'user' => array(
					'name' => __( 'User', 'perch' ),
					'type' => 'single',
					'group' => 'data',
					'atts' => array(
						'field' => array(
							'type' => 'select',
							'values' => array(
								'display_name'        => __( 'Display name', 'perch' ),
								'ID'                  => __( 'ID', 'perch' ),
								'user_login'          => __( 'Login', 'perch' ),
								'user_nicename'       => __( 'Nice name', 'perch' ),
								'user_email'          => __( 'Email', 'perch' ),
								'user_url'            => __( 'URL', 'perch' ),
								'user_registered'     => __( 'Registered', 'perch' ),
								'user_activation_key' => __( 'Activation key', 'perch' ),
								'user_status'         => __( 'Status', 'perch' )
							),
							'default' => 'display_name',
							'name' => __( 'Field', 'perch' ),
							'desc' => __( 'User data field name', 'perch' )
						),
						'default' => array(
							'default' => '',
							'name' => __( 'Default', 'perch' ),
							'desc' => __( 'This text will be shown if data is not found', 'perch' )
						),
						'before' => array(
							'default' => '',
							'name' => __( 'Before', 'perch' ),
							'desc' => __( 'This content will be shown before the value', 'perch' )
						),
						'after' => array(
							'default' => '',
							'name' => __( 'After', 'perch' ),
							'desc' => __( 'This content will be shown after the value', 'perch' )
						),
						'user_id' => array(
							'default' => '',
							'name' => __( 'User ID', 'perch' ),
							'desc' => __( 'You can specify custom user ID. Leave this field empty to use an ID of the current user', 'perch' )
						),
						'filter' => array(
							'default' => '',
							'name' => __( 'Filter', 'perch' ),
							'desc' => __( 'You can apply custom filter to the retrieved value. Enter here function name. Your function must accept one argument and return modified value. Example function: ', 'perch' ) . "<br /><pre><code style='display:block;padding:5px'>function my_custom_filter( \$value ) {\n\treturn 'Value is: ' . \$value;\n}</code></pre>"
						)
					),
					'desc' => __( 'User data', 'perch' ),
					'icon' => 'info-circle'
				),
				// post
				'post' => array(
					'name' => __( 'Post', 'perch' ),
					'type' => 'single',
					'group' => 'data',
					'atts' => array(
						'field' => array(
							'type' => 'select',
							'values' => array(
								'ID'                    => __( 'Post ID', 'perch' ),
								'post_author'           => __( 'Post author', 'perch' ),
								'post_date'             => __( 'Post date', 'perch' ),
								'post_date_gmt'         => __( 'Post date', 'perch' ) . ' GMT',
								'post_content'          => __( 'Post content', 'perch' ),
								'post_title'            => __( 'Post title', 'perch' ),
								'post_excerpt'          => __( 'Post excerpt', 'perch' ),
								'post_status'           => __( 'Post status', 'perch' ),
								'comment_status'        => __( 'Comment status', 'perch' ),
								'ping_status'           => __( 'Ping status', 'perch' ),
								'post_name'             => __( 'Post name', 'perch' ),
								'post_modified'         => __( 'Post modified', 'perch' ),
								'post_modified_gmt'     => __( 'Post modified', 'perch' ) . ' GMT',
								'post_content_filtered' => __( 'Filtered post content', 'perch' ),
								'post_parent'           => __( 'Post parent', 'perch' ),
								'guid'                  => __( 'GUID', 'perch' ),
								'menu_order'            => __( 'Menu order', 'perch' ),
								'post_type'             => __( 'Post type', 'perch' ),
								'post_mime_type'        => __( 'Post mime type', 'perch' ),
								'comment_count'         => __( 'Comment count', 'perch' )
							),
							'default' => 'post_title',
							'name' => __( 'Field', 'perch' ),
							'desc' => __( 'Post data field name', 'perch' )
						),
						'default' => array(
							'default' => '',
							'name' => __( 'Default', 'perch' ),
							'desc' => __( 'This text will be shown if data is not found', 'perch' )
						),
						'before' => array(
							'default' => '',
							'name' => __( 'Before', 'perch' ),
							'desc' => __( 'This content will be shown before the value', 'perch' )
						),
						'after' => array(
							'default' => '',
							'name' => __( 'After', 'perch' ),
							'desc' => __( 'This content will be shown after the value', 'perch' )
						),
						'post_id' => array(
							'default' => '',
							'name' => __( 'Post ID', 'perch' ),
							'desc' => __( 'You can specify custom post ID. Leave this field empty to use an ID of the current post. Current post ID may not work in Live Preview mode', 'perch' )
						),
						'filter' => array(
							'default' => '',
							'name' => __( 'Filter', 'perch' ),
							'desc' => __( 'You can apply custom filter to the retrieved value. Enter here function name. Your function must accept one argument and return modified value. Example function: ', 'perch' ) . "<br /><pre><code style='display:block;padding:5px'>function my_custom_filter( \$value ) {\n\treturn 'Value is: ' . \$value;\n}</code></pre>"
						)
					),
					'desc' => __( 'Post data', 'perch' ),
					'icon' => 'info-circle'
				),
				// post_terms
				// 'post_terms' => array(
				// 	'name' => __( 'Post terms', 'perch' ),
				// 	'type' => 'single',
				// 	'group' => 'data',
				// 	'atts' => array(
				// 		'post_id' => array(
				// 			'default' => '',
				// 			'name' => __( 'Post ID', 'perch' ),
				// 			'desc' => __( 'You can specify custom post ID. Leave this field empty to use an ID of the current post. Current post ID may not work in Live Preview mode', 'perch' )
				// 		),
				// 		'links' => array(
				// 			'type' => 'bool',
				// 			'default' => 'yes',
				// 			'name' => __( 'Show links', 'perch' ),
				// 			'desc' => __( 'Show terms names as hyperlinks', 'perch' )
				// 		),
				// 		'format' => array(
				// 			'type' => 'select',
				// 			'values' => array(
				// 				'text' => __( 'Terms separated by commas', 'perch' ),
				// 				'br' => __( 'Terms separated by new lines', 'perch' ),
				// 				'ul' => __( 'Unordered list', 'perch' ),
				// 				'ol' => __( 'Ordered list', 'perch' ),
				// 			),
				// 			'default' => 'text',
				// 			'name' => __( 'Format', 'perch' ),
				// 			'desc' => __( 'Choose how to output the terms', 'perch' )
				// 		),
				// 	),
				// 	'desc' => __( 'Terms list', 'perch' ),
				// 	'icon' => 'info-circle'
				// ),
				// template
				'template' => array(
					'name' => __( 'Template', 'perch' ),
					'type' => 'single',
					'group' => 'other',
					'atts' => array(
						'name' => array(
							'default' => '',
							'name' => __( 'Template name', 'perch' ),
							'desc' => sprintf( __( 'Use template file name (with optional .php extension). If you need to use templates from theme sub-folder, use relative path. Example values: %s, %s, %s', 'perch' ), '<b%value>page</b>', '<b%value>page.php</b>', '<b%value>includes/page.php</b>' )
						)
					),
					'desc' => __( 'Theme template', 'perch' ),
					'icon' => 'puzzle-piece'
				),
				// qrcode
				'qrcode' => array(
					'name' => __( 'QR code', 'perch' ),
					'type' => 'single',
					'group' => 'content',
					'atts' => array(
						'data' => array(
							'default' => '',
							'name' => __( 'Data', 'perch' ),
							'desc' => __( 'The text to store within the QR code. You can use here any text or even URL', 'perch' )
						),
						'title' => array(
							'default' => '',
							'name' => __( 'Title', 'perch' ),
							'desc' => __( 'Enter here short description. This text will be used in alt attribute of QR code', 'perch' )
						),
						'size' => array(
							'type' => 'slider',
							'min' => 10,
							'max' => 1000,
							'step' => 10,
							'default' => 200,
							'name' => __( 'Size', 'perch' ),
							'desc' => __( 'Image width and height (in pixels)', 'perch' )
						),
						'margin' => array(
							'type' => 'slider',
							'min' => 0,
							'max' => 50,
							'step' => 5,
							'default' => 0,
							'name' => __( 'Margin', 'perch' ),
							'desc' => __( 'Thickness of a margin (in pixels)', 'perch' )
						),
						'align' => array(
							'type' => 'select',
							'values' => array(
								'none' => __( 'None', 'perch' ),
								'left' => __( 'Left', 'perch' ),
								'center' => __( 'Center', 'perch' ),
								'right' => __( 'Right', 'perch' ),
							),
							'default' => 'none',
							'name' => __( 'Align', 'perch' ),
							'desc' => __( 'Choose image alignment', 'perch' )
						),
						'link' => array(
							'default' => '',
							'name' => __( 'Link', 'perch' ),
							'desc' => __( 'You can make this QR code clickable. Enter here the URL', 'perch' )
						),
						'target' => array(
							'type' => 'select',
							'values' => array(
								'self' => __( 'Open link in same window/tab', 'perch' ),
								'blank' => __( 'Open link in new window/tab', 'perch' ),
							),
							'default' => 'blank',
							'name' => __( 'Link target', 'perch' ),
							'desc' => __( 'Select link target', 'perch' )
						),
						'color' => array(
							'type' => 'color',
							'default' => '#000000',
							'name' => __( 'Primary color', 'perch' ),
							'desc' => __( 'Pick a primary color', 'perch' )
						),
						'background' => array(
							'type' => 'color',
							'default' => '#ffffff',
							'name' => __( 'Background color', 'perch' ),
							'desc' => __( 'Pick a background color', 'perch' )
						),
						'class' => array(
							'default' => '',
							'name' => __( 'Class', 'perch' ),
							'desc' => __( 'Extra CSS class', 'perch' )
						)
					),
					'desc' => __( 'Advanced QR code generator', 'perch' ),
					'icon' => 'qrcode'
				),
				// scheduler
				'scheduler' => array(
					'name' => __( 'Scheduler', 'perch' ),
					'type' => 'wrap',
					'group' => 'other',
					'atts' => array(
						'time' => array(
							'default' => '',
							'name' => __( 'Time', 'perch' ),
							'desc' => sprintf( __( 'In this field you can specify one or more time ranges. Every day at this time the content of shortcode will be visible. %s %s %s - show content from 9:00 to 18:00 %s - show content from 9:00 to 13:00 and from 14:00 to 18:00 %s - example with minutes (content will be visible each day, 45 minutes) %s - example with seconds', 'perch' ), '<br><br>', __( 'Examples (click to set)', 'perch' ), '<br><b%value>9-18</b>', '<br><b%value>9-13, 14-18</b>', '<br><b%value>9:30-10:15</b>', '<br><b%value>9:00:00-17:59:59</b>' )
						),
						'days_week' => array(
							'default' => '',
							'name' => __( 'Days of the week', 'perch' ),
							'desc' => sprintf( __( 'In this field you can specify one or more days of the week. Every week at these days the content of shortcode will be visible. %s 0 - Sunday %s 1 - Monday %s 2 - Tuesday %s 3 - Wednesday %s 4 - Thursday %s 5 - Friday %s 6 - Saturday %s %s %s - show content from Monday to Friday %s - show content only at Sunday %s - show content at Sunday and from Wednesday to Friday', 'perch' ), '<br><br>', '<br>', '<br>', '<br>', '<br>', '<br>', '<br>', '<br><br>', __( 'Examples (click to set)', 'perch' ), '<br><b%value>1-5</b>', '<br><b%value>0</b>', '<br><b%value>0, 3-5</b>' )
						),
						'days_month' => array(
							'default' => '',
							'name' => __( 'Days of the month', 'perch' ),
							'desc' => sprintf( __( 'In this field you can specify one or more days of the month. Every month at these days the content of shortcode will be visible. %s %s %s - show content only at first day of month %s - show content from 1th to 5th %s - show content from 10th to 15th and from 20th to 25th', 'perch' ), '<br><br>', __( 'Examples (click to set)', 'perch' ), '<br><b%value>1</b>', '<br><b%value>1-5</b>', '<br><b%value>10-15, 20-25</b>' )
						),
						'months' => array(
							'default' => '',
							'name' => __( 'Months', 'perch' ),
							'desc' => sprintf( __( 'In this field you can specify the month or months in which the content will be visible. %s %s %s - show content only in January %s - show content from February to June %s - show content in January, March and from May to July', 'perch' ), '<br><br>', __( 'Examples (click to set)', 'perch' ), '<br><b%value>1</b>', '<br><b%value>2-6</b>', '<br><b%value>1, 3, 5-7</b>' )
						),
						'years' => array(
							'default' => '',
							'name' => __( 'Years', 'perch' ),
							'desc' => sprintf( __( 'In this field you can specify the year or years in which the content will be visible. %s %s %s - show content only in 2014 %s - show content from 2014 to 2016 %s - show content in 2014, 2018 and from 2020 to 2022', 'perch' ), '<br><br>', __( 'Examples (click to set)', 'perch' ), '<br><b%value>2014</b>', '<br><b%value>2014-2016</b>', '<br><b%value>2014, 2018, 2020-2022</b>' )
						),
						'alt' => array(
							'default' => '',
							'name' => __( 'Alternative text', 'perch' ),
							'desc' => __( 'In this field you can type the text which will be shown if content is not visible at the current moment', 'perch' )
						)
					),
					'content' => __( 'Scheduled content', 'perch' ),
					'desc' => __( 'Allows to show the content only at the specified time period', 'perch' ),
					'note' => __( 'This shortcode allows you to show content only at the specified time.', 'perch' ) . '<br><br>' . __( 'Please pay special attention to the descriptions, which are located below each text field. It will save you a lot of time', 'perch' ) . '<br><br>' . __( 'By default, the content of this shortcode will be visible all the time. By using fields below, you can add some limitations. For example, if you type 1-5 in the Days of the week field, content will be only shown from Monday to Friday. Using the same principles, you can limit content visibility from years to seconds.', 'perch' ),
					'icon' => 'clock-o'
				),
			) );
			
			if(function_exists('is_woocommerce')):
			// products_carousel
			$shortcodes['products_carousel'] = array(
					'name' => __( 'Products carousel', 'perch' ),
					'type' => 'single',
					'group' => 'other',
					'atts' => array(
						'style' => array(
							'type' => 'select',
							'values' => array( 'default' => 'Default', '1' => 'style2' ),
							'default' => 'default', 'name' => __( 'Style', 'perch' ),
						),					
						'product_type' => array(
							'type' => 'select',
							'values' => array( 
								'all' => 'All Products', 
								'featured' => 'Featured products',
								'onsale' => 'On-sale products' 
								),
							'default' => 'all', 
							'name' => __( 'Product type', 'perch' ),
						),
						'posts_per_page' => array(
							'type' => 'number',
							'min' => -1,
							'max' => 10000,
							'step' => 1,
							'default' => get_option( 'posts_per_page' ),
							'name' => __( 'Posts per page', 'perch' ),
							'desc' => __( 'Specify number of products that you want to show. Enter -1 to get all posts', 'perch' )
						),
						'post_type' => array(
							'type' => 'select',
							'disabled' => true,
							'values' => Tp_Tools::get_types(),
							'default' => 'product',							
							'name' => __( 'Post types', 'perch' ),
							'desc' => __( 'Select post types. Hold Ctrl key to select multiple post types', 'perch' )
						),
						'taxonomy' => array(
							'type' => 'select',
							'values' => Tp_Tools::get_taxonomies(),
							'default' => 'product_cat',
							'disabled' => true,
							'name' => __( 'Taxonomy', 'perch' ),
							'desc' => __( 'Select taxonomy to show products from', 'perch' )
						),
						'tax_term' => array(
							'type' => 'select',
							'multiple' => true,
							'values' => Tp_Tools::get_terms( 'product_cat' ),
							'default' => '',
							'name' => __( 'Terms', 'perch' ),
							'desc' => __( 'Select terms to show posts from', 'perch' )
						),
						'tax_operator' => array(
							'type' => 'select',
							'values' => array( 'IN', 'NOT IN', 'AND' ),
							'default' => 'IN', 'name' => __( 'Taxonomy term operator', 'perch' ),
							'desc' => __( 'IN - posts that have any of selected categories terms<br/>NOT IN - posts that is does not have any of selected terms<br/>AND - posts that have all selected terms', 'perch' )
						),
						'offset' => array(
							'type' => 'number',
							'min' => 0,
							'max' => 10000,
							'step' => 1, 'default' => 0,
							'name' => __( 'Offset', 'perch' ),
							'desc' => __( 'Specify offset to start posts loop not from first post', 'perch' )
						),
						'order' => array(
							'type' => 'select',
							'values' => array(
								'desc' => __( 'Descending', 'perch' ),
								'asc' => __( 'Ascending', 'perch' )
							),
							'default' => 'DESC',
							'name' => __( 'Order', 'perch' ),
							'desc' => __( 'Posts order', 'perch' )
						),
						'orderby' => array(
							'type' => 'select',
							'values' => array(
								'none' => __( 'None', 'perch' ),
								'id' => __( 'Product ID', 'perch' ),
								'author' => __( 'Product author', 'perch' ),
								'title' => __( 'Product title', 'perch' ),
								'name' => __( 'Product slug', 'perch' ),
								'date' => __( 'Date', 'perch' ), 'modified' => __( 'Last modified date', 'perch' ),
								'parent' => __( 'Product parent', 'perch' ),
								'rand' => __( 'Random', 'perch' ), 'comment_count' => __( 'Comments number', 'perch' ),
								'menu_order' => __( 'Menu order', 'perch' ), 'meta_value' => __( 'Meta key values', 'perch' ),
							),
							'default' => 'date',
							'name' => __( 'Order by', 'perch' ),
							'desc' => __( 'Order Products by', 'perch' )
						),
						'post_parent' => array(
							'default' => '',
							'name' => __( 'Product parent', 'perch' ),
							'desc' => __( 'Show childrens of entered post (enter Product ID)', 'perch' )
						),
						'items' => array(
							'type' => 'number',
							'min' => 1,
							'max' => 20,
							'step' => 1,
							'default' => 4,
							'name' => __( 'Items to show', 'perch' ),
							'desc' => __( 'How much carousel items is visible', 'perch' )
						),
						'width' => array(
							'type' => 'slider',
							'min' => 100,
							'max' => 1600,
							'step' => 20,
							'default' => 600,
							'name' => __( 'Width', 'perch' ),
							'desc' => __( 'Carousel Image  width (in pixels)', 'perch' )
						),
						'height' => array(
							'type' => 'slider',
							'min' => 20,
							'max' => 1600,
							'step' => 20,
							'default' => 100,
							'name' => __( 'Height', 'perch' ),
							'desc' => __( 'Carousel Image height (in pixels)', 'perch' )
						),
						'add_to_cart' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Add to cart button area', 'perch' ), 
							'desc' => __( 'Display titles for each item', 'perch' )
						),
						'controls' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Control', 'perch' ), 'desc' => __( 'Is carousel centered on the page', 'perch' )
						),
						'autoplay' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Autoplay', 'perch' ), 
							'desc' => __( 'Is carousel autoplay on the page', 'perch' )
						),
					),
					'desc' => __( '', 'perch' ),
					'icon' => 'th-list'
				);

				// products_categories
				$shortcodes['products_categories'] = array(
					'name' => __( 'Products categories', 'perch' ),
					'type' => 'wrap',
					'group' => 'other',
					'atts' => array(						
						'width' => array(
							'type' => 'slider',
							'min' => 100,
							'max' => 500,
							'step' => 1,
							'default' => 356,
							'name' => __( 'Width', 'perch' ),
							'desc' => __( 'Category image width default.', 'perch' )
						),
						'height' => array(
							'type' => 'slider',
							'min' => 100,
							'max' => 500,
							'step' => 1,
							'default' => 255,
							'name' => __( 'Height', 'perch' ),
							'desc' => __( 'Category image height default.', 'perch' )
						),
					),
					'content' => __( 'Products category shortcode goes here.', 'perch' ),
					'desc' => __( 'Grid holder', 'perch' ),
					'icon' => 'th-list'
				);

				// products_category
				$shortcodes['products_category'] = array(
					'name' => __( 'Products category', 'perch' ),
					'type' => 'single',
					'group' => 'other',
					'atts' => array(						
						'tax_term' => array(
							'type' => 'select',
							'multiple' => false,
							'values' => Tp_Tools::get_terms( 'product_cat' ),
							'default' => '',
							'name' => __( 'Terms', 'perch' ),
							'desc' => __( 'Select terms to show posts from', 'perch' )
						),
						'row_offset' => array(
							'type' => 'slider',
							'min' => 1,
							'max' => 4,
							'step' => 1,
							'default' => 1,
							'name' => __( 'Row offset', 'perch' ),
							'desc' => __( 'Category image row offset.', 'perch' )
						),
						'column_offset' => array(
							'type' => 'slider',
							'min' => 1,
							'max' => 4,
							'step' => 1,
							'default' => 1,
							'name' => __( 'Column offset', 'perch' ),
							'desc' => __( 'Category image column offset.', 'perch' )
						),
						'info_display' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Category info display', 'perch' ), 'desc' => __( '', 'perch' )
						),
						'info_dark_color' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Category info dark color', 'perch' ), 'desc' => __( '', 'perch' )
						),
						'info_align' => array(
							'type' => 'select',
							'values' => array(
								'left' => __( 'Left', 'perch' ),
								'center' => __( 'Center', 'perch' ),
								'right' => __( 'Right', 'perch' ),								
							),
							'default' => 'center',
							'name' => __( 'Text alignment', 'perch' ),
							'desc' => __( '', 'perch' )
						),
					),
					'desc' => __( '', 'perch' ),
					'icon' => 'th-list'
				);
					
				// products_category
				$shortcodes['products_category_info'] = array(
					'name' => __( 'Products category Info', 'perch' ),
					'type' => 'wrap',
					'group' => 'other',
					'atts' => array(
						'background' => array(
							'type' => 'color',
							'default' => '#f5f7f8',
							'name' => __( 'Background color', 'perch' ),
							'desc' => __( 'Pick a background color', 'perch' )
						),						
						'image' => array(
							'type' => 'upload',
							'default' => plugins_url( 'assets/images/cat-info.jpg', TP_PLUGIN_FILE ),
							'name' => __( 'Background image', 'perch' ),
							'desc' => __( '', 'perch' )
						),
						'verticalalign' => array(
							'type' => 'select',
							'values' => array(
								'left' => __( 'Top', 'perch' ),
								'center' => __( 'Center', 'perch' ),
								'right' => __( 'Bottom', 'perch' ),	
								'50%' => __( '50%', 'perch' ),
								'10%' => __( '10%', 'perch' ),							
							),
							'default' => 'center',
							'name' => __( 'Image vertical alignment', 'perch' ),
							'desc' => __( '', 'perch' )
						),	
						'horizontalalign' => array(
							'type' => 'select',
							'values' => array(
								'left' => __( 'Left', 'perch' ),
								'center' => __( 'Center', 'perch' ),
								'right' => __( 'Right', 'perch' ),
								'50%' => __( '50%', 'perch' ),
								'10%' => __( '10%', 'perch' ),								
							),
							'default' => 'right',
							'name' => __( 'Image horizontal alignment', 'perch' ),
							'desc' => __( '', 'perch' )
						),	
						'fill' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Background Image fill', 'perch' ), 'desc' => __( '', 'perch' )
						),
						'title' => array(
							'default' => 'Accesories',
							'name' => __( 'Title', 'perch' ),
							'desc' => __( '', 'perch' )
						),
						'link_title' => array(
							'default' => 'View Collections',
							'name' => __( 'Link title', 'perch' ),
							'desc' => __( '', 'perch' )
						),
						'link' => array(
							'default' => '#',
							'name' => __( 'Link', 'perch' ),
							'desc' => __( '', 'perch' )
						),
						'info_dark_color' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => __( 'Category info dark color', 'perch' ), 
							'desc' => __( '', 'perch' )
						),
						'padding_left' => array(
							'type' => 'slider',
							'min' => 1,
							'max' => 300,
							'step' => 1,
							'default' => 50,
							'name' => __( 'Padding Left', 'perch' ),
							'desc' => __( 'in pixel', 'perch' )
						),
						'padding_top' => array(
							'type' => 'slider',
							'min' => 1,
							'max' => 300,
							'step' => 1,
							'default' => 50,
							'name' => __( 'Padding Top', 'perch' ),
							'desc' => __( 'in pixel', 'perch' )
						),
						'padding_right' => array(
							'type' => 'slider',
							'min' => 1,
							'max' => 300,
							'step' => 1,
							'default' => 50,
							'name' => __( 'Padding Right', 'perch' ),
							'desc' => __( 'in pixel', 'perch' )
						),
						'padding_bottom' => array(
							'type' => 'slider',
							'min' => 1,
							'max' => 300,
							'step' => 1,
							'default' => 50,
							'name' => __( 'Padding Bottom', 'perch' ),
							'desc' => __( 'in pixel', 'perch' )
						),
					),
					'desc' => __( '', 'perch' ),
					'content' => 'Free delivery in days to the place you included. 100% Free delivery.',
					'icon' => 'th-list'
				);	

				// product_image_gallery
				$shortcodes['product_image_gallery'] = array(
					'name' => __( 'Product image gallery', 'perch' ),
					'type' => 'single',
					'group' => 'other',
					'atts' => array(						
						'id' => array(
							'default' => '',
							'name' => __( 'Product ID\'s', 'perch' ),
							'desc' => __( 'Enter comma separated ID\'s of the Products that you want to show', 'perch' )
						),
						'posts_per_page' => array(
							'type' => 'number',
							'min' => -1,
							'max' => 10000,
							'step' => 1,
							'default' => 9,
							'name' => __( 'Posts per page', 'perch' ),
							'desc' => __( 'Specify number of products that you want to show. Enter -1 to get all posts', 'perch' )
						),
						'post_type' => array(
							'type' => 'select',
							'multiple' => true,
							'values' => Tp_Tools::get_types(),
							'default' => 'product',
							'disabled' => 'disabled',
							'name' => __( 'Post types', 'perch' ),
							'desc' => __( 'Select post types. Hold Ctrl key to select multiple post types', 'perch' )
						),
						'taxonomy' => array(
							'type' => 'select',
							'values' => Tp_Tools::get_taxonomies(),
							'default' => 'product_cat',
							'name' => __( 'Taxonomy', 'perch' ),
							'desc' => __( 'Select taxonomy to show products from', 'perch' )
						),
						'tax_term' => array(
							'type' => 'select',
							'multiple' => true,
							'values' => Tp_Tools::get_terms( 'product_cat' ),
							'default' => '',
							'name' => __( 'Terms', 'perch' ),
							'desc' => __( 'Select terms to show posts from', 'perch' )
						),
						'tax_operator' => array(
							'type' => 'select',
							'values' => array( 'IN', 'NOT IN', 'AND' ),
							'default' => 'IN', 'name' => __( 'Taxonomy term operator', 'perch' ),
							'desc' => __( 'IN - posts that have any of selected categories terms<br/>NOT IN - posts that is does not have any of selected terms<br/>AND - posts that have all selected terms', 'perch' )
						),
						'offset' => array(
							'type' => 'number',
							'min' => 0,
							'max' => 10000,
							'step' => 1, 'default' => 0,
							'name' => __( 'Offset', 'perch' ),
							'desc' => __( 'Specify offset to start posts loop not from first post', 'perch' )
						),
						'order' => array(
							'type' => 'select',
							'values' => array(
								'desc' => __( 'Descending', 'perch' ),
								'asc' => __( 'Ascending', 'perch' )
							),
							'default' => 'DESC',
							'name' => __( 'Order', 'perch' ),
							'desc' => __( 'Posts order', 'perch' )
						),
						'orderby' => array(
							'type' => 'select',
							'values' => array(
								'none' => __( 'None', 'perch' ),
								'id' => __( 'Product ID', 'perch' ),
								'author' => __( 'Product author', 'perch' ),
								'title' => __( 'Product title', 'perch' ),
								'name' => __( 'Product slug', 'perch' ),
								'date' => __( 'Date', 'perch' ), 'modified' => __( 'Last modified date', 'perch' ),
								'parent' => __( 'Product parent', 'perch' ),
								'rand' => __( 'Random', 'perch' ), 'comment_count' => __( 'Comments number', 'perch' ),
								'menu_order' => __( 'Menu order', 'perch' ), 'meta_value' => __( 'Meta key values', 'perch' ),
							),
							'default' => 'date',
							'name' => __( 'Order by', 'perch' ),
							'desc' => __( 'Order Products by', 'perch' )
						),
						'post_parent' => array(
							'default' => '',
							'name' => __( 'Product parent', 'perch' ),
							'desc' => __( 'Show childrens of entered post (enter Product ID)', 'perch' )
						),
						'column' => array(
							'type' => 'number',
							'min' => 1,
							'max' => 4,
							'step' => 1,
							'default' => 3,
							'name' => __( 'Column', 'perch' ),
							'desc' => __( 'Gallery image column', 'perch' )
						),
						'width' => array(
							'type' => 'slider',
							'min' => 10,
							'max' => 600,
							'step' => 1,
							'default' => 88,
							'name' => __( 'Width', 'perch' ),
							'desc' => __( 'Image  width (in pixels)', 'perch' )
						),
						'height' => array(
							'type' => 'slider',
							'min' => 10,
							'max' => 1600,
							'step' => 1,
							'default' => 110,
							'name' => __( 'Height', 'perch' ),
							'desc' => __( 'Image height (in pixels)', 'perch' )
						),
						'title' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => __( 'Show titles on hover', 'perch' ), 'desc' => __( '', 'perch' )
						),
					),
					'desc' => __( '', 'perch' ),
					'icon' => 'th-list'
				);
				
					

			endif;//	
		// Return result
		return ( is_string( $shortcode ) ) ? $shortcodes[sanitize_text_field( $shortcode )] : $shortcodes;
	}
}

class Perch_Shortcodes_Data extends Tp_Data {
	function __construct() {
		parent::__construct();
	}
}
