<?php
function perch_parse_color_text($text, $color='#000'){
	preg_match_all("/\{([^\}]*)\}/", $text, $matches);
		if( !empty($matches) ){
			foreach ($matches[1] as $value) {
				$text = str_replace("{{$value}}","<span style='color:{$color}'>{$value}</span>",$text);
			}
		}
		$text = str_replace(" / ","<span class='separator'>/</span>",$text);
		return $text;
}
class Tp_Shortcodes {
	static $tabs = array();
	static $tab_count = 0;

	function __construct() {}

	public static function image_info( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'image'  => '',
				'image_desc'  => '',
			), $atts, 'image_info' );
		do_action( 'perch/shortcode/image_info', $atts );

		extract($atts);

		return '<div class="image-info text-center">
                          '.(($image != '')? '<img src="'.esc_url($image).'" alt="about us">' : '').'
                          <p>'.do_shortcode($content).'</p>
                        </div><!-- .image-info -->';
	}


	public static function heading( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'style'  => 'default',
				'title'  => 'Heading title',
				'size'   => 3,
				'align'  => 'center',
				'margin' => '20',
				'class'  => ''
			), $atts, 'heading' );
		perch_query_asset( 'css', 'perch-content-shortcodes' );
		do_action( 'perch/shortcode/heading', $atts );
		return '<div class="perch-heading perch-heading-style-' . $atts['style'] . ' perch-heading-align-' . $atts['align'] . perch_ecssc( $atts ) . '" style="margin-bottom:' . $atts['margin'] . 'px"><h'. $atts['size'] .' class="perch-heading-inner">' . esc_attr($atts['title']) . '</h'. $atts['size'] .'><div class="heading-subtitle">'.do_shortcode( $content ).'</div></div>';
	}

	public static function instagram( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
			'layout_type' => 'feed',
			'car_display_item' => '6',
			'car_pagination' => 'no',
			'car_pagination_num' => 'yes',
			'car_navigation' => 'yes',
			'car_autoplay' => 'yes',
			'car_autoplay_time' => '5',
			'car_feed_gap' => '1',
			'car_transition' => '',
			'instagram_type' => 'user',
			'tagged_id' => '',
			'location_id' => '',
			'user_id' => '',
			'instagram_num' => '9',
			'sortby' => 'none',
			'skin_type' => 's1',
			'grid_columns_count_for_desktop' => 'vcyt-col-md-3',
			'grid_columns_count_for_tablet' => 'vcyt-col-sm-4',
			'grid_columns_count_for_mobile' => 'vcyt-col-xs-12',
			'effect' => '',
			'feed_gap' => 'yes',
			'hide_content' => 'yes',
			'loadmore' => 'yes',
			'loadmore_text' => '',
			'resolution' => 'low_resolution',
			'svc_class' => '',
			'pbgcolor' => '',
			'pbghcolor' => '',
			'tcolor' => '',
			'loder_color' => ''
		), $atts, 'instagram' );	
		do_action( 'perch/shortcode/instagram', $atts );		
			
		return perch_insta_social_layout_shortcode($atts);
	}

	public static function about_me( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'style'  	=> 'round',
				'image'  	=> '',
				'width'  	=> 275,
				'height'  	=> 275,
				'border'  	=> 'yes',
				'align'  	=> 'center',
				'sign'     => ''
			), $atts, 'about_me' );
		perch_query_asset( 'css', 'perch-content-shortcodes' );
		do_action( 'perch/shortcode/about_me', $atts );
		

		$atts['image'] = (is_numeric($atts['image']))? wp_get_attachment_url($atts['image']) : $atts['image'];
		

		$image = perch_image_resize( $atts['image'], $atts['width'], $atts['height'] );
		$image_class = ($atts['style']=='round')? 'img-circle' : 'img-thumbnail';
		$output = '';
		$output .= '<div class="perch-about-me perch-about-me-' . $atts['style'] . ' text-' . $atts['align'] . ' about-me-image-border-' . $atts['border'] . '">';
		$output .= '<div class="about-me-image-wrap"><img class="'.$image_class.'" src="'. $image['url'] .'" alt="About me"></div>';
		$output .= '<div class="perch-about-me-desc">'.do_shortcode( $content ).'</div>';
		$output .= ($atts['sign'] != '')? '<img class="signature" src="'.esc_url($atts['sign']).'" alt="Signature">' : '';
		$output .= '</div>';
		return $output;
	}

	public static function image_link( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'style'    => 'style1',
				'image'  	=> plugins_url( 'assets/images/ad.jpg', TP_PLUGIN_FILE ),
				'width'  	=> 310,
				'height'  	=> 110,				
				'title'  	=> 'Sample title',
				'link'  	=> '#',
				'target' => 'self',
				'overlay' => 'dark'
			), $atts, 'image_link' );

		do_action( 'perch/shortcode/image_link', $atts );
		$atts['image'] = (is_numeric($atts['image']))? wp_get_attachment_url($atts['image']) : $atts['image'];

		$style = ($atts['style'] == 'style1')? 'style="max-width: '.$atts['width'].'px"' : 'style="min-height: '.$atts['height'].'px"';
		
		$output = '';
		$output .= '<a class="ad-wraper overlay '.$atts['overlay'].'-overlay imgLiquidfill ad-'.$atts['style'].'" href="'.esc_url($atts['link']).'" target="_' . $atts['target'] . '" '.$style.'>
		<img src="'.esc_url($atts['image']).'" alt="">
								<div class="ad-table">
                                   <div class="ad-inner text-center">
                                       '.esc_attr($atts['title']).'
                                   </div></div>
                               </a>';
		return $output;
	}

	public static function alert( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'style'  => 'success',
				'size'   => 3,
				'align'  => 'left',
				'color'  => 'no',
				'margin' => '20',
				'title'  => 'Heading title'
			), $atts, 'alert' );
		perch_query_asset( 'css', 'bootstrap-theme' );
		perch_query_asset( 'css', 'perch-content-shortcodes' );
		do_action( 'perch/shortcode/alert', $atts );
		return '<div class="alert alert-'. $atts['style'] .' color-'. $atts['color'] .' text-'. $atts['align'] .'" role="alert" style="margin-bottom:' . $atts['margin'] . 'px"><h'. $atts['size'] .' class="alert-heading">'. $atts['title'] .'</h'. $atts['size'] .'>' . do_shortcode( $content ) . '</div>';
	}

	public static function testimonial( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'title'  => 'Best alternative shop',
				'image'   => plugins_url( 'assets/images/client-photo.png', TP_PLUGIN_FILE ),
				'width'  => 145,
				'height'  => 270,
				'name' => '- Henry Miller, Fashion Designer',
			), $atts, 'testimonial' );
		
		perch_query_asset( 'css', 'perch-content-shortcodes' );
		do_action( 'perch/shortcode/testimonial', $atts );

		$image = perch_image_resize( $atts['image'], $atts['width'], $atts['height'] );
		
		return '<div><div class="testimonial"><div class="testimonial-image" style="width: '. $atts['width'] .'px"><img src="'. $image['url'] .'" alt="'. $atts['title'] .'"></div><div class="testimonial-info"><h6>'. esc_attr($atts['title']) .'</h6><div class="testimonial-desc">' . do_shortcode( $content ) . '</div><p class="name">'. esc_attr($atts['name']) .'</p></div></div></div>';
	}

	public static function testimonials( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'border_bottom' => 'no',
				'autoplay' => 'no'
			), $atts, 'testimonials' );
		perch_query_asset( 'css', 'owl-carousel' );
		perch_query_asset( 'js', 'owl-carousel' );
		perch_query_asset( 'css', 'perch-content-shortcodes' );
		perch_query_asset( 'js', 'bohopeople' );
		do_action( 'perch/shortcode/testimonials', $atts );
		
		return '<div class="testimonial-carousel border-bottom-'.$atts['border_bottom'].'" data-autoplay="'. (($atts['autoplay'] == 'no')? 0 : 1 ).'">' . do_shortcode( $content ) . '</div>';
	}

	public static function team( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'style' => 'vertical',
				'image'   => plugins_url( 'assets/images/team.png', TP_PLUGIN_FILE ),
				'width'  => 255,
				'height'  => 202,
				'border'  => 'yes',
				'name' => 'STEVEN JOBS',
				'title' => 'Designer',
				'facebook' => '',
				'twitter' => '',
				'googleplus' => '',				
				'pinterest' => '',
				'linkedin' => '',
			), $atts, 'team' );
		perch_query_asset( 'css', 'bootstrap-theme' );
		perch_query_asset( 'css', 'perch-content-shortcodes' );
		do_action( 'perch/shortcode/team', $atts );

		$image = perch_image_resize( $atts['image'], $atts['width'], $atts['height'] );
		$social = '';
		$social .= ( $atts['facebook'] != '' )? '<li class="img-circle"><a href="" title="Facebook"><i class="fa fa-facebook"></i></a></li>' : '';
		$social .= ( $atts['twitter'] != '' )? '<li class="img-circle"><a href="" title="Twitter"><i class="fa fa-twitter"></i></a></li>' : '';
		$social .= ( $atts['googleplus'] != '' )? '<li class="img-circle"><a href="" title="Google +"><i class="fa fa-google-plus"></i></a></li>' : '';
		$social .= ( $atts['pinterest'] != '' )? '<li class="img-circle"><a href="" title="Pinterest"><i class="fa fa-pinterest-p"></i></a></li>' : '';
		$social .= ( $atts['linkedin'] != '' )? '<li class="img-circle"><a href="" title="Linkedin"><i class="fa fa-linkedin"></i></a></li>' : '';
		
		$output = '';
		$output .= '<div class="team team-'.$atts['style'].' border-'.$atts['border'].'">';
		$output .= '<div class="team-img"><img src="' .esc_url($image['url']). '" alt="'. esc_attr($atts['name']) .'"></div>';
		$output .= '<div class="team-info  text-center">';
		$output .= ( $atts['name'] != '' )?'<h2>'. esc_attr($atts['name']) .'</h2>' : '';
		$output .= ( $atts['title'] != '' )?'<p class="team-title">'. esc_attr($atts['title']) .'</p>' : '';
		$output .= ( $social != '' )? '<ul class="list-inline team-social">'. $social .'</ul>' : '';
		$output .= do_shortcode( $content );
		$output .= '</div></div>';
		
		return $output;
	}

	public static function social_links( $atts = null, $content = null){
		$atts = shortcode_atts( array(
				'size'        => 16,
				'align'  => 'center',
				'icon1' => '',
				'link1' => '',
				'icon2' => '',
				'link2' => '',
				'icon3' => '',
				'link3' => '',
				'icon4' => '',
				'link4' => '',
				'icon5' => '',
				'link5' => '',
				'icon6' => '',
				'link6' => '',
			), $atts, 'social_links' );
		do_action( 'perch/shortcode/social_links', $atts );

		perch_query_asset( 'css', 'bootstrap' );
		perch_query_asset( 'css', 'perch-content-shortcodes' );

		$output = '<div class="social_links_wrap text-'.$atts['align'].'">';
		
		$output .= '<div class="desc">'. do_shortcode( $content ) .'</div>';
		$output .= '<ul class="social_links list-inline">';
		for( $i=1; $i<=6; $i++ ){
			if( ($atts['icon'.$i] != '') && ($atts['link'.$i] != '') ){
				// Built-in icon
				if ( strpos( $atts['icon'.$i], 'icon:' ) !== false ) {
					$atts['icon'] = '<i class="' . trim( str_replace( 'icon:', '', $atts['icon'.$i] ) ) . '" style="font-size:' . $atts['size'] . 'px;"></i>';
					perch_query_asset( 'css', 'font-awesome' );
				}
				// Uploaded icon
				else {
					$atts['icon'] = '<img src="' . $atts['icon'.$i] . '" width="' . $atts['size'] . '" height="' . $atts['size'] . '" alt="' . $atts['title'] . '" />';
				}
				$output .= '<li><a href="'. esc_url($atts['link'.$i]) .'">'.$atts['icon'].'</a></li>';
			}
		}
		$output .= '</ul></div>';
		return $output;
	}

	public static function pricing_table( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'style' => 'default',
				'title' => 'Small package',
				'currency' => '$',
				'price' => '19',
				'precision' => '00',
				'package_details' => '1 Shirt|1 Shirt',
				'button_text' => 'Learn more',
				'button_url' => '#',
			), $atts, 'pricing_table' );

		perch_query_asset( 'css', 'bootstrap-theme' );
		perch_query_asset( 'css', 'pricing-table' );
		do_action( 'perch/shortcode/pricing_table', $atts );

		$output = '<div class="pricing-table"><ul class="pricing-table-'. $atts['style'] .' text-center">';
		$output .= ( $atts['title'] != '' )? '<li class="package-title">'. esc_attr($atts['title']) .'</li>' : '';
		$output .= '<li class="package-price"><span>'. esc_attr($atts['currency']) .'</span>'.intval($atts['price']).'<span>.'. esc_attr($atts['precision']) .'</span></li>';

		if( $atts['package_details'] != '' ){
			$arr = explode('|', $atts['package_details']);
			if( !empty($arr) ){
				foreach ($arr as $key => $value) {
					$output .= (trim($value) != '')? '<li class="package-condition">'.esc_attr(trim($value)).'</li>' : '';
				}
			}
		}
		$output .= ($content != '')? '<li class="package-details">'. do_shortcode( $content ) .'</li>' : '';
		$output .= ( $atts['button_text'] != '' )? '<li class="package-link"><a class="btn alt color-text" href="'.esc_url($atts['button_url']).'">'.esc_attr($atts['button_text']).'</a></li>' : '';
		$output .= '</ul></div>';

		return $output;		
	}

	public static function pricing_tables( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'style' => 'default',
				'column' => 3
			), $atts, 'pricing_tables' );

		perch_query_asset( 'css', 'bootstrap-theme' );
		perch_query_asset( 'css', 'pricing-table' );
		do_action( 'perch/shortcode/testimonials', $atts );

		$output = '<div class="pricing-tables pricing-tables-style-'. $atts['style'] .' column-'. $atts['column'] .'">';
		$output .= do_shortcode( $content );
		$output .= '</div>';

		return $output;		
	}

	public static function call_to_action( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'style' => 'default',
				'background' => 'no',
				'title' => 'Are you looking for job?',
				'title_color' => 'We are recruting!',
				'button_style1' => 'color-bg',
				'button_text1' => 'Learn more',
				'button_url1' => '',
				'button_style2' => 'alt',
				'button_text2' => '',
				'button_url2' => '#',
			), $atts, 'call_to_action' );

		perch_query_asset( 'css', 'bootstrap-theme' );
		perch_query_asset( 'css', 'pricing-table' );
		do_action( 'perch/shortcode/call_to_action', $atts );

		$title = '<h2>'. trim(esc_attr($atts['title'])) .' <span class="color-text">'. trim(esc_attr($atts['title_color'])) .'</span></h2>';
		$content = '<div class="cta-content">'.do_shortcode( $content ).'</div>';
		$button1 = (trim($atts['button_text1']) != '')? '<a href="'. esc_url($atts['button_url1']) .'" class="btn large color-text '.$atts['button_style1'].'">'. esc_attr($atts['button_text1']) .'</a>': '';
		$button2 = (trim($atts['button_text2']) != '')? '<a href="'. esc_url($atts['button_url2']) .'" class="btn large color-text '.$atts['button_style2'].'">'. esc_attr($atts['button_text2']) .'</a>' : '';

		$output = '<div class="perch-call-to-action perch-call-to-action-bg-'.$atts['background'].'  perch-call-to-action-'. $atts['style'] .'">';
		if( $atts['style'] == 'default' ){
			$output .= '<div class="row"><div class="col-md-8 col-lg-8">'. $title .$content.'</div><div class="text-right col-md-4 col-lg-4">'.$button1.'</div></div>';
		}else{
			$output .= $title .$content.'<div class="cta-button-wrap text-center">'.$button1.$button2.'</div>';
		}
		$output .= '</div>';

		return $output;		
	}

	public static function tabs( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'active'   => 1,
				'vertical' => 'no',
				'style'    => 'default', // 3.x
				'center' => 'no',
				'class'    => ''
			), $atts, 'tabs' );
		if ( $atts['style'] === '3' ) $atts['vertical'] = 'yes';
		do_shortcode( $content );
		$return = '';
		$tabs = $panes = array();
		if ( is_array( self::$tabs ) ) {
			if ( self::$tab_count < $atts['active'] ) $atts['active'] = self::$tab_count;
			foreach ( self::$tabs as $tab ) {
				$tabs[] = '<span class="' . perch_ecssc( $tab ) . $tab['disabled'] . '"' . $tab['anchor'] . $tab['url'] . $tab['target'] . '>' . perch_scattr( $tab['title'] ) . '</span>';
				$panes[] = '<div class="perch-tabs-pane perch-clearfix' . perch_ecssc( $tab ) . '">' . $tab['content'] . '</div>';
			}
			$atts['vertical'] = ( $atts['vertical'] === 'yes' ) ? ' perch-tabs-vertical' : ' perch-tabs-horizontal';
			$center = ( ($atts['vertical'] === 'no') && ($atts['center'] === 'yes') ) ? ' text-center' : '';
			$return = '<div class="perch-tabs perch-tabs-style-' . $atts['style'] . $atts['vertical'] . perch_ecssc( $atts ) . '" data-active="' . (string) $atts['active'] . '"><div class="perch-tabs-nav'.$center.'">' . implode( '', $tabs ) . '</div><div class="perch-tabs-panes">' . implode( "\n", $panes ) . '</div></div>';
		}
		// Reset tabs
		self::$tabs = array();
		self::$tab_count = 0;
		perch_query_asset( 'css', 'perch-box-shortcodes' );
		perch_query_asset( 'css', 'genericons' );
		perch_query_asset( 'js', 'jquery' );
		perch_query_asset( 'js', 'perch-other-shortcodes' );
		do_action( 'perch/shortcode/tabs', $atts );
		return $return;
	}

	public static function tab( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'title'    => __( 'Tab title', 'perch' ),
				'disabled' => 'no',
				'anchor'   => '',
				'url'      => '',
				'target'   => 'blank',
				'class'    => ''
			), $atts, 'tab' );
		$x = self::$tab_count;
		self::$tabs[$x] = array(
			'title'    => $atts['title'],
			'content'  => do_shortcode( $content ),
			'disabled' => ( $atts['disabled'] === 'yes' ) ? ' perch-tabs-disabled' : '',
			'anchor'   => ( $atts['anchor'] ) ? ' data-anchor="' . str_replace( array( ' ', '#' ), '', sanitize_text_field( $atts['anchor'] ) ) . '"' : '',
			'url'      => ' data-url="' . $atts['url'] . '"',
			'target'   => ' data-target="' . $atts['target'] . '"',
			'class'    => $atts['class']
		);
		self::$tab_count++;
		do_action( 'perch/shortcode/tab', $atts );
	}

	public static function spoiler( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'title'  => __( 'Spoiler title', 'perch' ),
				'open'   => 'no',
				'style'  => 'default',
				'icon'   => 'plus',
				'anchor' => '',
				'class'  => ''
			), $atts, 'spoiler' );
		$atts['style'] = str_replace( array( '1', '2' ), array( 'default', 'fancy' ), $atts['style'] );
		$atts['anchor'] = ( $atts['anchor'] ) ? ' data-anchor="' . str_replace( array( ' ', '#' ), '', sanitize_text_field( $atts['anchor'] ) ) . '"' : '';
		if ( $atts['open'] !== 'yes' ) $atts['class'] .= ' perch-spoiler-closed';
		perch_query_asset( 'css', 'font-awesome' );
		perch_query_asset( 'css', 'perch-box-shortcodes' );
		perch_query_asset( 'js', 'jquery' );
		perch_query_asset( 'js', 'perch-other-shortcodes' );
		do_action( 'perch/shortcode/spoiler', $atts );
		return '<div class="perch-spoiler perch-spoiler-style-' . $atts['style'] . ' perch-spoiler-icon-' . $atts['icon'] . perch_ecssc( $atts ) . '"' . $atts['anchor'] . '><div class="perch-spoiler-title"><span class="perch-spoiler-icon"></span>' . perch_scattr( $atts['title'] ) . '</div><div class="perch-spoiler-content perch-clearfix" style="display:none">' . perch_do_shortcode( $content, 's' ) . '</div></div>';
	}

	public static function accordion( $atts = null, $content = null ) {
		$atts = shortcode_atts( array( 'class' => '' ), $atts, 'accordion' );
		do_action( 'perch/shortcode/accordion', $atts );
		return '<div class="perch-accordion' . perch_ecssc( $atts ) . '">' . do_shortcode( $content ) . '</div>';
	}

	public static function divider( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'top'           => 'yes',
				'text'          => __( 'Go to top', 'perch' ),
				'style'         => 'default',
				'divider_color' => '#999999',
				'link_color'    => '#999999',
				'size'          => '3',
				'margin'        => '15',
				'class'         => ''
			), $atts, 'divider' );
		// Prepare TOP link
		$top = ( $atts['top'] === 'yes' ) ? '<a href="#" style="color:' . $atts['link_color'] . '">' . perch_scattr( $atts['text'] ) . '</a>' : '';
		perch_query_asset( 'css', 'perch-content-shortcodes' );
		return '<div class="perch-divider perch-divider-style-' . $atts['style'] . perch_ecssc( $atts ) . '" style="margin:' . $atts['margin'] . 'px 0;border-width:' . $atts['size'] . 'px;border-color:' . $atts['divider_color'] . '">' . $top . '</div>';
	}

	public static function spacer( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'size'  => '20',
				'class' => ''
			), $atts, 'spacer' );
		perch_query_asset( 'css', 'perch-content-shortcodes' );
		return '<div class="perch-spacer' . perch_ecssc( $atts ) . '" style="height:' . (string) $atts['size'] . 'px"></div>';
	}

	public static function highlight( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'background' => '#ddff99',
				'bg'         => null, // 3.x
				'color'      => '#000000',
				'class'      => ''
			), $atts, 'highlight' );
		if ( $atts['bg'] !== null ) $atts['background'] = $atts['bg'];
		perch_query_asset( 'css', 'perch-content-shortcodes' );
		return '<span class="perch-highlight' . perch_ecssc( $atts ) . '" style="background:' . $atts['background'] . ';color:' . $atts['color'] . '">&nbsp;' . do_shortcode( $content ) . '&nbsp;</span>';
	}

	public static function label( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'type'  => 'default',
				'style' => null, // 3.x
				'class' => ''
			), $atts, 'label' );
		if ( $atts['style'] !== null ) $atts['type'] = $atts['style'];
		perch_query_asset( 'css', 'perch-content-shortcodes' );
		return '<span class="perch-label perch-label-type-' . $atts['type'] . perch_ecssc( $atts ) . '">' . do_shortcode( $content ) . '</span>';
	}

	public static function quote( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'style' => 'default',
				'cite'  => false,
				'url'   => false,
				'class' => ''
			), $atts, 'quote' );
		$cite_link = ( $atts['url'] && $atts['cite'] ) ? '<a href="' . $atts['url'] . '" target="_blank">' . $atts['cite'] . '</a>'
		: $atts['cite'];
		$cite = ( $atts['cite'] ) ? '<span class="perch-quote-cite">' . $cite_link . '</span>' : '';
		$cite_class = ( $atts['cite'] ) ? ' perch-quote-has-cite' : '';
		perch_query_asset( 'css', 'perch-box-shortcodes' );
		do_action( 'perch/shortcode/quote', $atts );
		return '<div class="perch-quote perch-quote-style-' . $atts['style'] . $cite_class . perch_ecssc( $atts ) . '"><div class="perch-quote-inner perch-clearfix">' . do_shortcode( $content ) . perch_scattr( $cite ) . '</div></div>';
	}

	public static function pullquote( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'align' => 'left',
				'class' => ''
			), $atts, 'pullquote' );
		perch_query_asset( 'css', 'perch-box-shortcodes' );
		return '<div class="perch-pullquote perch-pullquote-align-' . $atts['align'] . perch_ecssc( $atts ) . '">' . do_shortcode( $content ) . '</div>';
	}

	public static function dropcap( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'style' => 'default',
				'size'  => 3,
				'class' => ''
			), $atts, 'dropcap' );
		$atts['style'] = str_replace( array( '1', '2', '3' ), array( 'default', 'light', 'default' ), $atts['style'] ); // 3.x
		// Calculate font-size
		$em = $atts['size'] * 0.5 . 'em';
		perch_query_asset( 'css', 'perch-content-shortcodes' );
		return '<span class="perch-dropcap perch-dropcap-style-' . $atts['style'] . perch_ecssc( $atts ) . '" style="font-size:' . $em . '">' . do_shortcode( $content ) . '</span>';
	}

	public static function frame( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'style' => 'default',
				'align' => 'left',
				'class' => ''
			), $atts, 'frame' );
		perch_query_asset( 'css', 'perch-content-shortcodes' );
		perch_query_asset( 'js', 'perch-other-shortcodes' );
		return '<span class="perch-frame perch-frame-align-' . $atts['align'] . ' perch-frame-style-' . $atts['style'] . perch_ecssc( $atts ) . '"><span class="perch-frame-inner">' . do_shortcode( $content ) . '</span></span>';
	}

	public static function row( $atts = null, $content = null ) {
		$atts = shortcode_atts( array( 'class' => '' ), $atts );
		return '<div class="perch-row' . perch_ecssc( $atts ) . '">' . perch_do_shortcode( $content, 'r' ) . '</div>';
	}

	public static function column( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'size'   => '1/2',
				'center' => 'no',
				'last'   => null,
				'class'  => ''
			), $atts, 'column' );
		if ( $atts['last'] !== null && $atts['last'] == '1' ) $atts['class'] .= ' perch-column-last';
		if ( $atts['center'] === 'yes' ) $atts['class'] .= ' perch-column-centered';
		perch_query_asset( 'css', 'perch-box-shortcodes' );
		return '<div class="perch-column perch-column-size-' . str_replace( '/', '-', $atts['size'] ) . perch_ecssc( $atts ) . '"><div class="perch-column-inner perch-clearfix">' . perch_do_shortcode( $content, 'c' ) . '</div></div>';
	}

	public static function perch_list( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'icon' => 'icon: star',
				'icon_color' => '#333',
				'style' => null,
				'class' => ''
			), $atts, 'list' );
		// Backward compatibility // 4.2.3+
		if ( $atts['style'] !== null ) {
			switch ( $atts['style'] ) {
			case 'star':
				$atts['icon'] = 'icon: star';
				$atts['icon_color'] = '#ffd647';
				break;
			case 'arrow':
				$atts['icon'] = 'icon: arrow-right';
				$atts['icon_color'] = '#00d1ce';
				break;
			case 'check':
				$atts['icon'] = 'icon: check';
				$atts['icon_color'] = '#17bf20';
				break;
			case 'cross':
				$atts['icon'] = 'icon: remove';
				$atts['icon_color'] = '#ff142b';
				break;
			case 'thumbs':
				$atts['icon'] = 'icon: thumbs-o-up';
				$atts['icon_color'] = '#8a8a8a';
				break;
			case 'link':
				$atts['icon'] = 'icon: external-link';
				$atts['icon_color'] = '#5c5c5c';
				break;
			case 'gear':
				$atts['icon'] = 'icon: cog';
				$atts['icon_color'] = '#ccc';
				break;
			case 'time':
				$atts['icon'] = 'icon: time';
				$atts['icon_color'] = '#a8a8a8';
				break;
			case 'note':
				$atts['icon'] = 'icon: edit';
				$atts['icon_color'] = '#f7d02c';
				break;
			case 'plus':
				$atts['icon'] = 'icon: plus-sign';
				$atts['icon_color'] = '#61dc3c';
				break;
			case 'guard':
				$atts['icon'] = 'icon: shield';
				$atts['icon_color'] = '#1bbe08';
				break;
			case 'event':
				$atts['icon'] = 'icon: bullhorn';
				$atts['icon_color'] = '#ff4c42';
				break;
			case 'idea':
				$atts['icon'] = 'icon: sun';
				$atts['icon_color'] = '#ffd880';
				break;
			case 'settings':
				$atts['icon'] = 'icon: cogs';
				$atts['icon_color'] = '#8a8a8a';
				break;
			case 'twitter':
				$atts['icon'] = 'icon: twitter-sign';
				$atts['icon_color'] = '#00ced6';
				break;
			}
		}
		if ( strpos( $atts['icon'], 'icon:' ) !== false ) {
			$style = ($atts['icon_color'] != '#333')?  ' style="color:' . $atts['icon_color'] . '"' : '';
			$atts['icon'] = '<i class="' . trim( str_replace( 'icon:', '', $atts['icon'] ) ) . '"'.$style.'></i>';
			perch_query_asset( 'css', 'schema-font-awesome' );
			perch_query_asset( 'css', 'schema-genericons' );
		}
		else $atts['icon'] = '<img src="' . $atts['icon'] . '" alt="" />';
		perch_query_asset( 'css', 'perch-content-shortcodes' );
		return '<div class="perch-list perch-list-style-' . $atts['style'] . perch_ecssc( $atts ) . '">' . str_replace( '<li>', '<li>' . $atts['icon'] . ' ', perch_do_shortcode( $content, 'l' ) ) . '</div>';
	}

	public static function button( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'url'         => get_option( 'home' ),
				'link'        => null, // 3.x
				'target'      => 'self',
				'style'       => 'default',
				'background'  => '#2D89EF',
				'color'       => '#FFFFFF',
				'dark'        => null, // 3.x
				'size'        => 3,
				'wide'        => 'no',
				'center'      => 'no',
				'radius'      => 'auto',
				'icon'        => false,
				'icon_color'  => '#FFFFFF',
				'ts_color'    => null, // Dep. 4.3.2
				'ts_pos'      => null, // Dep. 4.3.2
				'text_shadow' => 'none',
				'desc'        => '',
				'onclick'     => '',
				'rel'         => '',
				'title'       => '',
				'class'       => ''
			), $atts, 'button' );

		if ( $atts['link'] !== null ) $atts['url'] = $atts['link'];
		if ( $atts['dark'] !== null ) {
			$atts['background'] = $atts['color'];
			$atts['color'] = ( $atts['dark'] ) ? '#000' : '#fff';
		}
		if ( is_numeric( $atts['style'] ) ) $atts['style'] = str_replace( array( '1', '2', '3', '4', '5' ), array( 'default', 'glass', 'bubbles', 'noise', 'stroked' ), $atts['style'] ); // 3.x
		// Prepare vars
		$a_css = array();
		$span_css = array();
		$img_css = array();
		$small_css = array();
		$radius = '0px';
		$before = $after = '';
		// Text shadow values
		$shadows = array(
			'none'         => '0 0',
			'top'          => '0 -1px',
			'right'        => '1px 0',
			'bottom'       => '0 1px',
			'left'         => '-1px 0',
			'top-right'    => '1px -1px',
			'top-left'     => '-1px -1px',
			'bottom-right' => '1px 1px',
			'bottom-left'  => '-1px 1px'
		);
		// Common styles for button
		$styles = array(
			'size'     => round( ( $atts['size'] + 7 ) * 1.3 ),
			'ts_color' => ( $atts['ts_color'] === 'light' ) ? perch_hex_shift( $atts['background'], 'lighter', 50 ) : perch_hex_shift( $atts['background'], 'darker', 40 ),
			'ts_pos'   => ( $atts['ts_pos'] !== null ) ? $shadows[$atts['ts_pos']] : $shadows['none']
		);
		// Calculate border-radius
		if ( $atts['radius'] == 'auto' ) $radius = round( $atts['size'] + 2 ) . 'px';
		elseif ( $atts['radius'] == 'round' ) $radius = round( ( ( $atts['size'] * 2 ) + 2 ) * 2 + $styles['size'] ) . 'px';
		elseif ( is_numeric( $atts['radius'] ) ) $radius = intval( $atts['radius'] ) . 'px';
		// CSS rules for <a> tag
		$a_rules = array(
			'color'                 => $atts['color'],
			'background-color'      => $atts['background'],
			'border-color'          => perch_hex_shift( $atts['background'], 'darker', 20 ),
			'border-radius'         => $radius,
			'-moz-border-radius'    => $radius,
			'-webkit-border-radius' => $radius
		);
		// CSS rules for <span> tag
		$span_rules = array(
			'color'                 => $atts['color'],
			'padding'               => ( $atts['icon'] ) ? round( ( $atts['size'] ) / 2 + 4 ) . 'px ' . round( $atts['size'] * 2 + 10 ) . 'px' : '0px ' . round( $atts['size'] * 2 + 10 ) . 'px',
			'font-size'             => $styles['size'] . 'px',
			'line-height'           => ( $atts['icon'] ) ? round( $styles['size'] * 1.5 ) . 'px' : round( $styles['size'] * 2 ) . 'px',
			'border-color'          => perch_hex_shift( $atts['background'], 'lighter', 30 ),
			'border-radius'         => $radius,
			'-moz-border-radius'    => $radius,
			'-webkit-border-radius' => $radius,
			'text-shadow'           => $styles['ts_pos'] . ' 1px ' . $styles['ts_color'],
			'-moz-text-shadow'      => $styles['ts_pos'] . ' 1px ' . $styles['ts_color'],
			'-webkit-text-shadow'   => $styles['ts_pos'] . ' 1px ' . $styles['ts_color']
		);
		// Apply new text-shadow value
		if ( $atts['ts_color'] === null && $atts['ts_pos'] === null ) {
			$span_rules['text-shadow'] = $atts['text_shadow'];
			$span_rules['-moz-text-shadow'] = $atts['text_shadow'];
			$span_rules['-webkit-text-shadow'] = $atts['text_shadow'];
		}
		// CSS rules for <img> tag
		$img_rules = array(
			'width'     => round( $styles['size'] * 1.5 ) . 'px',
			'height'    => round( $styles['size'] * 1.5 ) . 'px'
		);
		// CSS rules for <small> tag
		$small_rules = array(
			'padding-bottom' => round( ( $atts['size'] ) / 2 + 4 ) . 'px',
			'color' => $atts['color']
		);
		// Create style attr value for <a> tag
		foreach ( $a_rules as $a_rule => $a_value ) $a_css[] = $a_rule . ':' . $a_value;
		// Create style attr value for <span> tag
		foreach ( $span_rules as $span_rule => $span_value ) $span_css[] = $span_rule . ':' . $span_value;
		// Create style attr value for <img> tag
		foreach ( $img_rules as $img_rule => $img_value ) $img_css[] = $img_rule . ':' . $img_value;
		// Create style attr value for <img> tag
		foreach ( $small_rules as $small_rule => $small_value ) $small_css[] = $small_rule . ':' . $small_value;
		// Prepare button classes
		$classes = array( 'perch-button', 'perch-button-style-' . $atts['style'] );
		// Additional classes
		if ( $atts['class'] ) $classes[] = $atts['class'];
		// Wide class
		if ( $atts['wide'] === 'yes' ) $classes[] = 'perch-button-wide';
		// Prepare icon
		if ( $atts['icon'] ) {
			if ( strpos( $atts['icon'], 'icon:' ) !== false ) {
				$icon = '<i class="' . trim( str_replace( 'icon:', '', $atts['icon'] ) ) . '" style="font-size:' . $styles['size'] . 'px;color:' . $atts['icon_color'] . '"></i>';
				perch_query_asset( 'css', 'font-awesome' );
			}
			else $icon = '<img src="' . $atts['icon'] . '" alt="' . esc_attr( $content ) . '" style="' . implode( $img_css, ';' ) . '" />';
		}
		else $icon = '';
		// Prepare <small> with description
		$desc = ( $atts['desc'] ) ? '<small style="' . implode( $small_css, ';' ) . '">' . perch_scattr( $atts['desc'] ) . '</small>' : '';
		// Wrap with div if button centered
		if ( $atts['center'] === 'yes' ) {
			$before .= '<div class="perch-button-center">';
			$after .= '</div>';
		}
		// Replace icon marker in content,
		// add float-icon class to rearrange margins
		if ( strpos( $content, '%icon%' ) !== false ) {
			$content = str_replace( '%icon%', $icon, $content );
			$classes[] = 'perch-button-float-icon';
		}
		// Button text has no icon marker, append icon to begin of the text
		else $content = $icon . ' ' . $content;
		// Prepare onclick action
		$atts['onclick'] = ( $atts['onclick'] ) ? ' onClick="' . $atts['onclick'] . '"' : '';
		// Prepare rel attribute
		$atts['rel'] = ( $atts['rel'] ) ? ' rel="' . $atts['rel'] . '"' : '';
		// Prepare title attribute
		$atts['title'] = ( $atts['title'] ) ? ' title="' . $atts['title'] . '"' : '';
		perch_query_asset( 'css', 'perch-content-shortcodes' );
		return $before . '<a href="' . perch_scattr( $atts['url'] ) . '" class="' . implode( $classes, ' ' ) . '" style="' . implode( $a_css, ';' ) . '" target="_' . $atts['target'] . '"' . $atts['onclick'] . $atts['rel'] . $atts['title'] . '><span style="' . implode( $span_css, ';' ) . '">' . do_shortcode( stripcslashes( $content ) ) . $desc . '</span></a>' . $after;
	}

	public static function service( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'title'       => __( 'Service title', 'perch' ),
				'icon'        => plugins_url( 'assets/images/service.png', TP_PLUGIN_FILE ),
				'icon_color'  => '#333',
				'size'        => 32,
				'align'		  => 'left',
				'class'       => ''
			), $atts, 'service' );
		// RTL
		$rtl = ( is_rtl() ) ? 'right' : 'left';
		// Built-in icon
		if ( strpos( $atts['icon'], 'icon:' ) !== false ) {
			$atts['icon'] = '<i class="' . trim( str_replace( 'icon:', '', $atts['icon'] ) ) . '" style="font-size:' . $atts['size'] . 'px;color:' . $atts['icon_color'] . '"></i>';
			perch_query_asset( 'css', 'font-awesome' );
		}
		// Uploaded icon
		else {
			$atts['icon'] = '<img src="' . $atts['icon'] . '" width="' . $atts['size'] . '" height="' . $atts['size'] . '" alt="' . $atts['title'] . '" />';
		}
		$extclass = ($content == '')? ' empty-service-content' : '';
		perch_query_asset( 'css', 'perch-box-shortcodes' );
		return '<div class="perch-service'.$extclass.' text-'.$atts['align'].' ' . perch_ecssc( $atts ) . '"><div class="perch-service-title" style="padding-' . $rtl . ':' . round( $atts['size'] + 14 ) . 'px;min-height:' . $atts['size'] . 'px;line-height:' . $atts['size'] . 'px">' . $atts['icon'] . ' ' . perch_scattr( $atts['title'] ) . '</div><div class="perch-service-content perch-clearfix" style="padding-' . $rtl . ':' . round( $atts['size'] + 35 ) . 'px">' . do_shortcode( $content ) . '</div></div>';
	}

	public static function box( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'title'       => __( 'This is box title', 'perch' ),
				'style'       => 'default',
				'box_color'   => '#333333',
				'title_color' => '#FFFFFF',
				'color'       => null, // 3.x
				'radius'      => '3',
				'class'       => ''
			), $atts, 'box' );
		if ( $atts['color'] !== null ) $atts['box_color'] = $atts['color'];
		// Prepare border-radius
		$radius = ( $atts['radius'] != '0' ) ? 'border-radius:' . $atts['radius'] . 'px;-moz-border-radius:' . $atts['radius'] . 'px;-webkit-border-radius:' . $atts['radius'] . 'px;' : '';
		$title_radius = ( $atts['radius'] != '0' ) ? $atts['radius'] - 1 : '';
		$title_radius = ( $title_radius ) ? '-webkit-border-top-left-radius:' . $title_radius . 'px;-webkit-border-top-right-radius:' . $title_radius . 'px;-moz-border-radius-topleft:' . $title_radius . 'px;-moz-border-radius-topright:' . $title_radius . 'px;border-top-left-radius:' . $title_radius . 'px;border-top-right-radius:' . $title_radius . 'px;' : '';
		perch_query_asset( 'css', 'perch-box-shortcodes' );
		// Return result
		return '<div class="perch-box perch-box-style-' . $atts['style'] . perch_ecssc( $atts ) . '" style="border-color:' . perch_hex_shift( $atts['box_color'], 'darker', 20 ) . ';' . $radius . '"><div class="perch-box-title" style="background-color:' . $atts['box_color'] . ';color:' . $atts['title_color'] . ';' . $title_radius . '">' . perch_scattr( $atts['title'] ) . '</div><div class="perch-box-content perch-clearfix">' . perch_do_shortcode( $content, 'b' ) . '</div></div>';
	}

	public static function note( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'note_color' => '#FFFF66',
				'text_color' => '#333333',
				'background' => null, // 3.x
				'color'      => null, // 3.x
				'radius'     => '3',
				'class'      => ''
			), $atts, 'note' );
		if ( $atts['color'] !== null ) $atts['note_color'] = $atts['color'];
		if ( $atts['background'] !== null ) $atts['note_color'] = $atts['background'];
		// Prepare border-radius
		$radius = ( $atts['radius'] != '0' ) ? 'border-radius:' . $atts['radius'] . 'px;-moz-border-radius:' . $atts['radius'] . 'px;-webkit-border-radius:' . $atts['radius'] . 'px;' : '';
		perch_query_asset( 'css', 'perch-box-shortcodes' );
		return '<div class="perch-note' . perch_ecssc( $atts ) . '" style="border-color:' . perch_hex_shift( $atts['note_color'], 'darker', 10 ) . ';' . $radius . '"><div class="perch-note-inner perch-clearfix" style="background-color:' . $atts['note_color'] . ';border-color:' . perch_hex_shift( $atts['note_color'], 'lighter', 80 ) . ';color:' . $atts['text_color'] . ';' . $radius . '">' . perch_do_shortcode( $content, 'n' ) . '</div></div>';
	}

	public static function expand( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'more_text'  => __( 'Show more', 'perch' ),
				'less_text'  => __( 'Show less', 'perch' ),
				'height'     => '100',
				'hide_less'  => 'no',
				'text_color' => '#333333',
				'link_color' => '#0088FF',
				'link_style' => 'default',
				'link_align' => 'left',
				'more_icon'  => '',
				'less_icon'  => '',
				'class'      => ''
			), $atts, 'expand' );
		// Prepare more icon
		$more_icon = ( $atts['more_icon'] ) ? Tp_Tools::icon( $atts['more_icon'] ) : '';
		$less_icon = ( $atts['less_icon'] ) ? Tp_Tools::icon( $atts['less_icon'] ) : '';
		if ( $more_icon || $less_icon ) perch_query_asset( 'css', 'font-awesome' );
		// Prepare less link
		$less = ( $atts['hide_less'] !== 'yes' ) ? '<div class="perch-expand-link perch-expand-link-less" style="text-align:' . $atts['link_align'] . '"><a href="javascript:;" style="color:' . $atts['link_color'] . ';border-color:' . $atts['link_color'] . '">' . $less_icon . '<span style="border-color:' . $atts['link_color'] . '">' . $atts['less_text'] . '</span></a></div>' : '';
		perch_query_asset( 'css', 'perch-box-shortcodes' );
		perch_query_asset( 'js', 'perch-other-shortcodes' );
		return '<div class="perch-expand perch-expand-collapsed perch-expand-link-style-' . $atts['link_style'] . perch_ecssc( $atts ) . '" data-height="' . $atts['height'] . '"><div class="perch-expand-content" style="color:' . $atts['text_color'] . ';max-height:' . intval( $atts['height'] ) . 'px;overflow:hidden">' . do_shortcode( $content ) . '</div><div class="perch-expand-link perch-expand-link-more" style="text-align:' . $atts['link_align'] . '"><a href="javascript:;" style="color:' . $atts['link_color'] . ';border-color:' . $atts['link_color'] . '">' . $more_icon . '<span style="border-color:' . $atts['link_color'] . '">' . $atts['more_text'] . '</span></a></div>' . $less . '</div>';
	}

	public static function lightbox( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'src'   => false,
				'type'  => 'iframe',
				'class' => ''
			), $atts, 'lightbox' );
		if ( !$atts['src'] ) return Tp_Tools::error( __FUNCTION__, __( 'please specify correct source', 'perch' ) );
		perch_query_asset( 'css', 'magnific-popup' );
		perch_query_asset( 'js', 'jquery' );
		perch_query_asset( 'js', 'magnific-popup' );
		perch_query_asset( 'js', 'perch-other-shortcodes' );
		return '<span class="perch-lightbox' . perch_ecssc( $atts ) . '" data-mfp-src="' . perch_scattr( $atts['src'] ) . '" data-mfp-type="' . $atts['type'] . '">' . do_shortcode( $content ) . '</span>';
	}

	public static function lightbox_content( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'id'         => '',
				'width'      => '50%',
				'margin'     => '40',
				'padding'    => '40',
				'text_align' => 'center',
				'background' => '#FFFFFF',
				'color'      => '#333333',
				'shadow'     => '0px 0px 15px #333333',
				'class'      => ''
			), $atts, 'lightbox_content' );
		perch_query_asset( 'css', 'perch-box-shortcodes' );
		if ( !$atts['id'] ) return Tp_Tools::error( __FUNCTION__, __( 'please specify correct ID for this block. You should use same ID as in the Content source field (when inserting lightbox shortcode)', 'perch' ) );
		$return = '<div class="perch-lightbox-content ' . perch_ecssc( $atts ) . '" id="' . trim( $atts['id'], '#' ) . '" style="display:none;width:' . $atts['width'] . ';margin-top:' . $atts['margin'] . 'px;margin-bottom:' . $atts['margin'] . 'px;padding:' . $atts['padding'] . 'px;background-color:' . $atts['background'] . ';color:' . $atts['color'] . ';box-shadow:' . $atts['shadow'] . ';text-align:' . $atts['text_align'] . '">' . do_shortcode( $content ) . '</div>';
		if ( did_action( 'perch/generator/preview/before' ) ) return '<div class="perch-lightbox-content-preview">' . $return . '</div>';
		else return $return;
	}

	public static function tooltip( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'style'        => 'yellow',
				'position'     => 'north',
				'shadow'       => 'no',
				'rounded'      => 'no',
				'size'         => 'default',
				'title'        => '',
				'content'      => __( 'Tooltip text', 'perch' ),
				'behavior'     => 'hover',
				'close'        => 'no',
				'class'        => ''
			), $atts, 'tooltip' );
		// Prepare style
		$atts['style'] = ( in_array( $atts['style'], array( 'light', 'dark', 'green', 'red', 'blue', 'youtube', 'tipsy', 'bootstrap', 'jtools', 'tipped', 'cluetip' ) ) ) ? $atts['style'] : 'plain';
		// Position
		$atts['position'] = str_replace( array( 'top', 'right', 'bottom', 'left' ), array( 'north', 'east', 'south', 'west' ), $atts['position'] );
		$position = array(
			'my' => str_replace( array( 'north', 'east', 'south', 'west' ), array( 'bottom center', 'center left', 'top center', 'center right' ), $atts['position'] ),
			'at' => str_replace( array( 'north', 'east', 'south', 'west' ), array( 'top center', 'center right', 'bottom center', 'center left' ), $atts['position'] )
		);
		// Prepare classes
		$classes = array( 'perch-qtip qtip-' . $atts['style'] );
		$classes[] = 'perch-qtip-size-' . $atts['size'];
		if ( $atts['shadow'] === 'yes' ) $classes[] = 'qtip-shadow';
		if ( $atts['rounded'] === 'yes' ) $classes[] = 'qtip-rounded';
		// Query assets
		perch_query_asset( 'css', 'qtip' );
		perch_query_asset( 'css', 'perch-other-shortcodes' );
		perch_query_asset( 'js', 'jquery' );
		perch_query_asset( 'js', 'qtip' );
		perch_query_asset( 'js', 'perch-other-shortcodes' );
		return '<span class="perch-tooltip' . perch_ecssc( $atts ) . '" data-close="' . $atts['close'] . '" data-behavior="' . $atts['behavior'] . '" data-my="' . $position['my'] . '" data-at="' . $position['at'] . '" data-classes="' . implode( ' ', $classes ) . '" data-title="' . $atts['title'] . '" title="' . esc_attr( $atts['content'] ) . '">' . do_shortcode( $content ) . '</span>';
	}

	public static function perch_private( $atts = null, $content = null ) {
		$atts = shortcode_atts( array( 'class' => '' ), $atts, 'private' );
		perch_query_asset( 'css', 'perch-other-shortcodes' );
		return ( current_user_can( 'publish_posts' ) ) ? '<div class="perch-private' . perch_ecssc( $atts ) . '"><div class="perch-private-shell">' . do_shortcode( $content ) . '</div></div>' : '';
	}

	public static function media( $atts = null, $content = null ) {
		// Check YouTube video
		if ( strpos( $atts['url'], 'youtu' ) !== false ) return Tp_Shortcodes::youtube( $atts );
		// Check Vimeo video
		elseif ( strpos( $atts['url'], 'vimeo' ) !== false ) return Tp_Shortcodes::vimeo( $atts );
		// Image
		else return '<img src="' . $atts['url'] . '" width="' . $atts['width'] . '" height="' . $atts['height'] . '" style="max-width:100%" />';
	}

	public static function youtube( $atts = null, $content = null ) {
		// Prepare data
		$return = array();
		$atts = shortcode_atts( array(
				'url'        => false,
				'width'      => 600,
				'height'     => 400,
				'autoplay'   => 'no',
				'responsive' => 'yes',
				'class'      => ''
			), $atts, 'youtube' );
		if ( !$atts['url'] ) return Tp_Tools::error( __FUNCTION__, __( 'please specify correct url', 'perch' ) );
		$atts['url'] = perch_scattr( $atts['url'] );
		$id = ( preg_match( '%(?:youtube(?:-nocookie)?\.com/(?:[^/]+/.+/|(?:v|e(?:mbed)?)/|.*[?&]v=)|youtu\.be/)([^"&?/ ]{11})%i', $atts['url'], $match ) ) ? $match[1] : false;
		// Check that url is specified
		if ( !$id ) return Tp_Tools::error( __FUNCTION__, __( 'please specify correct url', 'perch' ) );
		// Prepare autoplay
		$autoplay = ( $atts['autoplay'] === 'yes' ) ? '?autoplay=1' : '';
		// Create player
		$return[] = '<div class="perch-youtube perch-responsive-media-' . $atts['responsive'] . perch_ecssc( $atts ) . '">';
		$return[] = '<iframe width="' . $atts['width'] . '" height="' . $atts['height'] . '" src="http://www.youtube.com/embed/' . $id . $autoplay . '" frameborder="0" allowfullscreen="true"></iframe>';
		$return[] = '</div>';
		perch_query_asset( 'css', 'perch-media-shortcodes' );
		// Return result
		return implode( '', $return );
	}

	public static function youtube_advanced( $atts = null, $content = null ) {
		// Prepare data
		$return = array();
		$params = array();
		$atts = shortcode_atts( array(
				'url'            => false,
				'width'          => 600,
				'height'         => 400,
				'responsive'     => 'yes',
				'autohide'       => 'alt',
				'autoplay'       => 'no',
				'controls'       => 'yes',
				'fs'             => 'yes',
				'loop'           => 'no',
				'modestbranding' => 'no',
				'playlist'       => '',
				'rel'            => 'yes',
				'showinfo'       => 'yes',
				'theme'          => 'dark',
				'https'          => 'no',
				'wmode'          => '',
				'class'          => ''
			), $atts, 'youtube_advanced' );
		if ( !$atts['url'] ) return Tp_Tools::error( __FUNCTION__, __( 'please specify correct url', 'perch' ) );
		$atts['url'] = perch_scattr( $atts['url'] );
		$id = ( preg_match( '%(?:youtube(?:-nocookie)?\.com/(?:[^/]+/.+/|(?:v|e(?:mbed)?)/|.*[?&]v=)|youtu\.be/)([^"&?/ ]{11})%i', $atts['url'], $match ) ) ? $match[1] : false;
		// Check that url is specified
		if ( !$id ) return Tp_Tools::error( __FUNCTION__, __( 'please specify correct url', 'perch' ) );
		// Prepare params
		foreach ( array( 'autohide', 'autoplay', 'controls', 'fs', 'loop', 'modestbranding', 'playlist', 'rel', 'showinfo', 'theme', 'wmode' ) as $param ) $params[$param] = str_replace( array( 'no', 'yes', 'alt' ), array( '0', '1', '2' ), $atts[$param] );
		// Correct loop
		if ( $params['loop'] === '1' && $params['playlist'] === '' ) $params['playlist'] = $id;
		// Prepare protocol
		$protocol = ( $atts['https'] === 'yes' ) ? 'https' : 'http';
		// Prepare player parameters
		$params = http_build_query( $params );
		// Create player
		$return[] = '<div class="perch-youtube perch-responsive-media-' . $atts['responsive'] . perch_ecssc( $atts ) . '">';
		$return[] = '<iframe width="' . $atts['width'] . '" height="' . $atts['height'] . '" src="' . $protocol . '://www.youtube.com/embed/' . $id . '?' . $params . '" frameborder="0" allowfullscreen="true"></iframe>';
		$return[] = '</div>';
		perch_query_asset( 'css', 'perch-media-shortcodes' );
		// Return result
		return implode( '', $return );
	}

	public static function vimeo( $atts = null, $content = null ) {
		// Prepare data
		$return = array();
		$atts = shortcode_atts( array(
				'url'        => false,
				'width'      => 600,
				'height'     => 400,
				'autoplay'   => 'no',
				'responsive' => 'yes',
				'class'      => ''
			), $atts, 'vimeo' );
		if ( !$atts['url'] ) return Tp_Tools::error( __FUNCTION__, __( 'please specify correct url', 'perch' ) );
		$atts['url'] = perch_scattr( $atts['url'] );
		$id = ( preg_match( '~(?:<iframe [^>]*src=")?(?:https?:\/\/(?:[\w]+\.)*vimeo\.com(?:[\/\w]*\/videos?)?\/([0-9]+)[^\s]*)"?(?:[^>]*></iframe>)?(?:<p>.*</p>)?~ix', $atts['url'], $match ) ) ? $match[1] : false;
		// Check that url is specified
		if ( !$id ) return Tp_Tools::error( __FUNCTION__, __( 'please specify correct url', 'perch' ) );
		// Prepare autoplay
		$autoplay = ( $atts['autoplay'] === 'yes' ) ? '&amp;autoplay=1' : '';
		// Create player
		$return[] = '<div class="perch-vimeo perch-responsive-media-' . $atts['responsive'] . perch_ecssc( $atts ) . '">';
		$return[] = '<iframe width="' . $atts['width'] . '" height="' . $atts['height'] . '" src="//player.vimeo.com/video/' . $id . '?title=0&amp;byline=0&amp;portrait=0&amp;color=ffffff' . $autoplay . '" frameborder="0" allowfullscreen="true"></iframe>';
		$return[] = '</div>';
		perch_query_asset( 'css', 'perch-media-shortcodes' );
		// Return result
		return implode( '', $return );
	}

	public static function screenr( $atts = null, $content = null ) {
		// Prepare data
		$return = array();
		$atts = shortcode_atts( array(
				'url'        => false,
				'width'      => 600,
				'height'     => 400,
				'responsive' => 'yes',
				'class'      => ''
			), $atts, 'screenr' );
		if ( !$atts['url'] ) return Tp_Tools::error( __FUNCTION__, __( 'please specify correct url', 'perch' ) );
		$atts['url'] = perch_scattr( $atts['url'] );
		$id = ( preg_match( '~(?:<iframe [^>]*src=")?(?:https?:\/\/(?:[\w]+\.)*screenr\.com(?:[\/\w]*\/videos?)?\/([a-zA-Z0-9]+)[^\s]*)"?(?:[^>]*></iframe>)?(?:<p>.*</p>)?~ix', $atts['url'], $match ) ) ? $match[1] : false;
		// Check that url is specified
		if ( !$id ) return Tp_Tools::error( __FUNCTION__, __( 'please specify correct url', 'perch' ) );
		// Create player
		$return[] = '<div class="perch-screenr perch-responsive-media-' . $atts['responsive'] . perch_ecssc( $atts ) . '">';
		$return[] = '<iframe width="' . $atts['width'] . '" height="' . $atts['height'] . '" src="http://screenr.com/embed/' . $id . '" frameborder="0" allowfullscreen="true"></iframe>';
		$return[] = '</div>';
		perch_query_asset( 'css', 'perch-media-shortcodes' );
		// Return result
		return implode( '', $return );
	}

	public static function dailymotion( $atts = null, $content = null ) {
		// Prepare data
		$return = array();
		$atts = shortcode_atts( array(
				'url'        => false,
				'width'      => 600,
				'height'     => 400,
				'responsive' => 'yes',
				'autoplay'   => 'no',
				'background' => '#FFC300',
				'foreground' => '#F7FFFD',
				'highlight'  => '#171D1B',
				'logo'       => 'yes',
				'quality'    => '380',
				'related'    => 'yes',
				'info'       => 'yes',
				'class'      => ''
			), $atts, 'dailymotion' );
		if ( !$atts['url'] ) return Tp_Tools::error( __FUNCTION__, __( 'please specify correct url', 'perch' ) );
		$atts['url'] = perch_scattr( $atts['url'] );
		$id = strtok( basename( $atts['url'] ), '_' );
		// Check that url is specified
		if ( !$id ) return Tp_Tools::error( __FUNCTION__, __( 'please specify correct url', 'perch' ) );
		// Prepare params
		$params = array();
		foreach ( array( 'autoplay', 'background', 'foreground', 'highlight', 'logo', 'quality', 'related', 'info' ) as $param )
			$params[] = $param . '=' . str_replace( array( 'yes', 'no', '#' ), array( '1', '0', '' ), $atts[$param] );
		// Create player
		$return[] = '<div class="perch-dailymotion perch-responsive-media-' . $atts['responsive'] . perch_ecssc( $atts ) . '">';
		$return[] = '<iframe width="' . $atts['width'] . '" height="' . $atts['height'] . '" src="http://www.dailymotion.com/embed/video/' . $id . '?' . implode( '&', $params ) . '" frameborder="0" allowfullscreen="true"></iframe>';
		$return[] = '</div>';
		perch_query_asset( 'css', 'perch-media-shortcodes' );
		// Return result
		return implode( '', $return );
	}

	public static function audio( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'url'      => false,
				'width'    => 'auto',
				'title'    => '',
				'autoplay' => 'no',
				'loop'     => 'no',
				'class'    => ''
			), $atts, 'audio' );
		if ( !$atts['url'] ) return Tp_Tools::error( __FUNCTION__, __( 'please specify correct url', 'perch' ) );
		$atts['url'] = perch_scattr( $atts['url'] );
		// Generate unique ID
		$id = uniqid( 'perch_audio_player_' );
		// Prepare width
		$width = ( $atts['width'] !== 'auto' ) ? 'max-width:' . $atts['width'] : '';
		// Check that url is specified
		if ( !$atts['url'] ) return Tp_Tools::error( __FUNCTION__, __( 'please specify correct url', 'perch' ) );
		perch_query_asset( 'css', 'perch-players-shortcodes' );
		perch_query_asset( 'js', 'jquery' );
		perch_query_asset( 'js', 'jplayer' );
		perch_query_asset( 'js', 'perch-players-shortcodes' );
		perch_query_asset( 'js', 'perch-players-shortcodes' );
		// Create player
		return '<div class="perch-audio' . perch_ecssc( $atts ) . '" data-id="' . $id . '" data-audio="' . $atts['url'] . '" data-swf="' . plugins_url( 'assets/other/Jplayer.swf', TP_PLUGIN_FILE ) . '" data-autoplay="' . $atts['autoplay'] . '" data-loop="' . $atts['loop'] . '" style="' . $width . '"><div id="' . $id . '" class="jp-jplayer"></div><div id="' . $id . '_container" class="jp-audio"><div class="jp-type-single"><div class="jp-gui jp-interface"><div class="jp-controls"><span class="jp-play"></span><span class="jp-pause"></span><span class="jp-stop"></span><span class="jp-mute"></span><span class="jp-unmute"></span><span class="jp-volume-max"></span></div><div class="jp-progress"><div class="jp-seek-bar"><div class="jp-play-bar"></div></div></div><div class="jp-volume-bar"><div class="jp-volume-bar-value"></div></div><div class="jp-current-time"></div><div class="jp-duration"></div></div><div class="jp-title">' . $atts['title'] . '</div></div></div></div>';
	}

	public static function video( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'url'      => false,
				'poster'   => false,
				'title'    => '',
				'width'    => 600,
				'height'   => 300,
				'controls' => 'yes',
				'autoplay' => 'no',
				'loop'     => 'no',
				'class'    => ''
			), $atts, 'video' );
		if ( !$atts['url'] ) return Tp_Tools::error( __FUNCTION__, __( 'please specify correct url', 'perch' ) );
		$atts['url'] = perch_scattr( $atts['url'] );
		// Generate unique ID
		$id = uniqid( 'perch_video_player_' );
		// Check that url is specified
		if ( !$atts['url'] ) return Tp_Tools::error( __FUNCTION__, __( 'please specify correct url', 'perch' ) );
		// Prepare title
		$title = ( $atts['title'] ) ? '<div class="jp-title">' . $atts['title'] . '</div>' : '';
		perch_query_asset( 'css', 'perch-players-shortcodes' );
		perch_query_asset( 'js', 'jquery' );
		perch_query_asset( 'js', 'jplayer' );
		perch_query_asset( 'js', 'perch-players-shortcodes' );
		// Create player
		return '<div style="width:' . $atts['width'] . 'px"><div id="' . $id . '" class="perch-video jp-video perch-video-controls-' . $atts['controls'] . perch_ecssc( $atts ) . '" data-id="' . $id . '" data-video="' . $atts['url'] . '" data-swf="' . plugins_url( 'assets/other/Jplayer.swf', TP_PLUGIN_FILE ) . '" data-autoplay="' . $atts['autoplay'] . '" data-loop="' . $atts['loop'] . '" data-poster="' . $atts['poster'] . '"><div id="' . $id . '_player" class="jp-jplayer" style="width:' . $atts['width'] . 'px;height:' . $atts['height'] . 'px"></div>' . $title . '<div class="jp-start jp-play"></div><div class="jp-gui"><div class="jp-interface"><div class="jp-progress"><div class="jp-seek-bar"><div class="jp-play-bar"></div></div></div><div class="jp-current-time"></div><div class="jp-duration"></div><div class="jp-controls-holder"><span class="jp-play"></span><span class="jp-pause"></span><span class="jp-mute"></span><span class="jp-unmute"></span><span class="jp-full-screen"></span><span class="jp-restore-screen"></span><div class="jp-volume-bar"><div class="jp-volume-bar-value"></div></div></div></div></div></div></div>';
	}

	public static function table( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'style' => 'default',
				'url'   => false,
				'class' => ''
			), $atts, 'table' );
		$return = '<div class="perch-table perch-table-style-'.$atts['style'] . perch_ecssc( $atts ) . '">';
		$return .= ( $atts['url'] ) ? perch_parse_csv( $atts['url'] ) : do_shortcode( $content );
		$return .= '</div>';
		perch_query_asset( 'css', 'perch-content-shortcodes' );
		perch_query_asset( 'js', 'jquery' );
		perch_query_asset( 'js', 'perch-other-shortcodes' );
		return $return;
	}

	public static function permalink( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'id' => 1,
				'p' => null, // 3.x
				'target' => 'self',
				'class' => ''
			), $atts, 'permalink' );
		if ( $atts['p'] !== null ) $atts['id'] = $atts['p'];
		$atts['id'] = perch_scattr( $atts['id'] );
		// Prepare link text
		$text = ( $content ) ? $content : get_the_title( $atts['id'] );
		return '<a href="' . get_permalink( $atts['id'] ) . '" class="' . perch_ecssc( $atts ) . '" title="' . $text . '" target="_' . $atts['target'] . '">' . $text . '</a>';
	}

	public static function members( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'message'    => __( 'This content is for registered users only. Please %login%.', 'perch' ),
				'color'      => '#ffcc00',
				'style'      => null, // 3.x
				'login_text' => __( 'login', 'perch' ),
				'login_url'  => wp_login_url(),
				'login'      => null, // 3.x
				'class'      => ''
			), $atts, 'members' );
		if ( $atts['style'] !== null ) $atts['color'] = str_replace( array( '0', '1', '2' ), array( '#fff', '#FFFF29', '#1F9AFF' ), $atts['style'] );
		// Check feed
		if ( is_feed() ) return;
		// Check authorization
		if ( !is_user_logged_in() ) {
			if ( $atts['login'] !== null && $atts['login'] == '0' ) return; // 3.x
			// Prepare login link
			$login = '<a href="' . esc_attr( $atts['login_url'] ) . '">' . $atts['login_text'] . '</a>';
			perch_query_asset( 'css', 'perch-other-shortcodes' );
			return '<div class="perch-members' . perch_ecssc( $atts ) . '" style="background-color:' . perch_hex_shift( $atts['color'], 'lighter', 50 ) . ';border-color:' .perch_hex_shift( $atts['color'], 'darker', 20 ) . ';color:' .perch_hex_shift( $atts['color'], 'darker', 60 ) . '">' . str_replace( '%login%', $login, perch_scattr( $atts['message'] ) ) . '</div>';
		}
		// Return original content
		else return do_shortcode( $content );
	}

	public static function guests( $atts = null, $content = null ) {
		$atts = shortcode_atts( array( 'class' => '' ), $atts, 'guests' );
		$return = '';
		if ( !is_user_logged_in() && !is_null( $content ) ) {
			perch_query_asset( 'css', 'perch-other-shortcodes' );
			$return = '<div class="perch-guests' . perch_ecssc( $atts ) . '">' . do_shortcode( $content ) . '</div>';
		}
		return $return;
	}

	public static function feed( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'url'   => get_bloginfo_rss( 'rss2_url' ),
				'limit' => 3,
				'class' => ''
			), $atts, 'feed' );
		if ( !function_exists( 'wp_rss' ) ) include_once ABSPATH . WPINC . '/rss.php';
		ob_start();
		echo '<div class="perch-feed' . perch_ecssc( $atts ) . '">';
		wp_rss( $atts['url'], $atts['limit'] );
		echo '</div>';
		$return = ob_get_contents();
		ob_end_clean();
		return $return;
	}

	public static function subpages( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'depth' => 1,
				'p'     => false,
				'class' => ''
			), $atts, 'subpages' );
		global $post;
		$child_of = ( $atts['p'] ) ? $atts['p'] : get_the_ID();
		$return = wp_list_pages( array(
				'title_li' => '',
				'echo' => 0,
				'child_of' => $child_of,
				'depth' => $atts['depth']
			) );
		return ( $return ) ? '<ul class="perch-subpages' . perch_ecssc( $atts ) . '">' . $return . '</ul>' : false;
	}

	public static function siblings( $atts = null, $content = null ) {
		$atts = shortcode_atts( array( 'depth' => 1, 'class' => '' ), $atts, 'siblings' );
		global $post;
		$return = wp_list_pages( array( 'title_li' => '',
				'echo' => 0,
				'child_of' => $post->post_parent,
				'depth' => $atts['depth'],
				'exclude' => $post->ID ) );
		return ( $return ) ? '<ul class="perch-siblings' . perch_ecssc( $atts ) . '">' . $return . '</ul>' : false;
	}

	public static function menu( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'name' => false,
				'class' => ''
			), $atts, 'menu' );
		$return = wp_nav_menu( array(
				'echo'        => false,
				'menu'        => $atts['name'],
				'container'   => false,
				'fallback_cb' => array( __CLASS__, 'menu_fb' ),
				'items_wrap'  => '<ul id="%1$s" class="%2$s' . perch_ecssc( $atts ) . '">%3$s</ul>'
			) );
		return ( $atts['name'] ) ? $return : false;
	}

	public static function menu_fb() {
		return __( 'This menu doesn\'t exists, or has no elements', 'perch' );
	}

	public static function document( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'url'        => '',
				'file'       => null, // 3.x
				'width'      => 600,
				'height'     => 400,
				'responsive' => 'yes',
				'class'      => ''
			), $atts, 'document' );
		if ( $atts['file'] !== null ) $atts['url'] = $atts['file'];
		perch_query_asset( 'css', 'perch-media-shortcodes' );
		return '<div class="perch-document perch-responsive-media-' . $atts['responsive'] . '"><iframe src="//docs.google.com/viewer?embedded=true&url=' . $atts['url'] . '" width="' . $atts['width'] . '" height="' . $atts['height'] . '" class="perch-document' . perch_ecssc( $atts ) . '"></iframe></div>';
	}

	public static function map( $atts = array(), $content= '' ){
		$atts = shortcode_atts( 
			array(
				'latitude' 		=> '51.507207',
				'longitude'		=> "-0.127223",
				'height'        => 500,
				'zoom'  => 12,
				'marker' => plugins_url( 'assets/images/map-marker.png', TP_PLUGIN_FILE ),
			), $atts, 'map' );
		perch_query_asset( 'js', 'perch-map' );

		return '<div id="google-map" style="height:'.$atts['height'].'px" data-latitude="'.$atts['latitude'].'" data-longitude="'.$atts['longitude'].'" data-zoom="'.$atts['zoom'].'" data-marker="'.$atts['marker'].'"></div>';
	}

	public static function gmap( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'width'      => 600,
				'height'     => 400,
				'responsive' => 'yes',
				'address'    => 'New York',
				'class'      => ''
			), $atts, 'gmap' );
		perch_query_asset( 'css', 'perch-media-shortcodes' );
		return '<div class="perch-gmap perch-responsive-media-' . $atts['responsive'] . perch_ecssc( $atts ) . '"><iframe width="' . $atts['width'] . '" height="' . $atts['height'] . '" src="http://maps.google.com/maps?q=' . urlencode( perch_scattr( $atts['address'] ) ) . '&amp;output=embed"></iframe></div>';
	}

	public static function slider( $atts = null, $content = null ) {
		$return = '';
		$atts = shortcode_atts( array(
				'source'     => 'none',
				'limit'      => 20,
				'gallery'    => null, // Dep. 4.3.2
				'link'       => 'none',
				'target'     => 'self',
				'width'      => 600,
				'height'     => 300,
				'responsive' => 'yes',
				'title'      => 'yes',
				'centered'   => 'yes',
				'arrows'     => 'yes',
				'pages'      => 'yes',
				'mousewheel' => 'yes',
				'autoplay'   => 3000,
				'speed'      => 600,
				'class'      => ''
			), $atts, 'slider' );
		// Get slides
		$slides = (array) Tp_Tools::get_slides( $atts );
		// Loop slides
		if ( count( $slides ) ) {
			// Prepare unique ID
			$id = uniqid( 'perch_slider_' );
			// Links target
			$target = ( $atts['target'] === 'yes' || $atts['target'] === 'blank' ) ? ' target="_blank"' : '';
			// Centered class
			$centered = ( $atts['centered'] === 'yes' ) ? ' perch-slider-centered' : '';
			// Wheel control
			$mousewheel = ( $atts['mousewheel'] === 'yes' ) ? 'true' : 'false';
			// Prepare width and height
			$size = ( $atts['responsive'] === 'yes' ) ? 'width:100%' : 'width:' . intval( $atts['width'] ) . 'px;height:' . intval( $atts['height'] ) . 'px';
			// Add lightbox class
			if ( $atts['link'] === 'lightbox' ) $atts['class'] .= ' perch-lightbox-gallery';
			// Open slider
			$return .= '<div id="' . $id . '" class="perch-slider' . $centered . ' perch-slider-pages-' . $atts['pages'] . ' perch-slider-responsive-' . $atts['responsive'] . perch_ecssc( $atts ) . '" style="' . $size . '" data-autoplay="' . $atts['autoplay'] . '" data-speed="' . $atts['speed'] . '" data-mousewheel="' . $mousewheel . '"><div class="perch-slider-slides">';
			// Create slides
			foreach ( $slides as $slide ) {
				// Crop the image
				$image = perch_image_resize( $slide['image'], $atts['width'], $atts['height'] );
				// Prepare slide title
				$title = ( $atts['title'] === 'yes' && $slide['title'] ) ? '<span class="perch-slider-slide-title">' . stripslashes( $slide['title'] ) . '</span>' : '';
				// Open slide
				$return .= '<div class="perch-slider-slide">';
				// Slide content with link
				if ( $slide['link'] ) $return .= '<a href="' . $slide['link'] . '"' . $target . '><img src="' . $image['url'] . '" alt="' . esc_attr( $slide['title'] ) . '" />' . $title . '</a>';
				// Slide content without link
				else $return .= '<a><img src="' . $image['url'] . '" alt="' . esc_attr( $slide['title'] ) . '" />' . $title . '</a>';
				// Close slide
				$return .= '</div>';
			}
			// Close slides
			$return .= '</div>';
			// Open nav section
			$return .= '<div class="perch-slider-nav">';
			// Append direction nav
			if ( $atts['arrows'] === 'yes' ) $return .= '<div class="perch-slider-direction"><span class="perch-slider-prev"></span><span class="perch-slider-next"></span></div>';
			// Append pagination nav
			$return .= '<div class="perch-slider-pagination"></div>';
			// Close nav section
			$return .= '</div>';
			// Close slider
			$return .= '</div>';
			// Add lightbox assets
			if ( $atts['link'] === 'lightbox' ) {
				perch_query_asset( 'css', 'magnific-popup' );
				perch_query_asset( 'js', 'magnific-popup' );
			}
			perch_query_asset( 'css', 'perch-galleries-shortcodes' );
			perch_query_asset( 'js', 'jquery' );
			perch_query_asset( 'js', 'swiper' );
			perch_query_asset( 'js', 'perch-galleries-shortcodes' );
		}
		// Slides not found
		else $return = Tp_Tools::error( __FUNCTION__, __( 'images not found', 'perch' ) );
		return $return;
	}

	public static function carousel( $atts = null, $content = null ) {
		$return = '';
		$atts = shortcode_atts( array(
				'source'     => 'none',
				'limit'      => 20,
				'gallery'    => null, // Dep. 4.3.2
				'link'       => 'none',
				'target'     => 'self',
				'width'      => 600,
				'height'     => 100,
				'responsive' => 'yes',
				'items'      => 3,
				'scroll'     => 1,
				'title'      => 'yes',
				'centered'   => 'yes',
				'arrows'     => 'yes',
				'pages'      => 'no',
				'mousewheel' => 'yes',
				'autoplay'   => 3000,
				'speed'      => 600,
				'class'      => ''
			), $atts, 'carousel' );
		// Get slides
		$slides = (array) Tp_Tools::get_slides( $atts );
		// Loop slides
		if ( count( $slides ) ) {
			// Prepare unique ID
			$id = uniqid( 'perch_carousel_' );
			// Links target
			$target = ( $atts['target'] === 'yes' || $atts['target'] === 'blank' ) ? ' target="_blank"' : '';
			// Centered class
			$centered = ( $atts['centered'] === 'yes' ) ? ' perch-carousel-centered' : '';
			// Wheel control
			$mousewheel = ( $atts['mousewheel'] === 'yes' ) ? 'true' : 'false';
			// Prepare width and height
			$size = ( $atts['responsive'] === 'yes' ) ? 'width:100%' : 'width:' . intval( $atts['width'] ) . 'px;height:' . intval( $atts['height'] ) . 'px';
			// Add lightbox class
			if ( $atts['link'] === 'lightbox' ) $atts['class'] .= ' perch-lightbox-gallery';
			// Open slider
			$return .= '<div id="' . $id . '" class="perch-carousel' . $centered . ' perch-carousel-pages-' . $atts['pages'] . ' perch-carousel-responsive-' . $atts['responsive'] . perch_ecssc( $atts ) . '" style="' . $size . '" data-autoplay="' . $atts['autoplay'] . '" data-speed="' . $atts['speed'] . '" data-mousewheel="' . $mousewheel . '" data-items="' . $atts['items'] . '" data-scroll="' . $atts['scroll'] . '"><div class="perch-carousel-slides">';
			// Create slides
			foreach ( (array) $slides as $slide ) {
				// Crop the image
				$image = perch_image_resize( $slide['image'], ( round( $atts['width'] / $atts['items'] ) - 18 ), $atts['height'] );
				// Prepare slide title
				$title = ( $atts['title'] === 'yes' && $slide['title'] ) ? '<span class="perch-carousel-slide-title">' . stripslashes( $slide['title'] ) . '</span>' : '';
				// Open slide
				$return .= '<div class="perch-carousel-slide">';
				// Slide content with link
				if ( $slide['link'] ) $return .= '<a href="' . $slide['link'] . '"' . $target . '><img src="' . $image['url'] . '" alt="' . esc_attr( $slide['title'] ) . '" />' . $title . '</a>';
				// Slide content without link
				else $return .= '<a><img src="' . $image['url'] . '" alt="' . esc_attr( $slide['title'] ) . '" />' . $title . '</a>';
				// Close slide
				$return .= '</div>';
			}
			// Close slides
			$return .= '</div>';
			// Open nav section
			$return .= '<div class="perch-carousel-nav">';
			// Append direction nav
			if ( $atts['arrows'] === 'yes'
			) $return .= '<div class="perch-carousel-direction"><span class="perch-carousel-prev"></span><span class="perch-carousel-next"></span></div>';
			// Append pagination nav
			$return .= '<div class="perch-carousel-pagination"></div>';
			// Close nav section
			$return .= '</div>';
			// Close slider
			$return .= '</div>';
			// Add lightbox assets
			if ( $atts['link'] === 'lightbox' ) {
				perch_query_asset( 'css', 'magnific-popup' );
				perch_query_asset( 'js', 'magnific-popup' );
			}
			perch_query_asset( 'css', 'perch-galleries-shortcodes' );
			perch_query_asset( 'js', 'jquery' );
			perch_query_asset( 'js', 'swiper' );
			perch_query_asset( 'js', 'perch-galleries-shortcodes' );
		}
		// Slides not found
		else $return = Tp_Tools::error( __FUNCTION__, __( 'images not found', 'perch' ) );
		return $return;
	}



	public static function custom_gallery( $atts = null, $content = null ) {
		$return = '';
		$atts = shortcode_atts( array(
				'source'  => 'none',
				'limit'   => 20,
				'gallery' => null, // Dep. 4.4.0
				'link'    => 'none',
				'width'   => 90,
				'height'  => 90,
				'title'   => 'hover',
				'target'  => 'self',
				'class'   => ''
			), $atts, 'custom_gallery' );
		$slides = (array) Tp_Tools::get_slides( $atts );
		// Loop slides
		if ( count( $slides ) ) {
			// Prepare links target
			$atts['target'] = ( $atts['target'] === 'yes' || $atts['target'] === 'blank' ) ? ' target="_blank"' : '';
			// Add lightbox class
			if ( $atts['link'] === 'lightbox' ) $atts['class'] .= ' perch-lightbox-gallery';
			// Open gallery
			$return = '<div class="perch-custom-gallery perch-custom-gallery-title-' . $atts['title'] . perch_ecssc( $atts ) . '">';
			// Create slides
			foreach ( $slides as $slide ) {
				// Crop image
				$image = perch_image_resize( $slide['image'], $atts['width'], $atts['height'] );
				// Prepare slide title
				$title = ( $slide['title'] ) ? '<span class="perch-custom-gallery-title">' . stripslashes( $slide['title'] ) . '</span>' : '';
				// Open slide
				$return .= '<div class="perch-custom-gallery-slide">';
				// Slide content with link
				if ( $slide['link'] ) $return .= '<a href="' . $slide['link'] . '"' . $atts['target'] . '><img src="' . $image['url'] . '" alt="' . esc_attr( $slide['title'] ) . '" width="' . $atts['width'] . '" height="' . $atts['height'] . '" />' . $title . '</a>';
				// Slide content without link
				else $return .= '<a><img src="' . $image['url'] . '" alt="' . esc_attr( $slide['title'] ) . '" width="' . $atts['width'] . '" height="' . $atts['height'] . '" />' . $title . '</a>';
				// Close slide
				$return .= '</div>';
			}
			// Clear floats
			$return .= '<div class="perch-clear"></div>';
			// Close gallery
			$return .= '</div>';
			// Add lightbox assets
			if ( $atts['link'] === 'lightbox' ) {
				perch_query_asset( 'css', 'magnific-popup' );
				perch_query_asset( 'js', 'jquery' );
				perch_query_asset( 'js', 'magnific-popup' );
				perch_query_asset( 'js', 'perch-galleries-shortcodes' );
			}
			perch_query_asset( 'css', 'perch-galleries-shortcodes' );
		}
		// Slides not found
		else $return = Tp_Tools::error( __FUNCTION__, __( 'images not found', 'perch' ) );
		return $return;
	}

	public static function posts( $atts = null, $content = null ) {
		// Prepare error var
		$error = null;
		// Parse attributes
		$atts = shortcode_atts( array(
				'template'            => 'templates/default-loop.php',
				'column'			  => 2,
				'large_box_posts'	  => 1,
				'id'                  => false,
				'posts_per_page'      => get_option( 'posts_per_page' ),
				'post_type'           => 'post',
				'taxonomy'            => 'category',
				'tax_term'            => false,
				'tax_operator'        => 'IN',
				'author'              => '',
				'tag'                 => '',
				'meta_key'            => '',
				'offset'              => 0,
				'order'               => 'DESC',
				'orderby'             => 'date',
				'post_parent'         => false,
				'post_status'         => 'publish',
				'ignore_sticky_posts' => 'no',
				'related_posts' => 'yes',
				'author_info' => 'no',
				'pagination' => 'yes',
				'sidebar' => 'sidebar-1',
				'sidebar_position' => 'rs'
			), $atts, 'posts' );

		$original_atts = $atts;

		$author = sanitize_text_field( $atts['author'] );
		$id = $atts['id']; // Sanitized later as an array of integers
		$ignore_sticky_posts = ( bool ) ( $atts['ignore_sticky_posts'] === 'yes' ) ? true : false;
		$meta_key = sanitize_text_field( $atts['meta_key'] );
		$offset = intval( $atts['offset'] );
		$order = sanitize_key( $atts['order'] );
		$orderby = sanitize_key( $atts['orderby'] );
		$post_parent = $atts['post_parent'];
		$post_status = $atts['post_status'];
		$post_type = sanitize_text_field( $atts['post_type'] );
		$posts_per_page = intval( $atts['posts_per_page'] );
		$tag = sanitize_text_field( $atts['tag'] );
		$tax_operator = $atts['tax_operator'];
		$tax_term = sanitize_text_field( $atts['tax_term'] );
		$taxonomy = sanitize_key( $atts['taxonomy'] );
		// Set up initial query for post
		$args = array(
			'category_name'  => '',
			'order'          => $order,
			'orderby'        => $orderby,
			'post_type'      => explode( ',', $post_type ),
			'posts_per_page' => $posts_per_page,
			'tag'            => $tag
		);
		// Ignore Sticky Posts
		if ( $ignore_sticky_posts ) $args['ignore_sticky_posts'] = true;
		// Meta key (for ordering)
		if ( !empty( $meta_key ) ) $args['meta_key'] = $meta_key;
		// If Post IDs
		if ( $id ) {
			$posts_in = array_map( 'intval', explode( ',', $id ) );
			$args['post__in'] = $posts_in;
		}
		// Post Author
		if ( !empty( $author ) ) $args['author'] = $author;
		// Offset
		if ( !empty( $offset ) ) $args['offset'] = $offset;
		// Post Status
		$post_status = explode( ', ', $post_status );
		$validated = array();
		$available = array( 'publish', 'pending', 'draft', 'auto-draft', 'future', 'private', 'inherit', 'trash', 'any' );
		foreach ( $post_status as $unvalidated ) {
			if ( in_array( $unvalidated, $available ) ) $validated[] = $unvalidated;
		}
		if ( !empty( $validated ) ) $args['post_status'] = $validated;
		// If taxonomy attributes, create a taxonomy query
		if ( !empty( $taxonomy ) && !empty( $tax_term ) ) {
			// Term string to array
			$tax_term = explode( ',', $tax_term );
			// Validate operator
			if ( !in_array( $tax_operator, array( 'IN', 'NOT IN', 'AND' ) ) ) $tax_operator = 'IN';
			$tax_args = array( 'tax_query' => array( array(
						'taxonomy' => $taxonomy,
						'field' => ( is_numeric( $tax_term[0] ) ) ? 'id' : 'slug',
						'terms' => $tax_term,
						'operator' => $tax_operator ) ) );
			// Check for multiple taxonomy queries
			$count = 2;
			$more_tax_queries = false;
			while ( isset( $original_atts['taxonomy_' . $count] ) && !empty( $original_atts['taxonomy_' . $count] ) &&
				isset( $original_atts['tax_' . $count . '_term'] ) &&
				!empty( $original_atts['tax_' . $count . '_term'] ) ) {
				// Sanitize values
				$more_tax_queries = true;
				$taxonomy = sanitize_key( $original_atts['taxonomy_' . $count] );
				$terms = explode( ', ', sanitize_text_field( $original_atts['tax_' . $count . '_term'] ) );
				$tax_operator = isset( $original_atts['tax_' . $count . '_operator'] ) ? $original_atts[
				'tax_' . $count . '_operator'] : 'IN';
				$tax_operator = in_array( $tax_operator, array( 'IN', 'NOT IN', 'AND' ) ) ? $tax_operator : 'IN';
				$tax_args['tax_query'][] = array( 'taxonomy' => $taxonomy,
					'field' => 'slug',
					'terms' => $terms,
					'operator' => $tax_operator );
				$count++;
			}
			if ( $more_tax_queries ):
				$tax_relation = 'AND';
			if ( isset( $original_atts['tax_relation'] ) &&
				in_array( $original_atts['tax_relation'], array( 'AND', 'OR' ) )
			) $tax_relation = $original_atts['tax_relation'];
			$args['tax_query']['relation'] = $tax_relation;
			endif;
			$args = array_merge( $args, $tax_args );
		}

		// Fix for pagination
		if( is_front_page() ) { 
			$paged = ( get_query_var( 'page' ) ) ? get_query_var( 'page' ) : 1; 
		} else { 
			$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1; 
		}
		$args['paged'] = $paged;

		// If post parent attribute, set up parent
		if ( $post_parent ) {
			if ( 'current' == $post_parent ) {
				global $post;
				$post_parent = $post->ID;
			}
			$args['post_parent'] = intval( $post_parent );
		}
		// Save original posts
		global $posts;
		$original_posts = $posts;


		// Query posts
		$posts = new WP_Query( $args );
		$posts->pagination = $atts['pagination'];
		$posts->column = $atts['column'];
		$posts->large_box_posts = $atts['large_box_posts'];
		$posts->sidebar = $atts['sidebar'];
		$posts->sidebar_position = $atts['sidebar_position'];
		$posts->related_posts = $atts['related_posts'];
		$posts->author_info = $atts['author_info'];
		// Buffer output
		ob_start();
		// Search for template in stylesheet directory
		if ( file_exists( STYLESHEETPATH . '/' . $atts['template'] ) ) load_template( STYLESHEETPATH . '/' . $atts['template'], false );
		// Search for template in theme directory
		elseif ( file_exists( TEMPLATEPATH . '/' . $atts['template'] ) ) load_template( TEMPLATEPATH . '/' . $atts['template'], false );
		// Search for template in plugin directory
		elseif ( path_join( dirname( TP_PLUGIN_FILE ), $atts['template'] ) ) load_template( path_join( dirname( TP_PLUGIN_FILE ), $atts['template'] ), false );
		// Template not found
		else echo Tp_Tools::error( __FUNCTION__, __( 'template not found', 'perch' ) );
		$output = ob_get_contents();
		ob_end_clean();
		// Return original posts
		$posts = $original_posts;
		// Reset the query
		wp_reset_postdata();
		
		return $output;
	}
	//products_carousel
	public static function products_carousel( $atts = null, $content = null ) {
		// Prepare error var
		$error = null;
		// Parse attributes
		$atts = shortcode_atts( array(
				'style'				 => 'default',
				'template'            => 'templates/products-carousel.php',
				'id'                  => false,
				'posts_per_page'      => get_option( 'posts_per_page' ),
				'product_type'      => 'all',
				'post_type'           => 'product',
				'taxonomy'            => 'product_cat',
				'tax_term'            => false,
				'tax_operator'        => 'IN',
				'author'              => '',
				'tag'                 => '',
				'meta_key'            => '',
				'offset'              => 0,
				'order'               => 'DESC',
				'orderby'             => 'date',
				'post_parent'         => false,
				'post_status'         => 'publish',
				'ignore_sticky_posts' => 'no',
				'items' => 4,
				'width' => 400,
				'height' => 300,
				'add_to_cart' => 'yes',
				'controls' => 'no',
				'autoplay' => 'yes'
			), $atts, 'products_carousel' );

		$original_atts = $atts;

		$author = sanitize_text_field( $atts['author'] );
		$id = $atts['id']; // Sanitized later as an array of integers
		$ignore_sticky_posts = ( bool ) ( $atts['ignore_sticky_posts'] === 'yes' ) ? true : false;
		$meta_key = sanitize_text_field( $atts['meta_key'] );
		$offset = intval( $atts['offset'] );
		$order = sanitize_key( $atts['order'] );
		$orderby = sanitize_key( $atts['orderby'] );
		$post_parent = $atts['post_parent'];
		$post_status = $atts['post_status'];
		$post_type = sanitize_text_field( $atts['post_type'] );
		$posts_per_page = intval( $atts['posts_per_page'] );
		$tag = sanitize_text_field( $atts['tag'] );
		$tax_operator = $atts['tax_operator'];
		$tax_term = sanitize_text_field( $atts['tax_term'] );
		$taxonomy = sanitize_key( $atts['taxonomy'] );
		// Set up initial query for post
		$args = array(
			'category_name'  => '',
			'order'          => $order,
			'orderby'        => $orderby,
			'post_type'      => explode( ',', $post_type ),
			'posts_per_page' => $posts_per_page,
			'tag'            => $tag
		);
		// Ignore Sticky Posts
		if ( $ignore_sticky_posts ) $args['ignore_sticky_posts'] = true;
		// Meta key (for ordering)
		if ( !empty( $meta_key ) ) $args['meta_key'] = $meta_key;
		// If Post IDs
		if ( $id ) {
			$posts_in = array_map( 'intval', explode( ',', $id ) );
			$args['post__in'] = $posts_in;
		}
		// Post Author
		if ( !empty( $author ) ) $args['author'] = $author;
		// Offset
		if ( !empty( $offset ) ) $args['offset'] = $offset;
		// Post Status
		$post_status = explode( ', ', $post_status );
		$validated = array();
		$available = array( 'publish', 'pending', 'draft', 'auto-draft', 'future', 'private', 'inherit', 'trash', 'any' );
		foreach ( $post_status as $unvalidated ) {
			if ( in_array( $unvalidated, $available ) ) $validated[] = $unvalidated;
		}
		if ( !empty( $validated ) ) $args['post_status'] = $validated;
		// If taxonomy attributes, create a taxonomy query
		if ( !empty( $taxonomy ) && !empty( $tax_term ) ) {
			// Term string to array
			$tax_term = explode( ',', $tax_term );
			// Validate operator
			if ( !in_array( $tax_operator, array( 'IN', 'NOT IN', 'AND' ) ) ) $tax_operator = 'IN';
			$tax_args = array( 'tax_query' => array( array(
						'taxonomy' => $taxonomy,
						'field' => ( is_numeric( $tax_term[0] ) ) ? 'id' : 'slug',
						'terms' => $tax_term,
						'operator' => $tax_operator ) ) );
			// Check for multiple taxonomy queries
			$count = 2;
			$more_tax_queries = false;
			while ( isset( $original_atts['taxonomy_' . $count] ) && !empty( $original_atts['taxonomy_' . $count] ) &&
				isset( $original_atts['tax_' . $count . '_term'] ) &&
				!empty( $original_atts['tax_' . $count . '_term'] ) ) {
				// Sanitize values
				$more_tax_queries = true;
				$taxonomy = sanitize_key( $original_atts['taxonomy_' . $count] );
				$terms = explode( ', ', sanitize_text_field( $original_atts['tax_' . $count . '_term'] ) );
				$tax_operator = isset( $original_atts['tax_' . $count . '_operator'] ) ? $original_atts[
				'tax_' . $count . '_operator'] : 'IN';
				$tax_operator = in_array( $tax_operator, array( 'IN', 'NOT IN', 'AND' ) ) ? $tax_operator : 'IN';
				$tax_args['tax_query'][] = array( 'taxonomy' => $taxonomy,
					'field' => 'slug',
					'terms' => $terms,
					'operator' => $tax_operator );
				$count++;
			}
			if ( $more_tax_queries ):
				$tax_relation = 'AND';
			if ( isset( $original_atts['tax_relation'] ) &&
				in_array( $original_atts['tax_relation'], array( 'AND', 'OR' ) )
			) $tax_relation = $original_atts['tax_relation'];
			$args['tax_query']['relation'] = $tax_relation;
			endif;
			$args = array_merge( $args, $tax_args );
		}

		// If post parent attribute, set up parent
		if ( $post_parent ) {
			if ( 'current' == $post_parent ) {
				global $post;
				$post_parent = $post->ID;
			}
			$args['post_parent'] = intval( $post_parent );
		}
		$show = $atts['product_type'];
		switch ( $show ) {
			case 'featured' :
				$args['meta_query'][] = array(
					'key'   => '_featured',
					'value' => 'yes'
				);
				break;
			case 'onsale' :
				$product_ids_on_sale    = wc_get_product_ids_on_sale();
				$product_ids_on_sale[]  = 0;
				$args['post__in'] = $product_ids_on_sale;
				break;
		}
		// Save original posts
		global $posts;
		$original_posts = $posts;
		// Query posts
		$posts = new WP_Query( $args );
		$posts->items = $atts['items'];
		$posts->width = $atts['width'];
		$posts->height = $atts['height'];
		$posts->add_to_cart = $atts['add_to_cart'];
		$posts->controls = $atts['controls'];
		$posts->autoplay = $atts['autoplay'];
		$posts->style = $atts['style'];
		// Buffer output
		ob_start();
		// Search for template in stylesheet directory
		if ( file_exists( STYLESHEETPATH . '/' . $atts['template'] ) ) load_template( STYLESHEETPATH . '/' . $atts['template'], false );
		// Search for template in theme directory
		elseif ( file_exists( TEMPLATEPATH . '/' . $atts['template'] ) ) load_template( TEMPLATEPATH . '/' . $atts['template'], false );
		// Search for template in plugin directory
		elseif ( path_join( dirname( TP_PLUGIN_FILE ), $atts['template'] ) ) load_template( path_join( dirname( TP_PLUGIN_FILE ), $atts['template'] ), false );
		// Template not found
		else echo Tp_Tools::error( __FUNCTION__, __( 'template not found', 'perch' ) );
		$output = ob_get_contents();
		ob_end_clean();
		// Return original posts
		$posts = $original_posts;
		// Reset the query
		wp_reset_postdata();
		perch_query_asset( 'css', 'owl-carousel' );
		perch_query_asset( 'js', 'owl-carousel' );
		perch_query_asset( 'css', 'perch-content-shortcodes' );
		perch_query_asset( 'js', 'bohopeople' );
		return $output;
	}

	public static function clients_carousel( $atts = null, $content = null ) {
		$return = '';
		$atts = shortcode_atts( array(
				'source'     => 'none',
				'limit'      => 20,
				'gallery'    => null, // Dep. 4.3.2
				'link'       => 'none',
				'autoplay'       => 'yes',
				'border_top'       => 'yes',
				'border_bottom'       => 'yes',
				'item'       => 5,
			), $atts, 'clients_carousel' );
		// Get slides
		$slides = (array) Tp_Tools::get_slides( $atts );
		// Loop slides
		if ( count( $slides ) ) {
			perch_query_asset( 'css', 'owl-carousel' );
			perch_query_asset( 'js', 'owl-carousel' );
			perch_query_asset( 'css', 'perch-content-shortcodes' );
			perch_query_asset( 'js', 'bohopeople' );
			$return .= '<div class="clients_carousel border-top-'.$atts['border_top'].' border-bottom-'.$atts['border_bottom'].'" data-item="'.$atts['item'].'" data-autoplay="'. (($atts['autoplay'] == 'no')? 0 : 1 ).'">';
			// Create slides
			foreach ( (array) $slides as $slide ) {
				// Crop the image
				$return .= '<div class="client-logo">';
				// Slide content without link
				$return .= '<img src="' . $slide['image'] . '" alt="' . esc_attr( $slide['title'] ) . '" />';
				// Close slide
				$return .= '</div>';
			}
			$return .= '</div>';
			
		}
		// Slides not found
		else $return = Tp_Tools::error( __FUNCTION__, __( 'images not found', 'perch' ) );
		return $return;
	}

	//product_image_gallery
	public static function product_image_gallery( $atts = null, $content = null ) {
		// Prepare error var
		$error = null;
		// Parse attributes
		$atts = shortcode_atts( array(
				'id'                  => false,
				'template'            => 'templates/products-gallery.php',
				'posts_per_page'      => 9,
				'post_type'           => 'product',
				'taxonomy'            => 'product_cat',
				'tax_term'            => false,
				'tax_operator'        => 'IN',
				'author'              => '',
				'tag'                 => '',
				'meta_key'            => '',
				'offset'              => 0,
				'order'               => 'DESC',
				'orderby'             => 'date',
				'post_parent'         => false,
				'post_status'         => 'publish',
				'ignore_sticky_posts' => 'no',
				'column' => 3,
				'width' => 88,
				'height' => 110,
				'title'  => 'no'
			), $atts, 'product_image_gallery' );

		$original_atts = $atts;

		$author = sanitize_text_field( $atts['author'] );
		$id = $atts['id']; // Sanitized later as an array of integers
		$ignore_sticky_posts = ( bool ) ( $atts['ignore_sticky_posts'] === 'yes' ) ? true : false;
		$meta_key = sanitize_text_field( $atts['meta_key'] );
		$offset = intval( $atts['offset'] );
		$order = sanitize_key( $atts['order'] );
		$orderby = sanitize_key( $atts['orderby'] );
		$post_parent = $atts['post_parent'];
		$post_status = $atts['post_status'];
		$post_type = sanitize_text_field( $atts['post_type'] );
		$posts_per_page = intval( $atts['posts_per_page'] );
		$tag = sanitize_text_field( $atts['tag'] );
		$tax_operator = $atts['tax_operator'];
		$tax_term = sanitize_text_field( $atts['tax_term'] );
		$taxonomy = sanitize_key( $atts['taxonomy'] );
		// Set up initial query for post
		$args = array(
			'category_name'  => '',
			'order'          => $order,
			'orderby'        => $orderby,
			'post_type'      => explode( ',', $post_type ),
			'posts_per_page' => $posts_per_page,
			'tag'            => $tag
		);
		// Ignore Sticky Posts
		if ( $ignore_sticky_posts ) $args['ignore_sticky_posts'] = true;
		// Meta key (for ordering)
		if ( !empty( $meta_key ) ) $args['meta_key'] = $meta_key;
		// If Post IDs
		if ( $id ) {
			$posts_in = array_map( 'intval', explode( ',', $id ) );
			$args['post__in'] = $posts_in;
		}
		// Post Author
		if ( !empty( $author ) ) $args['author'] = $author;
		// Offset
		if ( !empty( $offset ) ) $args['offset'] = $offset;
		// Post Status
		$post_status = explode( ', ', $post_status );
		$validated = array();
		$available = array( 'publish', 'pending', 'draft', 'auto-draft', 'future', 'private', 'inherit', 'trash', 'any' );
		foreach ( $post_status as $unvalidated ) {
			if ( in_array( $unvalidated, $available ) ) $validated[] = $unvalidated;
		}
		if ( !empty( $validated ) ) $args['post_status'] = $validated;
		// If taxonomy attributes, create a taxonomy query
		if ( !empty( $taxonomy ) && !empty( $tax_term ) ) {
			// Term string to array
			$tax_term = explode( ',', $tax_term );
			// Validate operator
			if ( !in_array( $tax_operator, array( 'IN', 'NOT IN', 'AND' ) ) ) $tax_operator = 'IN';
			$tax_args = array( 'tax_query' => array( array(
						'taxonomy' => $taxonomy,
						'field' => ( is_numeric( $tax_term[0] ) ) ? 'id' : 'slug',
						'terms' => $tax_term,
						'operator' => $tax_operator ) ) );
			// Check for multiple taxonomy queries
			$count = 2;
			$more_tax_queries = false;
			while ( isset( $original_atts['taxonomy_' . $count] ) && !empty( $original_atts['taxonomy_' . $count] ) &&
				isset( $original_atts['tax_' . $count . '_term'] ) &&
				!empty( $original_atts['tax_' . $count . '_term'] ) ) {
				// Sanitize values
				$more_tax_queries = true;
				$taxonomy = sanitize_key( $original_atts['taxonomy_' . $count] );
				$terms = explode( ', ', sanitize_text_field( $original_atts['tax_' . $count . '_term'] ) );
				$tax_operator = isset( $original_atts['tax_' . $count . '_operator'] ) ? $original_atts[
				'tax_' . $count . '_operator'] : 'IN';
				$tax_operator = in_array( $tax_operator, array( 'IN', 'NOT IN', 'AND' ) ) ? $tax_operator : 'IN';
				$tax_args['tax_query'][] = array( 'taxonomy' => $taxonomy,
					'field' => 'slug',
					'terms' => $terms,
					'operator' => $tax_operator );
				$count++;
			}
			if ( $more_tax_queries ):
				$tax_relation = 'AND';
			if ( isset( $original_atts['tax_relation'] ) &&
				in_array( $original_atts['tax_relation'], array( 'AND', 'OR' ) )
			) $tax_relation = $original_atts['tax_relation'];
			$args['tax_query']['relation'] = $tax_relation;
			endif;
			$args = array_merge( $args, $tax_args );
		}

		// If post parent attribute, set up parent
		if ( $post_parent ) {
			if ( 'current' == $post_parent ) {
				global $post;
				$post_parent = $post->ID;
			}
			$args['post_parent'] = intval( $post_parent );
		}
		// Save original posts
		global $posts;
		$original_posts = $posts;
		// Query posts
		$posts = new WP_Query( $args );
		$posts->column = $atts['column'];
		$posts->width = $atts['width'];
		$posts->height = $atts['height'];
		$posts->title = $atts['title'];
		// Buffer output
		ob_start();
		// Search for template in stylesheet directory
		if ( file_exists( STYLESHEETPATH . '/' . $atts['template'] ) ) load_template( STYLESHEETPATH . '/' . $atts['template'], false );
		// Search for template in theme directory
		elseif ( file_exists( TEMPLATEPATH . '/' . $atts['template'] ) ) load_template( TEMPLATEPATH . '/' . $atts['template'], false );
		// Search for template in plugin directory
		elseif ( path_join( dirname( TP_PLUGIN_FILE ), $atts['template'] ) ) load_template( path_join( dirname( TP_PLUGIN_FILE ), $atts['template'] ), false );
		// Template not found
		else echo Tp_Tools::error( __FUNCTION__, __( 'template not found', 'perch' ) );
		$output = ob_get_contents();
		ob_end_clean();
		// Return original posts
		$posts = $original_posts;
		// Reset the query
		wp_reset_postdata();
		
		perch_query_asset( 'css', 'perch-content-shortcodes' );
		
		return $output;
	}

	public static function dummy_text( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'amount' => 1,
				'what'   => 'paras',
				'cache'  => 'yes',
				'class'  => ''
			), $atts, 'dummy_text' );
		$transient = 'perch/cache/dummy_text/' . sanitize_text_field( $atts['what'] ) . '/' . intval( $atts['amount'] );
		$return = get_transient( $transient );
		if ( $return && $atts['cache'] === 'yes' && TP_ENABLE_CACHE ) return $return;
		else {
			$xml = simplexml_load_file( 'http://www.lipsum.com/feed/xml?amount=' . $atts['amount'] . '&what=' . $atts['what'] . '&start=0' );
			$return = '<div class="perch-dummy-text' . perch_ecssc( $atts ) . '">' . wpautop( str_replace( "\n", "\n\n", $xml->lipsum ) ) . '</div>';
			set_transient( $transient, $return, 60*60*24*30 );
			return $return;
		}
	}

	public static function dummy_image( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'width'  => 500,
				'height' => 300,
				'theme'  => 'any',
				'class'  => ''
			), $atts, 'dummy_image' );
		$url = 'http://lorempixel.com/' . $atts['width'] . '/' . $atts['height'] . '/';
		if ( $atts['theme'] !== 'any' ) $url .= $atts['theme'] . '/' . rand( 0, 10 ) . '/';
		return '<img src="' . $url . '" alt="' . __( 'Dummy image', 'perch' ) . '" width="' . $atts['width'] . '" height="' . $atts['height'] . '" class="perch-dummy-image' . perch_ecssc( $atts ) . '" />';
	}

	public static function animate( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'type'      => 'bounceIn',
				'duration'  => 1,
				'delay'     => 0,
				'inline'    => 'no',
				'class'     => ''
			), $atts, 'animate' );
		$tag = ( $atts['inline'] === 'yes' ) ? 'span' : 'div';
		$time = '-webkit-animation-duration:' . $atts['duration'] . 's;-webkit-animation-delay:' . $atts['delay'] . 's;animation-duration:' . $atts['duration'] . 's;animation-delay:' . $atts['delay'] . 's;';
		$return = '<' . $tag . ' class="perch-animate' . perch_ecssc( $atts ) . '" style="visibility:hidden;' . $time . '" data-animation="' . $atts['type'] . '" data-duration="' . $atts['duration'] . '" data-delay="' . $atts['delay'] . '">' . do_shortcode( $content ) . '</' . $tag . '>';
		perch_query_asset( 'css', 'animate' );
		perch_query_asset( 'js', 'jquery' );
		perch_query_asset( 'js', 'inview' );
		perch_query_asset( 'js', 'perch-other-shortcodes' );
		return $return;
	}

	public static function meta( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'key'     => '',
				'default' => '',
				'before'  => '',
				'after'   => '',
				'post_id' => '',
				'filter'  => ''
			), $atts, 'meta' );
		// Define current post ID
		if ( !$atts['post_id'] ) $atts['post_id'] = get_the_ID();
		// Check post ID
		if ( !is_numeric( $atts['post_id'] ) || $atts['post_id'] < 1 ) return sprintf( '<p class="perch-error">Meta: %s</p>', __( 'post ID is incorrect', 'perch' ) );
		// Check key name
		if ( !$atts['key'] ) return sprintf( '<p class="perch-error">Meta: %s</p>', __( 'please specify meta key name', 'perch' ) );
		// Get the meta
		$meta = get_post_meta( $atts['post_id'], $atts['key'], true );
		// Set default value if meta is empty
		if ( !$meta ) $meta = $atts['default'];
		// Apply cutom filter
		if ( $atts['filter'] && function_exists( $atts['filter'] ) ) $meta = call_user_func( $atts['filter'], $meta );
		// Return result
		return ( $meta ) ? $atts['before'] . $meta . $atts['after'] : '';
	}

	public static function user( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'field'   => 'display_name',
				'default' => '',
				'before'  => '',
				'after'   => '',
				'user_id' => '',
				'filter'  => ''
			), $atts, 'user' );
		// Check for password requests
		if ( $atts['field'] === 'user_pass' ) return sprintf( '<p class="perch-error">User: %s</p>', __( 'password field is not allowed', 'perch' ) );
		// Define current user ID
		if ( !$atts['user_id'] ) $atts['user_id'] = get_current_user_id();
		// Check user ID
		if ( !is_numeric( $atts['user_id'] ) || $atts['user_id'] < 1 ) return sprintf( '<p class="perch-error">User: %s</p>', __( 'user ID is incorrect', 'perch' ) );
		// Get user data
		$user = get_user_by( 'id', $atts['user_id'] );
		// Get user data if user was found
		$user = ( $user && isset( $user->data->$atts['field'] ) ) ? $user->data->$atts['field'] : $atts['default'];
		// Apply cutom filter
		if ( $atts['filter'] && function_exists( $atts['filter'] ) ) $user = call_user_func( $atts['filter'], $user );
		// Return result
		return ( $user ) ? $atts['before'] . $user . $atts['after'] : '';
	}

	public static function post( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'field'   => 'post_title',
				'default' => '',
				'before'  => '',
				'after'   => '',
				'post_id' => '',
				'filter'  => ''
			), $atts, 'post' );
		// Define current post ID
		if ( !$atts['post_id'] ) $atts['post_id'] = get_the_ID();
		// Check post ID
		if ( !is_numeric( $atts['post_id'] ) || $atts['post_id'] < 1 ) return sprintf( '<p class="perch-error">Post: %s</p>', __( 'post ID is incorrect', 'perch' ) );
		// Get the post
		$post = get_post( $atts['post_id'] );
		// Set default value if meta is empty
		$post = ( empty( $post ) || empty( $post->$atts['field'] ) ) ? $atts['default'] : $post->$atts['field'];
		// Apply cutom filter
		if ( $atts['filter'] && function_exists( $atts['filter'] ) ) $post = call_user_func( $atts['filter'], $post );
		// Return result
		return ( $post ) ? $atts['before'] . $post . $atts['after'] : '';
	}

	// public static function post_terms( $atts = null, $content = null ) {
	//  $atts = shortcode_atts( array(
	//    'post_id'  => '',
	//    'taxonomy' => 'category',
	//    'limit'    => '5',
	//    'links'    => '',
	//    'format'   => ''
	//   ), $atts, 'post_terms' );
	//  // Define current post ID
	//  if ( !$atts['post_id'] ) $atts['post_id'] = get_the_ID();
	//  // Check post ID
	//  if ( !is_numeric( $atts['post_id'] ) || $atts['post_id'] < 1 ) return sprintf( '<p class="perch-error">Post terms: %s</p>', __( 'post ID is incorrect', 'perch' ) );
	// }

	public static function template( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'name' => ''
			), $atts, 'template' );
		// Check template name
		if ( !$atts['name'] ) return sprintf( '<p class="perch-error">Template: %s</p>', __( 'please specify template name', 'perch' ) );
		// Get template output
		ob_start();
		get_template_part( str_replace( '.php', '', $atts['name'] ) );
		$output = ob_get_contents();
		ob_end_clean();
		// Return result
		return $output;
	}

	public static function qrcode( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'data' => '',
				'title' => '',
				'size' => 200,
				'margin' => 0,
				'align' => 'none',
				'link' => '',
				'target' => 'blank',
				'color' => '#000000',
				'background' => '#ffffff',
				'class' => ''
			), $atts, 'qrcode' );
		// Check the data
		if ( !$atts['data'] ) return 'QR code: ' . __( 'please specify the data', 'perch' );
		// Prepare link
		$href = ( $atts['link'] ) ? ' href="' . $atts['link'] . '"' : '';
		// Prepare clickable class
		if ( $atts['link'] ) $atts['class'] .= ' perch-qrcode-clickable';
		// Prepare title
		$atts['title'] = esc_attr( $atts['title'] );
		// Query assets
		perch_query_asset( 'css', 'perch-content-shortcodes' );
		// Return result
		return '<span class="perch-qrcode perch-qrcode-align-' . $atts['align'] . perch_ecssc( $atts ) . '"><a' . $href . ' target="_' . $atts['target'] . '" title="' . $atts['title'] . '"><img src="https://api.qrserver.com/v1/create-qr-code/?data=' . urlencode( $atts['data'] ) . '&size=' . $atts['size'] . 'x' . $atts['size'] . '&format=png&margin=' . $atts['margin'] . '&color=' . perch_hex2rgb( $atts['color'] ) . '&bgcolor=' . perch_hex2rgb( $atts['background'] ) . '" alt="' . $atts['title'] . '" /></a></span>';
	}

	public static function scheduler( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'time'       => 'all',
				'days_week'  => 'all',
				'days_month' => 'all',
				'months'     => 'all',
				'years'      => 'all',
				'alt'        => ''
			), $atts, 'scheduler' );
		// Check time
		if ( $atts['time'] !== 'all' ) {
			// Get current time
			$now = current_time( 'timestamp', 0 );
			// Sanitize
			$atts['time'] = preg_replace( "/[^0-9-,:]/", '', $atts['time'] );
			// Loop time ranges
			foreach( explode( ',', $atts['time'] ) as $range ) {
				// Check for range symbol
				if ( strpos( $range, '-' ) === false ) return Tp_Tools::error( __FUNCTION__, sprintf( __( 'Incorrect time range (%s). Please use - (minus) symbol to specify time range. Example: 14:00 - 18:00', 'perch' ), $range ) );
				// Split begin/end time
				$time = explode( '-', $range );
				// Add minutes
				if ( strpos( $time[0], ':' ) === false ) $time[0] .= ':00';
				if ( strpos( $time[1], ':' ) === false ) $time[1] .= ':00';
				// Parse begin/end time
				$time[0] = strtotime( $time[0] );
				$time[1] = strtotime( $time[1] );
				// Check time
				if ( $now < $time[0] || $now > $time[1] ) return $atts['alt'];
			}
		}
		// Check day of the week
		if ( $atts['days_week'] !== 'all' ) {
			// Get current day of the week
			$today = date( 'w', current_time( 'timestamp', 0 ) );
			// Sanitize input
			$atts['days_week'] = preg_replace( "/[^0-9-,]/", '', $atts['days_week'] );
			// Parse days range
			$days = Tp_Tools::range( $atts['days_week'] );
			// Check current day
			if ( !in_array( $today, $days ) ) return $atts['alt'];
		}
		// Check day of the month
		if ( $atts['days_month'] !== 'all' ) {
			// Get current day of the month
			$today = date( 'j', current_time( 'timestamp', 0 ) );
			// Sanitize input
			$atts['days_month'] = preg_replace( "/[^0-9-,]/", '', $atts['days_month'] );
			// Parse days range
			$days = Tp_Tools::range( $atts['days_month'] );
			// Check current day
			if ( !in_array( $today, $days ) ) return $atts['alt'];
		}
		// Check month
		if ( $atts['months'] !== 'all' ) {
			// Get current month
			$now = date( 'n', current_time( 'timestamp', 0 ) );
			// Sanitize input
			$atts['months'] = preg_replace( "/[^0-9-,]/", '', $atts['months'] );
			// Parse months range
			$months = Tp_Tools::range( $atts['months'] );
			// Check current month
			if ( !in_array( $now, $months ) ) return $atts['alt'];
		}
		// Check year
		if ( $atts['years'] !== 'all' ) {
			// Get current year
			$now = date( 'Y', current_time( 'timestamp', 0 ) );
			// Sanitize input
			$atts['years'] = preg_replace( "/[^0-9-,]/", '', $atts['years'] );
			// Parse years range
			$years = Tp_Tools::range( $atts['years'] );
			// Check current year
			if ( !in_array( $now, $years ) ) return $atts['alt'];
		}
		// Return result (all check passed)
		return do_shortcode( $content );
	}

	public static function products_categories( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'width'       => 356,
				'height'       => 255,			
			), $atts, 'products_categories' );

		perch_query_asset( 'js', 'freewall' );
		perch_query_asset( 'css', 'perch-content-shortcodes' );

		return '<div class="freewall-container" data-cwidth="'.$atts['width'].'" data-cheight="'.$atts['height'].'">'. do_shortcode($content) .'</div>';
	}

	public static function products_category( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'tax_term'       => '',
				'row_offset'       => 1,
				'column_offset'   => 1,
				'info_display' => 'yes',
				'info_align' => 'center',
				'info_dark_color' => 'no',				
			), $atts, 'products_category' );

		perch_query_asset( 'css', 'bootstrap' );
		perch_query_asset( 'css', 'perch-content-shortcodes' );

		$image_width = 418;
    	$image_height = 294;
    	$width = ($image_width * $atts['row_offset'] + (($atts['row_offset']-1)*30));
    	$height = ($image_height * $atts['column_offset']) + (($atts['column_offset']-1)*30);
    	$term = get_term_by( 'id', $atts['tax_term'], 'product_cat', 'ARRAY_A' );
    	$term_link = get_term_link( $term['slug'], 'product_cat' );

		$output = '';
		
		$thumbnail_id = get_woocommerce_term_meta( $atts['tax_term'], 'thumbnail_id', true  );

		if ( $thumbnail_id ) {      
        	$imagearr = wp_get_attachment_image_src( $thumbnail_id, 'full' );
        	$image = perch_image_resize( $imagearr[0], $width,  $height);
        	$imageurl = $image['url'];

    	}else{
    		$imageurl = "http://placehold.it/{$width}x{$height}/000000/fff?text=Image+does+not+exists";
    	}

		
		$output .= '<div class="perch-category-image info-dark-color-'.$atts['info_dark_color'].' info-display-'.$atts['info_display'].' cell size'.$atts['row_offset'].$atts['column_offset'].' text-'.$atts['info_align'].'"><a href="'. ((!is_wp_error( $term_link ))?esc_url($term_link): $term_link->get_error_message()) .'" class="imgLiquidFill">';
		$output .= '<img src="'. esc_url( $imageurl ) .'" alt="'.((!is_wp_error( $term_link ))?esc_attr($term['name']): $term_link->get_error_message()).'">';

		$output .= '<div class="hover-wrap"><h3>'.((!is_wp_error( $term_link ))?esc_attr($term['name']): $term_link->get_error_message()).'</h3><div class="cross-title"><i class="genericon genericon-close"></i></div>';
		$output .= ($term['description'] != '')? '<p>'.esc_attr($term['description']).'</p>': '';
		$output .= '</div></a></div>';

		// Return result
		return $output;
	}

	public static function products_category_info( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'background' => '#f5f7f8',
				'image'       => plugins_url( 'assets/images/cat-info.png', TP_PLUGIN_FILE ),
				'verticalalign' => 'center',
				'horizontalalign' => 'right',
				'fill' => 'no',
				'title' => 'Accesories',
				'link_title' => 'View Collections',
				'link' => '',
				'info_display' => 'yes',
				'info_align' => 'left',
				'info_dark_color' => 'yes',	
				'padding_top' => 50,
				'padding_right' => 50,
				'padding_bottom' => 50,
				'padding_left' => 50,			
			), $atts, 'products_category' );

		perch_query_asset( 'css', 'bootstrap' );
		perch_query_asset( 'css', 'perch-content-shortcodes' );
		perch_query_asset( 'js', 'imgLiquid' );

		$output = ''; 

    	$imageurl = $atts['image'];

    	$padding = "padding-top: {$atts['padding_top']}px;";
    	$padding .= "padding-right: {$atts['padding_right']}px;";
    	$padding .= "padding-bottom: {$atts['padding_bottom']}px;";
    	$padding .= "padding-left: {$atts['padding_left']}px;";

		
		$output .= '<div class="perch-category-image perch-category-info-custom info-dark-color-'.$atts['info_dark_color'].' info-display-'.$atts['info_display'].' cell size11 text-'.$atts['info_align'].'">';
		$output .= '<div class="imgLiquid imgLiquidFill" data-imgLiquid-fill="'.(($atts['fill'] == 'yes')? 'true' : 'false').'" data-imgLiquid-horizontalAlign="'.$atts['horizontalalign'].'"  data-imgLiquid-verticalAlign="'.$atts['verticalalign'].'"  style="background-color:'.$atts['background'].'">';
		$output .= '<img style="width: 100%" src="'. esc_url( $imageurl ) .'" alt="'.esc_attr( $atts['title'] ).'">';
		$output .= '</div>';
		$output .= '<div class="hover-wrap" style="'.$padding.'"><h3>'.esc_attr( $atts['title'] ).'</h3>';
		$output .= ($content != '')? '<p>'.force_balance_tags(nl2br($content)).'</p>': '';

		$output .= ($atts['link_title'] != '')? '<a href="'.esc_url($atts['link']).'" class="color-text">'.esc_attr($atts['link_title']).'</a>' : '';
		$output .= '</div></div>';

		// Return result
		return $output;
	}

	public static function video_gallery( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'column'  => 3,
				'width'  => 220,
				'height' => 220,
				'videos' => '',
				'button_text' => 'View More',
				'button_url' => ''
			), $atts, 'video_gallery' );
		do_action( 'perch/shortcode/video_gallery', $atts );

		$videos = (function_exists('vc_param_group_parse_atts'))? vc_param_group_parse_atts($atts['videos']) : array();

		$output = '';

		if( !empty($videos) ):
			$output .= '<div class="audio-gallary"><div class="row">';
			foreach ($videos as $key => $value) {
				if( $value['url'] != '' ):
				$imagearr = ($value['image'] != '')? perch_image_resize( $value['image'], $atts['width'], $atts['height'] ) : array('url' => "http://placehold.it/{$atts['width']}x{$atts['height']}/000000/fff?text=Image+does+not+exists");
					$output .= '<div class="single-gallary-item col-md-'.(12/$atts['column']).'">
                                <div class="single-gallary-item-inner">
                                    <img alt="" src="'.esc_url($imagearr['url']).'">
                                    <a href="'.esc_url($value['url']).'" class="popup-youtube">Youtube video</a>
                                </div>
                            </div><!-- .single-gallary-item -->';
                endif;            
			}
			$output .= '</div></div>';
		endif;

		$output .= ($atts['button_url'] != '')? '<div style="clear: both" class="video-more-link text-center more-link-wrap"> <a class="btn btn-light view-more" href="'.esc_url($atts['button_url']).'" target="_blank">'.esc_attr($atts['button_text']).'</a></div>' : '';

		return $output;

		
	}


}

new Tp_Shortcodes;

class Perch_Shortcodes_Shortcodes extends Tp_Shortcodes {
	function __construct() {
		parent::__construct();
	}
}

add_shortcode( 'schema_contactinfo_list', 'schema_contactinfo_list_callback' );
function schema_contactinfo_list_callback( $atts = null, $content = null ){
	$atts = shortcode_atts( array(
				'contact_info' => '',				
			), $atts, 'schema_contactinfo_box' );
	$contact_info_arr = (function_exists('vc_param_group_parse_atts'))? vc_param_group_parse_atts($atts['contact_info']) : array();

	$output = '';

	if(!empty($contact_info_arr)){
		vc_iconpicker_editor_jscss();
		wp_enqueue_style( 'vc-icon-picker-main-css' );
		wp_enqueue_style( 'vc-icon-picker-main-css-theme' );
		$output .= '<div class="contact-info">
                                  <div class="info-inner">
                                    <ul>
                                     ';
		foreach ($contact_info_arr as $key => $value) {
			extract($value);
			$output .= '<li><i class="'.$value['icon_'.$type].'"></i>'.nl2br($info).'</li>';
		}
		$output .= '</ul>
                        </div>
                              </div>';
	}

	return $output;
}

add_shortcode( 'schema_contact_info_box', 'schema_contactinfo_box_callback' );
function schema_contactinfo_box_callback( $atts = null, $content = null ) {
		$atts = shortcode_atts( array(
				'bg_image'  => '',
				'overlay'  => 'dark',
				'type' => 'fontawesome',
				'icon_fontawesome' => 'fa fa-home',
				'icon_openiconic' => 'vc-oi vc-oi-dial',
				'icon_typicons' => 'typcn typcn-adjust-brightness',
				'icon_entypo' => 'entypo-icon entypo-icon-note',
				'icon_linecons' => 'vc_li vc_li-heart',
				'info' => ''
			), $atts, 'schema_contactinfo_box' );
		do_action( 'perch/shortcode/schema_contactinfo_box', $atts );

		extract($atts);

		vc_iconpicker_editor_jscss();
		wp_enqueue_style( 'vc-icon-picker-main-css' );
		wp_enqueue_style( 'vc-icon-picker-main-css-theme' );
		$style = ($bg_image != '')? ' style="background-image: url('.esc_url($bg_image).')"' : '';
		return '<div class="contact-address overlay '.$overlay.'-overlay"'.$style.'>
                                   <div class="address-inner">
                                       <span class="add-icon-wrap"><i class="'.$atts['icon_'.$type].'"></i></span>
                                       <div class="add-text">
                                           <p>'.$info.'</p>
                                       </div>
                                   </div>
                               </div>';
	}
