<?php
/* Check if Class Exists. */
if ( !class_exists( 'Investment_WSmenu_Walker_Menu' ) ) {

  /**
   * WP_Bootstrap_Navwalker class
   *
   * @package        Template
   * @subpackage     Bootstrap4
   *
   * @since          1.0.0
   * @see            https://getbootstrap.com/docs/4.0/components/navbar/
   * @extends        Walker_Nav_Menu
   * @author         Javier Prieto
   */
  class Investment_WSmenu_Walker_Menu extends Walker_Nav_Menu {

    /**
     * @since       1.0.0
     * @access      public
     * @var type    bool
     */
    private $dropdown = false;

    private $dropdown_class = 'dropdown-menu-item';
    private $dropdown_arrow = '<span class="wsarrow"></span>';
    private $first_lavel_item_class = '';
    private $first_lavel_link_class = '';
    private $second_lavel_item_class = '';
    private $second_lavel_link_class = '';

    /**
     * Starts the list before the elements are added.
     *
     * @since       1.0.0
     *
     * @see Walker::start_lvl()
     *
     * @param string   $output Passed by reference. Used to append additional content.
     * @param int      $depth  Depth of menu item. Used for padding.
     * @param stdClass $args   An object of wp_nav_menu() arguments.
     */
    public function start_lvl( &$output, $depth = 0, $args = array() ) {
      if ( isset( $args->item_spacing ) && 'discard' === $args->item_spacing ) {
        $t = '';
        $n = '';
      } else {
        $t = "\t";
        $n = "\n";
      }

      $this->dropdown = true;
      if( isset($args->theme_location) && $args->theme_location == 'right_menu' ){
          $output         .= $n . str_repeat( $t, $depth ) . '<ul class="sub-menu02" role="menu">' . $n;
      }else{
          $output         .= $n . str_repeat( $t, $depth ) . '<ul class="sub-menu" role="menu">' . $n;
      }
      
    }

    /**
     * Ends the list of after the elements are added.
     *
     * @since       1.0.0
     *
     * @see Walker::end_lvl()
     *
     * @param string   $output Passed by reference. Used to append additional content.
     * @param int      $depth  Depth of menu item. Used for padding.
     * @param stdClass $args   An object of wp_nav_menu() arguments.
     */
    public function end_lvl( &$output, $depth = 0, $args = array() ) {
      if ( isset( $args->item_spacing ) && 'discard' === $args->item_spacing ) {
        $t = '';
        $n = '';
      } else {
        $t = "\t";
        $n = "\n";
      }

      $this->dropdown = false;
      $output         .= $n . str_repeat( $t, $depth ) . '</ul>' . $n;
    }

    /**
     * Starts the element output.
     *
     * @since 1.0.0
     *
     * @see Walker::start_el()
     *
     * @param string   $output Passed by reference. Used to append additional content.
     * @param WP_Post  $item   Menu item data object.
     * @param int      $depth  Depth of menu item. Used for padding.
     * @param stdClass $args   An object of wp_nav_menu() arguments.
     * @param int      $id     Current item ID.
     */
    public function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
      if ( isset( $args->item_spacing ) && 'discard' === $args->item_spacing ) {
        $t = '';
        $n = '';
      } else {
        $t = "\t";
        $n = "\n";
      }

      $indent = str_repeat( $t, $depth );

      if ( 0 === strcasecmp( $item->attr_title, 'divider' ) && $this->dropdown ) {
        $output .= $indent . '<div class="dropdown-divider"></div>' . $n;
        return;
      } elseif ( 0 === strcasecmp( $item->title, 'divider' ) && $this->dropdown ) {
        $output .= $indent . '<div class="dropdown-divider"></div>' . $n;
        return;
      }

      $classes   = empty( $item->classes ) ? array() : (array) $item->classes;
      $classes[] = 'menu-item-' . $item->ID;
      

      if ( !$args->walker->has_children ) {
        $classes[] = 'nl-simple';
      }

      $classes[] = $this->megamenu_item_class($args, $item, $depth);

      

      /**
       * Filters the arguments for a single nav menu item.
       *
       * @since 1.2.0
       *
       * @param stdClass $args  An object of wp_nav_menu() arguments.
       * @param WP_Post  $item  Menu item data object.
       * @param int      $depth Depth of menu item. Used for padding.
       */
      $args = apply_filters( 'nav_menu_item_args', $args, $item, $depth );

      /**
       * Filters the CSS class(es) applied to a menu item's list item element.
       *
       * @since 3.0.0
       * @since 4.1.0 The `$depth` parameter was added.
       *
       * @param array    $classes The CSS classes that are applied to the menu item's `<li>` element.
       * @param WP_Post  $item    The current menu item.
       * @param stdClass $args    An object of wp_nav_menu() arguments.
       * @param int      $depth   Depth of menu item. Used for padding.
       */
      $class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args, $depth ) );
      $class_names = $class_names ? ' class="' . esc_attr( $class_names ) . '"' : '';

      /**
       * Filters the ID applied to a menu item's list item element.
       *
       * @since 3.0.1
       * @since 4.1.0 The `$depth` parameter was added.
       *
       * @param string   $menu_id The ID that is applied to the menu item's `<li>` element.
       * @param WP_Post  $item    The current menu item.
       * @param stdClass $args    An object of wp_nav_menu() arguments.
       * @param int      $depth   Depth of menu item. Used for padding.
       */
      $id = apply_filters( 'nav_menu_item_id', 'menu-item-' . $item->ID, $item, $args, $depth );
      $id = $id ? ' id="' . esc_attr( $id ) . '"' : '';
      

      $atts           = array();
      $atts['title']  = !empty( $item->attr_title ) ? $item->attr_title : '';
      $atts['target'] = !empty( $item->target ) ? $item->target : '';
      $atts['rel']    = !empty( $item->xfn ) ? $item->xfn : '';
      if($item->object == 'megamenu'):
      	$atts['href']   = '#';
      else:
      	$atts['href']   = !empty( $item->url ) ? $item->url : '';
  	  endif;

      /**
       * Filters the HTML attributes applied to a menu item's anchor element.
       *
       * @since 3.6.0
       * @since 4.1.0 The `$depth` parameter was added.
       *
       * @param array $atts {
       *     The HTML attributes applied to the menu item's `<a>` element, empty strings are ignored.
       *
       *     @type string $title  Title attribute.
       *     @type string $target Target attribute.
       *     @type string $rel    The rel attribute.
       *     @type string $href   The href attribute.
       * }
       * @param WP_Post  $item  The current menu item.
       * @param stdClass $args  An object of wp_nav_menu() arguments.
       * @param int      $depth Depth of menu item. Used for padding.
       */
      $atts = apply_filters( 'nav_menu_link_attributes', $atts, $item, $args, $depth );

     

      $attributes = '';
      foreach ( $atts as $attr => $value ) {
        if ( !empty( $value ) ) {
          $value      = ( 'href' === $attr ) ? esc_url( $value ) : esc_attr( $value );
          $attributes .= ' ' . $attr . '="' . $value . '"';
        }
      }

      /** This filter is documented in wp-includes/post-template.php */
      $title = apply_filters( 'the_title', $item->title, $item->ID );

      /**
       * Filters a menu item's title.
       *
       * @since 4.4.0
       *
       * @param string   $title The menu item's title.
       * @param WP_Post  $item  The current menu item.
       * @param stdClass $args  An object of wp_nav_menu() arguments.
       * @param int      $depth Depth of menu item. Used for padding.
       */
      $title = apply_filters( 'nav_menu_item_title', $title, $item, $args, $depth );

      $item_classes = array();



      if ( ( $depth == 0 ) && in_array($this->dropdown_class, $classes) ) {         
        $title .= $this->dropdown_arrow;
      }
     

      if ( 0 < $depth ) {
        $item_classes = array_diff( $item_classes, [ 'nav-link' ] );
        $item_classes[] = '';
      }

      if ( !$this->dropdown ) {
        $item_output = $indent . '<li' . $id . $class_names . '>' . $n . $indent . $t;
      }else{
      	$item_output = $indent . '<li'. $class_names . '>' . $n . $indent . $t;
      }

      $item_output .= $args->before;
      $item_output .= '<a class="' . implode( ' ', $item_classes ) . '" ' . $attributes . '>';
      $item_output .= $args->link_before . $title . $args->link_after;
      $item_output .= '</a>';
      $item_output .= $args->after;


    if($item->object == 'megamenu'):
      	$output .= self::megamenu_item($item_output, $item, $depth, $args);
      else:

      /**
       * Filters a menu item's starting output.
       *
       * The menu item's starting output only includes `$args->before`, the opening `<a>`,
       * the menu item's title, the closing `</a>`, and `$args->after`. Currently, there is
       * no filter for modifying the opening and closing `<li>` for a menu item.
       *
       * @since 3.0.0
       *
       * @param string   $item_output The menu item's starting HTML output.
       * @param WP_Post  $item        Menu item data object.
       * @param int      $depth       Depth of menu item. Used for padding.
       * @param stdClass $args        An object of wp_nav_menu() arguments.
       */
      
      	$output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
  	  endif;
    }

    public function megamenu_item_class($args, $item, $depth){
        $template_part = get_post_meta($item->object_id, 'megamenu_template', true );
        if( $template_part == 'elements/megamenu.php' ){

        }elseif ( 0 < $depth ||  ($item->object == 'megamenu')) {
          return $this->dropdown_class;
        }elseif($args->walker->has_children &&  ($item->object != 'megamenu')){
          return $this->dropdown_class;
        }
    }

    public function megamenu_item($item_output, $item, $depth, $args){
    	$output = '';
      $custom_nav_item_template = 'elements/megamenu.php';
      $template_part = get_post_meta($item->object_id, 'megamenu_template', true );
      $_post = get_post($item->object_id);
      $template_args = array(
        'menu_id' => $item->object_id,
        'menu_content' => $_post->post_content
      );
      $megamenu_content = Investment_WSmenu_buffer_template_file( $template_part , $template_args );
      $megamenu_content = str_replace("<p></p>","",$megamenu_content);

      
      if((0 == $depth) && ($template_part != $custom_nav_item_template)){
        $output .= $item_output;
      }   
           
    	
    	if(0 < $depth){
    		$output .= self::end_lvl($output, $depth, $args);
        $output .= $megamenu_content;
        $output .= self::start_lvl($output, $depth, $args);
    	}else{
        if( ($template_part == $custom_nav_item_template) ){
            $output .= "<li>{$megamenu_content}";
        }else{
            $output .= $megamenu_content;
        }
        
      }

    	 	
    	return apply_filters( 'walker_nav_menu_start_el', $output, $item, $depth, $args );
    }

    /**
     * Ends the element output, if needed.
     *
     * @since 1.0.0
     *
     * @see Walker::end_el()
     *
     * @param string   $output Passed by reference. Used to append additional content.
     * @param WP_Post  $item   Page data object. Not used.
     * @param int      $depth  Depth of page. Not Used.
     * @param stdClass $args   An object of wp_nav_menu() arguments.
     */
    public function end_el( &$output, $item, $depth = 0, $args = array() ) {
      if ( isset( $args->item_spacing ) && 'discard' === $args->item_spacing ) {
        $t = '';
        $n = '';
      } else {
        $t = "\t";
        $n = "\n";
      }

      $output .= $this->dropdown ? '' : str_repeat( $t, $depth ) . '</li>' . $n;
    }

    /**
     * Menu Fallback
     *
     * @since 1.0.0
     *
     * @param array $args passed from the wp_nav_menu function.
     */
    public static function fallback( $args ) {
      if ( current_user_can( 'edit_theme_options' ) ) {

        $defaults = array(
            'container'       => '',
            'container_id'    => false,
            'container_class' => false,
            'menu_class'      => '',
            'menu_id'         => false,
        );
        $args     = wp_parse_args( $args, $defaults );
        if ( !empty( $args['container'] ) ) {
          echo sprintf( '<%s id="%s" class="%s">', $args['container'], $args['container_id'], $args['container_class'] );
        }
        echo sprintf( '<ul id="%s" class="%s">', $args['menu_id'], $args['menu_class'] ) .
        '<li class="nav-item">' .
        '<a href="' . admin_url( 'nav-menus.php' ) . '" class="nav-link">' . esc_attr__( 'Add a menu', 'investment' ) . '</a>' .
        '</li></ul>';
        if ( !empty( $args['container'] ) ) {
          echo sprintf( '</%s>', $args['container'] );
        }
      }
    }

  }

}