<?php
if( class_exists('WPCF7_ContactFormTemplate') ):
class Investment_ContactFormTemplate extends WPCF7_ContactFormTemplate { 
	function __construct(){
      add_action( 'wpcf7_init', array( __CLASS__, 'add_form_tag_admin_edit_link' ) );
		  add_filter( 'wpcf7_default_template', array( __CLASS__, 'custom_form' ), 10, 2 );
	}
 
 
  public static function custom_form($template, $prop) { 
    if ( $prop == 'form' ) {
      $template = '<div class="row"><div class="col-lg-6">[text* first-name class:form-control placeholder "First name"]</div><div class="col-lg-6">[text* last-name class:form-control placeholder "Last name"]</div></div><div class="row"><div class="col-lg-6">[email* your-email class:form-control placeholder "Your E-maile"]</div><div class="col-lg-6">[text phone-number class:form-control placeholder "Your Phone Number"]</div></div><div class="row"><div class="col-lg-6">[text your-website class:form-control placeholder "Website"]</div><div class="col-lg-6">[select* department "Department" "Finance" "Investment" "Others"]</div></div>[textarea* your-message class:form-control placeholder "Your message"][submit class:button class:btn-secondary class:btn_normal class:caps_normal "Send a message"][editlink]'; 
    }
 
      return $template; 
  } 


  public static function add_form_tag_admin_edit_link() {
      wpcf7_add_form_tag( 'editlink', 'investment_admin_edit_link_form_tag_handler', array( 'name-attr' => false ) );
  }

  
} 

new Investment_ContactFormTemplate();
endif;

function investment_admin_edit_link_form_tag_handler( $tag ) {
     if( current_user_can( 'administrator' ) ){
          $wpcf7 = WPCF7_ContactForm::get_current(); 
          $id = $wpcf7->id();
          $form_edit_link = admin_url( 'admin.php?page=wpcf7&post='.intval($id).'&action=edit' );
          $mail_edit_link = admin_url( 'admin.php?page=wpcf7&post='.intval($id).'&action=edit&active-tab=1' );

          $html = '<div class="cf7-edit-link small">';  
          $html .= sprintf(' <a target="_blank" href="%s">%s</a>', esc_url($form_edit_link), esc_attr__('Edit contact form', 'investment'));        
          $html .= sprintf(', <a target="_blank" href="%s">%s</a>', esc_url($mail_edit_link), esc_attr__('Check Mail settings', 'investment'));
          $html .= '</div>';      

          return $html;
      }
}