<?php
/**
** A base module for [submit]
**/

/* form_tag handler */

remove_action( 'wpcf7_init', 'wpcf7_add_form_tag_submit', 10, 0 );
add_action( 'wpcf7_init', 'investment_wpcf7_add_form_tag_submit', 10, 0 );

function investment_wpcf7_add_form_tag_submit() {
	wpcf7_add_form_tag( 'submit', 'investment_wpcf7_submit_form_tag_handler' );
}

function investment_wpcf7_submit_form_tag_handler( $tag ) {
	$class = wpcf7_form_controls_class( $tag->type, 'has-spinner btn btn-secondary' );

	$atts = array();

	$atts['class'] = $tag->get_class_option( $class );
	$atts['id'] = $tag->get_id_option();
	$atts['tabindex'] = $tag->get_option( 'tabindex', 'signed_int', true );

	$value = isset( $tag->values[0] ) ? $tag->values[0] : '';

	if ( empty( $value ) ) {
		$value = __( 'Send', 'contact-form-7' );
	}

	$atts['type'] = 'submit';
	$atts['value'] = $value;

	$atts = wpcf7_format_atts( $atts );

	$html = sprintf( '<input %1$s />', $atts );

	return $html;
}
