<?php

if(function_exists('control_elementor_load_elements')){

    add_filter( 'control-elementor/category', function($title){
        return 'Investment';
    } );

    add_filter('elementor/icons_manager/additional_tabs', 'investment_add_elementor_icons_tab');
    function investment_add_elementor_icons_tab($additional_tabs){
        $additional_tabs['investment-perchicon'] = [
            'name'          => 'perchicon',
            'label'         => esc_html__( 'Perch Icons', 'control-elementor' ),
            'labelIcon'     => 'perch perch-integrity ',
            'prefix'        => 'perch-',
            'displayPrefix' => 'perch',
            'url'           => '',
            'enqueue'       => [ INVESTMENT_ASSETS . '/css/perch.css' ],
            'icons'         => control_elementor_iconpicker_icons_array(investment_iconpicker_type_perch([]), 'perch'),
            'ver'           => INVESTMENT_VERSION,
        ];

        $additional_tabs['investment-pixdenicon'] = [
            'name'          => 'pixdenicon',
            'label'         => esc_html__( 'Pixden Icons', 'control-elementor' ),
            'labelIcon'     => 'pe-7s pe-7s-science ',
            'prefix'        => 'pe-7s-',
            'displayPrefix' => 'pe-7s',
            'url'           => '',
            'enqueue'       => [ INVESTMENT_ASSETS . '/css/pe-icon-7-stroke.css' ],
            'icons'         => control_elementor_iconpicker_icons_array(investment_iconpicker_type_pixden([]), 'pe-7s'),
            'ver'           => INVESTMENT_VERSION,
        ];
    
        return $additional_tabs;
    }
}