<?php
add_action('admin_enqueue_scripts', 'investment_page_builder_assets');
function investment_page_builder_assets(){
    wp_enqueue_style( 'investment-builder', INVESTMENT_URI. '/admin/assets/css/builder.css', array(), INVESTMENT_VERSION, 'all' );
	wp_enqueue_script( 'investment-builder-bundle', INVESTMENT_URI. '/admin/assets/js/builder.bundle.min.js', array( 'jquery' ), INVESTMENT_VERSION, false );
}

function investment_page_builder_content(){
    $sections = get_post_meta(get_the_ID(), 'investment_contents', true);
    if( empty($sections) ) return;

    $output = '';
    foreach ($sections as $key => $section) {
        
        $style = !empty($section['style'])? $section['style'] : '';

        ob_start();
        get_template_part( 'template-parts/elements/section', $style, $section );
        $output .= ob_get_clean();
    }
    return $output;
}

add_filter( 'the_content', function($content){
    $investment_builder = get_post_meta( get_the_ID(), '__investment_page_builder', true );
    if($investment_builder){
        return investment_page_builder_content(); 
    }else{
        return $content; 
    }    
});

add_filter( 'ctrlbp_meta_boxes', function ( $meta_boxes ) {
    $meta_boxes[] = [
        'id' => 'investment-page-builder-settings',
        'style' => 'seamless',
        'closed' => false,        
        'autosave' => false,
        'context' => 'after_title',        
        'post_types' => ['page'],
        'fields' => [
            [
                'id' => '__investment_page_builder',
                'type' => 'checkbox',
                'desc' => 'Enable Investment page builder?',
            ]
        ] 
    ];

    $meta_boxes[] = [
        'title'      => 'Investment Page Builder',
        'id' => 'investment-page-builder',
        'closed' => false,        
        'autosave' => false,
        'context' => 'after_title',        
        'post_types' => ['page'],
        'visible' => ['__investment_page_builder', '=', true],
        'fields' => investment_page_builder_sections() 
    ];
    return $meta_boxes;
});



function investment_page_builder_sections(){
    return [            
        [
            'id' => 'investment_contents',
            'group_title' => 'Section #{id}',
            'type' => 'group',
            'clone' => true,
            'sort_clone' => true,
            'save_state' => true,
            'default_state' => 'expanded',            
            'add_button' => '+ Add Section',                       
            'fields' => investment_page_builder_fields(),
        ]
    ];
}

function investment_page_builder_tabs(){
    return [
        'general' => 'Content',
        'design' => 'Design',
        'typography' => 'Typography',
    ];
}

function investment_page_builder_fields(){
    $fields = [];
    $tabs = investment_page_builder_tabs();
    foreach ($tabs as $tab => $title) {
        $function_name = "investment_page_builder_fields_{$tab}";
        // Call the function & pass in arguments array.
		if ( function_exists( $function_name ) ) {
			$new_fields = call_user_func( $function_name, $tab );
            foreach( $new_fields as $key => $value ){
                $value['tab'] = $tab;
                $new_fields[$key] = $value;
            }
            $fields = array_merge($fields, $new_fields);
		}
    }
    
    return apply_filters( 'investment_page_builder_fields', $fields );
}

function investment_page_builder_tabs_html($prefix=''){
    ob_start(); ?>

    <ul class="nav nav-tabs">    
    <?php
    $tabs = investment_page_builder_tabs();
    $count = 0;
    foreach ($tabs as $key => $value):
        $active_tab = $prefix.$key;           
        ?>
         <li class="nav-item mb-0"> 
            <a class="nav-link<?php echo $count == 0? ' active': '' ?>" type="button" data-bs-toggle="collapse" data-bs-target="#<?php echo esc_attr($active_tab) ?>" aria-expanded="<?php echo $count == 0? 'true': 'false' ?>" aria-controls="<?php echo esc_attr($active_tab) ?>">
            <?php echo esc_attr($value); ?>
            </a>
        </li>
    <?php 
    $count++;
    endforeach; ?>
    </ul>
    <?php
    return ob_get_clean();
}

function investment_page_builder_fields_general(){
    return [  

        [
            'id' => 'id',
            'type' => 'text',
            'desc' => 'CSS ID',
        ],
        [
            'id' => 'class',
            'type' => 'text',
            'desc' => 'CSS class',
        ],
        [
            'id' => 'container',
            'type' => 'select',
            'desc' => 'Container',
            'options' => [
                '' => 'None',
                'container' => 'Container',
                'container-fluid' => 'Fluid Container',
            ]
        ]        
    ];
}