<?php
function investment_import_demo_data() {  

  return array(     
    array(
      'import_file_name'           => 'Home with Slider Revolution (WP Bakery)',
      'categories'                 => array( 'WPBakery Page Builder' ),
      'import_file_url'            => INVESTMENT_URI.'/admin/demo-data/demo-content.xml',
      'import_widget_file_url'     => INVESTMENT_URI.'/admin/demo-data/widgets.wie',
      'import_customizer_file_url' => INVESTMENT_URI.'/admin/demo-data/customizer.dat',
      'import_preview_image_url'   => INVESTMENT_ASSETS . '/images/home/home-style1.png',
      'preview_url'                => 'https://themeperch.com/themes/investment/wpbakery/',
    ),
    array(
      'import_file_name'           => 'Home with Image Background (WP Bakery)',
      'categories'                 => array( 'WPBakery Page Builder' ),
      'import_file_url'            => INVESTMENT_URI.'/admin/demo-data/demo-content.xml',
      'import_widget_file_url'     => INVESTMENT_URI.'/admin/demo-data/widgets.wie',
      'import_customizer_file_url' => INVESTMENT_URI.'/admin/demo-data/customizer.dat',
      'import_preview_image_url'   => INVESTMENT_ASSETS . '/images/home/home-style2.png',
      'preview_url'                => 'https://themeperch.com/themes/investment/wpbakery/home/',
    ),
    array(
      'import_file_name'           => 'Home with Image Background #2 (WP Bakery)',
      'categories'                 => array( 'WPBakery Page Builder' ),
      'import_file_url'            => INVESTMENT_URI.'/admin/demo-data/demo-content.xml',
      'import_widget_file_url'     => INVESTMENT_URI.'/admin/demo-data/widgets.wie',
      'import_customizer_file_url' => INVESTMENT_URI.'/admin/demo-data/customizer.dat',
      'import_preview_image_url'   => INVESTMENT_ASSETS . '/images/home/home-style3.png',
      'preview_url'                => 'https://themeperch.com/themes/investment/wpbakery/home-2/',
    ),
    array(
      'import_file_name'           => 'Home with Image Background #3 (WP Bakery)',
      'categories'                 => array( 'WPBakery Page Builder' ),
      'import_file_url'            => INVESTMENT_URI.'/admin/demo-data/demo-content.xml',
      'import_widget_file_url'     => INVESTMENT_URI.'/admin/demo-data/widgets.wie',
      'import_customizer_file_url' => INVESTMENT_URI.'/admin/demo-data/customizer.dat',
      'import_preview_image_url'   => INVESTMENT_ASSETS . '/images/home/home-style4.png',
      'preview_url'                => 'https://themeperch.com/themes/investment/wpbakery/home-3/',
    ),
    array(
      'import_file_name'           => 'Home Style 5 with Video Background (WP Bakery)',
      'categories'                 => array( 'WPBakery Page Builder' ),
      'import_file_url'            => INVESTMENT_URI.'/admin/demo-data/demo-content.xml',
      'import_widget_file_url'     => INVESTMENT_URI.'/admin/demo-data/widgets.wie',
      'import_customizer_file_url' => INVESTMENT_URI.'/admin/demo-data/customizer.dat',
      'import_preview_image_url'   => INVESTMENT_ASSETS . '/images/home/home-style5.png',
      'preview_url'                => 'https://themeperch.com/themes/investment/wpbakery/home-video/',
    ),
    array(
      'import_file_name'           => 'Creative home Layout (WP Bakery)',
      'categories'                 => array( 'WPBakery Page Builder' ),
      'import_file_url'            => INVESTMENT_URI.'/admin/demo-data/demo-content.xml',
      'import_widget_file_url'     => INVESTMENT_URI.'/admin/demo-data/widgets.wie',
      'import_customizer_file_url' => INVESTMENT_URI.'/admin/demo-data/customizer.dat',
      'import_preview_image_url'   => 'https://investmentwp.com/demos/images/home-style6.png',
      'preview_url'                => 'https://themeperch.com/themes/investment/wpbakery/home-4/',
    ),
    array(
      'import_file_name'           => 'Onepage layout with Image Background (WP Bakery)',
      'categories'                 => array( 'WPBakery Page Builder' ),
      'import_file_url'            => INVESTMENT_URI.'/admin/demo-data/demo-content.xml',
      'import_widget_file_url'     => INVESTMENT_URI.'/admin/demo-data/widgets.wie',
      'import_customizer_file_url' => INVESTMENT_URI.'/admin/demo-data/customizer.dat',
      'import_preview_image_url'   => INVESTMENT_ASSETS . '/images/home/header-style1.png',
      'preview_url'                => 'https://themeperch.com/themes/investment/wpbakery/onepage-with-image/',
    ),
    array(
      'import_file_name'           => 'Onepage layout with Video Background (WP Bakery)',
      'categories'                 => array( 'WPBakery Page Builder' ),
      'import_file_url'            => INVESTMENT_URI.'/admin/demo-data/demo-content.xml',
      'import_widget_file_url'     => INVESTMENT_URI.'/admin/demo-data/widgets.wie',
      'import_customizer_file_url' => INVESTMENT_URI.'/admin/demo-data/customizer.dat',
      'import_preview_image_url'   => INVESTMENT_ASSETS . '/images/home/header-style2.png',
      'preview_url'                => 'https://themeperch.com/themes/investment/wpbakery/onepage-with-video-header/',
    ),   
    
    //Elementor demo
    array(
      'import_file_name'           => 'Home with Slider Revolution (Elementor)',
      'categories'                 => array( 'Elementor' ),
      'import_file_url'            => INVESTMENT_URI.'/admin/demo-data/elementor/demo-content.xml',
      'import_widget_file_url'     => INVESTMENT_URI.'/admin/demo-data/elementor/widgets.wie',
      'import_customizer_file_url' => INVESTMENT_URI.'/admin/demo-data/customizer.dat',
      'import_preview_image_url'   => INVESTMENT_ASSETS . '/images/home/elementor/home-style1.png',
      'preview_url'                => 'https://themeperch.com/themes/investment/elementor/',
    ), 
    array(
      'import_file_name'           => 'Home with Image Background (Elementor)',
      'categories'                 => array( 'Elementor' ),
      'import_file_url'            => INVESTMENT_URI.'/admin/demo-data/elementor/demo-content.xml',
      'import_widget_file_url'     => INVESTMENT_URI.'/admin/demo-data/elementor/widgets.wie',
      'import_customizer_file_url' => INVESTMENT_URI.'/admin/demo-data/customizer.dat',
      'import_preview_image_url'   => INVESTMENT_ASSETS . '/images/home/elementor/home-style2.png',
      'preview_url'                => 'https://themeperch.com/themes/investment/elementor/home-1/',
    ),  
    array(
      'import_file_name'           => 'Home with Image Background #2 (Elementor)',
      'categories'                 => array( 'Elementor' ),
      'import_file_url'            => INVESTMENT_URI.'/admin/demo-data/elementor/demo-content.xml',
      'import_widget_file_url'     => INVESTMENT_URI.'/admin/demo-data/elementor/widgets.wie',
      'import_customizer_file_url' => INVESTMENT_URI.'/admin/demo-data/customizer.dat',
      'import_preview_image_url'   => INVESTMENT_ASSETS . '/images/home/elementor/home-style3.png',
      'preview_url'                => 'https://themeperch.com/themes/investment/elementor/home-2/',
    ), 
    array(
      'import_file_name'           => 'Home with Image Background #3 (Elementor)',
      'categories'                 => array( 'Elementor' ),
      'import_file_url'            => INVESTMENT_URI.'/admin/demo-data/elementor/demo-content.xml',
      'import_widget_file_url'     => INVESTMENT_URI.'/admin/demo-data/elementor/widgets.wie',
      'import_customizer_file_url' => INVESTMENT_URI.'/admin/demo-data/customizer.dat',
      'import_preview_image_url'   => INVESTMENT_ASSETS . '/images/home/elementor/home-style4.png',
      'preview_url'                => 'https://themeperch.com/themes/investment/elementor/home-3/',
    ),  
    array(
      'import_file_name'           => 'Home Style 5 with Video Background (Elementor)',
      'categories'                 => array( 'Elementor' ),
      'import_file_url'            => INVESTMENT_URI.'/admin/demo-data/elementor/demo-content.xml',
      'import_widget_file_url'     => INVESTMENT_URI.'/admin/demo-data/elementor/widgets.wie',
      'import_customizer_file_url' => INVESTMENT_URI.'/admin/demo-data/customizer.dat',
      'import_preview_image_url'   => INVESTMENT_ASSETS . '/images/home/elementor/home-style5.png',
      'preview_url'                => 'https://themeperch.com/themes/investment/elementor/home-video/',
    ),  
    array(
      'import_file_name'           => 'Creative home Layout (Elementor)',
      'categories'                 => array( 'Elementor' ),
      'import_file_url'            => INVESTMENT_URI.'/admin/demo-data/elementor/demo-content.xml',
      'import_widget_file_url'     => INVESTMENT_URI.'/admin/demo-data/elementor/widgets.wie',
      'import_customizer_file_url' => INVESTMENT_URI.'/admin/demo-data/customizer.dat',
      'import_preview_image_url'   => INVESTMENT_ASSETS . '/images/home/elementor/home-style6.png',
      'preview_url'                => 'https://themeperch.com/themes/investment/elementor/home-4/',
    ), 
    array(
      'import_file_name'           => 'Onepage layout with Image Background (Elementor)',
      'categories'                 => array( 'Elementor' ),
      'import_file_url'            => INVESTMENT_URI.'/admin/demo-data/elementor/demo-content.xml',
      'import_widget_file_url'     => INVESTMENT_URI.'/admin/demo-data/elementor/widgets.wie',
      'import_customizer_file_url' => INVESTMENT_URI.'/admin/demo-data/customizer.dat',
      'import_preview_image_url'   => INVESTMENT_ASSETS . '/images/home/elementor/header-style1.png',
      'preview_url'                => 'https://themeperch.com/themes/investment/elementor/onepage-with-image/',
    ), 
    array(
      'import_file_name'           => 'Onepage layout with Video Background (Elementor)',
      'categories'                 => array( 'Elementor' ),
      'import_file_url'            => INVESTMENT_URI.'/admin/demo-data/elementor/demo-content.xml',
      'import_widget_file_url'     => INVESTMENT_URI.'/admin/demo-data/elementor/widgets.wie',
      'import_customizer_file_url' => INVESTMENT_URI.'/admin/demo-data/customizer.dat',
      'import_preview_image_url'   => INVESTMENT_ASSETS . '/images/home/elementor/header-style2.png',
      'preview_url'                => 'https://themeperch.com/themes/investment/elementor/onepage-with-video-header/',
    ),  

  );

}

add_filter( 'pt-ocdi/import_files', 'investment_import_demo_data' );

function investment_after_import_setup() {
  // Assign menus to their locations.
  $main_menu = get_term_by( 'name', 'Header Menu', 'nav_menu' );
  $footer_menu = get_term_by( 'name', 'Footer menu', 'nav_menu' );

  set_theme_mod( 'nav_menu_locations', array(
      'primary' => $main_menu->term_id,
      'footer' => $footer_menu->term_id,
    )
  );

  // Assign front page and posts page (blog page).
  $front_page_id = get_page_by_title( 'Home' );
  $blog_page_id  = get_page_by_title( 'News' );

  update_option( 'show_on_front', 'page' );
  update_option( 'page_on_front', $front_page_id->ID );
  update_option( 'page_for_posts', $blog_page_id->ID );

  // Insert the post into the database
    $page = get_page_by_title( 'Casestudies' );
    if(get_post_status($page->ID)== 'publish'){
      update_post_meta($page->ID, 'header_image', INVESTMENT_ASSETS.'/images/lets-work-bg.jpg');
    }  

    // Insert the post into the database
    $page = get_page_by_title( 'Services' );
    if(get_post_status($page->ID) =='publish'){
      update_post_meta($page->ID, 'header_image', INVESTMENT_ASSETS.'/images/service/services-bg.jpg');
    }

    // Insert the post into the database
    $page = get_page_by_title( 'Team member' );
    if(get_post_status($page->ID) == 'publish'){
      update_post_meta($page->ID, 'header_image', INVESTMENT_ASSETS.'/images/team/team-header-bg.jpg');
    }

    $page = get_page_by_title( 'Partners' );
    if(get_post_status($page->ID) == 'publish'){
      update_post_meta($page->ID, 'header_image', INVESTMENT_ASSETS.'/images/partner/Partners-headein-bg.jpg');
    }

    $page = get_page_by_title( 'Career' );
    if(get_post_status($page->ID) == 'publish'){
      update_post_meta($page->ID, 'header_image', INVESTMENT_ASSETS.'/images/about-career.jpg');
    }

    investment_set_clean_content_by_post_type('page', array(
      'search' => 'https://themeperch.com/themes/investment/wp-content/themes/investment',
      'replace' => get_template_directory_uri(),
    ));

    $post_list = get_posts(array(
        'post_type'   => 'portfolio',
        'posts_per_page' => -1,
    ));

}

function investment_demo_import_permalinks_setup(){
  $options = array(
    'permalink_structure' => '/%postname%/',
  );
  foreach ($options as $option_id => $value) {
    update_option( $option_id, $value );
  }
}

add_action( 'pt-ocdi/after_import', 'investment_after_import_setup' );
function investment_demo_import_elementor_setup(){
  update_option( 'elementor_load_fa4_shim', 'yes' );
  investment_demo_import_permalinks_setup();
  update_option( 
    'elementor_cpt_support', 
    [
      'post',
      'page',
      'portfolio',
      'team',
      'service',
      'job'
    ]
 );
}

function investment_layout_setup($selected_import){
  if( !class_exists('OT_Loader') ) return;

  $layouts = investment_get_demo_layouts();
  if(in_array($selected_import['import_file_name'], [ 'Elementor Demo' ])){
    $active_layout = 'multinational';
  }else{
    $active_layout = 'default';
  }
  investment_import_layouts($layouts, $active_layout);

}

function investment_before_content_import( $selected_import ) {
  if(empty($selected_import['import_file_name'])) return;

  investment_layout_setup($selected_import);
  wp_delete_post(1, true); // remove hello world
  investment_demo_import_elementor_setup();

}
add_action( 'ocdi/before_content_import', 'investment_before_content_import' );

function investment_before_widgets_import( $selected_import ) {
  if(empty($selected_import['import_widget_file_url'])) return;
  
  $sidebars = get_option('sidebars_widgets');
  $sidebars['wp_inactive_widgets'] = $sidebars['sidebar-1'];
  $sidebars['sidebar-1'] = [];
  update_option( 'sidebars_widgets', $sidebars );
  
}
add_action( 'ocdi/before_widgets_import', 'investment_before_widgets_import' );