<?php
require( __DIR__. '/helpers.php' );

// Theme Options
require( __DIR__. '/theme-options.php' );

// Contact form
require( __DIR__. '/contact-form-7/select.php' );
require( __DIR__. '/contact-form-7/text.php' );
require( __DIR__. '/contact-form-7/textarea.php' );
require( __DIR__. '/contact-form-7/submit.php' );

//required plugins
require( __DIR__. '/tgmpa/investment-plugins.php' );

include __DIR__. '/class.newsletter.php';
include __DIR__. '/comment-form.php';
include __DIR__. '/scripts.php';
include __DIR__. '/iconpicker/iconpicker.php';
include __DIR__. '/mce-button.php';
include __DIR__. '/widgets.php';
include __DIR__. '/widgets-area.php';
include __DIR__. '/meta-boxes.php';
include __DIR__. '/mr-image-resize.php';
include __DIR__. '/demo-data.php';
include __DIR__. '/class.wpcf7-config.php';
include __DIR__. '/class.nav-walker.php';
include __DIR__. '/class-wp-bootstrap-navwalker.php';
//require_once __DIR__ .'/control-elements.php';
include __DIR__ .'/control-elementor.php';

/**
 * Filters the Layouts ID
 */
function investment_filter_demo_layouts_id() {
  return 'investment';
}
add_filter( 'ot_layouts_id', 'investment_filter_demo_layouts_id' );
/**
 * Theme Mode
 */
add_filter( 'ot_theme_mode', '__return_true' );
/**
 * Child Theme Mode
 */
add_filter( 'ot_child_theme_mode', '__return_false' );
/**
 * Show Settings Pages
 */
add_filter( 'ot_show_pages', '__return_false' );
/**
 * Show Theme Options UI Builder
 */
add_filter( 'ot_show_options_ui', '__return_false' );
/**
 * Show Settings Import
 */
add_filter( 'ot_show_settings_import', '__return_false' );
/**
 * Show Settings Export
 */
add_filter( 'ot_show_settings_export', '__return_false' );
/**
 * Show New Layout
 */
add_filter( 'ot_show_new_layout', '__return_true' );
/**
 * Show posts format
 */
add_filter( 'ot_post_formats', '__return_true' );


function investment_login_logo() { 
	$logo = (function_exists('ot_get_option'))? ot_get_option('admin_logo', INVESTMENT_ASSETS.'/images/logo.png') : INVESTMENT_ASSETS.'/images/logo.png';

    echo '<style type="text/css">
        body.login div#login h1 a {
            background-image: url('.esc_url($logo).');
            background-position: bottom center; 
        }
    </style>';
}
add_action( 'login_enqueue_scripts', 'investment_login_logo' );

/**
 * Filters the Logo header link
 */
add_filter('ot_header_logo_link', function(){
  ob_start();
  ?>
  <div class="theme-logo" style="justify-content:center">
      <img width="80" height="50" src="<?php echo INVESTMENT_ASSETS ?>/images/icon-white.svg" alt="<?php echo wp_get_theme()->get('Name') ?>">
      <span>Investment</span>
  </div>
  <?php
  return ob_get_clean();
});
add_filter( 'ot_header_version_text', function(){
  return 'vs '.INVESTMENT_VERSION;
});

add_action('ot_header_list', 'investment_customizer_link');
function investment_customizer_link(){
  echo '<li style="margin-top:9px"><a class="option-tree-ui-button button button-primary" style="color:#fff" href="'.admin_url().'customize.php">Customizer</a></li><li style="margin-top:9px"><a target="_blank" class="option-tree-ui-button button button-primary" style="color:#fff" href="https://themeperch.com/themes/investment/documentation/">Documentation</a></li>';
}

if ( ! function_exists( 'ot_theme_options_layouts_form' ) ) {

	/**
	 * Helper function to display Theme Options layouts form.
	 *
	 * @access public
	 */
	function ot_theme_options_layouts_form() {

		echo '<form method="post" id="option-tree-options-layouts-form">';

		// Form nonce.
		wp_nonce_field( 'option_tree_modify_layouts_form', 'option_tree_modify_layouts_nonce' );

		// Get the saved layouts.
		$layouts = get_option( ot_layouts_id() );

		// Set active layout.
		$active_layout = isset( $layouts['active_layout'] ) ? $layouts['active_layout'] : '';

		if ( is_array( $layouts ) && 1 < count( $layouts ) ) {

			$active_layout = $layouts['active_layout'];

			echo '<input type="hidden" id="the_current_layout" value="' . esc_attr( $active_layout ) . '" />';

			echo '<div class="option-tree-active-layout">';

			echo '<select name="' . esc_attr( ot_layouts_id() ) . '[active_layout]" class="option-tree-ui-select">';

			$hidden_safe = '';

			foreach ( $layouts as $key => $data ) {

				if ( 'active_layout' === $key ) {
					continue;
				}

				echo '<option ' . selected( $key, $active_layout, false ) . ' value="' . esc_attr( $key ) . '">' . esc_attr(ucfirst(str_replace('-', ' ', $key)) ) . '</option>';
				$hidden_safe .= '<input type="hidden" name="' . esc_attr( ot_layouts_id() ) . '[' . esc_attr( $key ) . ']" value="' . esc_attr( isset( $data ) ? $data : '' ) . '" />';
			}

			echo '</select>';

			echo '</div>';

			echo $hidden_safe; // phpcs:ignore
		}

		/* new layout wrapper */
		echo '<div class="option-tree-save-layout' . ( ! empty( $active_layout ) ? ' active-layout' : '' ) . '">';

		/* add new layout */
		echo '<input type="text" name="' . esc_attr( ot_layouts_id() ) . '[_add_new_layout_]" value="" class="widefat option-tree-ui-input" autocomplete="off" />';

		echo '<button type="submit" class="option-tree-ui-button button button-primary save-layout" title="' . esc_html__( 'New Layout', 'option-tree' ) . '">' . esc_html__( 'New Layout', 'option-tree' ) . '</button>';

		echo '</div>';

		echo '</form>';
	}
}

/**
 * Filters the Google font API key
 */
add_filter( 'ot_google_fonts_api_key', function(){
  return 'AIzaSyAY4CxRw0I0VvaABZcMcNqU-Zjuw7xjrW4'; 
});

add_filter('ot_validate_setting_input_safe', function($input_safe, $input, $type){

  if ( 'iconpicker' === $type ) {
      $input_safe = esc_attr($input);
  }

if ( 'iconpicker_input' === $type ) {
      $input_safe = wp_parse_args($input, array(
    'icon' => '',
    'input' => '',
  ));
  }

  if ( in_array($type, ['list-item', 'textblock']) ) {
      $input_safe = $input;
  }

  return $input_safe;
}, 10, 3);

// Add Toolbar Menus
function investment_themeperch_toolbar() {
	global $wp_admin_bar;

	$args = array(
		'id'     => 'themeperch',
		'parent' => '',
		'title'  => __( 'INVESTMENT '.INVESTMENT_VERSION, 'investment' ),
		'href'   => 'https://investmentwp.com/',
	);
	$wp_admin_bar->add_menu( $args );

	$args = array(
		'id'     => 'theme_options',
		'parent' => 'themeperch',
		'title'  => __( 'Theme options', 'investment' ),
		'href'   => admin_url('themes.php?page=ot-theme-options'),
		'target' => '_blank'
	);
	$wp_admin_bar->add_menu( $args );

	$args = array(
		'id'     => 'forum',
		'parent' => 'themeperch',
		'title'  => __( 'Forum support', 'investment' ),
		'href'   => 'http://www.themeperch.net/forums/forum/investment-expert-business-theme-investment-experts-financial-consultancy-rtl/',
		'target' => '_blank'
	);
	$wp_admin_bar->add_menu( $args );

	$args = array(
		'id'     => 'portfolio',
		'parent' => 'themeperch',
		'title'  => __( 'Envato Portfolio', 'investment' ),
		'href'   => 'http://themeforest.net/user/themeperch/portfolio?ref=themeperch',
		'target' => '_blank'
	);
	$wp_admin_bar->add_menu( $args );

	 $wp_admin_bar->remove_node( 'essb' );

}

function investment_themeperch_toolbar_remove(){
  global $wp_admin_bar;
  $wp_admin_bar->remove_node( 'essb' );
}

// Hook into the 'wp_before_admin_bar_render' action
if(is_admin()){
  add_action( 'wp_before_admin_bar_render', 'investment_themeperch_toolbar', 999 );
}else{
  add_action( 'wp_before_admin_bar_render', 'investment_themeperch_toolbar_remove', 999 );
}

add_filter( 'tiny_mce_before_init', 'investment_formatTinyMCE' );
function investment_formatTinyMCE( $in ) {

$in['wordpress_adv_hidden'] = FALSE;

return $in;
}
if(!function_exists('investment_parse_text')):
function investment_parse_text( $text, $tag = 'span' ) {
  preg_match_all( "/\{([^\}]*)\}/", $text, $matches );
  if ( !empty( $matches ) ) {
    foreach ( $matches[1] as $value ) {
      $find    = "{{$value}}";
      if( $tag != 'span' ){
        $replace = "<{$tag}>{$value}</{$tag}>";
      }else{
        $replace = "<{$tag} class='primary-color'>{$value}</{$tag}>";
      }
      
      $text    = str_replace( $find, $replace, $text );
    } //$matches[1] as $value
  } //!empty( $matches )
  
  $text = str_replace( " / ", "<span class='separator'>/</span>", $text );
  
  return $text;
}
endif;

if(!function_exists('investment_posts_template')):
function investment_posts_template( $atts, $content = null, $type = "posts" ) {
    // Prepare error var
    $error = null;
    // Parse attributes
    $atts  = shortcode_atts( array(
       'template' => 'templates/default-loop.php',
      'id' => false,
      'posts_per_page' => get_option( 'posts_per_page' ),
      'post_type' => 'post',
      'taxonomy' => 'category',
      'tax_term' => false,
      'tax_operator' => 'IN',
      'author' => '',
      'tag' => '',
      'meta_key' => '',
      'offset' => 0,
      'order' => 'DESC',
      'orderby' => 'date',
      'post_parent' => false,
      'post_status' => 'publish',
      'ignore_sticky_posts' => 'no',
      'autoplay' => 'no',
      'control' => 'yes',
      'column' => 4 ,
      'readmore_link' =>'no',
      'info' => '',
      'pagination' => 'yes',
      'all_posts_link_text' => 'See All posts'
    ), $atts, $type );
    
    $original_atts = $atts;
    
    $author              = sanitize_text_field( $atts['author'] );
    $id                  = $atts['id']; // Sanitized later as an array of integers
    $ignore_sticky_posts = ( bool ) ( $atts['ignore_sticky_posts'] === 'yes' ) ? true : false;
    $meta_key            = sanitize_text_field( $atts['meta_key'] );
    $offset              = intval( $atts['offset'] );
    $order               = sanitize_key( $atts['order'] );
    $orderby             = sanitize_key( $atts['orderby'] );
    $post_parent         = $atts['post_parent'];
    $post_status         = $atts['post_status'];
    $post_type           = sanitize_text_field( $atts['post_type'] );
    $posts_per_page      = intval( $atts['posts_per_page'] );
    $tag                 = sanitize_text_field( $atts['tag'] );
    $tax_operator        = $atts['tax_operator'];
    $tax_term            = sanitize_text_field( $atts['tax_term'] );
    $taxonomy            = sanitize_key( $atts['taxonomy'] );
    // Set up initial query for post
    $args                = array(
       'category_name' => '',
      'order' => $order,
      'orderby' => $orderby,
      'post_type' => explode( ',', $post_type ),
      'posts_per_page' => $posts_per_page,
      'tag' => $tag 
    );
    // Ignore Sticky Posts
    if ( $ignore_sticky_posts )
      $args['ignore_sticky_posts'] = true;
    // Meta key (for ordering)
    if ( !empty( $meta_key ) )
      $args['meta_key'] = $meta_key;
    // If Post IDs
    if ( $id ) {
      $posts_in         = array_map( 'intval', explode( ',', $id ) );
      $args['post__in'] = $posts_in;
    } //$id
    // Post Author
    if ( !empty( $author ) )
      $args['author'] = $author;
    // Offset
    if ( !empty( $offset ) )
      $args['offset'] = $offset;
    // Post Status
    $post_status = explode( ', ', $post_status );
    $validated   = array();
    $available   = array(
       'publish',
      'pending',
      'draft',
      'auto-draft',
      'future',
      'private',
      'inherit',
      'trash',
      'any' 
    );
    foreach ( $post_status as $unvalidated ) {
      if ( in_array( $unvalidated, $available ) )
        $validated[] = $unvalidated;
    } //$post_status as $unvalidated
    if ( !empty( $validated ) )
      $args['post_status'] = $validated;
    // If taxonomy attributes, create a taxonomy query
    if ( !empty( $taxonomy ) && !empty( $tax_term ) ) {
      // Term string to array
      $tax_term = explode( ',', $tax_term );
      // Validate operator
      if ( !in_array( $tax_operator, array(
         'IN',
        'NOT IN',
        'AND' 
      ) ) )
        $tax_operator = 'IN';
      $tax_args         = array(
         'tax_query' => array(
           array(
             'taxonomy' => $taxonomy,
            'field' => ( is_numeric( $tax_term[0] ) ) ? 'id' : 'slug',
            'terms' => $tax_term,
            'operator' => $tax_operator 
          ) 
        ) 
      );
      // Check for multiple taxonomy queries
      $count            = 2;
      $more_tax_queries = false;
      while ( isset( $original_atts['taxonomy_' . $count] ) && !empty( $original_atts['taxonomy_' . $count] ) && isset( $original_atts['tax_' . $count . '_term'] ) && !empty( $original_atts['tax_' . $count . '_term'] ) ) {
        // Sanitize values
        $more_tax_queries        = true;
        $taxonomy                = sanitize_key( $original_atts['taxonomy_' . $count] );
        $terms                   = explode( ', ', sanitize_text_field( $original_atts['tax_' . $count . '_term'] ) );
        $tax_operator            = isset( $original_atts['tax_' . $count . '_operator'] ) ? $original_atts['tax_' . $count . '_operator'] : 'IN';
        $tax_operator            = in_array( $tax_operator, array(
           'IN',
          'NOT IN',
          'AND' 
        ) ) ? $tax_operator : 'IN';
        $tax_args['tax_query'][] = array(
           'taxonomy' => $taxonomy,
          'field' => 'slug',
          'terms' => $terms,
          'operator' => $tax_operator 
        );
        $count++;
      } //isset( $original_atts['taxonomy_' . $count] ) && !empty( $original_atts['taxonomy_' . $count] ) && isset( $original_atts['tax_' . $count . '_term'] ) && !empty( $original_atts['tax_' . $count . '_term'] )
      if ( $more_tax_queries ):
        $tax_relation = 'AND';
        if ( isset( $original_atts['tax_relation'] ) && in_array( $original_atts['tax_relation'], array(
           'AND',
          'OR' 
        ) ) )
          $tax_relation = $original_atts['tax_relation'];
        $args['tax_query']['relation'] = $tax_relation;
      endif;
      $args = array_merge( $args, $tax_args );
    } //!empty( $taxonomy ) && !empty( $tax_term )
    
    // Fix for pagination
    if ( is_front_page() ) {
      $paged = ( get_query_var( 'page' ) ) ? get_query_var( 'page' ) : 1;
    } //is_front_page()
    else {
      $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
    }
    $args['paged'] = $paged;
    
    // If post parent attribute, set up parent
    if ( $post_parent ) {
      if ( 'current' == $post_parent ) {
        global $post;
        $post_parent = $post->ID;
      } //'current' == $post_parent
      $args['post_parent'] = intval( $post_parent );
    } //$post_parent
    // Save original posts
    global $posts;
    $original_posts = $posts;
    
    
    // Query posts
    $posts = new WP_Query( $args );
    
    $posts->autoplay = $atts['autoplay'];
    $posts->column   = $atts['column'];
    $posts->control  = $atts['control'];
    $posts->readmore_link  = $atts['readmore_link'];
    $posts->info = $atts['info'];
    $posts->all_posts_link_text = $atts['all_posts_link_text'];
    
    // Buffer output
    ob_start();
    // Search for template in stylesheet directory
    if ( file_exists( get_stylesheet_directory() . '/' . $atts['template'] ) )
      load_template( get_stylesheet_directory() . '/' . $atts['template'], false );
    // Search for template in theme directory
    elseif ( file_exists( get_template_directory() . '/template-parts/' . $atts['template'] ) )
      load_template( get_template_directory() . '/template-parts/' . $atts['template'], false );
    elseif ( file_exists( get_template_directory() . '/' . $atts['template'] ) )
      load_template( get_template_directory() . '/' . $atts['template'], false );  
    
    // Template not found
    else
      echo __( 'template not found', 'investment' );
    $output = ob_get_contents();
    ob_end_clean();
    // Return original posts
    $posts = $original_posts;
    // Reset the query
    wp_reset_postdata();
    
    return $output;
}
endif;


function investment_get_the_term_list( $id, $taxonomy, $before = '', $sep = '', $after = '', $name=true ) {
	$terms = get_the_terms( $id, $taxonomy );

	if ( is_wp_error( $terms ) )
		return $terms;

	if ( empty( $terms ) )
		return false;

	$links = array();

	foreach ( $terms as $term ) {
		$link = get_term_link( $term, $taxonomy );
		if ( is_wp_error( $link ) ) {
			return $link;
		}
		$links[] = ($name)? $term->name : $term->slug;
	}

	/**
	 * Filters the term links for a given taxonomy.
	 *
	 * The dynamic portion of the filter name, `$taxonomy`, refers
	 * to the taxonomy slug.
	 *
	 * @since 2.5.0
	 *
	 * @param array $links An array of term links.
	 */
	$term_links = apply_filters( "term_links-$taxonomy", $links );

	return $before . join( $sep, $term_links ) . $after;
}


function investment_header_search_icon( $align = "" ) {
	return '<li class="search-box' . ( ( $align != '' ) ? ' ' . $align : '' ) . '"><a href="#"><i class="fa fa-search"></i></a>
                      <ul>
                          <li>
                              <div class="search-form">' . get_search_form( false ) . '</div>
                          </li>
                      </ul>
                  </li>';
}

function investment_post_thumbnail( $size = 'thumbnail' ) {
	global $post;
	$postid = $post->ID;
	echo investment_get_post_thumbnail( $postid, $size );
}

function investment_get_post_thumbnail( $postid, $size = 'thumbnail' ) {
	$large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( $postid ), $size );
  if(empty($large_image_url) || is_wp_error( $large_image_url )) return;
  
	return '<img src="' . esc_url( $large_image_url[ 0 ] ) . '" alt="' . get_the_title( $postid ) . '">';
}

/**
 * Get size information for all currently-registered image sizes.
 *
 * @global $_wp_additional_image_sizes
 * @uses   get_intermediate_image_sizes()
 * @return array $sizes Data for all currently-registered image sizes.
 */
function investment_get_image_sizes() {
	global $_wp_additional_image_sizes;
	
	$sizes = array();
	
	foreach ( get_intermediate_image_sizes() as $_size ) {
		if ( in_array( $_size, array(
			 'thumbnail',
			'medium',
			'medium_large',
			'large' 
		) ) ) {
			$sizes[ $_size ][ 'width' ]  = get_option( "{$_size}_size_w" );
			$sizes[ $_size ][ 'height' ] = get_option( "{$_size}_size_h" );
			$sizes[ $_size ][ 'crop' ]   = (bool) get_option( "{$_size}_crop" );
		} //in_array( $_size, array( 'thumbnail', 'medium', 'medium_large', 'large' ) )
		elseif ( isset( $_wp_additional_image_sizes[ $_size ] ) ) {
			$sizes[ $_size ] = array(
				 'width' => $_wp_additional_image_sizes[ $_size ][ 'width' ],
				'height' => $_wp_additional_image_sizes[ $_size ][ 'height' ],
				'crop' => $_wp_additional_image_sizes[ $_size ][ 'crop' ] 
			);
		} //isset( $_wp_additional_image_sizes[ $_size ] )
	} //get_intermediate_image_sizes() as $_size
	
	return $sizes;
}

function investment_get_image_sizes_Arr() {
  $sizes = investment_get_image_sizes();

  $arr = array();
  foreach ($sizes as $key => $value) {
     $arr[$key] = ucfirst(trim(str_replace(['-', '_', 'ctrl'], ' ', $key)));
  }
  
  return $arr;
}
/**
 * Filter callback to add image sizes to Media Uploader
 */
function investment_display_image_size_names_muploader( $sizes ) {
	
	$new_sizes = array();
	
	$added_sizes = get_intermediate_image_sizes();
	
	// $added_sizes is an indexed array, therefore need to convert it
	// to associative array, using $value for $key and $value
	foreach( $added_sizes as $key => $value) {
		$new_sizes[$value] = $value;
	}
	
	// This preserves the labels in $sizes, and merges the two arrays
	$new_sizes = array_merge( $new_sizes, $sizes );
	
	return $new_sizes;
}
add_filter('image_size_names_choose', 'investment_display_image_size_names_muploader', 11, 1);
/**
 * Get size information for a specific image size.
 *
 * @uses   investment_get_image_sizes()
 * @param  string $size The image size for which to retrieve data.
 * @return bool|array $size Size data about an image size or false if the size doesn't exist.
 */
function investment_get_image_size( $size ) {
	$sizes = investment_get_image_sizes();
	
	if ( isset( $sizes[ $size ] ) ) {
		return $sizes[ $size ];
	} //isset( $sizes[ $size ] )
	
	return false;
}

/**
 * Get the width of a specific image size.
 *
 * @uses   investment_get_image_size()
 * @param  string $size The image size for which to retrieve data.
 * @return bool|string $size Width of an image size or false if the size doesn't exist.
 */
function investment_get_image_width( $size ) {
	if ( !$size = investment_get_image_size( $size ) ) {
		return false;
	} //!$size = investment_get_image_size( $size )
	
	if ( isset( $size[ 'width' ] ) ) {
		return $size[ 'width' ];
	} //isset( $size[ 'width' ] )
	
	return false;
}

/**
 * Get the height of a specific image size.
 *
 * @uses   get_image_size()
 * @param  string $size The image size for which to retrieve data.
 * @return bool|string $size Height of an image size or false if the size doesn't exist.
 */
function investment_get_image_height( $size ) {
	if ( !$size = investment_get_image_size( $size ) ) {
		return false;
	} //!$size = investment_get_image_size( $size )
	
	if ( isset( $size[ 'height' ] ) ) {
		return $size[ 'height' ];
	} //isset( $size[ 'height' ] )
	
	return false;
}

add_filter( 'manage_posts_columns', 'investment_columns_head' );
add_action( 'manage_posts_custom_column', 'investment_columns_content', 10, 2 );

// ADD NEW COLUMN
function investment_columns_head( $defaults ) {
  if( !in_array( get_post_type(), ['post', 'portfolio', 'service', 'job', 'partner']) ) return $defaults;
	$defaults[ 'featured_image' ] = __( 'Featured Image', 'investment' );
	return $defaults;
}

function investment_columns_content( $column_name, $post_ID ) {
  if( !in_array( get_post_type($post_ID), ['post', 'portfolio', 'service', 'job', 'partner']) ) return;
	if ( $column_name == 'featured_image' ) {
		if ( has_post_thumbnail( $post_ID ) ) {
			// HAS A FEATURED IMAGE
			echo investment_get_post_thumbnail( $post_ID, 'thumbnail' );
		}
	} 
}

add_filter('manage_job_posts_columns' , 'investment_job_columns_item');
add_action( 'manage_job_posts_custom_column' , 'investment_manage_job_posts_custom_column', 10, 2 );
function investment_job_columns_item($columns) {
  
  unset(
    $columns['featured_image'],
    $columns['author'],
    $columns['comments']
  );
  $new_columns = array(
    'department' => __('Department', 'investment'),
    'type' => __('Job type', 'investment'),
    'vacancy' => __('Vacancy', 'investment'),
    'sallary' => __('Sallary info', 'investment'),
  );
    return array_merge($columns, $new_columns);
}
function investment_manage_job_posts_custom_column( $column, $post_id ) {
    switch ( $column ) {

        case 'department' :
            echo get_post_meta( $post_id , 'department' , true ); 
            break;
        case 'type' :
            $type = get_post_meta( $post_id , 'type' , true ); 
            echo isset($type['input'])? esc_attr($type['input']) : '--';
            break;
        case 'vacancy' :
            $vacancy = get_post_meta( $post_id , 'vacancy' , true ); 
            echo isset($vacancy['input'])? esc_attr($vacancy['input']) : '--';
            break;
        case 'sallary' :
            $sallary = get_post_meta( $post_id , 'sallary_info' , true ); 
            echo isset($sallary['input'])? esc_attr($sallary['input']) : '--';
            break;        

    }
}

add_filter('manage_team_posts_columns' , 'investment_team_columns_item');
add_action( 'manage_team_posts_custom_column' , 'investment_manage_team_posts_custom_column', 10, 2 );
function investment_team_columns_item($columns) {
  
  unset(
    $columns['featured_image'],
    $columns['date']
  );
  $new_columns = array(
    'designation' => __('Designation', 'investment'),  
    'date' => __('Date', 'investment'),  
    'featured_image' => __('Member image', 'investment'),  
  );
    return array_merge($columns, $new_columns);
}
function investment_manage_team_posts_custom_column( $column, $post_id ) {
    switch ( $column ) {

        case 'designation' :
            echo get_post_meta( $post_id , 'designation' , true ); 
            break;
        

    }
}

add_action( 'print_media_templates', function() {
	
	// define your backbone template;
	// the "tmpl-" prefix is required,
	// and your input field should have a data-setting attribute
	// matching the shortcode name
?>
  <script type="text/html" id="tmpl-investment-custom-gallery-setting">
    <label class="setting">
      <span><?php
	echo __( 'Gallery type', 'investment' );
?></span>
      <select data-setting="gallery_type">
        <option value="default"> <?php
	echo __( 'Default', 'investment' );
?> </option>
        <option value="slider"> <?php
	echo __( 'Slider', 'investment' );
?> </option>
        <option value="tiled"> <?php
	echo __( 'Tiled', 'investment' );
?> </option>
      </select>
    </label>
  </script>

  <script>

    jQuery(document).ready(function(){

      // add your shortcode attribute and its default value to the
      // gallery settings list; $.extend should work as well...
      _.extend(wp.media.gallery.defaults, {
        gallery_type: 'default'
      });

      // merge default gallery settings template with yours
      wp.media.view.Settings.Gallery = wp.media.view.Settings.Gallery.extend({
        template: function(view){
          return wp.media.template('gallery-settings')(view)
               + wp.media.template('investment-custom-gallery-setting')(view);
        }
      });

    });

  </script>
  <?php
	
} );

function investment_set_post_views( $postID ) {
	$count_key = 'investment_post_views_count';
	$count     = get_post_meta( $postID, $count_key, true );
	if ( $count == '' ) {
		$count = 0;
		delete_post_meta( $postID, $count_key );
		add_post_meta( $postID, $count_key, '0' );
	} //$count == ''
	else {
		$count++;
		update_post_meta( $postID, $count_key, $count );
	}
}
//investment_set_post_views(get_the_ID());


function investment_track_post_views( $post_id ) {
	if ( !is_single() )
		return;
	if ( empty( $post_id ) ) {
		global $post;
		$post_id = $post->ID;
	} //empty( $post_id )
	investment_set_post_views( $post_id );
}
add_action( 'wp_head', 'investment_track_post_views' );

function investment_get_post_views( $postID ) {
	$count_key = 'investment_post_views_count';
	$count     = get_post_meta( $postID, $count_key, true );
	if ( $count == '' ) {
		delete_post_meta( $postID, $count_key );
		add_post_meta( $postID, $count_key, '0' );
		return "0";
	} //$count == ''
	
	return investment_format_count( $count );
}
//investment_get_post_views(get_the_ID());

if ( !function_exists( 'investment_get_comments_number' ) ):
	function investment_get_comments_number() {
		global $post;
		$num_comments = get_comments_number( $post->ID ); // get_comments_number returns only a numeric value
		
		if ( comments_open( $post->ID ) ) {
			if ( $num_comments == 0 ) {
				$comments = __( 'No Comments', 'investment' );
			} //$num_comments == 0
			elseif ( $num_comments > 1 ) {
				$comments = $num_comments . ' <span>' . __( 'Comments', 'investment' ) . '</span>';
			} //$num_comments > 1
			else {
				$comments = '1 <span>' . __( 'Comment', 'investment' ) . '</span>';
			}
			$write_comments = '<a href="' . get_comments_link() . '">' . $comments . '</a>';
		} //comments_open( $post->ID )
		else {
			$write_comments = __( 'Comments off', 'investment' );
		}
		
		return '<i class="fa fa-comment-o"></i>' . $write_comments;
	}
endif;

/**
 * gets the current post type in the WordPress Admin
 */
function investment_get_current_post_type() {
	global $wpdb, $post, $typenow, $current_screen;
	
	//we have a post so we can just get the post type from that
	if ( $typenow )
		return $typenow;
	//check the global $typenow - set in admin.php
	
	//check the global $current_screen object - set in sceen.php
	elseif ( $current_screen && $current_screen->post_type )
		return $current_screen->post_type;
	//lastly check the post_type querystring
	elseif ( isset( $_REQUEST[ 'post_type' ] ) )
		return sanitize_key( $_REQUEST[ 'post_type' ] );
	elseif ( isset( $_REQUEST[ 'post' ] ) && get_post_type( $_REQUEST[ 'post' ] ) )
		return get_post_type( $_REQUEST[ 'post' ] );
	elseif ( $post && $post->post_type )
		return $post->post_type;
	//we do not know the post type!
	return null;
}

// Custom filter function to modify default gallery shortcode output
function investment_post_gallery( $output, $attr ) {
	
	// Initialize
	global $post, $wp_locale;
	
	// Gallery instance counter
	static $instance = 0;
	$instance++;
	
	// Validate the author's orderby attribute
	if ( isset( $attr[ 'orderby' ] ) ) {
		$attr[ 'orderby' ] = sanitize_sql_orderby( $attr[ 'orderby' ] );
		if ( !$attr[ 'orderby' ] )
			unset( $attr[ 'orderby' ] );
	} //isset( $attr[ 'orderby' ] )
	
	// Get attributes from shortcode
	extract( shortcode_atts( array(
		 'order' => 'ASC',
		'orderby' => 'menu_order ID',
		'id' => $post->ID,
		'itemtag' => 'dl',
		'icontag' => 'dt',
		'captiontag' => 'dd',
		'columns' => 3,
		'size' => 'thumbnail',
		'include' => '',
		'exclude' => '',
		'gallery_type' => 'default' 
	), $attr ) );
	
	// Initialize
	$id          = intval( $id );
	$attachments = array();
	if ( $order == 'RAND' )
		$orderby = 'none';
	
	if ( !empty( $include ) ) {
		
		// Include attribute is present
		$include      = preg_replace( '/[^0-9,]+/', '', $include );
		$_attachments = get_posts( array(
			 'include' => $include,
			'post_status' => 'inherit',
			'post_type' => 'attachment',
			'post_mime_type' => 'image',
			'order' => $order,
			'orderby' => $orderby 
		) );
		
		// Setup attachments array
		foreach ( $_attachments as $key => $val ) {
			$attachments[ $val->ID ] = $_attachments[ $key ];
		} //$_attachments as $key => $val
		
	} //!empty( $include )
	else if ( !empty( $exclude ) ) {
		
		// Exclude attribute is present 
		$exclude = preg_replace( '/[^0-9,]+/', '', $exclude );
		
		// Setup attachments array
		$attachments = get_children( array(
			 'post_parent' => $id,
			'exclude' => $exclude,
			'post_status' => 'inherit',
			'post_type' => 'attachment',
			'post_mime_type' => 'image',
			'order' => $order,
			'orderby' => $orderby 
		) );
	} //!empty( $exclude )
	else {
		// Setup attachments array
		$attachments = get_children( array(
			 'post_parent' => $id,
			'post_status' => 'inherit',
			'post_type' => 'attachment',
			'post_mime_type' => 'image',
			'order' => $order,
			'orderby' => $orderby 
		) );
	}
	
	if ( empty( $attachments ) )
		return '';
	
	// Filter gallery differently for feeds
	if ( is_feed() ) {
		$output = "\n";
		foreach ( $attachments as $att_id => $attachment )
			$output .= wp_get_attachment_link( $att_id, $size, true ) . "\n";
		return $output;
	} //is_feed()
	
	// Filter tags and attributes
	$itemtag    = tag_escape( $itemtag );
	$captiontag = tag_escape( $captiontag );
	$columns    = intval( $columns );
	$itemwidth  = $columns > 0 ? floor( 100 / $columns ) : 100;
	$float      = is_rtl() ? 'right' : 'left';
	$selector   = "gallery-{$instance}";
	$output     = '';
	
	if ( $gallery_type == 'slider' ):
		$output = '<div class="image-holder post-carousel">';
		foreach ( $attachments as $id => $attachment ) {
			$src         = wp_get_attachment_image_src( $id, $size );
			$fullsrc     = wp_get_attachment_image_src( $id, 'full' );
			$imagewidth  = ( investment_get_layout() == 'full' ) ? 1170 : 832;
			$imageheight = ( investment_get_layout() == 'full' ) ? 585 : 554;
			
			$output .= '<img alt="' . esc_attr( $attachment->post_title ) . '"
						     src="' . investment_image_resize( $fullsrc[ 0 ], $imagewidth, $imageheight ) . '">';
		} //$attachments as $id => $attachment
		$output .= '</div>';
	elseif ( $gallery_type == 'tiled' ):
		$uniqid = uniqid( 'tiled_gallery_' );
		wp_enqueue_style( 'unite-gallery' );
		wp_enqueue_script( 'ug-theme-tiles' );
		$output = '<div id="' . $uniqid . '" class="gallery-tiled" style="display:none;">';
		foreach ( $attachments as $id => $attachment ) {
			$src     = wp_get_attachment_image_src( $id, $size );
			$fullsrc = wp_get_attachment_image_src( $id, 'full' );
			$output .= '<a href="' . get_attachment_link( $id ) . '">
						<img alt="' . esc_attr( $attachment->post_title ) . '"
						     src="' . esc_url( $src[ 0 ] ) . '"
						     data-image="' . esc_url( $fullsrc[ 0 ] ) . '"
						     data-description="' . wptexturize( $attachment->post_excerpt ) . '"
						     style="display:none">
						</a>';
		} //$attachments as $id => $attachment
		$output .= '</div>
		<script>
			jQuery(document).ready(function(){
				jQuery("#' . $uniqid . '").unitegallery({
					tiles_type:"justified",
					tiles_justified_space_between: 10
				});
			});
		</script>';
	else:
		// Filter gallery CSS
		$output = apply_filters( 'gallery_style', "
			<style type='text/css'>
				#{$selector} {
					margin: 30px -15px;
				}
				#{$selector} .gallery-item {
					float: {$float};
					margin-top: 10px;
					text-align: center;
					width: {$itemwidth}%;
					padding-left: 15px;
					padding-right: 15px;
				}
				#{$selector} img {
					
				}
				#{$selector} .gallery-caption {
					margin-left: 0;
				}
			</style>
			<!-- see gallery_shortcode() in wp-includes/media.php -->
			<div id='$selector' class='gallery galleryid-{$id} gallery-columns-{$columns}'>" );
		// Iterate through the attachments in this gallery instance
		$i      = 0;
		$class  = ( isset( $attr[ 'link' ] ) && $attr[ 'link' ] == 'file' ) ? ' image-link' : '';
		foreach ( $attachments as $id => $attachment ) {
			
			// Attachment link
			$link = isset( $attr[ 'link' ] ) && 'file' == $attr[ 'link' ] ? wp_get_attachment_link( $id, $size, false, false ) : wp_get_attachment_link( $id, $size, true, false );
			
			// Start itemtag
			$output .= "<{$itemtag} class='gallery-item{$class}'>";
			
			// icontag
			$output .= "
			<{$icontag} class='gallery-icon'>
				$link
			</{$icontag}>";
			
			if ( $captiontag && trim( $attachment->post_excerpt ) ) {
				
				// captiontag
				$output .= "
				<{$captiontag} class='gallery-caption'>
					" . wptexturize( $attachment->post_excerpt ) . "
				</{$captiontag}>";
				
			} //$captiontag && trim( $attachment->post_excerpt )
			
			// End itemtag
			$output .= "</{$itemtag}>";
			
			// Line breaks by columns set
			if ( $columns > 0 && ++$i % $columns == 0 )
				$output .= '<br style="clear: both;">';
			
		} //$attachments as $id => $attachment
		
		// End gallery output
		$output .= "
			<br style='clear: both;'>
		</div>\n";
	endif;
	
	return $output;
	
}
// Apply filter to default gallery shortcode
add_filter( 'post_gallery', 'investment_post_gallery', 10, 2 );

add_filter( 'ot_recognized_post_format_meta_boxes', 'investment_recognized_post_format_meta_boxes' );
function investment_recognized_post_format_meta_boxes( $formats ) {
	$formats[] = investment_meta_box_post_format_status();
	return $formats;
}

function investment_meta_box_post_format_status( $pages = 'post' ) {
	
	if ( !current_theme_supports( 'post-formats' ) || !in_array( 'video', current( get_theme_support( 'post-formats' ) ) ) )
		return false;
	
	if ( is_string( $pages ) )
		$pages = explode( ',', $pages );
	
	return apply_filters( 'investment_meta_box_post_format_status', array(
		 'id' => 'ot-post-format-status',
		'title' => __( 'Twiter Status', 'investment' ),
		'desc' => '',
		'pages' => $pages,
		'context' => 'side',
		'priority' => 'low',
		'fields' => array(
			 array(
				 'id' => '_format_status_embed',
				'label' => '',
				'desc' => 'Example: https://twitter.com/envato/status/710131105714798592',
				'std' => '',
				'type' => 'text' 
			),
			array(
				 'id' => 'status_background_type',
				'label' => '',
				'desc' => __( 'Status background image', 'investment' ),
				'std' => 'custom',
				'type' => 'select',
				'choices' => array(
					 array(
						 'label' =>  __( 'Custom image', 'investment' ),
						'value' => 'custom' 
					),
					array(
						 'label' =>  __( 'Featured image', 'investment' ),
						'value' => 'featured' 
					) 
				) 
			),
			array(
				 'id' => '_format_status_image',
				'label' => '',
				'desc' => __( 'Custom background image', 'investment' ),
				'std' => INVESTMENT_ASSETS . '/images/statusbg.png',
				'type' => 'upload',
				'operator' => 'and',
				'condition' => 'status_background_type:is(custom)' 
			) 
		) 
	), $pages );
	
}

add_filter( 'ot_meta_box_post_format_quote', 'investment_meta_box_post_format_quote' );
function investment_meta_box_post_format_quote() {
	return array(
		 'id' => 'ot-post-format-quote',
		'title' => __( 'Quote', 'investment' ),
		'desc' => '',
		'pages' => array(
			 'post' 
		),
		'context' => 'side',
		'priority' => 'low',
		'fields' => array(
			 array(
				 'id' => '_format_quote_text',
				'label' => '',
				'desc' => __( 'Quote Title (ex. Design is not just what it looks like and feels like. Design is how it works.)', 'investment' ),
				'std' => '',
				'type' => 'text' 
			),
			array(
				 'id' => '_format_quote_name',
				'label' => '',
				'desc' => __( 'Name (ex. Steve jobs)', 'investment' ),
				'std' => '',
				'type' => 'text' 
			),
			array(
				 'id' => 'quote_background_type',
				'label' => '',
				'desc' => __( 'Quote background image', 'investment' ),
				'std' => 'custom',
				'type' => 'select',
				'choices' => array(
					  array(
             'label' =>  __( 'Custom image', 'investment' ),
            'value' => 'custom' 
          ),
          array(
             'label' =>  __( 'Featured image', 'investment' ),
            'value' => 'featured' 
          ) 
				) 
			),
			array(
				 'id' => '_format_quote_image',
				'label' => '',
				'desc' => __( 'Custom background image', 'investment' ),
				'std' => INVESTMENT_ASSETS . '/images/qutoebg.png',
				'type' => 'upload',
				'operator' => 'and',
				'condition' => 'quote_background_type:is(custom)' 
			) 
		) 
	);
}

function investment_header_default_social_icons() {
	return array(
		array(
			 'title' => __( 'Linkedin', 'investment' ),
       'icon' => 'fa-linkedin',
       'input' => '#',
       'icon_link' => array(
          'icon' => 'fa-linkedin',
          'input' => '#' 
       ) 
		), 
		array(
			 'title' => __( 'Twitter', 'investment' ),
       'icon' => 'fa-twitter',
       'input' => '#',
			'icon_link' => array(
				 'icon' => 'fa-twitter',
				'input' => '#' 
			) 
		),
		array(
			 'title' => __( 'Google +', 'investment' ),
       'icon' => 'fa-google-plus',
       'input' => '#',
			'icon_link' => array(
				 'icon' => 'fa-google-plus',
				'input' => '#' 
			) 
		),	
		
	);
}

function investment_default_social_icons() {
	return array(
		 array(
			 'title' => __( 'Facebook', 'investment' ),
       'icon' => 'fa-facebook',
       'input' => '#',
			'icon_link' => array(
				 'icon' => 'fa-facebook',
				'input' => '#' 
			) 
		),
		array(
			 'title' => __( 'Twitter', 'investment' ),
       'icon' => 'fa-twitter',
       'input' => '#',
			'icon_link' => array(
				 'icon' => 'fa-twitter',
				'input' => '#' 
			) 
		),
		array(
			 'title' => __( 'Google +', 'investment' ),
       'icon' => 'fa-google-plus',
       'input' => '#',
			'icon_link' => array(
				 'icon' => 'fa-google-plus',
				'input' => '#' 
			) 
		),
		array(
			 'title' => __( 'Youtube', 'investment' ),
       'icon' => 'fa-youtube-play',
       'input' => '#',
			'icon_link' => array(
				 'icon' => 'fa-youtube-play',
				'input' => '#' 
			) 
		),
		
		
	);
}

if( !function_exists('investment_get_topbar_info') ):
function investment_get_topbar_info($class = ''){

  $display = ot_get_option('header_topbar_info_display', 'on');
  if( $display != 'on' ) return false;
  $output = '';
  $classArr = array('nav-item');
  $classArr[] = $class;
  $classArr = array_filter($classArr);

  $topbar_info = ot_get_option('topbar_info', array(
                    array(
                        'title' => __( 'Time', 'investment' ),
                        'icon' => 'fa-clock-o',
                        'input' => 'Mon - Fri : 09:00 - 17:00',
                        'icon_link' => array('icon' => 'fa-clock-o', 'input' => __( 'Mon - Fri : 09:00 - 17:00', 'investment' ))
                    ),
                    array(
                        'title' => __( 'Phone', 'investment' ),
                        'icon' => 'fa-phone',
                        'input' => '888-123-2342',
                        'icon_link' => array('icon' => 'fa-phone', 'input' => __( '888-123-2342', 'investment' ))
                    ),

                ));

  if(empty($topbar_info)) return false;

  foreach ($topbar_info as $key => $value) {
    $input = '';
    $icon = '';
    //depreciated
    if(is_array($value['icon_link'])){
      $input = isset($value['icon_link']['input'])? $value['icon_link']['input'] : '';
      $icon = isset($value['icon_link']['icon'])? $value['icon_link']['icon'] : '';
    }else{
      $input = isset($value['input']) ? $value['input'] : '';
      $icon = isset($value['icon']) ? $value['icon'] : '';
    }
    
    $title = isset($value['title'])? $value['title'] : '';
    $input = sprintf(_x('%s', 'Topbar info '.$title, 'investment'), $input);
    $output .= '<div class="'.implode(' ', $classArr).'"><i class="fa '.esc_attr($icon).' primary-color" aria-hidden="true"></i>'.force_balance_tags($input).'</div>';
  }

     return $output; 
}
endif;

function investment_get_topbar_button($class=""){
  
  $display = ot_get_option('topbar_button_display', 'on');

  if( $display == 'off' ) return '';
  $output = '';
  $classArr = array(
    'topbar-button',
    'list-inline',
    'd-sm-flex',
    'd-none',
    'gap-5',
    'm-0',
    $class
  );
 
  $classArr = array_filter($classArr);

  $topbar_background = ot_get_option('topbar_background', 'secondary-bg-dark');
  $button_class = ($topbar_background == 'primary-bg')? 'btn-secondary' : 'btn-primary';
  $topbar_button = ot_get_option('topbar_button', array(
                    array(
                        'title' => __( 'Work with us', 'investment' ),
                        'link' => '#',
                        'target' => '_self',
                        'modal' => 'no'
                    ),
                ));

    if(empty($topbar_button)) return false;

    $output .= '<ul class="'.implode(' ', $classArr).'">';
    foreach ($topbar_button as $key => $value) {
      $button_class .= (isset($value['modal']) && ($value['modal'] == 'yes'))? ' modal-popup' : '';
      $title = sprintf(_x('%s', "Topbar button {$key}", 'investment'), $value['title']);
      $target = (!empty($value['target']) && $value['modal'] == 'no') ? ' target='.$value['target'] : '';
      $output .= '<li class="list-inline-item m-0"><a href="'.esc_attr($value['link']).'" class="btn btn-sm '.esc_attr($button_class).'"' . $target . '>'.esc_attr($title).'</a></li>';
    }
    $output .= '</ul>';
  return $output;    
}

function investment_get_social_icons( $social_icons = array(), $args = array() ) {
	
	if ( empty( $social_icons ) )
		return;
	
	$output = '';
	extract( shortcode_atts( array(
		'wrap' => 'ul',
		'wrapclass' => '',
		'linkwrapbefore' => '',
		'linkwrap' => 'li',
		'linkwrapclass' => '',
		'linkclass' => '',
		'linktext' => true 
	), $args ) );
	
	$output = ( $wrap != '' ) ? '<' . esc_attr( $wrap ) . ( ( $wrapclass != '' ) ? ' class="' . esc_attr( $wrapclass ) . '"' : '' ) . '>' : '';
	$output .= ( $linkwrapbefore != '' ) ? force_balance_tags( $linkwrapbefore ) : '';
	
	$linkbefore = ( $linkwrap != '' ) ? '<' . esc_attr( $linkwrap ) . ( ( $linkwrapclass != '' ) ? ' class="' . esc_attr( $linkwrapclass ) . '"' : '' ) . '>' : '';
	$linkafter  = ( $linkwrap != '' ) ? '</' . esc_attr( $linkwrap ) . '>' : '';
	
	$linkclass = ( $linkclass != '' ) ? ' class="' . esc_attr( $linkclass ) . '"' : '';

	foreach ( $social_icons as $key => $value ) {
    $title      = isset( $value[ 'title' ] ) ? $value[ 'title' ] : '';
		$url        = '';
		$icon_class = '';

    if(is_array($value['icon_link'])){
      $url = isset( $value[ 'icon_link' ][ 'input' ] ) ? $value[ 'icon_link' ][ 'input' ] : '';
      $icon_class = isset( $value[ 'icon_link' ][ 'icon' ] ) ? $value[ 'icon_link' ][ 'icon' ] : '';
    }
    else{
      $url = isset( $value[ 'input' ] ) ? $value[ 'input' ] : '';
      $icon_class = isset( $value[ 'icon' ] ) ? $value[ 'icon' ] : '';
    }
		
		$output .= $linkbefore . '<a target="_blank" href="' . esc_url( $url ) . '" title="' . esc_attr( $title ) . '"' . $linkclass . '>
			<i class="fa ' . esc_attr( $icon_class ) . '"></i>
			' . ( ( $linktext ) ? '<span>' . esc_attr( $title ) . '</span>' : '' ) . '
			</a>' . $linkafter;
		
	} //$social_icons as $key => $value
	
	$output .= ( $wrap != '' ) ? '</' . esc_attr( $wrap ) . '>' : '';
	
	return $output;
}

function investment_get_navbar_text(){
  $search_icon_display = ot_get_option( 'search_icon_display', 'off' );
  $search_icon = ($search_icon_display == 'on')? investment_menu_search_icon() : '';
  $social_icons_display = ot_get_option('header_social_icons_display', 'on');
  $cart = function_exists('is_woocommerce') ?investment_get_cart_icon() : '';
  $social_icons = '';
  if($social_icons_display == 'on'){
      $iconsArr = ot_get_option('header_social_icons', investment_header_default_social_icons());
      
      $social_icons_scroll_display = ot_get_option('header_social_icons_display_in_menu', 'off');
      $social_icons = investment_get_social_icons($iconsArr, array(
              'wrapclass' => 'social-icon list-inline mb-0 d-flex scroll-display-'.$social_icons_scroll_display,
              'linkwrapclass' => 'list-inline-item',
              'linktext' => false,
              'linkclass' => 'icon-link social-link p-5'
          ));
  }
  $menu_button = ot_get_option('topbar_button_display_in_menu', 'on');
  
  $button = ($menu_button == 'on')? investment_get_topbar_button('scroll-display-'.$menu_button) : '';

  $navtext_classes = [
      'd-flex',
      'align-items-center',
      'gap-20',
      'mt-20',
      'mt-xl-0'
  ];
  $output = '<div class="'.join( ' ', $navtext_classes ).'">'.$search_icon.$cart.$social_icons.$button.'</div>';
  return apply_filters( 'investment_get_navbar_text', $output );
}


// Add Profile Fields
if( !function_exists('investment_contact_options') ):
function investment_contact_options(){
    $profile_fields = array();
     $profile_fields['facebook'] = array('Facebook', 'fb');
    $profile_fields['twitter'] = array('Twitter', 'tw');
    $profile_fields['youtube-play'] = array('Youtube', 'yt');
    $profile_fields['pinterest'] = array('Pinterest', 'pt');
    $profile_fields['linkedin'] = array('Linkedin', 'li');
    $profile_fields['flickr'] = array('Flickr', 'fl');
    $profile_fields['google-plus'] = array('Google+', 'gplus');
    $profile_fields['instagram'] = array('Instagram', 'ig');
    $profile_fields['vk'] = array('Vk', 'vk');

    return $profile_fields;

}
endif;


function investment_get_user_contacts_list(){
    global $post;
    $array = investment_contact_options();
    foreach ($array as $key => $value) {
        $link = get_user_meta( get_the_author_meta( 'ID' ), $key, true );
        echo ($link != '')?'<li><a class="'.esc_attr($value[1]).'" href="'.esc_url($link).'" title="'.esc_attr($value[0]).'"><i class="fa fa-'.esc_attr($key).'"></i></a></li>' : '';
    }
}

function investment_get_header_type(){
	global $post;
	$output = array(
			'type' => '',
			'shortcode' => false
		);

	if(is_page()){
		$header_type = get_post_meta( $post->ID, 'header_type', true );
		$output['shortcode'] = ($header_type == 'shortcode')? get_post_meta( get_the_ID(), 'shortcode', true ) : false;		
	}elseif (is_single()) {		
		$header_type = ot_get_option( 'single_post_header_style', 'style1' );
		$output['shortcode'] = ($header_type == 'shortcode')? ot_get_option( 'single_post_shortcode' ) : false;
	}else{
		$header_type = ot_get_option( 'blog_header_style', 'style1' );
		$output['shortcode'] = ($header_type == 'shortcode')? ot_get_option( 'blog_shortcode' ) : false;
	}

	$output['type'] = ( $header_type != '' )? $header_type : 'style1';

	return $output;
}

add_action( 'investment_after_header', 'investment_get_header_style' );
function investment_get_header_style(){

	$header = investment_get_header_type();
	$header_type = $header['type'];	

	if( ($header_type == 'style1') || ($header_type == 'style2') ){
		$args['template'] = 'header/slider-'.$header_type.'.php';
	}else{
		$args['template'] = 'header/page-header.php';
	}


	if(isset($args['template'])){
		echo investment_posts_template($args);
	}
	
}

function investment_parse_color_text($text){
	preg_match_all("/\{([^\}]*)\}/", $text, $matches);
		if( !empty($matches) ){
			foreach ($matches[1] as $value) {
				$text = str_replace("{{$value}}","<span class='primary-color'>{$value}</span>",$text);
			}
		}
		return $text;
}

add_filter('nav_menu_css_class' , 'investment_active_nav_class' , 10 , 2);
function investment_active_nav_class($classes, $item){
     if( in_array('current-menu-item', $classes) ){
             $classes[] = 'active';
     }
     return $classes;
}

function investment_password_form() {
    global $post;
    $label = 'pwbox-'.( empty( $post->ID ) ? rand() : $post->ID );
    $o = '<form class="password-form" action="' . esc_url( site_url( 'wp-login.php?action=postpass', 'login_post' ) ) . '" method="post">
    ' . __( "To view this protected post, enter the password below:", "investment" ) . '
    <div class="row">
    <div class="col-lg-8 col-sm-8 col-xs-12"><input class="post-password-input form-control" placeholder="' . __( "Password:", "investment" ) . '" name="post_password" id="' . $label . '" type="password" size="20" maxlength="20" /></div><div class="col-lg-4 col-sm-4 col-xs-12"><input type="submit" class="btn btn-default" name="Submit" value="' . esc_attr__( "Submit", "investment" ) . '" /></div>
    </div>
    </form>
    ';
    return $o;
}
add_filter( 'the_password_form', 'investment_password_form' );

add_action( 'wp_ajax_instafeed_access_token_action', 'investment_instafeed_access_token_action' );
add_action( 'wp_ajax_nopriv_instafeed_access_token_action', 'investment_instafeed_access_token_action' );

function investment_instafeed_access_token_action(){
	global $wpdb;
	$access_token = (isset($_POST['access_token']))? $_POST['access_token'] : '';
	if($access_token != ''){
		update_option( 'access_token', $access_token );
		echo 'Updated';
	}else{
		echo 'Some thing went wrong';
	}

	wp_die();
	
}

function investment_wpcf7_dynamic_recipient_for_members($args) {
  if( is_singular('team') ){
    $args['recipient'] = get_post_meta( get_the_ID(), 'contact_form_email', true );
    return $args;
  }
  return $args;
}

add_filter( 'vc_iconpicker-type-pixden', 'investment_iconpicker_type_pixden' );

function investment_iconpicker_type_pixden( $icons ){
  $pixden = array( array('pe-7s-album' => 'album' ), array('pe-7s-arc' => 'arc' ), array('pe-7s-back-2' => 'back-2' ), array('pe-7s-bandaid' => 'bandaid' ), array('pe-7s-car' => 'car' ), array('pe-7s-diamond' => 'diamond' ), array('pe-7s-door-lock' => 'door-lock' ), array('pe-7s-eyedropper' => 'eyedropper' ), array('pe-7s-female' => 'female' ), array('pe-7s-gym' => 'gym' ), array('pe-7s-hammer' => 'hammer' ), array('pe-7s-headphones' => 'headphones' ), array('pe-7s-helm' => 'helm' ), array('pe-7s-hourglass' => 'hourglass' ), array('pe-7s-leaf' => 'leaf' ), array('pe-7s-magic-wand' => 'magic-wand' ), array('pe-7s-male' => 'male' ), array('pe-7s-map-2' => 'map-2' ), array('pe-7s-next-2' => 'next-2' ), array('pe-7s-paint-bucket' => 'paint-bucket' ), array('pe-7s-pendrive' => 'pendrive' ), array('pe-7s-photo' => 'photo' ), array('pe-7s-piggy' => 'piggy' ), array('pe-7s-plugin' => 'plugin' ), array('pe-7s-refresh-2' => 'refresh-2' ), array('pe-7s-rocket' => 'rocket' ), array('pe-7s-settings' => 'settings' ), array('pe-7s-shield' => 'shield' ), array('pe-7s-smile' => 'smile' ), array('pe-7s-usb' => 'usb' ), array('pe-7s-vector' => 'vector' ), array('pe-7s-wine' => 'wine' ), array('pe-7s-cloud-upload' => 'cloud-upload' ), array('pe-7s-cash' => 'cash' ), array('pe-7s-close' => 'close' ), array('pe-7s-bluetooth' => 'bluetooth' ), array('pe-7s-cloud-download' => 'cloud-download' ), array('pe-7s-way' => 'way' ), array('pe-7s-close-circle' => 'close-circle' ), array('pe-7s-id' => 'id' ), array('pe-7s-angle-up' => 'angle-up' ), array('pe-7s-wristwatch' => 'wristwatch' ), array('pe-7s-angle-up-circle' => 'angle-up-circle' ), array('pe-7s-world' => 'world' ), array('pe-7s-angle-right' => 'angle-right' ), array('pe-7s-volume' => 'volume' ), array('pe-7s-angle-right-circle' => 'angle-right-circle' ), array('pe-7s-users' => 'users' ), array('pe-7s-angle-left' => 'angle-left' ), array('pe-7s-user-female' => 'user-female' ), array('pe-7s-angle-left-circle' => 'angle-left-circle' ), array('pe-7s-up-arrow' => 'up-arrow' ), array('pe-7s-angle-down' => 'angle-down' ), array('pe-7s-switch' => 'switch' ), array('pe-7s-angle-down-circle' => 'angle-down-circle' ), array('pe-7s-scissors' => 'scissors' ), array('pe-7s-wallet' => 'wallet' ), array('pe-7s-safe' => 'safe' ), array('pe-7s-volume2' => 'volume2' ), array('pe-7s-volume1' => 'volume1' ), array('pe-7s-voicemail' => 'voicemail' ), array('pe-7s-video' => 'video' ), array('pe-7s-user' => 'user' ), array('pe-7s-upload' => 'upload' ), array('pe-7s-unlock' => 'unlock' ), array('pe-7s-umbrella' => 'umbrella' ), array('pe-7s-trash' => 'trash' ), array('pe-7s-tools' => 'tools' ), array('pe-7s-timer' => 'timer' ), array('pe-7s-ticket' => 'ticket' ), array('pe-7s-target' => 'target' ), array('pe-7s-sun' => 'sun' ), array('pe-7s-study' => 'study' ), array('pe-7s-stopwatch' => 'stopwatch' ), array('pe-7s-star' => 'star' ), array('pe-7s-speaker' => 'speaker' ), array('pe-7s-signal' => 'signal' ), array('pe-7s-shuffle' => 'shuffle' ), array('pe-7s-shopbag' => 'shopbag' ), array('pe-7s-share' => 'share' ), array('pe-7s-server' => 'server' ), array('pe-7s-search' => 'search' ), array('pe-7s-film' => 'film' ), array('pe-7s-science' => 'science' ), array('pe-7s-disk' => 'disk' ), array('pe-7s-ribbon' => 'ribbon' ), array('pe-7s-repeat' => 'repeat' ), array('pe-7s-refresh' => 'refresh' ), array('pe-7s-add-user' => 'add-user' ), array('pe-7s-refresh-cloud' => 'refresh-cloud' ), array('pe-7s-paperclip' => 'paperclip' ), array('pe-7s-radio' => 'radio' ), array('pe-7s-note2' => 'note2' ), array('pe-7s-print' => 'print' ), array('pe-7s-network' => 'network' ), array('pe-7s-prev' => 'prev' ), array('pe-7s-mute' => 'mute' ), array('pe-7s-power' => 'power' ), array('pe-7s-medal' => 'medal' ), array('pe-7s-portfolio' => 'portfolio' ), array('pe-7s-like2' => 'like2' ), array('pe-7s-plus' => 'plus' ), array('pe-7s-left-arrow' => 'left-arrow' ), array('pe-7s-play' => 'play' ), array('pe-7s-key' => 'key' ), array('pe-7s-plane' => 'plane' ), array('pe-7s-joy' => 'joy' ), array('pe-7s-photo-gallery' => 'photo-gallery' ), array('pe-7s-pin' => 'pin' ), array('pe-7s-phone' => 'phone' ), array('pe-7s-plug' => 'plug' ), array('pe-7s-pen' => 'pen' ), array('pe-7s-right-arrow' => 'right-arrow' ), array('pe-7s-paper-plane' => 'paper-plane' ), array('pe-7s-delete-user' => 'delete-user' ), array('pe-7s-paint' => 'paint' ), array('pe-7s-bottom-arrow' => 'bottom-arrow' ), array('pe-7s-notebook' => 'notebook' ), array('pe-7s-note' => 'note' ), array('pe-7s-next' => 'next' ), array('pe-7s-news-paper' => 'news-paper' ), array('pe-7s-musiclist' => 'musiclist' ), array('pe-7s-music' => 'music' ), array('pe-7s-mouse' => 'mouse' ), array('pe-7s-more' => 'more' ), array('pe-7s-moon' => 'moon' ), array('pe-7s-monitor' => 'monitor' ), array('pe-7s-micro' => 'micro' ), array('pe-7s-menu' => 'menu' ), array('pe-7s-map' => 'map' ), array('pe-7s-map-marker' => 'map-marker' ), array('pe-7s-mail' => 'mail' ), array('pe-7s-mail-open' => 'mail-open' ), array('pe-7s-mail-open-file' => 'mail-open-file' ), array('pe-7s-magnet' => 'magnet' ), array('pe-7s-loop' => 'loop' ), array('pe-7s-look' => 'look' ), array('pe-7s-lock' => 'lock' ), array('pe-7s-lintern' => 'lintern' ), array('pe-7s-link' => 'link' ), array('pe-7s-like' => 'like' ), array('pe-7s-light' => 'light' ), array('pe-7s-less' => 'less' ), array('pe-7s-keypad' => 'keypad' ), array('pe-7s-junk' => 'junk' ), array('pe-7s-info' => 'info' ), array('pe-7s-home' => 'home' ), array('pe-7s-help2' => 'help2' ), array('pe-7s-help1' => 'help1' ), array('pe-7s-graph3' => 'graph3' ), array('pe-7s-graph2' => 'graph2' ), array('pe-7s-graph1' => 'graph1' ), array('pe-7s-graph' => 'graph' ), array('pe-7s-global' => 'global' ), array('pe-7s-gleam' => 'gleam' ), array('pe-7s-glasses' => 'glasses' ), array('pe-7s-gift' => 'gift' ), array('pe-7s-folder' => 'folder' ), array('pe-7s-flag' => 'flag' ), array('pe-7s-filter' => 'filter' ), array('pe-7s-file' => 'file' ), array('pe-7s-expand1' => 'expand1' ), array('pe-7s-exapnd2' => 'exapnd2' ), array('pe-7s-edit' => 'edit' ), array('pe-7s-drop' => 'drop' ), array('pe-7s-drawer' => 'drawer' ), array('pe-7s-download' => 'download' ), array('pe-7s-display2' => 'display2' ), array('pe-7s-display1' => 'display1' ), array('pe-7s-diskette' => 'diskette' ), array('pe-7s-date' => 'date' ), array('pe-7s-cup' => 'cup' ), array('pe-7s-culture' => 'culture' ), array('pe-7s-crop' => 'crop' ), array('pe-7s-credit' => 'credit' ), array('pe-7s-copy-file' => 'copy-file' ), array('pe-7s-config' => 'config' ), array('pe-7s-compass' => 'compass' ), array('pe-7s-comment' => 'comment' ), array('pe-7s-coffee' => 'coffee' ), array('pe-7s-cloud' => 'cloud' ), array('pe-7s-clock' => 'clock' ), array('pe-7s-check' => 'check' ), array('pe-7s-chat' => 'chat' ), array('pe-7s-cart' => 'cart' ), array('pe-7s-camera' => 'camera' ), array('pe-7s-call' => 'call' ), array('pe-7s-calculator' => 'calculator' ), array('pe-7s-browser' => 'browser' ), array('pe-7s-box2' => 'box2' ), array('pe-7s-box1' => 'box1' ), array('pe-7s-bookmarks' => 'bookmarks' ), array('pe-7s-bicycle' => 'bicycle' ), array('pe-7s-bell' => 'bell' ), array('pe-7s-battery' => 'battery' ), array('pe-7s-ball' => 'ball' ), array('pe-7s-back' => 'back' ), array('pe-7s-attention' => 'attention' ), array('pe-7s-anchor' => 'anchor' ), array('pe-7s-albums' => 'albums' ), array('pe-7s-alarm' => 'alarm' ), array('pe-7s-airplay' => 'airplay' ),  );

  return array_merge( $icons, $pixden );
}

add_filter( 'vc_iconpicker-type-perch', 'investment_iconpicker_type_perch' );

function investment_iconpicker_type_perch( $icons ){
  $pixden = array( 
    array('perch perch-Inbox' => 'Inbox' ), 
    array('perch perch-Folder' => 'Folder' ),   
    array('perch perch-integrity' => 'integrity' ),   
    array('perch perch-Keyboard' => 'Keyboard' ),   
    array('perch perch-Message' => 'Message' ),   
    array('perch perch-middle-market' => 'Middle market' ),   
    array('perch perch-operator-first' => 'Operator-first' ),   
    array('perch perch-Phone2' => 'Phone2' ),   
    array('perch perch-Plaine' => 'Plaine' ),   
    array('perch perch-Printer' => 'Printer' ),   
    array('perch perch-Search' => 'Search' ),   
    array('perch perch-strategy' => 'strategy' ),   
    array('perch perch-User' => 'User' ),   
    array('perch perch-value' => 'value' ),   
  );

  return array_merge( $icons, $pixden );
}

function investment_vc_icontype_dropdown( $name = 'icon_type', $value = array(
                'Perch'  => 'perch',
                'Pixden'  => 'pixden',
                'Linecons' => 'linecons',
                'Entypo' => 'entypo',
                'Typicons' => 'typicons',
                'Openiconic' => 'openiconic',
                'Fontawesome' => 'fontawesome',                
              ) ){
  return array(
          'type' => 'dropdown',
          'heading' => __('Icon type', 'investment'),
          'param_name' => $name,
          'description' => '',
          'value' => $value
        );
}

function investment_vc_icon_set( $type, $name = 'icon_pixden', $value= 'pe-7s-diamond', $dependency = '' ){
 
  $arr = array(
          'type' => 'iconpicker',
          'heading' => __( 'Icon', 'investment' ),
          'param_name' => $name,
          'value' => $value,
          'settings' => array(
              'emptyIcon' => false,
              'type' => $type,
              'iconsPerPage' => 4000,
          ),
          'description' => __( 'Select icon from library.', 'investment' ),

      );

  if( $dependency != '' ){
    $arr['dependency']['element'] = $dependency;
    $arr['dependency']['value'] =  $type;
  }

  return $arr;
}

add_action('init', 'investment_archive_page_id');
function investment_archive_page_id(){
    global  $wpdb;

    $archiveArr = array('portfolio', 'service', 'partner', 'team', 'job');
    foreach ($archiveArr as $key => $value) {
       $default = (get_post_status(get_option($value.'_archive_id')) == 'publish')? get_option($value.'_archive_id') : '';
        $aid = ot_get_option($value.'_archive', $default);
        if( $default != $aid ){
            delete_option($value.'_archive_id');
            add_option($value.'_archive_id', $aid);
            flush_rewrite_rules();
        }
    }

   

}

add_filter('revslider_mod_default_css_handles', 'investment_revslider_mod_default_css_handles', 10, 1);

function investment_revslider_mod_default_css_handles($defaults){
  $defaults['.tp-caption.investment-subtitle-style1'] = '5.0';
  $defaults['.tp-caption.investment-subtitle-style2'] = '5.0';
  $defaults['.tp-caption.investment-title-style1'] = '5.0';
  $defaults['.tp-caption.investment-title-style2'] = '5.0';

  return $defaults;
}

function investment_wpml_lang_select_option(){

  $display = ot_get_option( 'header_language_dropdown', 'on' );
  if( $display != 'on' ) return false;

  if( function_exists('icl_disp_language') ): 
    $languages = icl_get_languages('skip_missing=0&orderby=code');
    if(!empty($languages)){
      $activeflag = investment_wpml_custom_flags();
        echo '<li id="language_list" class="dropdown"><a href="#" class="dropdown-toggle" data-bs-toggle="dropdown"><img src="'.$activeflag['country_flag_url'].'"><span class="caret"></span></a><ul class="dropdown-menu">';
        foreach($languages as $l){
            echo '<li>';
            if($l['country_flag_url']){
                if(!$l['active']) echo '<a href="'.$l['url'].'">';
                echo '<img src="'.$l['country_flag_url'].'" height="12" alt="'.$l['language_code'].'" width="18" />';
                if(!$l['active']) echo '</a>';
            }
            if(!$l['active']) echo '<a href="'.$l['url'].'">';
            echo icl_disp_language($l['native_name'], $l['translated_name']);
            if(!$l['active']) echo '</a>';
            echo '</li>';
        }
        echo '</ul></li>';
    }
    endif;

    if( function_exists('pll_the_languages') ):
      $args = array(
        'current_lang' => true,
        'raw' => 1
        );
      $current_lang = pll_the_languages($args);
      $current_lang = array_filter($current_lang, function($ar) {
         return ($ar['current_lang'] == 1);
      });
      echo '<li  id="language_list" class="dropdown">'; 
        
        foreach ($current_lang as $key => $value) {
          if( is_array($value) && array_key_exists('current_lang', $value) ){
            echo '<a href="#" class="dropdown-toggle" data-bs-toggle="dropdown">';
            echo '<img src="'.esc_url($value['flag']).'" height="12" alt="'.esc_attr($value['locale']).'" width="18" />';
            echo '<span class="caret"></span></a>';
            break;
          }
        }        
        
        $args = array(
            'dropdown' => 0,
            'echo' => 1,
            'show_flags' => 1,
          );
        echo '<ul class="dropdown-menu">';
        pll_the_languages($args);
        echo '</ul>';
      echo '</li>';
    endif;

    if( function_exists( 'mltlngg_get_switcher_block' ) ):
    global $mltlngg_current_language, $mltlngg_enabled_languages;
    echo '<li  id="language_list" class="dropdown">'; 
   
      echo '<a href="#" class="dropdown-toggle" data-bs-toggle="dropdown">';
      echo '<img class="mltlngg-lang" src="' . plugins_url( 'multilanguage/images/flags/' , '' ) . $mltlngg_current_language . '.png" alt="' . $mltlngg_current_language . '">';
      echo '<span class="caret"></span></a>';
      echo '<ul class="dropdown-menu">';
      echo '<form name="mltlngg_change_language" method="post" action="">';
      foreach ( $mltlngg_enabled_languages as $item ) {
        $flag = ( empty( $item['flag'] ) ) ? plugins_url( 'multilanguage/images/flags/' , '' ) . $item['locale'] . '.png' : $item['flag'];        
        echo '<li><button class="mltlngg-lang-button-icons" name="mltlngg_change_display_lang" value="' . $item['locale'] . '" title="' . $item['name'] . '"><img class="mltlngg-lang" src="' . $flag . '" alt="' . $item['name'] . '"> ' . $item['name'] .
              '</button></li>';
      }
      echo '</form>';
      echo '</ul>';
    echo '</li>';
    endif;  

}

function investment_wpml_custom_flags( ) {
   
    $languages = icl_get_languages('skip_missing=1');
    $curr_lang = array();
    if( !empty( $languages ) ) {
         
        foreach( $languages as $language ) {
            if( !empty( $language['active'] ) ) {
                $curr_lang = $language; // This will contain current language info.
                break;
            }
        }
    }
 
    return $curr_lang;
}

function investment_menu_search_icon($class=''){
  $sticky_display = ot_get_option( 'sticky_search_display', 'off' );
   return '<span class="sticky-'.$sticky_display.' '.$class.'"><a class="icon-link search-icon" href="#" id="off-search" data-bs-toggle="offcanvas" data-bs-target="#offcanvassearch"><i class="perch perch-Search"></i></a></span>';
  
}

if(function_exists('vc_set_as_theme')):
include __DIR__. '/vc-extends.php';
endif;

function investment_megamenu_add_theme_default_1508180866($themes) {
    $themes["investment"] = array(
        'title' => 'Investment Expert',
        'container_background_from' => 'rgba(255, 255, 255, 0)',
        'container_background_to' => 'rgba(255, 255, 255, 0)',
        'arrow_up' => 'disabled',
        'arrow_down' => 'disabled',
        'arrow_left' => 'dash-f345',
        'arrow_right' => 'dash-f341',
        'menu_item_align' => 'right',
        'menu_item_background_hover_from' => 'rgba(255, 255, 255, 0)',
        'menu_item_background_hover_to' => 'rgba(255, 255, 255, 0)',
        'menu_item_link_font_size' => '16px',
        'menu_item_link_height' => '73px',
        'menu_item_link_color' => 'rgba(255, 255, 255, 0)',
        'menu_item_link_weight' => 'bold',
        'menu_item_link_text_align' => 'right',
        'menu_item_link_weight_hover' => 'bold',
        'menu_item_highlight_current' => 'off',
        'panel_background_from' => 'rgb(255, 255, 255)',
        'panel_background_to' => 'rgb(255, 255, 255)',
        'panel_header_color' => 'rgb(32, 48, 79)',
        'panel_header_padding_bottom' => '15px',
        'panel_header_border_color' => 'rgb(110, 110, 110)',
        'panel_padding_left' => '30px',
        'panel_padding_right' => '30px',
        'panel_padding_top' => '30px',
        'panel_padding_bottom' => '30px',
        'panel_widget_padding_left' => '0',
        'panel_widget_padding_right' => '0',
        'panel_widget_padding_top' => '0',
        'panel_widget_padding_bottom' => '0',
        'panel_font_size' => '14px',
        'panel_font_color' => 'rgb(110, 110, 110)',
        'panel_font_family' => 'inherit',
        'panel_second_level_font_color' => 'rgb(32, 48, 79)',
        'panel_second_level_font_color_hover' => 'rgb(243, 82, 90)',
        'panel_second_level_text_transform' => 'uppercase',
        'panel_second_level_font' => 'inherit',
        'panel_second_level_font_size' => '16px',
        'panel_second_level_font_weight' => 'bold',
        'panel_second_level_font_weight_hover' => 'bold',
        'panel_second_level_text_decoration' => 'none',
        'panel_second_level_text_decoration_hover' => 'none',
        'panel_second_level_padding_bottom' => '0',
        'panel_second_level_margin_top' => '10px',
        'panel_second_level_margin_bottom' => '10px',
        'panel_second_level_border_color' => '#555',
        'panel_third_level_font_color' => '#666',
        'panel_third_level_font_color_hover' => '#666',
        'panel_third_level_font' => 'inherit',
        'panel_third_level_font_size' => '14px',
        'flyout_width' => '220px',
        'flyout_menu_background_from' => 'rgb(255, 255, 255)',
        'flyout_menu_background_to' => 'rgb(255, 255, 255)',
        'flyout_padding_top' => '0',
        'flyout_padding_right' => '0',
        'flyout_padding_bottom' => '0',
        'flyout_padding_left' => '0',
        'flyout_link_padding_left' => '15px',
        'flyout_link_padding_right' => '15px',
        'flyout_link_padding_top' => '15px',
        'flyout_link_padding_bottom' => '15px',
        'flyout_link_weight' => 'bold',
        'flyout_link_weight_hover' => 'bold',
        'flyout_background_from' => 'rgb(255, 255, 255)',
        'flyout_background_to' => 'rgb(255, 255, 255)',
        'flyout_background_hover_from' => 'rgb(245, 245, 245)',
        'flyout_background_hover_to' => 'rgb(245, 245, 245)',
        'flyout_link_size' => '16px',
        'flyout_link_color' => '#666',
        'flyout_link_color_hover' => '#666',
        'flyout_link_family' => 'inherit',
        'line_height' => '23px',
        'toggle_background_from' => 'rgb(32, 48, 79)',
        'toggle_background_to' => 'rgb(32, 48, 79)',
        'toggle_font_color' => 'rgba(255, 255, 255, 0)',
        'toggle_bar_height' => '48px',
        'mobile_menu_item_height' => '48px',
        'mobile_background_from' => 'rgb(34, 34, 34)',
        'mobile_background_to' => 'rgb(34, 34, 34)',
        'mobile_menu_item_link_font_size' => '16px',
        'mobile_menu_item_link_color' => '#ffffff',
        'mobile_menu_item_link_text_align' => 'left',
        'custom_css' => '/** Push menu onto new line **/
#{$wrap} {
    clear: both;
}',
    );
    return $themes;
}
add_filter("megamenu_themes", "investment_megamenu_add_theme_default_1508180866");

if( !function_exists('investment_disable_post_type_arr') ):
function investment_disable_post_type_arr(){
    if(function_exists('ot_get_option')){
      return ot_get_option('disable_post_type', array());
    }else{
      return array();
    }
}
endif;

add_filter( 'display_post_states', 'investment_add_display_post_states', 10, 2 );
function investment_add_display_post_states( $post_states, $post ) {
    if ( intval(ot_get_option('team_archive')) === $post->ID ) {
      $post_states[] = __( 'Team Page', 'investment' );
    }
    if ( intval(ot_get_option('service_archive')) === $post->ID ) {
      $post_states[] = __( 'Services Page', 'investment' );
    }
    if ( intval(ot_get_option('portfolio_archive')) === $post->ID ) {
      $post_states[] = __( 'Portfolio Page', 'investment' );
    }
    if ( intval(ot_get_option('partner_archive')) === $post->ID ) {
      $post_states[] = __( 'Partner Page', 'investment' );
    }
    if ( intval(ot_get_option('job_archive')) === $post->ID ) {
      $post_states[] = __( 'Career Page', 'investment' );
    }

    return $post_states;
}

/**
* Post content serch replace 
* @param $content string
* @param $search string
* @param $replace string
*
* @return filtered string
*/
function investment_content_search_replace_content($content, $search, $replace){
    $encode_search =  urlencode( $search);
    $encode_replace =  urlencode( $replace);
    $json_search =  json_encode( $search);
    $json_replace =  json_encode( $replace);

    $total_founds = substr_count($content, $search);
    $total_founds += substr_count($content, $encode_search);
    $total_founds += substr_count($content, $json_search);

    if( $total_founds > 0 ):
      // Search
      $content = str_replace($search, $replace, $content);
      $content = str_replace($encode_search, $encode_replace, $content);
      $content = str_replace($json_search, $json_replace, $content);
    endif;
    return $content;
}

function investment_set_clean_content_by_post_type( $post_type = 'page', $args = array() ){
    $output = array();
    if( $post_type == '' ) return;
    $default = array(
      'search' => '',
      'replace' => '',
    );
    extract(wp_parse_args($args, $default));
    
    if($search != '' && $replace != ''){
        $post_list = get_posts(array(
            'post_type'   => $post_type,
            'posts_per_page' => -1,
        ));
        
        foreach ( $post_list as $post ) {
            $my_post = array(
              'ID'           => $post->ID,
              'post_content' => investment_content_search_replace_content($post->post_content, $search,  $replace),
            );
            $header_image = get_post_meta( $post->ID, 'header_image', true);
            update_post_meta($post->ID, 'header_image', investment_content_search_replace_content($header_image, $search,  $replace));
            wp_update_post( $my_post );
        }
    }
}

add_action( 'wp_ajax_investment_content_search_replace', 'investment_content_search_replace_callback' );
function investment_content_search_replace_callback(){
  $results = '';
  $ids = $_POST['ids'];
  $search = $_POST['search'];
  $replace = $_POST['replace'];

  if($search == '') wp_die();
  if($replace == '') wp_die();
  if(empty($ids)) wp_die();

  $encode_search =  urlencode( $search);
  $encode_replace =  urlencode( $replace);
  foreach ($ids as $post_id) {
      $post = get_post($post_id);
      $content = $post->post_content;
     

        $my_post = array(
            'ID'           => $post_id,
            'post_content' => investment_content_search_replace_content($content, $search,  $replace),
        );     

      wp_update_post( $my_post );
      $results .= '<p>'.sprintf(esc_attr__( '%s items replace successfully for %s', 'investment' ), $total_founds, $post->post_title).'</p>';
     

  }

 
  echo '<div id="message" class="updated investment-message">';
  echo '<a class="welcome-panel-close" href="#" aria-label="Dismiss the panel">Dismiss</a>';
  echo do_shortcode($results);
  echo '</div>';
  
  
  wp_die();
}

function investment_rec_array_search_replace ($find, $replace, $array){
    if (! is_array($array)) {
        return str_replace($find, $replace, $array);
    }
 
    $newArray = array();
 
    foreach ($array as $key => $value) {
        $newArray[$key] = investment_rec_array_search_replace($find, $replace, $value);
    }
 
    return $newArray;
}

function investment_set_clean_options($args = array()){
    $default = array(
      'search' => '',
      'replace' => '',
    );
    extract(wp_parse_args($args, $default));

    $option_ids = array(
      'widget_media_image',
      //'widget_text',
     // 'widget_perch_about_us'
    );

    foreach ($option_ids as $option_id) {
        $options = get_option($option_id);
        
        if($options){
          $options = investment_rec_array_search_replace($search, $replace, $options);
          update_option($option_id, $options);
        }
    }

}

function investment_get_svg_icon($key, $extra_class=""){
    $icons = [
      'quote' => '<svg version="1.1" class="'.esc_attr($extra_class).'" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
      viewBox="0 0 446 446" xml:space="preserve">   
      <g>
        <g>
          <path d="M109.7,91.08c25.2,0,48.33,10.17,65.12,28.63c17.14,18.84,25.22,43.63,22.74,69.78
            c-3.71,39.23-15.88,71.28-37.2,97.99c-17.29,21.66-37.53,38.34-60.17,49.57c-22.52,11.16-48.08,17.27-75.98,18.16
            c-0.24,0.01-0.48,0.01-0.71,0.01c-0.66,0-1.15-0.03-1.51-0.07c-0.08-0.49-0.15-1.25-0.15-2.36c-0.02-9.98-0.01-20.19,0-29.19
            c0-1.5,0.08-2.47,0.17-3.08c0.6-0.1,1.57-0.21,3.06-0.25c33.95-1.05,64.06-12.79,89.48-34.89c0.54-0.47,1.02-0.93,1.63-1.5
            c0.32-0.3,0.7-0.66,1.17-1.1c2.69-2.5,3.58-6.38,2.27-9.81c-1.31-3.43-4.58-5.71-8.25-5.77c-12.4-0.21-23.4-2.23-33.62-6.15
            c-17.42-6.69-32.7-19.62-43.03-36.41c-10.3-16.74-14.77-35.83-12.57-53.74c2.55-20.77,11.2-39.32,25.03-53.64
            C60.91,103,78.55,94.2,98.18,91.79C102.02,91.32,105.89,91.08,109.7,91.08 M109.7,82.08c-4.14,0-8.35,0.25-12.61,0.78
            c-44.23,5.43-78.19,40.62-83.87,86.93c-5.06,41.23,21.52,84.37,61.31,99.65c11.53,4.43,23.48,6.52,36.69,6.75
            c-1.33,1.24-1.94,1.84-2.57,2.39c-24.05,20.91-52.05,31.7-83.85,32.68c-9.37,0.29-11.94,2.82-11.95,12.32
            c-0.01,9.74-0.02,19.48,0,29.22c0.02,8.21,2.83,11.42,10.66,11.42c0.32,0,0.65-0.01,1-0.02c58.49-1.85,106.39-25.35,142.9-71.11
            c23.91-29.96,35.51-64.6,39.12-102.76C212.13,131.1,167.22,82.08,109.7,82.08L109.7,82.08z"/>
        </g>
        <g>
          <path d="M336.38,90.78c24.27,0,47.83,10.58,64.64,29.02c8.27,9.08,14.5,19.5,18.5,30.98
            c4.18,11.99,5.69,24.54,4.51,37.29c-3.72,39.97-15.88,72.41-37.17,99.15c-17.33,21.77-37.63,38.52-60.32,49.79
            c-22.59,11.21-48.24,17.33-76.23,18.19c-0.22,0.01-0.43,0.01-0.63,0.01c-0.62,0-1.09-0.03-1.43-0.07
            c-0.06-0.44-0.12-1.08-0.12-2.01c-0.04-10.51-0.04-20.87-0.01-30.8c0-0.87,0.06-1.47,0.11-1.88c0.44-0.08,1.12-0.15,2.11-0.18
            c35.5-0.84,66.04-13.07,93.35-37.4c2.77-2.47,3.74-6.38,2.45-9.86c-1.29-3.48-4.58-5.8-8.29-5.86c-17.3-0.28-32.18-4.17-45.5-11.9
            c-32.1-18.64-49.39-55.3-43.04-91.22c3.18-18.01,11.71-34.37,24.66-47.31c12.95-12.94,29.31-21.46,47.33-24.63
            C326.28,91.22,331.36,90.78,336.38,90.78C336.38,90.78,336.38,90.78,336.38,90.78 M336.37,81.78c-5.47,0-11.04,0.48-16.65,1.46
            c-40.44,7.12-72.14,38.8-79.29,79.23c-7.02,39.73,11.99,80.02,47.39,100.57c15.06,8.74,31.36,12.82,49.87,13.12
            c-25.68,22.88-54.51,34.34-87.58,35.12c-7.98,0.19-10.99,3.14-11.01,11.02c-0.04,10.29-0.03,20.58,0.01,30.87
            c0.03,7.85,2.92,11.04,10.55,11.04c0.3,0,0.6,0,0.91-0.01c58.71-1.8,106.74-25.41,143.32-71.37
            c24.13-30.32,35.51-65.42,39.09-103.92C438.36,131.06,392.1,81.77,336.37,81.78L336.37,81.78z"/>
        </g>
      </g>
      </svg>'
    ];

    if( !empty($icons[$key]) ) return $icons[$key];
}

function is_color_dark($color){
  $dark_colors = [
    'primary',
    'secondary',
    'secondary-light',
    'success',
    'danger',
    'dark',
  ];

  return in_array($color, $dark_colors);
}

function investment_theme_colors(){
    $theme_colors = array(
      'primary',
      'secondary',
      'secondary-light',
      'success',
      'info',
      'warning',
      'danger',
      'light',
      'dark',
    );

    return $theme_colors;
}

function investment_theme_colors_dropdown(){
  $theme_colors = investment_theme_colors();
  if(empty($theme_colors)) return;

  $choices = [];
  foreach($theme_colors as $color){
    $choices[] = array(
        'value'       => $color,
        'label'       => ucwords(str_replace('-', ' ', $color))
    );
  }

  return $choices;
}

if ( ! function_exists( 'investment_get_demo_layouts' ) ) {
  function investment_get_demo_layouts(){
    $active_layout = '';
    $layouts = [
      'active_layout' => ''
    ];
    $count = 1;
    foreach( glob( INVESTMENT_DIR . '/admin/demo-data/theme-options/*.txt' ) as $file ){
      $layout_name = str_replace('.txt', '', basename($file));
      if( $count == 1 ) $active_layout = $layout_name;
      ob_start();
      include $file;
      $layouts[$layout_name] = ob_get_clean();
      $count++;
    }
    $layouts['active_layout'] = $active_layout;

    return ot_encode($layouts);
  }
}

function investment_import_layouts( $layouts = '', $active_layout = false) {

  // Previous layouts value.
  $option_tree_layouts = get_option( ot_layouts_id() );

  // New layouts value.
  $rebuild = ot_decode($layouts);
  $layouts = ot_decode($layouts);

  // Validate layouts.
  if ( is_array( $layouts ) && ! empty( $layouts ) ) {

    // Setup active layout.
    if ( isset( $layouts['active_layout'] ) && ! empty( $layouts['active_layout'] && $active_layout) ) {
      $active_layout = ! empty($active_layout) ? $active_layout : $layouts['active_layout'];
      $rebuild['active_layout'] = $active_layout;
    }

    $first_layout = '';

    if( is_array($option_tree_layouts) && ! empty($option_tree_layouts) ){
      foreach($option_tree_layouts as $key => $layout){
        if( ! isset($layouts[$key]) ){
          $layouts[$key] = $layout;
        }
      }
    }

    // Loop through layouts.
    foreach ( $layouts as $key => $layout ) {

      // Skip over active layout key.
      if ( 'active_layout' === $key ) {
        continue;
      }

      // Check if the key exists then set value.
      if ( isset( $option_tree_layouts[ $key ] ) && ! empty( $option_tree_layouts[ $key ] ) ) {
        $rebuild[ $key ] = $option_tree_layouts[ $key ];
        if ( '' === $first_layout ) {
          $first_layout = $key;
        }
      }
    }

    if ( isset( $rebuild['active_layout'] ) && ! isset( $rebuild[ $rebuild['active_layout'] ] ) && ! empty( $first_layout ) ) {
      $rebuild['active_layout'] = $first_layout;
    }
  }

  // Default message.
  $message = 'Layouts import failed.';

  // Save & show success message.
  if ( is_array( $rebuild ) && 1 < count( $rebuild ) ) {
    if( $active_layout  && ! empty($active_layout)){
      $rebuild['active_layout'] = $active_layout;
    }
    $options = ot_decode( $rebuild[ $rebuild['active_layout'] ] );

    if ( $options ) {

      $options_safe = array();

      // Get settings array.
      $settings = get_option( ot_settings_id() );

      // Has options.
      if ( is_array( $options ) ) {

        // Validate options.
        if ( is_array( $settings ) ) {
          foreach ( $settings['settings'] as $setting ) {
            if ( isset( $options[ $setting['id'] ] ) ) {
              $options_safe[ $setting['id'] ] = ot_validate_setting( wp_unslash( $options[ $setting['id'] ] ), $setting['type'], $setting['id'] );
            }
          }
        }

        update_option( ot_options_id(), $options_safe );
      }
    }

    // Rebuild the layouts.
    update_option( ot_layouts_id(), $rebuild );

    // Change message.
    $message = 'Layouts imported successfully.';
  } elseif ( 1 >= count( $rebuild ) ) {

    // Delete layouts option.
    delete_option( ot_layouts_id() );

    // Change message.
    $message = 'Layouts deleted.';
  }

return $message;
}