<?php
/**
 * Lightens/darkens a given colour (hex format), returning the altered colour in hex format.7
 * @param str $hex Colour as hexadecimal (with or without hash);
 * @percent float $percent Decimal ( 0.2 = lighten by 20%(), -0.4 = darken by 40%() )
 * @return str Lightened/Darkend colour as hexadecimal (with hash);
 */
function investment_color_luminance( $hex, $percent ) {
	
	// validate hex string
	
	$hex = preg_replace( '/[^0-9a-f]/i', '', $hex );
	$new_hex = '#';
	
	if ( strlen( $hex ) < 6 ) {
		$hex = $hex[0] + $hex[0] + $hex[1] + $hex[1] + $hex[2] + $hex[2];
	}
	
	// convert to decimal and change luminosity
	for ($i = 0; $i < 3; $i++) {
		$dec = hexdec( substr( $hex, $i*2, 2 ) );
		$dec = (int)min( max( 0, $dec + $dec * $percent ), 255 ); 
		$new_hex .= str_pad( dechex( $dec ) , 2, 0, STR_PAD_LEFT );
	}		
	
	return $new_hex;
}

add_action( 'wp_enqueue_scripts', function(){
	// if(!class_exists('RevSliderFront')) return;

	$enable_slider_height = ot_get_option('enable_slider_resize_control', 'on');
	if($enable_slider_height == 'on'){
		// remove_action('wp_print_footer_scripts', array('RevSliderFront', 'add_inline_js'), 100);
		// add_action('wp_print_footer_scripts', 'investment_layout_size_inline_js');
	}
});

function investment_layout_size_inline_js(){
	global $rs_js_collection;	
		
	if(empty($rs_js_collection)) return true;
	if(empty($rs_js_collection['revapi'])) return true;	

	$default_height = ot_get_option('header_slider_height', '470');
	$tra_header_height = ot_get_option('transparent_header_slider_height', '630');

	$slider_height = in_array('frontpage-transparent-header', get_body_class())? intval($tra_header_height) : intval($default_height);

	echo '<script id="rs-initialisation-scripts">'."\n";
	echo RS_T2.'var	tpj = jQuery;'."\n\n";
	echo RS_T2.'var	'.implode(',', $rs_js_collection['revapi']) . ';'."\n";
	if(!empty($rs_js_collection['js'])){
		foreach($rs_js_collection['js'] as $key => $script){
				
			$script = str_replace('visibilityLevels:"1240', 'visibilityLevels:"1400,1240', $script);
			$script = str_replace('responsiveLevels:"1240', 'responsiveLevels:"1400,1240', $script);
			$script = str_replace('gridwidth:"', 'gridwidth:"1290,', $script);
			$script = str_replace('gridheight:"', 'gridheight:"'.$slider_height.',', $script);
			$rs_js_collection['js'][$key] = $script;
		}
		echo "\n" . implode("\n", $rs_js_collection['js']);
	}
	if(!empty($rs_js_collection['minimal'])){
		echo "\n" . $rs_js_collection['minimal'];
	}
	
	echo RS_T.'</script>'."\n";	
}
