<?php
/**
 * Initialize the meta boxes. 
 */
add_action( 'admin_init', 'investment_general_meta_boxes' );
if( !function_exists('investment_general_meta_boxes') ):
function investment_general_meta_boxes() {
    $screen = get_current_screen();

   
  $my_meta_box = array(
    'id'        => 'investment_settings_box',
    'title'     => __( 'Investment settings', 'investment' ),
    'desc'      => '',
    'pages'     => array( 'page' ),
    'context'   => 'normal',
    'priority'  => 'high',
    'fields'    => array(  
        array(
        'id'          => 'title_settings',
        'label'       => __( 'Header settings', 'investment' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'tab',
        'class'       => '',
      ),     
      array(
        'id'          => 'title_display',
        'label'       => __( 'Title display', 'investment' ),
        'desc'        => __( 'Title off only work for page.', 'investment' ),
        'std'         => 'on',
        'type'        => 'on-off',
        'class'       => '',
        'choices'     => array()
      ),
      array(
        'id'          => 'title',
        'label'       => __( 'Title', 'investment' ),
        'desc'        => __( 'Leave blank to show the main title.', 'investment' ),
        'std'         => '',
        'type'        => 'text',
        'class'       => '',
        'condition'   => 'title_display:is(on)',
        'choices'     => array()
      ),
      
    )
  );
    

    if ( investment_get_current_post_type() == 'page' ) {
        $page_metaboxes =    array(
         
          array(
            'id'          => 'header_image',
            'label'       => __( 'Header image', 'investment' ),
            'desc'        => '',
            'std'         => INVESTMENT_ASSETS.'/images/home-banner-bg.jpg',
            'type'        => 'upload',
            'class'       => '',
            'condition'   => 'title_display:is(on)',
          ), 
          array(
            'id'          => 'shortcode',
            'label'       => __( 'Shortcode', 'investment' ),
            'desc'        => __( 'Use shortcode here', 'investment' ),
            'std'         => '',
            'type'        => 'text',
            'class'       => '',
            'condition'   => 'title_display:is(off)',
          ),
          array(
            'id'          => 'content_type',
            'label'       => __( 'Content area spacing', 'investment' ),
            'desc'        => '',
            'std'         => 'normal',
            'type'        => 'select',
            'class'       => '',
            'choices'     => array(
                    array(
                        'label' => __( 'Default', 'investment' ),
                        'value' => 'normal'
                    ), 
                    array(
                        'label' => __( 'Top spacing only', 'investment' ),
                        'value' => 'top-spacing-only'
                    ), 
                    array(
                        'label' => __( 'Bottom spacing only', 'investment' ),
                        'value' => 'bottom-spacing-only'
                    ), 
                    array(
                        'label' => __( 'No spacing in top and bottom', 'investment' ),
                        'value' => 'no-spacing'
                    ),                                      
                    array(
                        'label' => __( 'Custom spacing', 'investment' ),
                        'value' => 'custom_spacing'
                    )
                )
          ),
          array(
            'id'          => 'spacing',
            'label'       => __( 'Custom spacing', 'investment' ),
            'desc'        => __( 'Custom spacing applied on content holder', 'investment' ),
            'std'         => array(
                    'top'       => 70,
                    'bottom'    => 0,
                    'left'      => 0,
                    'right'     => 0,
                    'unit'      => 'px'
                ),
            'type'        => 'spacing',
            'class'       => '',
            'condition'   => 'content_type:is(custom_spacing)',
        ), 

        array(
        'id'          => 'page_layout',
        'label'       => __( 'Default layout', 'investment' ),
        'desc'        => '',
        'std'         => 'full',
        'type'        => 'radio-image',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and',
        'choices'     => array( 
          array(
            'value'       => 'full',
            'label'       => __( 'Full width', 'investment' ),
            'src'         => OT_URL . '/assets/images/layout/full-width.png'
          ),
          array(
            'value'       => 'ls',
            'label'       => __( 'Left sidebar', 'investment' ),
            'src'         => OT_URL . '/assets/images/layout/left-sidebar.png'
          ),
          array(
            'value'       => 'rs',
            'label'       => __( 'Right sidebar', 'investment' ),
            'src'         => OT_URL . '/assets/images/layout/right-sidebar.png'
          ),
        )
      ),
      array(
        'id'          => 'sidebar',
        'label'       => __( 'Select sidebar', 'investment' ),
        'desc'        => '',
        'std'         => 'sidebar-1',
        'type'        => 'sidebar-select',
        'class'       => '',
        'choices'     => array(),
        'operator'    => 'and',
        'condition'   => 'page_layout:not(full)'
      ),
      array(
        'id'          => 'force_transparent_header',
        'label'       => __( 'Force page transparent header', 'investment' ),
        'std'         => 'off',
        'type'        => 'on-off',
        'class'       => '',
      ),
     );

        $my_meta_box['fields'] = array_merge($my_meta_box['fields'], $page_metaboxes);
    }


  
    ot_register_meta_box( $my_meta_box );



    $my_meta_box = array(
    'id'        => 'investment_settings_box',
    'title'     => __('Investment Portfolio settings', 'investment'),
    'desc'      => '',
    'pages'     => array( 'portfolio' ),
    'context'   => 'normal',
    'priority'  => 'high',
    'fields'    => array(  
         array(
            'id'          => 'title_settings',
            'label'       => __( 'Header settings', 'investment'),
            'desc'        => '',
            'std'         => '',
            'type'        => 'tab',
            'class'       => '',
          ),     
          array(
            'id'          => 'title_display',
            'label'       => __( 'Title display', 'investment'),
            'desc'        => __( 'Title off only work for page.', 'investment'),
            'std'         => 'on',
            'type'        => 'on-off',
            'class'       => '',
            'choices'     => array()
          ),
          array(
            'id'          => 'title',
            'label'       => __( 'Title', 'investment'),
            'desc'        => __( 'Leave blank to show the main title.', 'investment'),
            'std'         => '',
            'type'        => 'text',
            'class'       => '',
            'condition'   => 'title_display:is(on)',
            'choices'     => array()
          ),
        array(
            'id'          => 'custom_link',
            'label'       => __( 'Custom link', 'investment'),
            'desc'        => __( 'Leave blank to avoid custom link.', 'investment'),
            'std'         => '',
            'type'        => 'text',
            'class'       => '',
            'choices'     => array()
          ),
          array(
            'id'          => 'company_settings',
            'label'       => __( 'Partners Information', 'investment'),
            'desc'        => '',
            'type'        => 'tab',
          ), 
          array(
            'id'          => 'company_logo',
            'label'       => __( 'Company Logo', 'investment'),
            'std'         => '',
            'type'        => 'upload',
            'desc'        => __( 'Display on portfolio archive.', 'investment').' <br>Examplae: '.INVESTMENT_ASSETS.'/images/portfolio-logo-1.png . '
          ),
          array(
            'id'          => 'related_partner',
            'label'       => __( 'Related partner', 'investment'),
            'std'         => '',
            'type'        => 'custom-post-type-select',
            'rows'        => '',
            'post_type'   => 'partner',
          ),          
          array(
            'id'          => 'portfolio_settings',
            'label'       => __( 'Portfolio Informations', 'investment'),
            'desc'        => '',
            'type'        => 'tab',
          ),
          array(
            'id'          => 'portfolio_info',
            'label'       => __( 'Portfolio Informations', 'investment'),
            'std'        => array(
                    array(
                            'title' => __( 'Investment:', 'investment'),
                            'desc' => __( '1.3M', 'investment'),
                        ),
                    array(
                            'title' => __( 'Our Share:', 'investment'),
                            'desc' => __( '18.3%', 'investment'),
                        ),
                    array(
                            'title' => __( 'Status:', 'investment'),
                            'desc' => __( 'Tecnology', 'investment'),
                        ),
                    array(
                            'title' => __( 'Date:', 'investment'),
                            'desc' => __( '09-24-2016', 'investment'),
                        ),
                    array(
                            'title' => __( 'Sector:', 'investment'),
                            'desc' => __( 'Unreized/UPF', 'investment'),
                        ),
                    array(
                            'title' => __( 'Address:', 'investment'),
                            'desc' => __( '125 Street, USA', 'investment'),
                        ),
                ),
            'type'        => 'list-item',
            'settings'    => array(
                    array(
                        'id'          => 'desc',
                        'label'       => 'Short description',
                        'type'        => 'text',
                      ),
                ),  
          ),
          array(
            'id'          => 'portfolio_downloads',
            'label'       => __( 'Downloads link', 'investment'),
            'std'        => array(
                    array(
                            'title' => __( 'Download Company Brochures', 'investment'),
                            'url' => '#'
                        ),
                    
                ),
            'type'        => 'list-item',
            'settings'    => array(
                    array(
                        'id'          => 'url',
                        'label'       => __( 'Download URL', 'investment'),
                        'type'        => 'upload',
                      ),
                ),  
          ),
          array(
            'id'          => 'portfolio_testimonials_tabs',
            'label'       => __( 'Portfolio Testimonials', 'investment'),
            'desc'        => '',
            'type'        => 'tab',
          ),
          array(
            'id'          => 'portfolio_testimonials',
            'label'       => __( 'Testimonials', 'investment'),
            'std'        => array(
                    array(
                            'title' => 'Alexa Von Tobel',
                            'subtitle' => 'CEO Finance Consult Manager',
                            'image' => INVESTMENT_ASSETS.'/images/photo-man.png',
                            'desc' => '“There are two things I look for in a financial adviser. Firstly, a thorough, up to date knowledge of all aspects of government rules and regulations pertaining to superannuation and investments. '
                        ),
                    
                ),
            'type'        => 'list-item',
            'settings'    => array(
                    array(
                        'id'          => 'subtitle',
                        'label'       => __( 'Subtitle', 'investment'),
                        'type'        => 'text',
                        'desc'        => __( 'Example: CEO Finance Consult Manager', 'investment'),
                      ),
                    array(
                        'id'          => 'image',
                        'label'       => __( 'Image', 'investment'),
                        'type'        => 'upload',
                      ),
                    array(
                        'id'          => 'desc',
                        'label'       => __( 'Testimoial details', 'investment'),
                        'type'        => 'textarea',
                        'rows'        => 3
                      ),
                ),  
          ),

        )
    );

      ot_register_meta_box( $my_meta_box );


    $my_meta_box = array(
    'id'        => 'investment_partner_settings_box',
    'title'     => __('Investment Partner settings', 'investment'),
    'desc'      => '',
    'pages'     => array( 'partner' ),
    'context'   => 'normal',
    'priority'  => 'high',
    'fields'    => array(            
          array(
            'id'          => 'company_subtitle',
            'label'       => __( 'Company subtitle', 'investment'),
            'desc'        => __( 'Leave blank to avoid this field. Example: Technology', 'investment'),
            'type'        => 'text',
          ), 
          array(
                'id'          => 'company_social_links_display',
                'label'       => __( 'Company Social link display', 'investment'),
                'std'         => 'on',
                'type'        => 'on-off',
          ),         
          array(
            'id'          => 'company_links',
            'label'       => __( 'Company social links', 'investment'),
            'std'        => array(
                    array(
                            'title' => __( 'Linkdin', 'investment'),
                            'icon_link' => array('icon' => 'fa-linkedin', 'input' => '#')
                        ),
                    array(
                            'title' => __( 'Message', 'investment'),
                            'icon_link' => array('icon' => 'fa-envelope', 'input' => 'mailto:info@themeperch.net')
                        ),
                    array(
                            'title' => __( 'Website', 'investment'),
                            'icon_link' => array('icon' => 'fa-globe', 'input' => '#')
                        ),                   
                ),
            'type'        => 'list-item',
            'condition' => 'company_social_links_display:is(on)',
            'settings'    => array(
                    array(
                        'id'          => 'icon_link',
                        'label'       => 'Icon & link',
                        'type'        => 'iconpicker_input',
                      ),
                ),  
          ),
          array(
            'id'          => 'company_location',
            'label'       => __( 'Company Location', 'investment'),
            'desc'         => __( 'Example: London, UK', 'investment'),
            'type'        => 'text',
          ),
          array(
            'id'          => 'map_icon_link',
            'label'       => __( 'Google map Icon & link', 'investment'),
            'type'        => 'iconpicker_input',
            'std' => array('icon' => 'fa-map-marker', 'input' => '#')
          ),
        )
    );

      ot_register_meta_box( $my_meta_box );

      $my_meta_box = array(
        'id'        => 'investment_team_settings_box',
        'title'     => __('Investment Team settings', 'investment'),
        'desc'      => '',
        'pages'     => array( 'team' ),
        'context'   => 'normal',
        'priority'  => 'high',
        'fields'    => array(  
             array(
                'id'          => 'title_settings',
                'label'       => __( 'Header settings', 'investment'),
                'desc'        => '',
                'std'         => '',
                'type'        => 'tab',
                'class'       => '',
              ), 
              array(
                'id'          => 'surname',
                'label'       => __( 'Surname', 'investment'),
                'std'         => '',
                'type'        => 'text',
              ),    
              array(
                'id'          => 'designation',
                'label'       => __( 'Designation', 'investment'),
                'std'         => '',
                'type'        => 'text',
                'desc'        => __( 'Example: CEo & Finance Manager ', 'investment'),
              ),
              array(
                'id'          => 'member_info',
                'label'       => __( 'Team member Information', 'investment'),
                'std'        => array(
                        array(
                                'title' => __( 'Phone number', 'investment'),
                                'linkable' => 'on',
                                'link' => 'tel:+1 888-456-7895',
                                'icon_desc' => array('icon' => 'fa-phone', 'input' => ' +1 888-456-7895')
                            ),
                        array(
                                'title' => __( 'Email Address', 'investment'),
                                'linkable' => 'on',
                                'link' => 'mailto:info@themeperch.net',
                                'icon_desc' => array('icon' => 'fa-envelope', 'input' => 'info@themeperch.net')
                            ),
                        array(
                                'title' => __( 'Address', 'investment'),
                                'linkable' => 'on',
                                'link' => '#',
                                'icon_desc' => array('icon' => 'fa-map-marker', 'input' => '70 W. Madison Street, Ste. 1400 Chicago, IL 60602, United States')
                            ),
                        
                    ),
                'type'        => 'list-item',
                'settings'    => array(
                        array(
                            'id'          => 'linkable',
                            'label'       => __( 'Is this information will be linkable?', 'investment'),
                            'std'         => 'on',
                            'type'        => 'on-off',
                        ),
                        array(
                            'id'          => 'link',
                            'label'       => 'Link',
                            'std'         => '#',
                            'type'        => 'text',
                            'condition' => 'linkable:is(on)'
                          ),
                        array(
                            'id'          => 'icon_desc',
                            'label'       => __( 'Icon & description', 'investment'),
                            'type'        => 'iconpicker_input',
                          ),
                    ),  
              ),
              array(
                'id'          => 'member_social_links_display',
                'label'       => __( 'Member Social link display', 'investment'),
                'std'         => 'on',
                'type'        => 'on-off',
              ),
              array(
                'id'          => 'social_links',
                'label'       => __( 'Team member social links', 'investment'),
                'std'        => array(
                        array(
                                'title' => 'Facebook',
                                'icon_link' => array('icon' => 'fa-facebook', 'input' => '#')
                            ),
                        array(
                                'title' => 'Twitter',
                                'icon_link' => array('icon' => 'fa-twitter', 'input' => '#')
                            ),
                        array(
                                'title' => 'Linkdin',
                                'icon_link' => array('icon' => 'fa-linkedin', 'input' => '#')
                            ),
                        array(
                                'title' => 'Google+',
                                'icon_link' => array('icon' => 'fa-google-plus', 'input' => '#')
                            ),
                        array(
                                'title' => 'Skype',
                                'icon_link' => array('icon' => 'fa-skype', 'input' => '#')
                            ),
                    ),
                'type'        => 'list-item',
                'condition' => 'member_social_links_display:is(on)',
                'settings'    => array(
                        array(
                            'id'          => 'icon_link',
                            'label'       => __( 'Icon & link', 'investment'),
                            'type'        => 'iconpicker_input',
                          ),
                    ),  
              ),
              array(
                'id'          => 'education_training_tab',
                'label'       => __( 'Education & Training', 'investment'),
                'desc'        => '',
                'type'        => 'tab',
              ),
              array(
                'id'          => 'education_training_title',
                'label'       => __( 'Education & Training Title', 'investment'),
                'std'         => 'Education & Training',
                'type'        => 'text',
              ),
              array(
                'id'          => 'education_training',
                'label'       => __( 'Education & Training', 'investment'),
                'std'        => array(
                        array(
                                'title' => 'MBA, London School of Financial Management, London University',
                                'desc' => ''
                            ),
                        array(
                                'title' => 'BS, International Business, Technical University of Edinburg',
                                'desc' => ''
                            ),
                        array(
                                'title' => 'MBA, London School of Financial Management, London University',
                                'desc' => ''
                            ),
                    ),
                'type'        => 'list-item',
                'settings'    => array(
                        array(
                            'id'          => 'desc',
                            'label'       => __( 'Short description', 'investment'),
                            'type'        => 'textarea',
                            'rows' => 2
                          ),
                    ),  
              ),
              array(
                'id'          => 'expertise_tab',
                'label'       => __( 'Areas of Expertise', 'investment'),
                'desc'        => '',
                'type'        => 'tab',
              ),
              array(
                'id'          => 'expertise_title',
                'label'       => __( 'Areas of Expertise Title', 'investment'),
                'std'         => 'Areas of Expertise',
                'type'        => 'text',
              ),
              array(
                'id'          => 'expertise',
                'label'       => __( 'Areas of Expertise', 'investment'),
                'std'        => array(
                        array(
                                'title' => 'Socially Responsible Investing',
                                'desc' => ''
                            ),
                        array(
                                'title' => 'Tax Mitigation Strategies',
                                'desc' => ''
                            ),
                        array(
                                'title' => 'Comprehensive Financial Plans',
                                'desc' => ''
                            ),
                        array(
                                'title' => 'Investment Management',
                                'desc' => ''
                            ),
                    ),
                'type'        => 'list-item',
                'settings'    => array(
                        array(
                            'id'          => 'desc',
                            'label'       => __( 'Short description', 'investment'),
                            'type'        => 'textarea',
                            'rows' => 2
                          ),
                    ),  
              ),
              array(
                'id'          => 'member_contact_form_tab',
                'label'       => __( 'Member contact Form', 'investment'),
                'desc'        => '',
                'type'        => 'tab',
              ),
              array(
                'id'          => 'member_help_display',
                'label'       => __( 'Member Help title', 'investment'),
                'std'         => 'on',
                'type'        => 'on-off',
              ),
              array(
                'id'          => 'member_help_title',
                'label'       => __( 'Member Help title', 'investment'),
                'std'         => __( 'Need Help To Grow Your Business?', 'investment'),
                'type'        => 'text',
                'condition'        => 'member_help_display:is(on)',
              ),
              array(
                'id'          => 'member_help_subtitle',
                'label'       => __( 'Member Help subtitle', 'investment'),
                'std'         => 'Investment Expert will help you start and grow your own company.',
                'type'        => 'text',
                'condition'        => 'member_help_display:is(on)',
              ),
              array(
                'id'          => 'contact_form_title',
                'label'       => __( 'Contact form title', 'investment'),
                'std'         => 'Contact {member_name}',
                'type'        => 'text',
                'description' => '',
              ),
              array(
                'id'          => 'contact_form_subtitle',
                'label'       => __( 'Contact form subtitle', 'investment'),
                'std'         => 'Please take a second and fill out this form as it will give me a better idea of your current investment plan:',
                'type'        => 'text',
              ),
              array(
                'id'          => 'contact_form_email',
                'label'       => __( 'Contact form Reciept email', 'investment'),
                'std'         => 'info@investmentexpert.com',
                'type'        => 'text',
              ),
              array(
                'id'          => 'member_contact_form',
                'label'       => __( 'Contact form', 'investment'),
                'desc'        => '',
                'post_type'   => 'wpcf7_contact_form',
                'std'         => '',
                'type'        => 'custom-post-type-select',
                'class'       => '',   
              ),
              array(
                'id'          => 'member_posts_tab',
                'label'       => __( 'Member Posts', 'investment'),
                'desc'        => '',
                'type'        => 'tab',
              ),
              array(
                'id'          => 'member_posts_title',
                'label'       => __( 'Member post title', 'investment'),
                'std'         => 'Insights',
                'type'        => 'text',
              ),
              array(
                'id'          => 'display_posts',
                'label'       => __( 'Display post', 'investment'),
                'desc'        => '',
                'std'         => 3,
                'type'        => 'numeric-slider',
                'min_max_step'=> '1,20,1',
                'class'       => '',
              ),
              array(
                'id'          => 'ids',
                'label'       => __( 'Post ID,s', 'investment'),
                'desc'        => __( 'You can select post ID.', 'investment'),
                'std'         => '',
                'type'        => 'post-checkbox',
                'post_type'   => 'post,event',
                'operator'    => 'and'
              ),


            )
        );

      ot_register_meta_box( $my_meta_box );

      $my_meta_box = array(
    'id'        => 'investment_job_settings_box',
    'title'     => __('Investment Job settings', 'investment'),
    'desc'      => '',
    'pages'     => array( 'job' ),
    'context'   => 'normal',
    'priority'  => 'high',
    'fields'    => array( 
            array(
                'id'          => 'department',
                'label'       => __( 'Department', 'investment'),
                'type'        => 'text',
                'std'         => 'Customer Support'
            ),
            array(
                'id'          => 'location',
                'label'       => __( 'Location', 'investment'),
                'type'        => 'iconpicker_input',
                'std'         => array('icon' => 'fa-map-marker', 'input' => 'Birmingham, West Midlands')
            ),            
            array(
                'id'          => 'type',
                'label'       => __( 'Job type', 'investment'),
                'type'        => 'iconpicker_input',
                'std'         => array('icon' => 'fa-clock-o', 'input' => 'Permanent, Full-time')
            ),
            array(
                'id'          => 'sallary_info',
                'label'       => __( 'Sallary info', 'investment'),
                'type'        => 'iconpicker_input',
                'std'         => array('icon' => 'fa-money', 'input' => '$25000 - $35000 per annum')
            ),
            array(
                'id'          => 'vacancy',
                'label'       => __( 'Vacancy', 'investment'),
                'type'        => 'iconpicker_input',
                'std'         => array('icon' => 'fa-user', 'input' => '21 Applicantions')
            ),
        )
    );

      ot_register_meta_box( $my_meta_box );

 
}
endif;

add_action( 'portfolio_category_add_form_fields', 'investment_portfolio_category_add_form_fields', 10, 2 );
function investment_portfolio_category_add_form_fields($taxonomy) {   
    ?><div class="form-field term-group">
        <label for="custom-link"><?php _e('Custom Category link', 'investment'); ?></label>
        <input name="custom-link" id="custom-link" value="" size="40" type="text">
        <p>Leave blank to avoid custom link. Default term link will be used.</p>
    </div><?php
}

add_action( 'created_portfolio_category', 'investment_save_portfolio_category_meta', 10, 2 );
function investment_save_portfolio_category_meta( $term_id, $tt_id ){
    if( isset( $_POST['custom-link'] ) && '' !== $_POST['custom-link'] ){
        $link = esc_url( $_POST['custom-link'] );
        add_term_meta( $term_id, 'custom-link', $link, true );
    }
}

add_action( 'portfolio_category_edit_form_fields', 'investment_portfolio_category_edit_form_fields', 10, 2 );

function investment_portfolio_category_edit_form_fields( $term, $taxonomy ){
 
          
    // get current group
    $link = get_term_meta( $term->term_id, 'custom-link', true );
                
    ?><tr class="form-field term-group-wrap">
        <th scope="row"><label for="custom-link"><?php _e('Custom Category link', 'investment'); ?></label></th>
        <td><input name="custom-link" id="custom-link" value="<?php echo esc_url($link) ?>" size="40" type="text">
       </td>
    </tr><?php
}

add_action( 'edited_portfolio_category', 'investment_edited_portfolio_category', 10, 2 );

function investment_edited_portfolio_category( $term_id, $tt_id ){

    if( isset( $_POST['custom-link'] ) && '' !== $_POST['custom-link'] ){
        $link = esc_url( $_POST['custom-link'] );
        update_term_meta( $term_id, 'custom-link', $link );
    }
}