<?php
function investment_background_options( $options = array() ){
	$options = array( 
        array(
             'id' => 'smmoth_scrolling',
            'label' => __( 'Smooth scrolling', 'investment' ),
            'desc' => '',
            'std' => 'off',
            'type' => 'on-off',
            'section' => 'background_options',
        ),
        array(
            'id'          => 'scroliing_speed',
            'label'       => __( 'Scrolling speed', 'investment' ),
            'desc'        => __( 'Number only', 'investment' ),
            'std'         => '500',
            'type'        => 'text',
            'section'     => 'background_options',
            'condition'   => 'smmoth_scrolling:is(on)',
            'operator'    => 'and'
        ),      
		array(
        'id'          => 'container_width',
        'label'       => __( 'Container width', 'investment' ),
        'desc'        =>  __( 'Applied for screen size >= 1200px', 'investment' ),
        'std'         => array('1170', 'px'),
        'type'        => 'measurement',
        'section'     => 'background_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '320,2000,1',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and',
        'action'   => array()
      ),
      array(
        'id'          => 'container_width_lg',
        'label'       => __( 'Container width Large Screen', 'investment' ),
        'desc'        =>  __( 'Applied for screen size >= 1400px', 'investment' ),
        'std'         => array('1320', 'px'),
        'type'        => 'measurement',
        'section'     => 'background_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '320,2000,1',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and',
        'action'   => array()
      ),
       array(
        'id'          => 'background_style',
        'label'       => __( 'Page style', 'investment' ),
        'desc'        => '',
        'std'         => 'width',
        'type'        => 'select',
        'section'     => 'background_options',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and',
        'choices'   => array(
            array(
                'label' => 'Width',
                'value' => 'width' 
                ),
            array(
                'label' => 'Boxed',
                'value' => 'boxed' 
                ),
            )
        ),
       array(
        'id'          => 'top_padding',
        'label'       => __( 'Top offset', 'investment' ),
        'desc'        => __( 'Container top spacing', 'investment' ),
        'std'         => array('0', 'px'),
        'type'        => 'measurement',
        'section'     => 'background_options',
        'condition'   => 'background_style:is(boxed)',
        'operator'    => 'and',
        'action'   => array()
      ),
       array(
        'id'          => 'bottom_padding',
        'label'       => __( 'Bottom offset', 'investment' ),
        'desc'        => __( 'Container bottom spacing', 'investment' ),
        'std'         => array('0', 'px'),
        'type'        => 'measurement',
        'section'     => 'background_options',
        'condition'   => 'background_style:is(boxed)',
        'operator'    => 'and',
        'action'   => array()
      ),
      array(
        'id'          => 'inner_padding',
        'label'       => __( 'Inner space', 'investment' ),
        'desc'        => __( 'Container inner spacing', 'investment' ),
        'std'         => array('30', 'px'),
        'type'        => 'measurement',
        'min_max_step'=> '0,500,1',
        'section'     => 'background_options',
        'condition'   => 'background_style:is(boxed)',
        'operator'    => 'and',
        'action'   => array()
      ),
       array(
        'id'          => 'background_type',
        'label'       => __( 'Background type', 'investment' ),
        'desc'        => '',
        'std'         => 'pattern',
        'type'        => 'select',
        'section'     => 'background_options',
        'class'       => '',
        'condition'   => 'background_style:is(boxed)',
        'operator'    => 'and',
        'choices'   => array(
            array(
                'label' => __('Pattern image', 'investment' ),
                'value' => 'pattern' 
                ),
            array(
                'label' => __('Custom Image', 'investment' ),
                'value' => 'custom_image' 
                ),
            )
        ),

        array(
        'id'          => 'pattern',
        'label'       => __( 'Pattern', 'investment' ),
        'desc'        => '',
        'std'         => '1',
        'type'        => 'radio-image',
        'section'     => 'background_options',
        'class'       => '',
        'condition'   => 'background_style:is(boxed),background_type:is(pattern)',
        'operator'    => 'and',
        'choices'   => array(
            array(
                'label' => 'Pattern1',
                'value' => '1' ,
                'src'  => INVESTMENT_URI.'/assets/images/patterns/1.png'
                ),
            array(
                'label' => 'Pattern2',
                'value' => '2' ,
                'src'  => INVESTMENT_URI.'/assets/images/patterns/2.png'
                ),
            array(
                'label' => 'Pattern3',
                'value' => '3' ,
                'src'  => INVESTMENT_URI.'/assets/images/patterns/3.png'
                ),
            array(
                'label' => 'Pattern4',
                'value' => '4' ,
                'src'  => INVESTMENT_URI.'/assets/images/patterns/4.png'
                ),
            array(
                'label' => 'Pattern5',
                'value' => '5' ,
                'src'  => INVESTMENT_URI.'/assets/images/patterns/5.png'
                ),
            array(
                'label' => 'Pattern6',
                'value' => '6' ,
                'src'  => INVESTMENT_URI.'/assets/images/patterns/6.png'
                ),
            )
      ),
      array(
        'id'          => 'body_background',
        'label'       => __( 'Body background', 'investment' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'background',
        'section'     => 'background_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'background_style:is(boxed),background_type:is(custom_image)',
        'operator'    => 'and',
        'action'   => array()
      ),
      array(
        'id'          => 'main_container_background',
        'label'       => __( 'Main container background', 'investment' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'background',
        'section'     => 'background_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and',
        'action'   => array()
      ),
      array(
        'id'          => 'main_container_spacing',
        'label'       => __( 'Main container Inner spacing', 'investment' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'spacing',
        'section'     => 'background_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'background_style:is(boxed)',
        'operator'    => 'and',
        
      ),
      array(
        'id'          => 'main_container_border',
        'label'       => __( 'Main container Border', 'investment' ),
        'desc'        => '',
        'std'         => array(),
        'type'        => 'border',
        'section'     => 'background_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'background_style:is(boxed)',
        'operator'    => 'and',
        'action'   => array(
                array(
                    'selector' => 'body > .container',
                    'property'   => 'background'
                    )
            )
      ),
    );

	return apply_filters( 'investment_background_options', $options );
}  
?>