<?php
function investment_blog_options( $options = array() ){
	$options = array(
        array(
             'id' => 'post_meta_display',
            'label' => __( 'Post mets display', 'investment' ),
            'desc' => '',
            'std' => 'on',
            'type' => 'on-off',
            'section' => 'blog_options',
            'condition' => '',
            'operator' => 'or' 
        ),
        array(
        'id'          => 'disable_post_meta',
        'label'       => __( 'Disable post meta', 'investment' ),
        'desc'          => __( 'Check to disable post meta','investment' ),
        'type'        => 'checkbox',
        'section'     => 'blog_options',
        'condition' => 'post_meta_display:is(on)',
        'choices'     => array( 
            array(
            'value'       => 'date',
            'label'       => __( 'Post Date', 'investment' ),
            ),
            array(
            'value'       => 'user',
            'label'       => __( 'Post author', 'investment' ),
            ),
            array(
            'value'       => 'category',
            'label'       => __( 'Post category', 'investment' ),
            ),
            array(
            'value'       => 'comment',
            'label'       => __( 'Post comment', 'investment' ),
            ),
        )
    ),
        array(
             'id' => 'blog__tab',
            'label' => __( 'Blog options', 'investment' ),
            'type' => 'tab',
            'section' => 'blog_options',
        ), 
        array(
        'id'          => 'sticky_post_text',
        'label'       => __( 'Sticky post text', 'investment' ),
        'desc'        => '',
        'std'         => __( 'Sticky', 'investment' ),
        'type'        => 'text',
        'section'     => 'blog_options',
        'condition'   => '',
        'operator'    => 'and'
      ),
        array(
            'id'          => 'excerpt_length',
            'label'       => __( 'Excerpt Length', 'investment' ),
            'desc'        => '',
            'std'         => '35',
            'type'        => 'numeric-slider',
            'section'     => 'blog_options',
            'min_max_step'=> '1,150,1',
            'condition'   => 'related_posts:is(on)',
            'operator'    => 'and'
          
        ),
        array(
        'id'          => 'read_more_text',
        'label'       => __( 'Read more text', 'investment' ),
        'desc'        => '',
        'std'         => __( 'Read More', 'investment' ),
        'type'        => 'text',
        'section'     => 'blog_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
        array(
            'id'          => 'next_post_text',
            'label'       => __( 'Next post text', 'investment' ),
            'desc'        => '',
            'std'         => __( 'Next','investment' ),
            'type'        => 'text',
            'section'     => 'blog_options',
        ),
        array(
            'id'          => 'prev_post_text',
            'label'       => __( 'Previous post text', 'investment' ),
            'desc'        => '',
            'std'         => __( 'Previous', 'investment' ),
            'type'        => 'text',
            'section'     => 'blog_options',
        ),        
		array(
        'id'          => 'blog_layout',
        'label'       => __( 'Blog layout', 'investment' ),
        'desc'        => '',
        'std'         => 'rs',
        'type'        => 'radio-image',
        'section'     => 'blog_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and',
        'choices'     => array( 
          array(
            'value'       => 'full',
            'label'       => __( 'Full width', 'investment' ),
            'src'         => OT_URL . '/assets/images/layout/full-width.png'
          ),
          array(
            'value'       => 'ls',
            'label'       => __( 'Left sidebar', 'investment' ),
            'src'         => OT_URL . '/assets/images/layout/left-sidebar.png'
          ),
          array(
            'value'       => 'rs',
            'label'       => __( 'Right sidebar', 'investment' ),
            'src'         => OT_URL . '/assets/images/layout/right-sidebar.png'
          )
        )
      ),
      array(
        'id'          => 'blog_layout_sidebar',
        'label'       => __( 'Blog Sidebar', 'investment' ),
        'desc'        => '',
        'std'         => 'sidebar-1',
        'type'        => 'sidebar-select',
        'section'     => 'blog_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'blog_layout:not(full)',
        'operator'    => 'and'
      ),
      array(
             'id' => 'blog_post__tab',
            'label' => __( 'Single Post options', 'investment' ),
            'type' => 'tab',
            'section' => 'blog_options',
        ), 
      array(
        'id'          => 'single_layout',
        'label'       => __( 'Single post layout', 'investment' ),
        'desc'        => '',
        'std'         => 'rs',
        'type'        => 'radio-image',
        'section'     => 'blog_options',
        'operator'    => 'and',
        'choices'     => array( 
          array(
            'value'       => 'full',
            'label'       => __( 'Full width', 'investment' ),
            'src'         => OT_URL . '/assets/images/layout/full-width.png'
          ),
          array(
            'value'       => 'ls',
            'label'       => __( 'Left sidebar', 'investment' ),
            'src'         => OT_URL . '/assets/images/layout/left-sidebar.png'
          ),
          array(
            'value'       => 'rs',
            'label'       => __( 'Right sidebar', 'investment' ),
            'src'         => OT_URL . '/assets/images/layout/right-sidebar.png'
          )
        )
      ),
      array(
        'id'          => 'single_layout_sidebar',
        'label'       => __( 'Single post Sidebar', 'investment' ),
        'desc'        => '',
        'std'         => 'sidebar-1',
        'type'        => 'sidebar-select',
        'section'     => 'blog_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'single_layout:not(full)',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'single_post_title_tag',
        'label'       => esc_attr__( 'Single post title tag', 'investment' ),
        'std'         => 'h2',
        'type'        => 'select',           
        'section'     => 'blog_options',
        'operator'    => 'and',
        'choices'     => investment_title_tag_std(),

        ),
       array(
        'id'          => 'single_post_title_tag_size',
        'label'       => esc_attr__( 'Single post title tag size', 'investment' ),
        'std'         => 'single-title',
        'type'        => 'select',           
        'section'     => 'blog_options',
        'operator'    => 'and',
        'choices'     => investment_title_tag_size_std(),
        ),
    
       array(
        'id'          => 'blog_options_css',
        'label'       => __( 'CSS', 'investment' ),
        'class'      => 'hide-field',
        'desc'        => '',
        'std'         => '

',
        'type'        => 'css',
        'section'     => 'blog_options',
        'rows'        => '20',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      
    );

	return apply_filters( 'investment_blog_options', $options );
}  
?>