<?php
function investment_footer_options( $options = array() ) {  
    $options = array(
        array(
            'id' => 'footer_widgets__tab',
           'label' => __( 'General options', 'investment' ),
           'type' => 'tab',
           'section' => 'footer_options',
       ),  
       array(
        'id' => 'footer_widget_area',
        'label' => __( 'Display footer widget area','investment' ),
        'desc' => '',
        'std' => 'on',
        'type' => 'on-off',
        'section' => 'footer_options' 
        ),
        
        array(
            'id' => 'footer_widget_area_column',
            'label' => __( 'Footer widget area column', 'investment' ),
            'desc' => '',
            'std' => 4,
            'type' => 'numeric-slider',
            'section' => 'footer_options',
            'min_max_step' => '1,4,1',
            'condition' => 'footer_widget_area:is(on)',
            'operator' => 'and' 
            
        ),
        array(
            'id'          => 'footer_background_style',
            'label'       => __( 'Footer background style', 'investment' ),
            'desc'        => '',
            'std'         => 'theme-color',
            'type'        => 'select',
            'section'     => 'footer_options',
            'choices'     => array( 
              array(
                'value'       => 'theme-color',
                'label'       => __( 'Theme Color', 'investment' ),
              ),
              array(
                'value'       => 'custom',
                'label'       => __( 'Custom background', 'investment' ),
              ),
            ),
            'condition' => 'footer_widget_area:is(on)'
        ),
        array(
            'id'          => 'footer_background_color',
            'label'       => __( 'Footer background color', 'investment' ),
            'desc'        => '',
            'std'         => 'secondary',
            'type'        => 'select',
            'section'     => 'footer_options',
            'choices'     => investment_theme_colors_dropdown(),
            'condition'   => 'footer_widget_area:is(on),footer_background_style:not(custom)',
            'operator'    => 'and',
        ),
        
        array(
            'id'          => 'footer_background',
            'label'       => __( 'Footer background', 'investment' ),
            'desc'        => '',
            'std'         => '',
            'type'        => 'background',
            'section'     => 'footer_options',
            'rows'        => '',
            'post_type'   => '',
            'taxonomy'    => '',
            'min_max_step'=> '',
            'class'       => '',
            'condition'   => 'footer_widget_area:is(on),footer_background_style:is(custom)',
            'operator'    => 'and',
            'action'   => array()
        ),
        array(
            'id' => 'footer_extra_class',
           'label' => __( 'Extra classes', 'investment' ),
           'desc' => __( 'Put your class name. For multiple classes, each class should be separated by space ', 'investment' ),
           'std' => '',
           'type' => 'text',
           'section' => 'footer_options', 
           'condition' => 'footer_widget_area:is(on)'
       ),
        
        array(
            'id' => 'cta__tab',
            'label' => __( 'Footer CTA options', 'investment' ),
            'type' => 'tab',
            'section' => 'footer_options',
        ),
        array(
             'id' => 'lets_work_area',
            'label' => __( 'Let\'s work area Display','investment' ),
            'desc' => __( 'Display before footer area','investment' ),
            'std' => 'on',
            'type' => 'on-off',
            'section' => 'footer_options' 
        ), 
        array(
             'id' => 'lets_work_bg',
            'label' => __( 'Lets work background image', 'investment' ),
            'std' => '',
            'type' => 'upload',
            'section' => 'footer_options',
            'condition' => 'lets_work_area:not(off)',
            'operator' => 'and' 
        ), 
        array(
             'id' => 'lets_work_title',
            'label' => __( 'Lets work title', 'investment' ),
            'desc' => __( 'Use {} to highlight text', 'investment' ),
            'std' => __( 'Make A Difference With {Expert Team}', 'investment' ),
            'type' => 'textarea-simple',
            'rows' => '2',
            'section' => 'footer_options',
            'condition' => 'lets_work_area:not(off)',
            'operator' => 'and' 
        ), 
        array(
            'id' => 'lets_work_title_font_size',
            'label' => 'Title font size',
            'std' => 'display-5',
            'type' => 'select',
            'section' => 'footer_options',
            'condition' => 'lets_work_area:not(off)',
            'choices' => array(
                array(
                    'value' => 'display-1',
                    'label' => __( 'Display1','investment' ),
                ),
                array(
                    'value' => 'display-2',
                    'label' => __( 'Display 2','investment' ),
                ),
                array(
                    'value' => 'display-3',
                    'label' => __( 'Display 3','investment' ),
                ),
                array(
                    'value' => 'display-4',
                    'label' => __( 'Display 4','investment' ),
                ),
                array(
                    'value' => 'display-5',
                    'label' => __( 'Display 5','investment' ),
                ),
                array(
                    'value' => 'display-6',
                    'label' => __( 'Display 6','investment' ),
                ),
                array(
                    'value' => 'fs-1',
                    'label' => __( 'H1','investment' ),
                ),
                array(
                    'value' => 'fs-2',
                    'label' => __( 'H2','investment' ),
                ),
                array(
                    'value' => 'fs-3',
                    'label' => __( 'H3','investment' ),
                ),
                array(
                    'value' => 'fs-4',
                    'label' => __( 'H4','investment' ),
                ),
                array(
                    'value' => 'fs-5',
                    'label' => __( 'H5','investment' ),
                ),
                array(
                    'value' => 'fs-6',
                    'label' => __( 'H6','investment' ),
                )                
            ),
        ),
        array(
            'id' => 'lets_work_title_font_weight',
            'label' => 'Title font weight',
            'std' => '',
            'type' => 'select',
            'section' => 'footer_options',
            'condition' => 'lets_work_area:not(off)',
            'choices' => array(
                array(
                    'value' => '',
                    'label' => __( 'Default','investment' ),
                ),
                array(
                    'value' => 'fw-normal',
                    'label' => __( 'Normal','investment' ),
                ),
                array(
                    'value' => 'fw-medium',
                    'label' => __( 'Medium','investment' ),
                ),
                array(
                    'value' => 'fw-semibold',
                    'label' => __( 'Semibold','investment' ),
                ),
                array(
                    'value' => 'fw-bold',
                    'label' => __( 'Bold','investment' ),
                ),
                array(
                    'value' => 'fw-bolder',
                    'label' => __( 'Bolder','investment' ),
                )
            ),
        ), 
        array(
             'id' => 'lets_work_button_title',
            'label' => __( 'Lets work button title', 'investment' ),
            'std' => __( 'Let’s Work Together', 'investment' ),
            'type' => 'text',
            'section' => 'footer_options',
            'condition' => 'lets_work_area:not(off)',
            'operator' => 'and' 
        ), 
        array(
             'id' => 'lets_work_button_link',
            'label' => __( 'Lets work button link', 'investment' ),
            'std' => '#',
            'type' => 'text',
            'section' => 'footer_options',
            'condition' => 'lets_work_area:not(off)',
            'operator' => 'and' 
        ), 
        array(
            'id' => 'lets_work_button_link_target',
            'label' => 'Link target',
            'std' => '_self',
            'type' => 'select',
            'section' => 'footer_options',
            'condition' => 'lets_work_area:not(off)',
            'choices' => array(
                    array(
                        'value' => '_self',
                    'label' => __( 'Same window','investment' ),
                ),
                array(
                        'value' => '_blank',
                    'label' => __( 'New window','investment' ),
                ),
                
            ),
        ), 
    
        array(
             'id' => 'footer_copyright__tab',
            'label' => __( 'Footer copyright options', 'investment' ),
            'type' => 'tab',
            'section' => 'footer_options',
        ),          
        array(
             'id' => 'footer_copyright_bar',
            'label' => __( 'Display footer copyright bar', 'investment' ),
            'desc' => '',
            'std' => 'on',
            'type' => 'on-off',
            'section' => 'footer_options',
            'condition' => '',
            'operator' => 'and' 
        ),
        array(
            'id' => 'copyright_text',
           'label' => __( 'Copyright Text', 'investment' ),
           'desc' => '',
           'std' => '&copy; ' . date( 'Y' ) . ' Investment Expert. All Rights Reserved',
           'type' => 'textarea',
           'section' => 'footer_options',
           'rows' => '2',
           'condition' => 'footer_copyright_bar:not(off)',
           'operator' => 'and' 
       ),
        array(
            'id'          => 'copyrightbar_background_style',
            'label'       => __( 'Copyright bar background style', 'investment' ),
            'desc'        => '',
            'std'         => 'theme-color',
            'type'        => 'select',
            'section'     => 'footer_options',
            'choices'     => array( 
              array(
                'value'       => 'theme-color',
                'label'       => __( 'Theme Color', 'investment' ),
              ),
              array(
                'value'       => 'custom',
                'label'       => __( 'Custom background', 'investment' ),
              ),
            ),
            'condition' => 'footer_copyright_bar:not(off)'
        ),
        array(
            'id'          => 'copyrightbar_background_color',
            'label'       => __( 'Copyright bar background color', 'investment' ),
            'desc'        => '',
            'std'         => 'dark',
            'type'        => 'select',
            'section'     => 'footer_options',
            'choices'     => investment_theme_colors_dropdown(),
            'condition'   => 'footer_copyright_bar:not(off),copyrightbar_background_style:not(custom)',
            'operator'    => 'and',
        ),
        
        array(
            'id'          => 'footer_copyright_background',
            'label'       => __( 'Copyright bar background', 'investment' ),
            'desc'        => '',
            'std'         => '',
            'type'        => 'background',
            'section'     => 'footer_options',
            'rows'        => '',
            'post_type'   => '',
            'taxonomy'    => '',
            'min_max_step'=> '',
            'class'       => '',
            'condition'   => 'footer_copyright_bar:not(off),copyrightbar_background_style:is(custom)',
            'operator'    => 'and',
            'action'   => array()
          ),
        array(
            'id' => 'copyrightbar_extra_class',
           'label' => __( 'Extra classes', 'investment' ),
           'desc' => __( 'Put your class name. For multiple classes, each class should be separated by space ', 'investment' ),
           'std' => '',
           'type' => 'text',
           'section' => 'footer_options', 
           'condition' => 'footer_copyright_bar:not(off)'
       ),
        
        array(
             'id' => 'footer_css',
            'label' => __( 'CSS', 'investment' ),
            'class' => 'hide-field',
            'desc' => '',
            'std' => '

',
            'type' => 'css',
            'section' => 'footer_options',
            'rows' => '20',
            'operator' => 'and' 
        ) 
    );
    
    return apply_filters( 'investment_footer_options', $options );
}