<?php
function investment_general_options( $options = array() ){
	$options = array(
    array(
      'id'          => 'logo-settings',
      'label'       => __( 'General settings', 'investment' ),
      'type'        => 'tab',
      'section'     => 'general_options'
    ),
      array(
        'id'          => 'logo',
        'label'       => __( 'Logo', 'investment' ),
        'desc'        => '',
        'std'         => INVESTMENT_ASSETS.'/images/logo.png',
        'type'        => 'upload',
        'section'     => 'general_options',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'logo_light',
        'label'       => __( 'Logo white', 'investment' ),
        'desc'        => __( 'Used in transparent header and dark header','investment' ),
        'std'         => INVESTMENT_ASSETS.'/images/logo-white.png',
        'type'        => 'upload',
        'section'     => 'general_options',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'logo_height',
        'label'       => __( 'Logo height maximum', 'investment' ),
        'std'         => array('40', 'px'),
        'type'        => 'measurement',
        'section'     => 'general_options',
        'operator'    => 'and',
      ),
      array(
        'id'          => 'logo_dimension',
        'label'       => __( 'Logo dimension', 'investment' ),
        'desc'        => __( 'Header logo dimension for large screen','investment' ),
        'type'        => 'dimension',
        'section'     => 'general_options',
        'condition'   => '',
        'operator'    => 'and'
      ),      
      array(
        'id'          => 'logo_dimension_md',
        'label'       => __( 'Logo dimension Tablet', 'investment' ),
        'desc'        => __( 'Optional, effective when your layout can be adapted at a particular viewport or device size > 1200px)','investment' ),
        'type'        => 'dimension',
        'section'     => 'general_options',
      ),
      array(
        'id'          => 'logo_dimension_sm',
        'label'       => __( 'Logo dimension mobile', 'investment' ),
        'desc'        => __( 'Optional, effective when your layout can be adapted at a particular viewport or device size > 640px)','investment' ),
        'type'        => 'dimension',
        'section'     => 'general_options',
      ),
      
      array(
        'id'          => 'google_map_api',
        'label'       => __( 'Google map API', 'investment' ),
        'desc'        => '<a class="button" href="https//console.developers.google.com/flows/enableapi?apiid=maps_backend,geocoding_backend,directions_backend,distance_matrix_backend,elevation_backend&keyType=CLIENT_SIDE&reusekey=true" target="_blank"><strong>'.__( 'Get an API key', 'investment' ).'</strong></a>',
        'std'         => '',
        'type'        => 'text',
        'section'     => 'general_options',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'general-search-icons-settings',
        'label'       => __( 'Search & social icons', 'investment' ),
        'type'        => 'tab',
        'section'     => 'general_options'
      ),
     array(
        'id'          => 'search_placeholder',
        'label'       => __( 'Search Placeholder Text', 'investment' ),
        'desc'        => '',
        'std'         => __('What you are searching for?', 'investment' ),
        'type'        => 'text',
        'section'     => 'general_options',
      ),
     array(
        'id'          => 'search_button',
        'label'       => __( 'Search Button Text', 'investment' ),
        'desc'        => '',
        'std'         => __( 'Search', 'investment' ),
        'type'        => 'text',
        'section'     => 'general_options',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'disable_button_icon',
        'label'       => __( 'Disable arrow icon after button', 'investment' ),
        'desc'        => __('Check to disable arrow icon after button.', 'investment' ),
        'std'         => '',
        'type'        => 'checkbox',
        'choices'     => array( 
          array(
          'value'       => 'yes',
          'label'       => __( 'Disable icon', 'investment' ),
          ),
        ),
        'section'     => 'general_options',
        'condition'   => '',
        'operator'    => 'and'
      ),
     array(
            'id' => 'social_icons',
            'label' => __( 'Social Icons', 'investment' ),
            'desc' => '',
            'std' => investment_default_social_icons(),
            'type' => 'list-item',
            'section' => 'general_options',
            'condition' => '',
            'operator' => 'and',
            'settings' => array(
                array(
                    'id' => 'icon',
                    'label' => __( 'Icon', 'investment' ),
                    'desc' => '',
                    'type' => 'iconpicker' 
                ),
                array(
                    'id' => 'input',
                    'label' => __( 'Social link', 'investment' ),
                    'desc' => '',
                    'type' => 'text' 
                ),
                 array(
                     'id' => 'icon_link',
                    'label' => __( 'Icon & Social link (This field will be depreciated later)', 'investment' ),
                    'desc' => '',
                    'std' => array(
                         'icon' => 'fa-heart',
                        'input' => '#' 
                    ),
                    'type' => 'iconpicker_input' 
                ) 
            ) 
        ),
        
        array(
          'id'          => 'general-advanced-settings',
          'label'       => __( 'Advanced settings', 'investment' ),
          'type'        => 'tab',
          'section'     => 'general_options'
        ),
        
        
     array(
        'id'          => 'disable_post_type',
        'label'       => __( 'Disable post type', 'investment' ),
        'desc' => __('Check to disable post type options.', 'investment' ),
        'type'        => 'checkbox',
        'section'     => 'general_options',
        'choices'     => array( 
          array(
            'value'       => 'portfolio',
            'label'       => __( 'Portfolio', 'investment' ),
          ),
          array(
            'value'       => 'service',
            'label'       => __( 'Service', 'investment' ),
          ),
          array(
            'value'       => 'team',
            'label'       => __( 'Team', 'investment' ),
          ),
          array(
            'value'       => 'job',
            'label'       => __( 'Job', 'investment' ),
          ),
          array(
            'value'       => 'partner',
            'label'       => __( 'Partner', 'investment' ),
          )
        )
      ),
      array(
        'id'          => 'admin_logo',
        'label'       => __( 'Admin logo', 'investment' ),
        'desc'        => '',
        'std'         => INVESTMENT_ASSETS.'/images/icon.png',
        'type'        => 'upload',
        'section'     => 'general_options',
        'condition'   => '',
        'operator'    => 'and'
      ),
      

      array(
        'id'          => 'enable_slider_resize_control',
        'label'       => __( 'Enable slider height control for large screen (xl)', 'investment' ), 
        'desc'       => __( 'Slider height for other screen sizes can be controlled from slider revolution plugin settings', 'investment' ), 
        'std'         => 'on',
        'type'        => 'on-off',
        'section'     => 'general_options',
      ),

      array(
        'id' => 'header_slider_height',
        'label' => __( 'Default header slider height for large screen (xl)', 'investment' ),
        'desc' => __('in pixel', 'investment' ),
        'std' => '470',
        'type' => 'text',
        'section' => 'general_options',
        'condition' => 'enable_slider_resize_control:is(on)' ,
      ),

      array(
        'id' => 'transparent_header_slider_height',
        'label' => __( 'Transparent header slider height for large screen (xl)', 'investment' ),
        'desc' => __('in pixel', 'investment' ),
        'std' => '630',
        'type' => 'text',
        'section' => 'general_options',
        'condition' => 'enable_slider_resize_control:is(on)' , 
      ),
     

	);

	return apply_filters( 'investment_general_options', $options );
}
?>