<?php
function investment_woo_cart_icon_option(){
    if( function_exists('is_woocommerce') ){
        return array(
             'id' => 'header_cart_icon',
            'label' => __( 'Header cart icon display', 'investment' ),
            'desc' => '',
            'std' => 'on',
            'type' => 'on-off',
            'section' => 'header_options',
            'condition' => '',
            'operator' => 'or' 
        );
    }
}
function investment_langs_dropdown_option(){
    
        return array(
             'id' => 'header_language_dropdown',
            'label' => __( 'Header topbar Language dropdown display', 'investment' ),
            'desc' => 'This option only applicable when <strong>WPML</strong>, <strong>Polylang</strong> or <strong>Multilanguage by BestWebSoft</strong> plugins are installed',
            'std' => 'on',
            'type' => 'on-off',
            'section' => 'header_options',
            'condition' => '',
            'operator' => 'or' 
        );
   
}
function investment_header_options( $options = array() ) {
    $options = array(
        array(
            'id' => 'header-navbar-general',
           'label' => __( 'General settings', 'investment' ),         
           'type' => 'tab',
           'section' => 'header_options' 
       ),
       array(
        'id' => 'header_style',
        'label' => __( 'Header Style', 'investment' ),
        'desc' => '',
        'std' => 'header-style1',
        'type' => 'select',
        'section' => 'header_options',
        'class' => 'radio-image-half',
        'condition' => '',
        'operator' => 'and',
        'choices' => array(
                array(
                    'value' => 'header-style1',
                'label' => 'Style 1',
            ),
            array(
                    'value' => 'header-style2',
                'label' => 'Style 2(Full-width menu bar)',
            ),
            
        ) 
    ),        
    
       array(
            'id' => 'header_topbar',
            'label' => __( 'Top bar display', 'investment' ),
            'desc' => '',
            'std' => 'on',
            'type' => 'on-off',
            'section' => 'header_options',
            'condition' => '',
            'operator' => 'or' 
        ),
        array(
            'id' => 'header_topbar_info_display',
           'label' => __( 'Top bar info display', 'investment' ),
           'desc' => 'Check topbar settings tab',
           'std' => 'on',
           'type' => 'on-off',
           'section' => 'header_options',
           'condition' => 'header_topbar:is(on)',
           'operator' => 'or' 
       ),
       array(
        'id' => 'navbar_button_display',
        'label' => __( 'Topbar button in navbar', 'investment' ),
        'desc' => '',
        'std' => 'off',
        'type' => 'on-off',
        'condition' => 'header_topbar:is(on)',
        'section' => 'header_options'
        ),
        array(
            'id' => 'topbar_button_display_in_menu',
           'label' => __( 'Topbar button display in menu while scrolling', 'investment' ),
           'desc' => '',
           'std' => 'on',
           'type' => 'on-off',
           'section' => 'header_options',
           'operator' => 'and',
           'condition' => 'header_sticky_nav:is(on),navbar_button_display:is(on),header_topbar:is(on)'
       ),
       array(
            'id' => 'search_icon_display',
            'label' => __( 'Search icon in navbar', 'investment' ),
            'desc' => '',
            'std' => 'off',
            'type' => 'on-off',
            'section' => 'header_options',
            'condition' => ''
        ),
       array(
            'id' => 'header_social_icons_display',
            'label' => __( 'Social Icons in navbar', 'investment' ),
            'desc' => '',
            'std' => 'on',
            'type' => 'on-off',
            'section' => 'header_options' 
        ),
        
        array(
             'id' => 'header_sticky_nav',
            'label' => __( 'Sticky navbar', 'investment' ),
            'desc' => '',
            'std' => 'on',
            'type' => 'on-off',
            'section' => 'header_options' 
        ),
        
       array(
            'id' => 'sticky_search_display',
           'label' => __( 'Search icon display when menu is sticky', 'investment' ),
           'desc' => '',
           'std' => 'off',
           'type' => 'on-off',
           'section' => 'header_options',
           'operator' => 'and',
           'condition' => 'search_icon_display:is(on),header_sticky_nav:is(on)'
       ),      
        array(
            'id' => 'header_social_icons_display_in_menu',
           'label' => __( 'Social Icons display in menu while scrolling', 'investment' ),
           'desc' => '',
           'std' => 'off',
           'type' => 'on-off',
           'section' => 'header_options',
           'operator' => 'and',
           'condition' => 'header_sticky_nav:is(on),header_social_icons_display:is(on)'
       ),
        
        
        array(
            'id' => 'frontpage_header_style',
            'label' => __( 'Front page Header Style', 'investment' ),
            'desc' => '',
            'std' => 'transparent-header',
            'type' => 'select',
            'section' => 'header_options',
            'condition' => '',
            'operator' => 'and',
            'choices' => array(
                    array(
                        'value' => 'header-default',
                    'label' => __( 'Default','investment' ),
                ),
                array(
                        'value' => 'transparent-header',
                    'label' => __( 'Transparent header','investment' ),
                ),
                
            ) 
        ),
        array(
            'id' => 'mobile_menu_style',
            'label' => __( 'Mobile Menu Style', 'investment' ),
            'desc' => '',
            'std' => 'offcanvas',
            'type' => 'select',
            'section' => 'header_options',
            'operator' => 'or' ,
            'choices' => array(
                    array(
                        'value' => 'offcanvas',
                        'label' => 'Offcanvas',
                    ),
                    array(
                        'value' => 'collapse',
                        'label' => 'Collapsible',
                    ),
                
            ) 
        ),                
        array(
                'id' => 'header_background',
            'label' => __( 'Header Menu area background', 'investment' ),
            'desc' => '',
            'std' => 'default-bg',
            'type' => 'select',
            'section' => 'header_options',
            'operator' => 'or' ,
            'choices' => array(
                    array(
                        'value' => 'default-bg',
                    'label' => 'White Background',
                ),
                array(
                        'value' => 'secondary-bg-dark',
                    'label' => 'Secondary BG',
                ),
                
            ) 
        ),
        
        array(
            'id' => 'header-topbar-settings',
           'label' => __( 'Topbar settings', 'investment' ),         
           'type' => 'tab',
           'section' => 'header_options' 
       ),
        
        investment_langs_dropdown_option(),
        array(
             'id' => 'topbar_background',
            'label' => __( 'Topbar background', 'investment' ),
            'desc' => '',
            'std' => 'secondary-bg-dark',
            'type' => 'select',
            'section' => 'header_options',
            'condition' => 'header_style:is(header-style1),header_topbar:is(on)' ,
            'choices' => array(
                 array(
                     'value' => 'white-bg',
                    'label' => __( 'White Background','investment' ),
                ),
                array(
                     'value' => 'secondary-bg-dark',
                    'label' => __( 'Secondary color background','investment' ),
                ),
                array(
                     'value' => 'primary-bg',
                    'label' =>__(  'Primary color background','investment' ),
                ),
                
            ) 
        ),
        
        array(
             'id' => 'topbar_info',
            'label' => __( 'Topbar information', 'investment' ),
            'desc' => '',
            'std' => array(
                    array(
                        'title' => __( 'Time', 'investment' ),
                        'icon' => 'fa-clock-o',
                        'input' => 'Mon - Fri : 09:00 - 17:00',
                        'icon_link' => array('icon' => 'fa-clock-o', 'input' => 'Mon - Fri : 09:00 - 17:00')
                    ),
                    array(
                        'title' => __( 'Phone', 'investment' ),
                        'icon' => 'fa-phone',
                        'input' => '888-123-2342',
                        'icon_link' => array('icon' => 'fa-phone', 'input' => '888-123-2342')
                    ),

                ),
            'type' => 'list-item',
            'section' => 'header_options',
            'condition' => 'header_topbar_info_display:is(on)',
            'operator' => 'and',
            'settings' => array(
                array(
                    'id' => 'icon',
                    'label' => __( 'Icon', 'investment' ),
                    'desc' => '',
                    'type' => 'iconpicker' 
                 ),
                array(
                    'id' => 'input',
                    'label' => __( 'Short description', 'investment' ),
                    'desc' => '',
                    'type' => 'text' 
                ),
                 array(
                    'id' => 'icon_link',
                    'label' => __( 'Icon & description (This field will be depreciated later)', 'investment' ),
                    'desc' => '',
                    'std' => array(
                         'icon' => 'fa-heart',
                        'input' => '#' 
                    ),
                    'type' => 'iconpicker_input' 
                ) 
            ) 
        ),        
        investment_woo_cart_icon_option(),

        array(
             'id' => 'topbar_button_display',
            'label' => __( 'Header Top bar button display', 'investment' ),
            'desc' => '',
            'std' => 'on',
            'type' => 'on-off',
            'section' => 'header_options',
        ),
        
        array(
            'id' => 'navbar-icon-settings',
           'label' => __( 'Navbar icons & buttons', 'investment' ),         
           'type' => 'tab',
           'section' => 'header_options' 
       ),
       array(
            'id' => 'topbar_button',
            'label' => __( 'Topbar Button', 'investment' ),
            'desc' => '',
            'std' => array(
                    array(
                        'title' => __( 'Work with us', 'investment' ),
                        'link' => '#',
                        'target' => '_self',
                        'modal' => 'no',
                    ),
                ),
            'type' => 'list-item',
            'section' => 'header_options',
            'operator' => 'and',
            'settings' => array(
                    array(
                        'id' => 'link',
                    'label' => __( 'link', 'investment' ),
                    'desc' => '',
                    'std' => '#',
                    'type' => 'text' 
                ),
                array(
                        'id' => 'target',
                    'label' => 'Link target',
                    'std' => '_self',
                    'type' => 'select',
                    'choices' => array(
                            array(
                                'value' => '_self',
                            'label' => __( 'Same window','investment' ),
                        ),
                        array(
                                'value' => '_blank',
                            'label' => __( 'New window','investment' ),
                        ),
                        
                    ),
                    'condition' => 'modal:is(no)' 
                ), 
                array(
                    'id' => 'modal',
                    'label' => 'Enable modal',
                    'std' => 'no',
                    'type' => 'select',
                    'choices' => array(
                            array(
                                'value' => 'no',
                            'label' => __( 'No','investment' ),
                        ),
                        array(
                                'value' => 'yes',
                            'label' => __( 'Yes','investment' ),
                        ),
                        
                    ) 
                ), 
            ) 
        ),        
        array(
             'id' => 'header_social_icons',
            'label' => __( 'Social Icons', 'investment' ),
            'desc' => '',
            'std' => investment_header_default_social_icons(),
            'type' => 'list-item',
            'section' => 'header_options',
            'operator' => 'and',
            'settings' => array(
                array(
                    'id' => 'icon',
                    'label' => __( 'Icon', 'investment' ),
                    'desc' => '',
                    'type' => 'iconpicker' 
                 ),
                array(
                    'id' => 'input',
                    'label' => __( 'Social link', 'investment' ),
                    'desc' => '',
                    'type' => 'text' 
                ),
                 array(
                    'id' => 'icon_link',
                    'label' => __( 'Top bar Title (This field will be depreciated later)', 'investment' ),
                    'desc' => '',
                    'std' => array(
                        'icon' => 'fa-heart',
                        'input' => '#' 
                    ),
                    'type' => 'iconpicker_input' 
                ) 
            ) 
        ),
         
        array(
            'id' => 'header-responsive-settings',
           'label' => __( 'Responsive settings', 'investment' ),         
           'type' => 'tab',
           'section' => 'header_options' 
        ),
       array(
        'id' => 'header_menu_breakpoint',
        'label' => __( 'Menu breakpoint', 'investment' ),
        'desc' => __('in pixel', 'investment' ),
        'std' => '800',
        'type' => 'text',
        'section' => 'header_options' 
    ),
       
        
    );
    
    return apply_filters( 'investment_header_options', $options );
}
?>