<?php
function investment_portfolio_options( $options = array() ){
  $career = investment_get_page_by_title( 'Career' );
  $services = investment_get_page_by_title( 'Services' );
  $team = investment_get_page_by_title( 'Team member' );
  $casestudies = investment_get_page_by_title( 'Casestudies' );  
  $partners = investment_get_page_by_title( 'Partners' );

	$options = array(
        array(
             'id' => 'portfolio__tab',
            'label' => __( 'Portfolio options', 'investment' ),
            'type' => 'tab',
            'section' => 'portfolio_options',
        ),
        array(
        'id'          => 'portfolio_archive',
        'label'       => __( 'Portfolio Archive page', 'investment' ),
        'desc'        => sprintf(__('If archive page is not working, then save again <a href="%s" target="_blank">permalink settings</a>, For best performance use Pretty permalink(Example: Post name, Day and name etc)', 'investment'), admin_url('options-permalink.php')),
        'std'         => ( !is_null($casestudies) && (get_post_status($casestudies->ID) == 'publish') )? $casestudies->ID : '',
        'type'        => 'page-select',
        'section'     => 'portfolio_options',
        'rows'        => '',
      ),
    array(
        'id'          => 'portfolio_category_slug',
        'label'       => __( 'Portfolio category slug', 'investment' ),
        'desc'        => sprintf(__('If archive page is not working, then save again <a href="%s" target="_blank">permalink settings</a>, For best performance use Pretty permalink(Example: Post name, Day and name etc)', 'investment'), admin_url('options-permalink.php')),
        'std'         => 'portfolio_category',
        'type'        => 'text',
        'section'     => 'portfolio_options',
        'condition'   => '',
        'operator'    => 'and'
      ),
    array(
        'id'          => 'portfolio_tag_slug',
        'label'       => __( 'Portfolio tag slug', 'investment' ),
        'desc'        => sprintf(__('If archive page is not working, then save again <a href="%s" target="_blank">permalink settings</a>, For best performance use Pretty permalink(Example: Post name, Day and name etc)', 'investment'), admin_url('options-permalink.php')),
        'std'         => 'ptag',
        'type'        => 'text',
        'section'     => 'portfolio_options',
        'condition'   => '',
        'operator'    => 'and'
      ),
    array(
        'id'          => 'portfolio_all_text',
        'label'       => __( 'Portfolio all text', 'investment' ),
        'desc'        => '',
        'std'         => __( 'All', 'investment' ),
        'type'        => 'text',
        'section'     => 'portfolio_options',
        'condition'   => '',
        'operator'    => 'and'
      ),
    array(
        'id'          => 'portfolio_all_text',
        'label'       => __( 'Portfolio all text', 'investment' ),
        'desc'        => '',
        'std'         => __( 'All', 'investment' ),
        'type'        => 'text',
        'section'     => 'portfolio_options',
        'condition'   => '',
        'operator'    => 'and'
      ),
    array(
        'id'          => 'portfolio_read_more_text',
        'label'       => __( 'Portfolio read more text', 'investment' ),
        'desc'        => '',
        'std'         => __( 'Find out more', 'investment' ),
        'type'        => 'text',
        'section'     => 'portfolio_options',
        'condition'   => '',
        'operator'    => 'and'
      ),
    array(
        'id'          => 'portfolio_single_layout',
        'label'       => __( 'Single portfolio layout', 'investment' ),
        'desc'        => '',
        'std'         => 'rs',
        'type'        => 'radio-image',
        'section'     => 'portfolio_options',
        'operator'    => 'and',
        'choices'     => array( 
          array(
            'value'       => 'full',
            'label'       => __( 'Full width', 'investment' ),
            'src'         => OT_URL . '/assets/images/layout/full-width.png'
          ),
          array(
            'value'       => 'ls',
            'label'       => __( 'Left sidebar', 'investment' ),
            'src'         => OT_URL . '/assets/images/layout/left-sidebar.png'
          ),
          array(
            'value'       => 'rs',
            'label'       => __( 'Right sidebar', 'investment' ),
            'src'         => OT_URL . '/assets/images/layout/right-sidebar.png'
          )
        )
      ),
      array(
        'id'          => 'portfolio_single_layout_sidebar',
        'label'       => __( 'Single portfolio Sidebar', 'investment' ),
        'desc'        => '',
        'std'         => 'sidebar-portfolio',
        'type'        => 'sidebar-select',
        'section'     => 'portfolio_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'portfolio_single_layout:not(full)',
        'operator'    => 'and'
      ),
      array(
             'id' => 'service__tab',
            'label' => __( 'Service options', 'investment' ),
            'type' => 'tab',
            'section' => 'portfolio_options',
        ),
     array(
        'id'          => 'service_archive',
        'label'       => 'Service Archive page',
        'desc'        => sprintf(__('If archive page is not working, then save again <a href="%s" target="_blank">permalink settings</a>, For best performance use Pretty permalink(Example: Post name, Day and name etc)', 'investment'), admin_url('options-permalink.php')),
        'std'         => ( !is_null($services) && (get_post_status($services->ID) == 'publish') )? $services->ID : '',
        'type'        => 'page-select',
        'section'     => 'portfolio_options',
        'rows'        => '',
      ),
     array(
        'id'          => 'service_archive_column',
        'label'       => __( 'Service column in Archive page', 'investment' ),
        'desc'        => '',
        'std'         => 3,
        'type'        => 'select',
        'section'     => 'portfolio_options',
        'operator'    => 'and',
        'choices'     => array( 
          array(
            'value'       => 2,
            'label'       => '2 column',
          ),
          array(
            'value'       => 3,
            'label'       => '3 column',
          ),
          array(
            'value'       => 4,
            'label'       => '4 column',
          ),
        )
      ),
     array(
        'id'          => 'service_read_more_text',
        'label'       => __( 'Service read more text', 'investment' ),
        'desc'        => '',
        'std'         => __( 'Know more', 'investment' ),
        'type'        => 'text',
        'section'     => 'portfolio_options',
        'condition'   => '',
        'operator'    => 'and'
      ),
     array(
        'id'          => 'services_single_layout',
        'label'       => __( 'Single service layout', 'investment' ),
        'desc'        => '',
        'std'         => 'rs',
        'type'        => 'radio-image',
        'section'     => 'portfolio_options',
        'operator'    => 'and',
        'choices'     => array( 
          array(
            'value'       => 'full',
            'label'       => __( 'Full width', 'investment' ),
            'src'         => OT_URL . '/assets/images/layout/full-width.png'
          ),
          array(
            'value'       => 'ls',
            'label'       => __( 'Left sidebar', 'investment' ),
            'src'         => OT_URL . '/assets/images/layout/left-sidebar.png'
          ),
          array(
            'value'       => 'rs',
            'label'       => __( 'Right sidebar', 'investment' ),
            'src'         => OT_URL . '/assets/images/layout/right-sidebar.png'
          )
        )
      ),
      array(
        'id'          => 'services_single_layout_sidebar',
        'label'       => __( 'Single service Sidebar', 'investment' ),
        'desc'        => '',
        'std'         => 'sidebar-service',
        'type'        => 'sidebar-select',
        'section'     => 'portfolio_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'services_single_layout:not(full)',
        'operator'    => 'and'
      ),
      array(
             'id' => 'team__tab',
            'label' => __( 'Team options', 'investment' ),
            'type' => 'tab',
            'section' => 'portfolio_options',
        ),
     array(
        'id'          => 'team_archive',
        'label'       => __( 'Team Archive page', 'investment' ),
        'desc'        => sprintf(__('If archive page is not working, then save again <a href="%s" target="_blank">permalink settings</a>, For best performance use Pretty permalink(Example: Post name, Day and name etc)', 'investment'), admin_url('options-permalink.php')),
        'std'         => ( !is_null($team) && (get_post_status($team->ID) == 'publish') )? $team->ID : '',
        'type'        => 'page-select',
        'section'     => 'portfolio_options',
        'rows'        => '',
      ),
     array(
        'id'          => 'team_archive_column',
        'label'       => __( 'Team column in Archive page', 'investment' ),
        'desc'        => '',
        'std'         => 3,
        'type'        => 'select',
        'section'     => 'portfolio_options',
        'operator'    => 'and',
        'choices'     => array( 
          array(
            'value'       => 2,
            'label'       => __('2 column', 'investment' ),
          ),
          array(
            'value'       => 3,
            'label'       => __('3 column', 'investment' ),
          ),
          array(
            'value'       => 4,
            'label'       => __('4 column', 'investment' ),
          ),
        )
      ),
     array(
        'id'          => 'team_read_more_text',
        'label'       => __( 'Team read more text', 'investment' ),
        'desc'        => '',
        'std'         => __( 'Know more', 'investment' ),
        'type'        => 'text',
        'section'     => 'portfolio_options',
        'condition'   => '',
        'operator'    => 'and'
      ),
     array(
        'id'          => 'teams_single_layout',
        'label'       => __( 'Single team layout', 'investment' ),
        'desc'        => '',
        'std'         => 'rs',
        'type'        => 'radio-image',
        'section'     => 'portfolio_options',
        'operator'    => 'and',
        'choices'     => array( 
          array(
            'value'       => 'full',
            'label'       => __( 'Full width', 'investment' ),
            'src'         => OT_URL . '/assets/images/layout/full-width.png'
          ),
          array(
            'value'       => 'ls',
            'label'       => __( 'Left sidebar', 'investment' ),
            'src'         => OT_URL . '/assets/images/layout/left-sidebar.png'
          ),
          array(
            'value'       => 'rs',
            'label'       => __( 'Right sidebar', 'investment' ),
            'src'         => OT_URL . '/assets/images/layout/right-sidebar.png'
          )
        )
      ),
     array(
            'id'          => 'single_team_title_tag',
            'label'       => esc_attr__( 'Single Team title tag', 'investment' ),
            'std'         => 'h3',
            'type'        => 'select',           
            'section'     => 'portfolio_options',
            'operator'    => 'and',
            'choices'     => investment_title_tag_std(),
        ),
        array(
            'id'          => 'single_team_tag_size',
            'label'       => esc_attr__( 'Single Team title tag size', 'investment' ),
            'std'         => '',
            'type'        => 'select',           
            'section'     => 'portfolio_options',
            'operator'    => 'and',
            'choices'     => investment_title_tag_size_std(),
        ),
      array(
        'id'          => 'teams_single_layout_sidebar',
        'label'       => __( 'Single team Sidebar', 'investment' ),
        'desc'        => '',
        'std'         => 'sidebar-service',
        'type'        => 'sidebar-select',
        'section'     => 'portfolio_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'teams_single_layout:not(full)',
        'operator'    => 'and'
      ),
      array(
             'id' => 'job__tab',
            'label' => __( 'Career & partner options', 'investment' ),
            'type' => 'tab',
            'section' => 'portfolio_options',
        ),
     array(
        'id'          => 'partner_archive',
        'label'       => __( 'Partner Archive page', 'investment' ),
        'desc'        => sprintf(__('If archive page is not working, then save again <a href="%s" target="_blank">permalink settings</a>, For best performance use Pretty permalink(Example: Post name, Day and name etc)', 'investment'), admin_url('options-permalink.php')),
        'std'         => ( !is_null($partners) && (get_post_status($partners->ID) == 'publish') )? $partners->ID : '',
        'type'        => 'page-select',
        'section'     => 'portfolio_options',
        'rows'        => '',
      ),
     array(
        'id'          => 'job_archive',
        'label'       => __( 'Job Archive page', 'investment' ),
        'desc'        => sprintf(__('If archive page is not working, then save again <a href="%s" target="_blank">permalink settings</a>, For best performance use Pretty permalink(Example: Post name, Day and name etc)', 'investment'), admin_url('options-permalink.php')),
        'std'         => ( !is_null($career) && (get_post_status($career->ID) == 'publish') )? $career->ID : '',
        'type'        => 'page-select',
        'section'     => 'portfolio_options',
        'rows'        => '',
      ),
      
    );

	return apply_filters( 'investment_portfolio_options', $options );
}  
?>