<?php
function investment_slider_options( $options = array() ){
	$options = array(  		
      array(
        'id'          => 'posts_option',
        'label'       => __( 'Posts display option', 'investment' ),
        'desc'        => '',
        'std'         => 'recent',
        'type'        => 'select',
        'section'     => 'front_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'choices'     => array( 
          array(
            'value'       => 'recent',
            'label'       => __( 'Recent posts', 'investment' ),
            'src'         => ''
          ),
          array(
            'value'       => 'ids',
            'label'       => __( 'ID,s only', 'investment' ),
            'src'         => ''
          ),
          array(
            'value'       => 'category',
            'label'       => __( 'Category posts', 'investment' ),
            'src'         => ''
          )
        ),
      ),

      array(
        'id'          => 'slider_posts',
        'label'       => __( 'Display post in slider', 'investment' ),
        'desc'        => '',
        'std'         => 5,
        'type'        => 'numeric-slider',
        'section'     => 'front_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '1,20,1',
        'class'       => '',
        'condition'   => 'posts_option:not(ids)'
      ),   
      array(
        'id'          => 'exclude_cat',
        'label'       => __( 'Exclude Category', 'investment' ),
        'desc'        => __( 'Exclude category from recent posts.', 'investment' ),
        'std'         => '',
        'type'        => 'category-checkbox',
        'section'     => 'front_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'posts_option:is(recent)',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'ids',
        'label'       => __( 'Post ID,s', 'investment' ),
        'desc'        => __( 'You can select post,event ID.', 'investment' ),
        'std'         => '',
        'type'        => 'post-checkbox',
        'section'     => 'front_options',
        'rows'        => '',
        'post_type'   => 'post,event',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'posts_option:is(ids)',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'include_cat',
        'label'       => __( 'Include Category', 'investment' ),
        'desc'        => __( 'Default show recent posts from all category.', 'investment' ),
        'std'         => '',
        'type'        => 'category-checkbox',
        'section'     => 'front_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'posts_option:is(category)',
        'operator'    => 'and'
      ),         
      
      array(
        'id'          => 'category_display',
        'label'       => __( 'Category Display', 'investment' ),
        'desc'        => '',
        'std'         => 'on',
        'type'        => 'on-off',
        'section'     => 'front_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => '',
        'operator'    => 'and'
      ),
      
       );

	return apply_filters( 'investment_slider_options', $options );
}  

function investment_get_slider_args( $args = array()) {

    $slider_posts = ot_get_option('slider_posts');  
  $excerpt_display = ot_get_option('excerpt_display');
  $excerpt_length = ot_get_option('excerpt_length');  
  $exclude_cat = ot_get_option('include_cat', array());
  $posts_option = ot_get_option('posts_option', 'recent');

  $args['ignore_sticky_posts'] = true;
  
  if( $posts_option == 'ids' ){
    $id = ot_get_option('ids', array());
    if ( $id ) {
      $posts_in = array_map( 'intval', ot_get_option('ids', array()) );
      $args['post__in'] = $posts_in;
    } 
  }else{
    $args['posts_per_page'] = $slider_posts;
  }
  if( $posts_option == 'recent' ){
    $exclude_cat = ot_get_option('exclude_cat', array());
    $args['category__not_in'] = $exclude_cat;
  }
  if( $posts_option == 'category' ){
    $include_cat = ot_get_option('include_cat', array());
    $args['category__in'] = $include_cat;
  }

  return apply_filters( 'investment_get_slider_args', $args );
}