<?php
function investment_woo_options( $options = array() ){
	$options = array(  
      array(
        'id' => 'product_thumbnail_size',
        'label' => __('Thumbail Size', 'investment'),
        'desc' => __('Applied on product archive page', 'investment'),
        'section'     => 'woo_options',
        'type' => 'select',  
        'std'         => 'investment-400x400-crop',             
        'choices' => investment_img_size_dropdown()
            
        ),
        array(
            'id'          => 'product_archive_custom_button_text',
            'label'       => __( 'Change add to cart button text', 'investment' ),
            'desc'        => __( 'Applied on product archive page.', 'investment' ),
            'std'         => 'off',
            'type'        => 'on-off',
            'section'     => 'woo_options',
            'condition'   => '',
            'operator'    => 'and'
          
        ),
        array(
        'id'          => 'archive_add_to_cart_text',
        'label'       => __( 'Add to cart text', 'investment' ),
        'desc'        => __( 'Applied on product archive page.', 'investment' ),

        'std'         => __( 'Add to cart', 'investment' ),

        'type'        => 'text',
        'section'     => 'woo_options',
        'condition'   => 'product_archive_custom_button_text:is(on)',
        'operator'    => 'and'
        ),
        array(
        'id'          => 'variable_add_to_cart_text',
        'label'       => __( 'Add to cart text for variation product', 'investment' ),
        'desc'        => __( 'Applied on product archive page.', 'investment' ),
        'std'         => 'Select options',
        'type'        => 'text',
        'section'     => 'woo_options',
        'condition'   => 'product_archive_custom_button_text:is(on)',
        'operator'    => 'and'
        ),
        array(
        'id'          => 'external_add_to_cart_text',
        'label'       => __( 'Add to cart text for External product', 'investment' ),
        'desc'        => __( 'Applied on product archive page.', 'investment' ),
        'std'         => __( 'Buy product', 'investment' ),
        'type'        => 'text',
        'section'     => 'woo_options',
        'condition'   => 'product_archive_custom_button_text:is(on)',
        'operator'    => 'and'
        ),
        array(
        'id'          => 'grouped_add_to_cart_text',
        'label'       => __( 'Add to cart text for External product', 'investment' ),
        'desc'        => __( 'Applied on product archive page.', 'investment' ),
        'std'         => __( 'View products', 'investment' ),
        'type'        => 'text',
        'section'     => 'woo_options',
        'condition'   => 'product_archive_custom_button_text:is(on)',
        'operator'    => 'and'
        ),
          array(
            'id'          => 'listview_button_text',
            'label'       => __( 'List view button text', 'investment' ),
            'desc'        => __( 'Applied on product archive page.', 'investment' ),
            'std'         => __( 'See Details', 'investment' ),
            'type'        => 'text',
            'section'     => 'woo_options',
            'condition'   => 'product_archive_custom_button_text:is(on)',
            'operator'    => 'and'
          ),
          
        array(
            'id'          => 'product_custom_button_text',
            'label'       => __( 'Custom add to cart button text', 'investment' ),
            'desc'        => __( 'Applied on single product page.', 'investment' ),
            'std'         => 'off',
            'type'        => 'on-off',
            'section'     => 'woo_options',
            'condition'   => '',
            'operator'    => 'and'
          
        ),
         
        array(
        'id'          => 'add_to_cart_text',
        'label'       => __( 'Add to cart text', 'investment' ),
        'desc'        => __( 'Applied on single product page.', 'investment' ),
        'std'         => __( 'Add to cart', 'investment' ),
        'type'        => 'text',
        'section'     => 'woo_options',
        'condition'   => 'product_custom_button_text:is(on)',
        'operator'    => 'and'
      ),
        array(
            'id'          => 'added_to_cart_text',
            'label'       => __( 'Already in cart text', 'investment' ),
            'desc'        => __( 'Applied on single product page.', 'investment' ),
            'std'         => __( 'Already in cart', 'investment' ),
            'type'        => 'text',
            'section'     => 'woo_options',
            'condition'   => 'product_custom_button_text:is(on)',
            'operator'    => 'and'
          ),
        array(
            'id'          => 'related_product_display',
            'label'       => __( 'Related product show in single product', 'investment' ),
            'desc'        => '',
            'std'         => 'off',
            'type'        => 'on-off',
            'section'     => 'woo_options',
            'condition'   => '',
            'operator'    => 'and'
          
        ),           
        array(
            'id'          => 'related_product',
            'label'       => __( 'Related product display maximum', 'investment' ),
            'desc'        => '',
            'std'         => '6',
            'type'        => 'numeric-slider',
            'section'     => 'woo_options',
            'min_max_step'=> '1,12,1',
            'class'       => '',
            'condition'   => 'related_product_display:is(on)',
            'operator'    => 'and'
          
        ),
        array(
            'id'          => 'related_product_column',
            'label'       => __( 'Related product column', 'investment' ),
            'desc'        => '',
            'std'         => '3',
            'type'        => 'numeric-slider',
            'section'     => 'woo_options',
            'min_max_step'=> '2,4,1',
            'class'       => '',
            'condition'   => 'related_product_display:is(on)',
            'operator'    => 'and'
          
        ),        
        
	  array(
        'id'          => 'shop_layout',
        'label'       => __( 'Shop layout', 'investment' ),
        'desc'        => '',
        'std'         => 'ls',
        'type'        => 'radio-image',
        'section'     => 'woo_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and',
        'choices'     => array( 
          array(
            'value'       => 'full',
            'label'       => __( 'Full width', 'investment' ),
            'src'         => OT_URL . '/assets/images/layout/full-width.png'
          ),
          array(
            'value'       => 'ls',
            'label'       => __( 'Left sidebar', 'investment' ),
            'src'         => OT_URL . '/assets/images/layout/left-sidebar.png'
          ),
          array(
            'value'       => 'rs',
            'label'       => __( 'Right sidebar', 'investment' ),
            'src'         => OT_URL . '/assets/images/layout/right-sidebar.png'
          )
        )
      ),
    array(
        'id'          => 'shop_layout_sidebar',
        'label'       => __( 'Select shop Sidebar', 'investment' ),
        'desc'        => '',
        'std'         => 'sidebar-2',
        'type'        => 'sidebar-select',
        'section'     => 'woo_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'shop_layout:not(full)',
        'operator'    => 'and'
      ),
    array(
        'id'          => 'product_layout',
        'label'       => __( 'Product layout', 'investment' ),
        'desc'        => '',
        'std'         => 'rs',
        'type'        => 'radio-image',
        'section'     => 'woo_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and',
        'choices'     => array( 
          array(
            'value'       => 'full',
            'label'       => __( 'Full width', 'investment' ),
            'src'         => OT_URL . '/assets/images/layout/full-width.png'
          ),
          array(
            'value'       => 'ls',
            'label'       => __( 'Left sidebar', 'investment' ),
            'src'         => OT_URL . '/assets/images/layout/left-sidebar.png'
          ),
          array(
            'value'       => 'rs',
            'label'       => __( 'Right sidebar', 'investment' ),
            'src'         => OT_URL . '/assets/images/layout/right-sidebar.png'
          )
        )
      ),
    array(
        'id'          => 'product_layout_sidebar',
        'label'       => __( 'Product Sidebar', 'investment' ),
        'desc'        => '',
        'std'         => 'sidebar-2',
        'type'        => 'sidebar-select',
        'section'     => 'woo_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'product_layout:not(full)',
        'operator'    => 'and'
      ),
    
      
    );

    if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
  
        return apply_filters( 'investment_woo_options', $options );
    }else{
        return array(
            array(
            'id'          => 'woo_info',
            'label'       => 'Woocommerce',
            'desc'       => __( 'Woocommerce plugin is Required. Installed & activated woocommerce plugin to get Woo options', 'investment' ),          
            'std'         => '3',
            'type'        => 'textblock',
            'section'     => 'woo_options',           
        ));
    }

	
}  
?>