<?php
//include all available options
include INVESTMENT_DIR . '/admin/options/general_options.php';
include INVESTMENT_DIR . '/admin/options/background_options.php';
include INVESTMENT_DIR . '/admin/options/header_options.php';
include INVESTMENT_DIR . '/admin/options/sidebar_options.php';
include INVESTMENT_DIR . '/admin/options/footer_options.php';
include INVESTMENT_DIR . '/admin/options/blog_options.php';
include INVESTMENT_DIR . '/admin/options/portfolio_options.php';
include INVESTMENT_DIR . '/admin/options/typography_options.php';
include INVESTMENT_DIR . '/admin/options/styling_options.php';
include INVESTMENT_DIR . '/admin/options/custom_css.php';
include INVESTMENT_DIR . '/admin/options/slider_options.php';
include INVESTMENT_DIR . '/admin/options/404_options.php';
include INVESTMENT_DIR . '/admin/options/woo_options.php';

function investment_woo_ot_section(){
    
      return array(
          'id'          => 'woo_options',
          'title'       => __( 'Woo options', 'investment' )
        );
   
}
/**
 * Initialize the custom theme options.
 */
add_action( 'admin_init', 'investment_theme_options', 1 );

/**
 * Build the custom settings & update OptionTree.
 */
function investment_theme_options() {
  
  /* OptionTree is not loaded yet */
  if ( ! function_exists( 'ot_settings_id' ) )
    return false;
    
  /**
   * Get a copy of the saved settings array. 
   */
 $saved_settings = get_option( ot_settings_id(), array() );
  
  /**
   * Custom settings array that will eventually be 
   * passes to the OptionTree Settings API Class.
   */
  //available option functions - return type array()
  $general_options = investment_general_options();
  $background_options = investment_background_options();
  $header_options = investment_header_options();
  $slider_options = investment_slider_options();
  $sidebar_options = investment_sidebar_options();
  $footer_options = investment_footer_options();
  $blog_options = investment_blog_options();  
  $portfolio_options = investment_portfolio_options();  
  $typography_options = investment_typography_options();
  $styling_options = investment_styling_options();
  $error_options = investment_404_options();
  $custom_css = investment_custom_css();
  $woo_options = investment_woo_options();
  


  //merge all available options
  $settings = array_merge( $general_options, $background_options, $header_options,  $slider_options, $sidebar_options, $footer_options,  $blog_options, $portfolio_options, $error_options, $typography_options, $styling_options,  $custom_css, $woo_options );

  

 

  $custom_settings = array( 
    'contextual_help' => array( 
      'sidebar'       => ''
    ),
    'sections'        => array( 
      array(
        'id'          => 'general_options',
        'title'       => __( 'General options', 'investment' )
      ),
      array(
        'id'          => 'header_options',
        'title'       => __( 'Header options', 'investment' )
      ),/*
      array(
        'id'          => 'front_options',
        'title'       => 'Slider Options'
      ),*/
      array(
        'id'          => 'background_options',
        'title'       => __( 'Background Options', 'investment' )
      ),     
      array(
        'id'          => 'footer_options',
        'title'       => __( 'Footer options', 'investment' )
      ),
      array(
        'id'          => 'sidebar_option',
        'title'       => __( 'Sidebar options', 'investment' )
      ),
      array(
        'id'          => 'blog_options',
        'title'       => __( 'Blog options', 'investment' )
      ),
      array(
        'id'          => 'portfolio_options',
        'title'       => __( 'Service, Portfolio & Team', 'investment' )
      ),
      investment_woo_ot_section(),
      /*array(
        'id'          => 'post_options',
        'title'       => __( 'Post options', 'investment' )
      ),*/
      array(
        'id'          => '404_options',
        'title'       => __( '404 page', 'investment' )
      ),
      array(
        'id'          => 'fonts',
        'title'       => __( 'Typography options', 'investment' )
      ),
      array(
        'id'          => 'styling_options',
        'title'       => __( 'Styling options', 'investment' )
      ),
      array(
        'id'          => 'custom_css',
        'title'       => __( 'Custom css', 'investment' )
      )
    ),
    'settings'        => $settings
  );

  
  /* allow settings to be filtered before saving */
  //$custom_settings = apply_filters( ot_settings_id() . '_args', $custom_settings );
  
  /* settings are not the same update the DB */
  if ( ($saved_settings !== $custom_settings) ) {
    update_option( ot_settings_id(), $custom_settings ); 
  }
  
  /* Lets OptionTree know the UI Builder is being overridden */
  global $ot_has_custom_theme_options;
  $ot_has_custom_theme_options = true;

  return $custom_settings[ 'settings' ];
  
}