<?php
if( !function_exists('vc_get_shared') ):
/**
 * @param string $asset
 *
 * @return array|string
 */
function vc_get_shared( $asset = '' ) {
    switch ( $asset ) {
        case 'colors':
            return VcSharedLibrary::getColors();
            break;

        case 'colors-dashed':
            return VcSharedLibrary::getColorsDashed();
            break;

        case 'icons':
            return VcSharedLibrary::getIcons();
            break;

        case 'sizes':
            return VcSharedLibrary::getSizes();
            break;

        case 'button styles':
        case 'alert styles':
            return VcSharedLibrary::getButtonStyles();
            break;
        case 'message_box_styles':
            return VcSharedLibrary::getMessageBoxStyles();
            break;
        case 'cta styles':
            return VcSharedLibrary::getCtaStyles();
            break;

        case 'text align':
            return VcSharedLibrary::getTextAlign();
            break;

        case 'cta widths':
        case 'separator widths':
            return VcSharedLibrary::getElementWidths();
            break;

        case 'separator styles':
            return VcSharedLibrary::getSeparatorStyles();
            break;

        case 'separator border widths':
            return VcSharedLibrary::getBorderWidths();
            break;

        case 'single image styles':
            return VcSharedLibrary::getBoxStyles();
            break;

        case 'single image external styles':
            return VcSharedLibrary::getBoxStyles( array( 'default', 'round' ) );
            break;

        case 'toggle styles':
            return VcSharedLibrary::getToggleStyles();
            break;

        case 'animation styles':
            return VcSharedLibrary::getAnimationStyles();
            break;

        default:
            # code...
            break;
    }

    return '';
}
endif;
 
if(function_exists('vc_set_as_theme')):
vc_set_as_theme( $disable_updater = false );
endif; 



$dir = __DIR__ . '/vc-templates';
vc_set_shortcodes_templates_dir( apply_filters('investment_vc_shortcodes_templates_dir', $dir) );

if( !function_exists('investment_get_posts_dropdown') ):
function investment_get_posts_dropdown( $args = array() ) {
    global $wpdb, $post;

    $dropdown = array();
    $the_query = new WP_Query( $args );
    if ( $the_query->have_posts() ) {
        while ( $the_query->have_posts() ) {
            $the_query->the_post(); 
            $dropdown[get_the_ID()] = get_the_title();
        }
    }
    wp_reset_postdata();

    return $dropdown;
}
endif;

if( !function_exists('investment_get_terms') ):
function investment_get_terms( $tax = 'category', $key = 'id' ) {
    $terms = array();

    if(!taxonomy_exists($tax)) return false;

    if ( $key === 'id' ) foreach ( (array) get_terms( $tax, array( 'hide_empty' => false ) ) as $term ) $terms[$term->term_id] = $term->name;
      elseif ( $key === 'slug' ) foreach ( (array) get_terms( $tax, array( 'hide_empty' => false ) ) as $term ) $terms[$term->slug] = $term->name;
        return $terms;
}
endif;

if(!function_exists('investment_number_settings_field')):
function investment_number_settings_field( $settings, $value ) {
   return '<div class="my_param_block">'
             .'<input name="' . esc_attr( $settings['param_name'] ) . '" class="wpb_vc_param_value wpb-textinput ' .
             esc_attr( $settings['param_name'] ) . ' ' .
             esc_attr( $settings['type'] ) . '_field" type="number" min="'.intval($settings['min']).'" max="'.intval($settings['max']).'" step="'.intval($settings['step']).'" value="' . esc_attr( $value ) . '" />' .
             '</div>'; // This is html markup that will be outputted in content elements edit form
}
endif;

if(!function_exists('investment_vc_image_upload_settings_field')):
function investment_vc_image_upload_settings_field($settings, $value){
  return '<div class="investment-upload-container">
      <input type="text" name="' . esc_attr( $settings['param_name'] ) . '" value="'.esc_url($value).'" class="wpb_vc_param_value wpb-textinput perch-generator-attr perch-generator-upload-value" />
      <a href="javascript:;" class="button investment-upload-button"><span class="wp-media-buttons-icon"></span>'.esc_attr(__( 'Media manager', 'investment' )).'</a>
      <img width="80" src="'.esc_url($value).'" alt="">     
    </div>';
}
endif;

if(!function_exists('investment_perch_select_settings_field')):
function investment_perch_select_settings_field( $args, $value ) {
    $selected = is_array($value)? $value : explode(',', $value);
    $args = wp_parse_args( $args, array(
        'param_name'       => '',
        'heading'     => '',
        'class'    => 'wpb_vc_param_value wpb-input wpb-select dropdown',
        'multiple' => '',
        'size'     => '',
        'disabled' => '',
        'selected' => $selected,
        'none'     => '',
        'value'  => array(),
        'style' => '',
        'format'   => 'keyval', // keyval/idtext
        'noselect' => '' // return options without <select> tag
      ) );
    $options = array();
    if ( !is_array( $args['value'] ) ) $args['value'] = array();
     if ( $args['param_name'] ) $name = ' name="' . $args['param_name'] . '"';
    if ( $args['param_name'] ) $args['param_name'] = ' id="' . $args['param_name'] . '"';   
    if ( $args['class'] ) $args['class'] = ' class="' . $args['class'] . '"';
    if ( $args['style'] ) $args['style'] = ' style="' . esc_attr( $args['style'] ) . '"';
    if ( $args['multiple'] ) $args['multiple'] = ' multiple="multiple"';
    if ( $args['disabled'] ) $args['disabled'] = ' disabled="disabled"';
    if ( $args['size'] ) $args['size'] = ' size="' . $args['size'] . '"';
    if ( $args['none'] && $args['format'] === 'keyval' ) $args['options'][0] = $args['none'];
    if ( $args['none'] && $args['format'] === 'idtext' ) array_unshift( $args['options'], array( 'id' => '0', 'text' => $args['none'] ) );
    
    // keyval loop
    // $args['options'] = array(
    //   id => text,
    //   id => text
    // );
    if ( $args['format'] === 'keyval' ) foreach ( $args['value'] as $id => $text ) {
        $options[] = '<option value="' . (string) $id . '">' . (string) $text . '</option>';
      }
    // idtext loop
    // $args['options'] = array(
    //   array( id => id, text => text ),
    //   array( id => id, text => text )
    // );
    elseif ( $args['format'] === 'idtext' ) foreach ( $args['options'] as $option ) {
        if ( isset( $option['id'] ) && isset( $option['text'] ) )
          $options[] = '<option value="' . (string) $option['id'] . '">' . (string) $option['text'] . '</option>';
      }
    $options = implode( '', $options );

    if(is_array($args['selected'])){
        foreach ($args['selected'] as $key => $value) {
          $options = str_replace( 'value="' . $value . '"', 'value="' . $value . '" selected="selected"', $options );
        }
    }else{
      $options = str_replace( 'value="' . $args['selected'] . '"', 'value="' . $args['selected'] . '" selected="selected"', $options );
    }
    
    $output = ( $args['noselect'] ) ? $options : '<select' .$name. $args['param_name'] . $args['class'] . $args['multiple'] . $args['size'] . $args['disabled'] . $args['style'] . '>' . $options . '</select>';
   // $output .= '<input type="hidden" '.$name.' value="'.$value.'">';
    return '<div class="perch_select_param_block">'.$output.'</div>';
}
endif;



if(function_exists('vc_set_as_theme')):
vc_set_as_theme( $disable_updater = false );
$list = array(
    'page',
    'post',
    'team',
    'portfolio',
    'service',
    'job'
);
vc_set_default_editor_post_types( $list ); 
endif;


/* global vc include files */
foreach (glob(INVESTMENT_DIR."/admin/vc-extends/*.php") as $filename){
    include $filename;
}