<?php 
/**
 * The VC Functions
 */
add_action( 'vc_before_init', 'investment_about_company_shortcode_vc');
function investment_about_company_shortcode_vc() {
	
	vc_map( 
		array(
			'icon' => 'investment-icon',
			'name' => __('About company', 'investment'),
			'base' => 'investment_about_company',
			'class' => 'investment-vc',
			'category' => __('Investment', 'investment'),
			'description' => 'Display company, portfolio details with gallery',
			
			'params' => array(
				array(
					'type' => 'checkbox',
					'heading' => __( 'Gallery display right?', 'investment' ),
					'param_name' => 'gallery_display',
					'value' => array( __( 'Yes', 'investment' ) => 'yes' )	,
					'std' => 'yes',		
					'edit_field_class' => 'vc_col-sm-4',		
				),
				array(
	                 'type' => 'dropdown',
	                'heading' => __( 'First image size', 'investment' ),
	                'param_name' => 'large_img_size',
	                'value' => array_flip( investment_get_image_sizes_Arr() ),
	                'description' => '',
	                'std' => 'investment-630x335-crop',
	                'edit_field_class' => 'vc_col-sm-4', 
	            ),
	            array(
	                 'type' => 'dropdown',
	                'heading' => __( 'Small image size', 'investment' ),
	                'param_name' => 'thumb_img_size',
	                'value' => array_flip( investment_get_image_sizes_Arr() ),
	                'description' => '',
	                'std' => 'investment-300x300-crop',
	                'edit_field_class' => 'vc_col-sm-4', 
	            ),	
				array(
					'type' => 'attach_images',
					'heading' => __('Image gallery', 'investment'),
					'param_name' => 'gallery',
					'description' => '',
					'admin_label' => true,
					
				),							
				array(
					'type' => 'textfield',
					'heading' => __('Heading Title', 'investment'),
					'param_name' => 'title',
					'description' => 'use {} for highlight text',
					'value' => 'About Company',
					'save_always' => true,
					'admin_label' => true,
					'edit_field_class' => 'vc_col-sm-8',
				),
				array(
					'type' => 'perch_select',
					'heading' => __('Heading tag', 'investment'),
					'save_always' => true,
					'param_name' => 'tag',
					'value' =>  array(
								'h1' => __( 'H1', 'investment' ),
								'h2' => __( 'H2', 'investment' ),
								'h3' => __( 'H3', 'investment' ),
								'h4' => __( 'H4', 'investment' ),
								'h5' => __( 'H5', 'investment' ),
								'h6' => __( 'H6', 'investment' ),
							),
					'edit_field_class' => 'vc_col-sm-4', 
				),
				array(
					'type' => 'checkbox',
					'heading' => __( 'Add underline?', 'investment' ),
					'param_name' => 'add_underline',
					'description' => __( 'Display underline after title', 'investment' ),
					'value' => array( __( 'Yes', 'investment' ) => 'yes' )	,
					'std' => 'yes',	
					'save_always' => true,	
					'edit_field_class' => 'vc_col-sm-8',		
				),
				array(
					'type' => 'dropdown',
					'heading' => __( 'Underline style', 'investment' ),
					'param_name' => 'style',
					'value' => array(
						__( 'Thin', 'investment' ) => 'underline-primary',
						__( 'Bold', 'investment' ) => 'underline_small',
					),
					'std' => 'underline_small',
					'dependency' => array(
						'element' => 'add_underline',
						'value' => array( 'yes')
					),
					'edit_field_class' => 'vc_col-sm-4', 
				),				
				array(
					'type' => 'textarea_html',
					'heading' => __('Description', 'investment'),
					'param_name' => 'content',
					'description' => '',
					'value' => '<h4>Lead text Investment Expert is one of the largest and most experienced global private equity firms. We have established a team investment professionals,foucsed on buyouts and </h4>
								<p class="normal">Many businesses,large and small,have a huge source of great ideas that can help theme improve,innovate and grow,and yet so many of these companies never think of using this amazing corporate asset. What is this highly valuable asset? Its own people.Says Morgan Fraud,the author of The Investment Experts."Given that we are all capable of contributing new ideas,the"</p>',
					'admin_label' => true
				),
				array(
					'type' => 'textarea',
					'heading' => __('Footer text', 'investment'),
					'param_name' => 'footer_text',
					'description' => '',
					'value' => '',
					'admin_label' => true
				),

			),	

	));
	
}

class WPBakeryShortCode_Investment_about_company extends WPBakeryShortCode {
}