<?php
/**
 * The VC Functions
 */
add_action( 'vc_before_init', 'investment_accordion_shortcode_vc');
function investment_accordion_shortcode_vc() {	
	
	vc_map( 
		array(
			'icon' => 'investment-icon',
			'name' => __('Accordions', 'investment'),
			'base' => 'investment_accordions',
			'class' => 'investment-vc wpb_vc_tta_accordion',
			'category' => __('Investment', 'investment'),
			'is_container' => true,
			'show_settings_on_create' => false,
			'as_parent' => array(
				'only' => 'vc_tta_section',
			),
			'category' => __('Investment', 'investment'),
			'description' => 'Toggle area can be used for Faqs, etc',
			'params' => array(					
				),
				'js_view' => 'VcBackendTtaAccordionView',
				'custom_markup' => '
			<div class="vc_tta-container" data-vc-action="collapseAll">
				<div class="vc_general vc_tta vc_tta-accordion vc_tta-color-backend-accordion-white vc_tta-style-flat vc_tta-shape-rounded vc_tta-o-shape-group vc_tta-controls-align-left vc_tta-gap-2">
				   <div class="vc_tta-panels vc_clearfix {{container-class}}">
				      {{ content }}
				      <div class="vc_tta-panel vc_tta-section-append">
				         <div class="vc_tta-panel-heading dark-bg">
				            <h4 class="vc_tta-panel-title vc_tta-controls-icon-position-left">
				               <a href="javascript:;" aria-expanded="false" class="vc_tta-backend-add-control">
				                   <span class="vc_tta-title-text">' . __( 'Add New Section', 'investment' ) . '</span>
				                    <i class="vc_tta-controls-icon vc_tta-controls-icon-plus"></i>
								</a>
				            </h4>
				         </div>
				      </div>
				   </div>
				</div>
			</div>',
			'default_content' => '[vc_tta_section title="' . sprintf( '%s %d', __( 'Section', 'investment' ), 1 ) . '"][/vc_tta_section][vc_tta_section title="' . sprintf( '%s %d', __( 'Section', 'investment' ), 2 ) . '"][/vc_tta_section]',
		) 
	);

	
	
}
