<?php 
/**
 * The VC Functions
 */
add_action( 'vc_before_init', 'investment_call_to_action_shortcode_vc');
function investment_call_to_action_shortcode_vc() {
	
	vc_map( 
		array(
			'icon' => 'investment-icon',
			'name' => __('Call to action', 'investment'),
			'base' => 'investment_call_to_action',
			'class' => 'investment-vc',
			'category' => __('Investment', 'investment'),
			'description' => 'Title, button with dark background',
			
			'params' => array(
				array(
					'type' => 'dropdown',
					'heading' => __('Background type', 'investment'),
					'param_name' => 'bg_type',
					'value' =>  array_flip(array( 
								'primary-bg' => 'Primary color', 
								'secondary-bg' => 'Secondary color',
								'secondary-light-bg' => 'Secondary light color', 
								'dark-bg' => 'Dark color',
								'grey-bg' => 'Grey color', 
								'tra-bg' => 'Transparent color', 
								'white-bg' => 'White color' 
							)),
					'std' => 'secondary-bg',
				),
				array(
					'type' => 'textfield',
					'heading' => __('Title', 'investment'),
					'param_name' => 'title',
					'description' => 'use {} for highlight text',
					'value' => 'Our clients are looking for YOU!',
					'admin_label' => true
				),
				array(
					'type' => 'textarea',
					'heading' => __('Sub title', 'investment'),
					'param_name' => 'subtitle',
					'description' => 'use {} for highlight text',
					'value' => '',
				),
				array(
					'type' => 'textfield',
					'heading' => __('Button title', 'investment'),
					'param_name' => 'button_text',
					'value' => 'Apply now',
					'admin_label' => true
				),
				array(
					'type' => 'textfield',
					'heading' => __('Button url', 'investment'),
					'param_name' => 'button_url',
					'value' => '#',
				),
				
			),	

	));
	
}

class WPBakeryShortCode_Investment_call_to_action extends WPBakeryShortCode {
}